
<?php if(!empty($driver_salaries)){

    $driver_name = $driver_salaries[0]['name'];
    $paid_date = $driver_salaries[0]['paid_date'];
    $cash_bank = $driver_salaries[0]['cash_bank'];
    $bank = $driver_salaries[0]['payment_mode'];
    $transaction_type = $driver_salaries[0]['transaction_type'];
    $transaction_no = $driver_salaries[0]['transaction_no'];
    $transaction_date = $driver_salaries[0]['transaction_date'];
    $from_date = $driver_salaries[0]['from_date'];
    $to_date = $driver_salaries[0]['to_date'];

 ?>
<div class="panel panel-primary">
	<div class="panel-heading">
		<h6 class="panel-title"><i class="icon-database"></i> <?= $this->lang->line('driver-salary'); ?> </h6>
	</div>
	<div class="panel-body">
        <div class="form-group">
            <div class="row">
                <div class="col-md-6">
                    <label class=><?=$this->lang->line('driver');?></label>
                    <?= form_input('driver_id',set_value('driver_id',$driver_name),"class='form-control' disabled"); ?>
                    <?= form_error('driver_id');?>
                </div>
                <div class="col-md-3">
                    <label class="required"><?=$this->lang->line('from');?></label>
                    <?= form_input(array('name'=>'from_date','class'=>'form-control datepicker'),set_value('from_date',cdateFormat($from_date)),'disabled'); ?>
                    <?= form_error('from_date');?>
                </div>

                <div class="col-md-3">
                    <label class="required"><?=$this->lang->line('to');?></label>
                    <?= form_input(array('name'=>'to_date','class'=>'form-control datepicker'),set_value('to_date',cdateFormat($to_date)),'disabled'); ?>
                    <?= form_error('to_date');?>
                </div>              
            </div>
		</div>
		
	</div>
</div>

    <div class="panel panel-primary">
        <div class="panel-heading">
            <h6 class="panel-title"><i class="icon-database"></i> <?= $this->lang->line('bill'); ?> </h6>
        </div>
        <div class="panel-body">
            <div class="row">
                <div class="col-md-12">
                    <div class='table-responsive'>
                        <table class="table table-bordered table-striped">
                        <thead>
                        <tr class="bg-success">
                        <th>#</th>
                        <th></th>
                        <th><?= $this->lang->line('bill-date'); ?></th>
                        <th><?= $this->lang->line('voucher-type'); ?></th>
                        <th><?= $this->lang->line('bill-no'); ?></th>
                        <th><?= $this->lang->line('customer-name'); ?></th>
                        <th><?= $this->lang->line('route'); ?></th>
                        <th><?= $this->lang->line('vehicle-rent'); ?></th>
                        <th><?= $this->lang->line('percentage'); ?></th>
                        <th><?= $this->lang->line('amount'); ?></th>
                        </tr>
                        </thead>
                        <?php
                        
                        $i=0;$total_salary_amount = $salary_amount = $total_vehicle_rent = 0;
                        foreach($driver_salary_bills as $key => $driver_bills):$i++;

                            $vtype_id = $driver_bills['vtype_id'];
                            $bill_type = $driver_bills['bill_type']; # 0 -> sales / delivery-note , 1 -> purchase / receipt-note
                            $bill_group_id = $driver_bills['group_id'];
                            $percentage_id = $driver_bills['percentage_id'];
                            $prev_amount = $driver_bills['amount'];
                            $bill_prefix = $this->stock->get_voucher_prefix($vtype_id);
                            $vehicle_rent = $driver_bills['vehicle_rent'];
                            $salary_percent_dtls = $this->salary_settings->get_salary_percentage(array('conditions'=>array('id'=>$percentage_id)));
                            if(!empty($salary_percent_dtls)){
                                $percentage = $salary_percent_dtls[0]['percentage'];
                            }
                            $salary_amount = get_rounded(($vehicle_rent*$percentage)/100);
                            if($prev_amount == $salary_amount){
                                $total_salary_amount += $salary_amount;
                            }
                            
                            if(empty($bill_type)){

                            }else{

                            }

                            ?>
                            <tr>
                            <td class="text-center no-wrap"><?= $i;?></td>
                            <td></td>
                            <td class="text-center no-wrap"><?=dateFormat($driver_bills['bill_date']);?></td>
                            <td><?= $driver_bills['voucher_type']; ?></td>
                            <td class="no-wrap"><?=$bill_prefix.' '.$driver_bills['bill_no'];?></td>
                            <td></td>
                            <td><?= $driver_bills['route']; ?></td>
                            <td class="text-right"><?=numberFormat(get_rounded($vehicle_rent));?></td>                            
                            <td><?= $salary_percentages[$percentage_id]; ?></td>
                            <td class="text-right"><?= $salary_amount; ?></td>
                            </tr>
                        <?php 
                        endforeach;
                         $total_salary_amount = ($total_salary_amount);
                        ?>
                        <tr>
                            <td colspan="9" class="text-right h5">Total Amount</td>
                            <td class="text-right h5"><?= $total_salary_amount; ?></td>
                        </tr>
                        </table>
                    </div>
                </div>
            </div>

            <div class="form-group">
                <div class="row">
                    <div class="col-md-4">
                        <label class="required"><?=$this->lang->line('payment-date');?></label>
                        <?= form_input(array('name'=>'paid_date','class'=>'form-control datepicker'),set_value('paid_date',cdateFormat($paid_date)),'disabled'); ?>
                        <?= form_error('paid_date');?>
                    </div>                    

                    <div class="col-md-8">
                        <label class=""><?=$this->lang->line('remarks');?></label>
                        <?= form_textarea(array('name'=>'remarks','class'=>'form-control','rows'=>2),set_value('remarks'),'disabled'); ?>
                        <?= form_error('remarks');?>
                    </div>
                </div> 
            </div>       

            <div class="form-group">

            <div class="row">
                <label class="required col-md-3"><?= $this->lang->line('payment-mode'); ?></label>
                <div class="col-md-2">
                    <?= form_radio('receipt_mode','0',set_radio('receipt_mode',$cash_bank,true),'class="receipt-mode" disabled'); ?>
                    <label><?= $this->lang->line('cash'); ?></label>
                </div>
                <div class="col-md-2">
                    <?= form_radio('receipt_mode','1',set_radio('receipt_mode',$cash_bank,true),'class="receipt-mode" disabled'); ?>
                    <label><?= $this->lang->line('bank'); ?></label>
                </div>
                <?= form_error('receipt_mode'); ?>
            </div>                
            </div> 
     
            <?php
            $disPDC = 'disabled="disabled"';
            if($cash_bank >0){
                $disPDC = NULL;
            }
            ?>
            <div class="form-group">
                <div class="row">
                    <div class="col-md-12">
                        <?= form_dropdown('payment_mode',$bank_accounts,set_value('payment_mode',$bank),"class='form-control payment-mode pdc' $disPDC disabled"); ?>
                        <?= form_error('payment_mode');?>
                    </div>
                </div>
            </div>

            <div class="form-group">
                <div class="row">
                    <div class="col-md-4">
                        <label><?=$this->lang->line('transaction-type');?></label>
                        <?php $transaction_types = $this->dms->transaction_types();?>
                        <?= form_dropdown('ccd',$transaction_types,set_value('ccd',$transaction_type),"class='form-control pdc' $disPDC disabled"); ?>
                        <?=form_error('ccd');?>
                    </div>
                    <div class="col-md-4">
                        <label class="pdcl"><?=$this->lang->line('cd-no');?></label>
                        <?= form_input(array('name'=>'cheque_no','class'=>'form-control pdc'),set_value('cheque_no',$transaction_no),'disabled '.$disPDC); ?>
                        <?= form_error('cheque_no');?>
                    </div>
                    <div class="col-md-4">
                        <label class="pdcl"><?=$this->lang->line('cheque-date');?></label>
                        <?= form_input(array('name'=>'cheque_date','class'=>'form-control pdc datepicker required'),set_value('cheque_date',cdateFormat($transaction_date)),'disabled '.$disPDC); ?>
                        <?= form_error('cheque_date');?>
                    </div>
                </div>
            </div>

        </div>
    </div>
    <?php

}
?>