<?= form_open(); ?>

<div class="panel panel-primary">
    <div class="panel-heading">
        <h6 class="panel-title"><i class="icon-database"></i><?= $this->lang->line("new")." ".$this->lang->line("$voucher_name")." ".$this->lang->line("bill"); ?></h6>
    </div>
    <div class="panel-body">
        <div class="form-group">
            <div class="row">
				<div class="col-md-4">
                    <label class="required"><?=$this->lang->line('voucher-types');?></label>
                    <?=form_dropdown("vtype_id",$voucher_types,set_value("vtype_id",$voucher_type),"class='form-control d-voucher-type' $disabled");?>
                    <?=form_error('vtype_id');?>
                </div>
                <div class="col-md-4">
                    <label class="required"><?=$this->lang->line('bill-no');?></label>
					<div class="input-group">
						<span class="input-group-addon text-bold" id="bill-prefix"><?= $bill_prefix; ?></span>
						<?=form_input('sales[bill_no]',set_value('sales[bill_no]',$voucher_no),"class='form-control text-right number' id='sbill-ajax' $disabled");?>
					</div>                       
                    <?= form_error('sales[bill_no]');?>
                </div>
                <div class="col-md-4">
                    <label class="required"><?=$this->lang->line('bill-date');?></label>
                    <?=form_input('sales[bill_date]',set_value('sales[bill_date]',cdateFormat($voucher_date)),"class='datepicker form-control bill-date' id='sdate-ajax' $disabled");?>
                    <?= form_error('sales[bill_date]');?>
                </div>
            </div>
        </div>

        <div class="form-group">
            <div class="row">
                <div class="col-md-3">
                    <label><?=$this->lang->line('dno');?></label>
                    <?=form_input('sales[dno]',set_value('sales[dno]'),"class='form-control text-right' $disabled");?>
                    <?= form_error('sales[dno]');?>
                </div>
            	<div class="col-md-3">
                    <label class="required"><?=$this->lang->line('customer-types');?></label>
                    <?=form_dropdown("sales[customer_type]",$customerTypes,set_value("sales[customer_type]",$custType),"class='form-control customer_type' $disabled");?>
                    <?=form_error('sales[customer_type]');?>
                </div>
                <div class="col-md-6">
                    <label class="required"><?=$this->lang->line('customer-name');?></label>
					<?= form_dropdown('sales[customer_id]',$customers,set_value('sales[customer_id]',$cust_id),"class='form-control customers' $disabled"); ?>
                    <?= form_error('sales[customer_id]');?>
                </div>
            </div>
        </div>

        <div class="form-group">
            <div class="row">
                <div class="col-md-4">
                    <label><?=$this->lang->line('user-type');?></label>
                    <?= form_dropdown('sales[user_type]',$user_types,set_value('sales[user_type]',$desig_id),"class='form-control user_type' $disabled"); ?>
                    <?= form_error('sales[user_type]');?>
                </div>
                <div class="col-md-8">
                    <label><?=$this->lang->line('user');?></label>
                    <?= form_dropdown('sales[user_id]',$users,set_value('sales[user_id]',$user),"class='form-control users' $disabled"); ?>
                    <?= form_error('sales[user_id]');?>
                </div>
                <?php /*<div class="col-md-4">
                    <label><?=$this->lang->line('pricelist');?></label>
                    <?= form_dropdown('sales[pricelist_id]',$pricelists,set_value('sales[pricelist_id]',$price_list_id),"class='form-control' $disabled"); ?>
                    <?= form_error('sales[pricelist_id]');?>
                </div>*/?>
            </div>
        </div>

        <div class="form-group">
            <div class="row">
                <div class="col-md-6">
                    <label class="required"><?=$this->lang->line('item-name');?></label>
                    <?= form_dropdown('item_id',$items,set_value('item_id'),'class="form-control item_name"'); ?>
                    <?= form_error('item_id');?>
                </div>
                <div class="col-md-<?=(empty($presumptive_tax) && $sales_cst)?4:6;?>">
                    <label class="required"><?=$this->lang->line('godown');?></label>
                    <?= form_dropdown('godown_id',$goDowns,set_value('godown_id'),'class="form-control godown"'); ?>
                    <?= form_error('godown_id');?>
                </div>
                <?php if(empty($presumptive_tax) && $sales_cst){?>
                <div class="col-md-2">
                    <label><?=$this->lang->line('cst');?> %</label>
                    <?= form_input(array('name'=>'cst','class'=>'form-control text-right decimal cst'),set_value('cst')); ?>
                    <?= form_error('cst');?>
                </div>
                <?php }?>
            </div>
        </div>

        <div class="form-group">
            <div class="row">
                <div class="col-md-2">
                    <label class="required"><?=$this->lang->line('quantity');?></label>
                    <?= form_input(array('name'=>'qty','class'=>'form-control text-right qnty qty-rate decimal'),set_value('qty')); ?>
                    <?= form_error('qty');?>
                </div>
                <div class="col-md-2">
                    <label class="required"><?=$this->lang->line('unit');?></label>
                    <?= form_dropdown('unit_id',$units,set_value('unit_id'),'class="form-control unit"'); ?>
                    <?= form_error('unit_id');?>
                </div>
                <div class="col-md-2">
                    <label class="required"><?=$this->lang->line('rate');?></label>
                    <?= form_input(array('name'=>'rate','class'=>'form-control text-right rate qty-rate decimal'),set_value('rate')); ?>
                    <?= form_error('rate');?>
                </div>
                <div class="col-md-2">
                    <label class="required"><?=$this->lang->line('amount');?></label>
                    <?= form_input(array('name'=>'amount','class'=>'form-control text-right amount'),set_value('amount')); ?>
                    <?= form_error('amount');?>
                </div>
                <div class="col-md-2">
                    <label><?=$this->lang->line('discount');?> %</label>
                    <?= form_input(array('name'=>'discount_per','class'=>'form-control text-right discount_per decimal','id'=>'discount_per'),set_value('discount_per')); ?>
                    <?= form_error('discount_per');?>
                </div>
                <div class="col-md-2">
                    <label><?=$this->lang->line('discount');?> <?=$this->lang->line('amt');?></label>
                    <?= form_input(array('name'=>'discount_amt','class'=>'form-control text-right discount_amt decimal'),set_value('discount_amt')); ?>
                    <?= form_error('discount_amt');?>
                </div>
                <?php /*?><div class="col-md-2">
                    <div class="row">
                        <div class="col-md-12">
                            <label><?=$this->lang->line('freight');?></label>
                            <?= form_input(array('name'=>'freight','class'=>'form-control text-right freigh-amt','onKeyPress' => 'return isNumberKey(event)'),set_value('freight')); ?>
                            <?= form_error('freight');?>
                        </div>
                    </div>
                </div><?php */?>
            </div>
        </div>
        <div class="float-left"><?=$this->lang->line('stock-bal')." : ";?>
            
        </div>
        <div class="float-left text-bold marg-left-10" id="stock-balance"><?=$stock_count." ".$primary_unit;?>
            
        </div>
        <div class="form-group">
            <div class="text-right">
                <?=form_submit(array('name' => 'btn_add','class'=>'btn btn-primary btn-loading pull-right','value'=>$this->lang->line('add-to-bill')));?>
            </div>
        </div>
    </div>
</div>

<?= form_close(); ?>

<?php
if($sales_temp_status > 0)
{
	$uri_array = $this->uri->uri_to_assoc(3);
?>
	<?= form_open(); ?>
	<div class="row">
	    <div class="col-md-12">
            <div class='table-responsive'>
	            <table class="table table-bordered table-striped">
    	        <thead>
	            <tr class="bg-success">
            	<th>#</th>
            	<th><?= $this->lang->line('item-name');?></th>
            	<th><?= $this->lang->line('quantity');?></th>
            	<th><?= $this->lang->line('unit'); ?></th>
            	<th><?= $this->lang->line('rate'); ?></th>
            	<th><?= $this->lang->line('amount'); ?></th>
            	<th><?= $this->lang->line('dis'); ?> <?= $this->lang->line('amt'); ?></th>
            	<th><?= $this->lang->line('net-value'); ?></th>
<?php 
                    $l_date='2017-07-01';
                    $b_date=$voucher_date;
                   
                    if($b_date < $l_date)
                    {
                        $a=10;$b=8;
                        $colspan = 2;
                        if(empty($presumptive_tax) && $sales_cst)
                        {
                            $colspan-=1;
?>
                            <th><?= $this->lang->line('cst').". ".$this->lang->line('amt'); ?></th>
<?php 
                        }
?>
<?php 
                        if(empty($presumptive_tax))
                        {
                            $colspan-=2;
?>
                           <th><?= $this->lang->line('vat'); ?> (%)</th>
                           <th><?= $this->lang->line('vat'); ?> <?= $this->lang->line('amt'); ?></th>
 <?php 
                        }
                    }
                    else
                    {
                        $a=12;  $b=10;
?>
                        <th><?= $this->lang->line('cgst'); ?> (%)</th>
                        <th><?= $this->lang->line('sgst'); ?> (%)</th>
                        <th><?= $this->lang->line('cgst'); ?> <?= $this->lang->line('amt'); ?></th>
                        <th><?= $this->lang->line('sgst'); ?> <?= $this->lang->line('amt'); ?></th> 

<?php
                    }
?>
                        <?php /*?><th><?= $this->lang->line('freight'); ?></th><?php */?>
                	<th class="width-150"><?= $this->lang->line('net'); ?> <?= $this->lang->line('amt'); ?></th>
                	<th colspan='2'><?=$this->lang->line('actions');?></th>
                	</tr>
                	</thead>
                	<?php
                	$i=0;$totalAmount=0;$totalDiscountAmt=0;$totalNetValue=0;$totalVatAmt=0;$totalNetAmount=0;//$totalFreight=0;
                	$grandNetAmount=0;$total_cst_amount = 0;
                	foreach($sales_temp_data as $key => $item)
                	{
                		$i++;
                		$itemID = $item['item_id'];
                		$item_details = $this->stock->get_item($itemID,array('item_code','item_name'));
                		$qty = $item['qty'];
                		$rate = $item['rate'];
                		$discount_per = $item['discount_per'];
                		$discount_amt = $item['discount_amt'];
                		$cst_percent = $item['cst'];
                		$vat = 0;$vatAmount = 0;$cst_amount = 0;$cgstAmt=0;$sgstAmt=0;
                		$amount = $item['amount'];
                		$totalAmount += $amount;
                		$netValue = $amount-$discount_amt;
                             if($b_date < $l_date)
                             {
                		 if(empty($presumptive_tax))
                                 {
                		      if($cst_percent == 0)
                                      {
                				$vat = $this->stock->get_item_vat($itemID);
                				$vatAmount = $item['vat_amt'];
                				$totalVatAmt += $vatAmount;
                		      }
                                      else
                                      {
                				$cst_amount = ($netValue*$cst_percent)/100;
                		      }
                		  }
                                
                		  $total_cst_amount += $cst_amount;
                                  $netAmount = $netValue+$vatAmount+$cst_amount;
                              }
                              else
                              {
                                  $cgst=$this->stock->get_item_cgst($itemID);
                                  $sgst=$this->stock->get_item_sgst($itemID);
                                  $cgstAmt = $item['cgst_amt'];
                                  $sgstAmt = $item['sgst_amt'];
                                  $vatAmount = $cgstAmt+$sgstAmt;
                                  $totalVatAmt += $vatAmount;
                                  $netAmount = $netValue+$vatAmount;
                              }

                		$totalNetValue += $netValue;
                		/*$freight = $item['freight'];
                		$totalFreight += $freight;*/
                		
                		$totalNetAmount += $netAmount;
                		$totalDiscountAmt += $discount_amt;
                		?>
                		<tr>
                    		<td><?= $i; ?></td>
                    		<td><?= $item_details['item_code']; ?> / <?= $item_details['item_name']; ?></td>
                    		<td class="text-right"><?= $qty; ?></td>
                    		<td><?=$this->stock->get_unit_symbol($item['unit_id']); ?></td>
                    		<td class="text-right"><?= numberFormat($rate); ?></td>
                    		<td class="text-right"><?= numberFormat(round_this($amount)); ?></td>
                    		<td class="text-right"><?= numberFormat(round_this($discount_amt)); ?></td>
                    		<td class="text-right"><?= numberFormat(round_this($netValue)); ?></td>
                            <?php
                            if($b_date < $l_date)
                            {
                                if(empty($presumptive_tax) && $sales_cst)
                                {
                            ?>
                            	    <td class="text-right"><?= numberFormat(round_this($cst_amount)); ?></td>
                    	<?php 
                                }
                            ?>
                            <?php 
                                if(empty($presumptive_tax))
                                {
?>
                                    <td class="text-right"><?= $vat; ?></td>
                                    <td class="text-right"><?= numberFormat(round_this($vatAmount)); ?></td>
                            <?php 
                                }
                             }
                             else
                             {
?>
                                 <td class="text-right"><?= $cgst; ?></td>
                                 <td class="text-right"><?= $sgst; ?></td>
                                 <td class="text-right"><?= numberFormat(round_this($cgstAmt)); ?></td>
                                 <td class="text-right"><?= numberFormat(round_this($sgstAmt)); ?></td>

<?php                                 
                             }
                            ?>
                            <?php /*?><td class="text-right"><?= numberFormat($freight); ?></td><?php */?>
                    		<td class="text-right"><?= numberFormat(round_this($netAmount)); ?></td>
                            <?php app_table_links('ida/'.$item['id'],array(352,353));?>
                    	</tr>
                    	<?php
                        }
                        	$grandNetAmount = round_this($totalNetAmount);
                        	?>
                        	<tr>
                        	<td class="text-right text-bold" colspan="5"><?= $this->lang->line('total'); ?></td>
                        	<td class="text-right text-bold"><?= numberFormat(round_this($totalAmount)); ?></td>
                        	<td class="text-right text-bold"><?= numberFormat(round_this($totalDiscountAmt)); ?></td>
                        	<td class="text-right text-bold"><?= numberFormat(round_this($totalNetValue)); ?></td>
                            <?php 
                                if($b_date < $l_date)
                                {
                                  if(empty($presumptive_tax) && $sales_cst)
                                  {
?>
                                       	<td class="text-right text-bold"><?= numberFormat(round_this($total_cst_amount)); ?></td>
                        	<?php }?>
                            <?php
                                    if(empty($presumptive_tax)){?>
                        		<td class="disabled"></td>
                        		<td class="text-right text-bold"><?= numberFormat(round_this($totalVatAmt)); ?></td>
                            <?php }

                                }
                                else
                                {
?>
                                    <td class="disabled"></td>
                                    <td class="text-right text-bold" colspan="2"><?php echo"Total GST Amt."; ?></td>
                                    <td class="text-right text-bold" colspan="1"><?= numberFormat(round_this($totalVatAmt)); ?></td>
                                    
<?php
                                 }


?>
                            <?php /*?><td class="text-right text-bold"><?= numberFormat($totalFreight); ?></td><?php */?>
                        	<td class="text-right text-bold"><?= numberFormat(round_this($totalNetAmount)); ?></td>
                        	<td colspan="2" class="disabled"></td>
                        	</tr>
                            <?php $presumptive_tax_amt = 0;if(!empty($presumptive_tax)){
                        	$presumptive_tax_amt = ($totalNetAmount*$presumptive_tax[0])/100;
                        	$grandNetAmount += round_this($presumptive_tax_amt);
                        	?>
                        	<tr>
                        	<td colspan="<?=($a-$colspan);?>" class="text-right">
                        	<span class="text-bold"><?=$this->lang->line('presum-tax');?> @ <?=$presumptive_tax[0];?> %</span></td>
                        	<td class="text-right"><?=numberFormat(round_this($presumptive_tax_amt));?></td>
                        	<td colspan="2" class="disabled"></td>
                        	</tr>
                            <?php }?>
                            <?php $cess_amt = (($totalVatAmt+$total_cst_amount+$presumptive_tax_amt)*$cess)/100;
                        	$grandNetAmount += round_this($cess_amt);?>
                            <tr>
                            <td colspan="2" class="text-right text-bold required"><?=$this->lang->line('area');?></td>
                        	<td colspan="<?=($b-$colspan);?>" class="text-right text-bold">
                            	<div class="row">
                                    <div class="col-md-9"><?= form_dropdown('area_id',$areas,set_value('area_id'),'class="form-control"'); ?><?= form_error('area_id');?></div>
                                    <div class="col-md-3 pull-right"><?=$this->lang->line('cess');?> @ <?=$cess;?> %</div>
                        		</div>
                        	</td>
                            <td class="text-right"><?=numberFormat(round_this($cess_amt));?></td>
                        	<td colspan="2" class="disabled"></td>
                        	</tr>

    <tr>
	<td colspan="<?=($a-$colspan);?>" class="text-right text-bold">
    <div class="row">
    	<div class="col-md-12 pull-right"><?= $this->lang->line('freight');?></div>
    </div>
	</td>
	<td><?= form_input(array('name'=>'freight','class'=>'form-control decimal text-right width-150 pull-right freight-amt'),set_value('freight')); ?><?=form_error('freight');?></td>
	<td colspan="2" class="disabled"></td>
	</tr>

    <tr>
	<td class="text-right text-bold" colspan="2"><?=$this->lang->line('remarks');?></td>
	<td colspan="<?=($b-$colspan);?>" class="text-right text-bold">
		<div class="row">
		<div class="col-md-9 pull-left"><?= form_textarea(array('name'=>'remarks','class'=>'form-control','rows'=>2),set_value('remarks')); ?><?=form_error('remarks');?></div>
        <div class="col-md-3 pull-right"><?= $this->lang->line('other-expense');?></div>
		</div>
	</td>
	<td><?= form_input(array('name'=>'other_expense','class'=>'form-control text-right width-150 pull-right other-expense decimal'),set_value('other_expense')); ?><?=form_error('other_expense');?></td>
	<td colspan="2" class="disabled"><input type="hidden" id="gnTotalAmt" value="<?= round_this($grandNetAmount); ?>"></td>
	</tr>

	<?php if(show_round_off()){ ?>
    <tr>
    <td class="text-right text-bold" colspan="<?=($a-$colspan);?>">
    <div class="row">
        <div class="col-md-3 pull-right text-bold"><?=$this->lang->line('round-off');?></div>
    </div>
    </td>
    <td class="text-right text-bold"><div class="in-line" id="roundOff"><?= numberFormat(round_off($grandNetAmount)); ?></div></td>
	<td colspan="2" class="disabled"></td>
	</tr>
    <?php } ?>

    <tr>
    <td class="text-right text-bold" colspan="2"><?=$this->lang->line('discount');?> %</td>
    <td class="text-right text-bold" colspan="<?=($b-$colspan);?>">
    <div class="row">
        <div class="col-md-3 pull-left">
        <?= form_input(array('name'=>'bill_discount_per','class'=>'form-control text-right bill_discount_percent decimal'),set_value('bill_discount_per')); ?><?=form_error('bill_discount_per');?>
        </div>
        <div class="col-md-3"><?= $this->lang->line('discount');?> <?=$this->lang->line('amount');?></div>
        <div class="col-md-3"><?= form_input(array('name'=>'bill_discount_amt','class'=>'form-control bill_discount_amount decimal text-right'),set_value('bill_discount_amt')); ?><?=form_error('bill_discount_amt');?></div>
        <div class="col-md-3 pull-right text-bold"><?=$this->lang->line('net-amount');?></div>
    </div>
    </td>
    <td class="text-right text-bold"><div class="in-line" id="grandTotalAmount"><?= numberFormat(get_rounded($grandNetAmount)); ?></div></td>
	<td colspan="2" class="disabled"></td>
	</tr>

	</table>
	</div>



    <div class="panel panel-primary">
        <div class="panel-heading">
             <h6 class="panel-title"><i class="icon-truck"></i> <?= $this->lang->line('assign-vehicles'); ?> </h6>
        </div>
        <div class="panel-body">
        
        <?= form_open(); ?>
        
            <?php
            $checkSts = 'checked';
            if($this->input->post()){
                if($this->input->post('vehicle_type')){
                    $checkSts = 'checked';
                }else{
                    $checkSts = '';
                }
            }
            ?>

            <div class="form-group">
                <div class="row">
                    <div class="col-md-12">
                    <?= form_checkbox(array('name'=>'vehicle_type','value'=>1,'class'=>'vehicle-type','checked'=>$checkSts)); ?>
                        <label><?= $this->lang->line('company-vehicle'); ?></label>
                    </div>
                </div>
            </div>
            
            <?php 
            $CmpSts = 'display-none';
            if(!$this->input->post() || $this->input->post('vehicle_type'))
            {
                $CmpSts = '';
            }?>
            <div class="form-group company-vehicle <?= $CmpSts; ?>">
                <div class="row">
                    <div class="col-md-6">
                    <?php $vehicles['']='Select'; ?>
                        <label class="required"><?=$this->lang->line('vehicle');?></label>
                        <?= form_dropdown('vehicle_id',$vehicles,set_value('vehicle_id'),'class="form-control"'); ?>
                        <?= form_error('vehicle_id');?>
                    </div>
                    <div class="col-md-6">
                    <?php $drivers['']='Select'; ?>
                        <label class="required"><?=$this->lang->line('driver');?></label>
                        <?= form_dropdown('driver_id',$drivers,set_value('driver_id'),'class="form-control"'); ?>
                        <?= form_error('driver_id');?>
                    </div>
                </div>
            </div>

            <?php
            $nonCmpSts = 'display-none';
            if($this->input->post() && !$this->input->post('vehicle_type'))
            {
                $nonCmpSts = '';
            }?>
            <div class="form-group non-company-vehicle <?= $nonCmpSts; ?>">
                <div class="row">
                    <div class="col-md-6">
                        <label class="required"><?=$this->lang->line('vehicle');?></label>
                        <?= form_input(array('name'=>'vehicle_no','class'=>'form-control'),set_value('vehicle_no')); ?>
                        <?= form_error('vehicle_no');?>
                    </div>
                    <div class="col-md-6">
                        <label class=""><?=$this->lang->line('driver');?></label>
                        <?= form_input(array('name'=>'driver_name','class'=>'form-control'),set_value('driver_name')); ?>
                    </div>
                </div>
            </div>
                        
            <div class="form-group">
                <div class="row">
                    <div class="col-md-6">
                    <?php $routes['']='Select'; ?>
                        <label class="required"><?=$this->lang->line('route');?></label>
                        <?php // form_input(array('name'=>'route_id','class'=>'form-control'),set_value('route_id')); ?>
                        <?= form_dropdown('route_id',$routes,set_value('route_id'),'class="form-control"'); ?>
                        <?= form_error('route_id');?>
                    </div>
                    <div class="col-md-6">
                        <label class=""><?=$this->lang->line('km');?></label>
                        <?= form_input(array('name'=>'km','class'=>'form-control decimal'),set_value('km')); ?>
                        <?= form_error('km');?>
                    </div>                                     
                </div>
            </div>             
                    
            <div class="form-group">
                <div class="row">
                    <div class="col-md-12">
                        <label class=""><?=$this->lang->line('remarks');?></label>
                        <?= form_textarea(array('name'=>'remarks','rows'=>3,'class'=>'form-control')); ?>
                        <?= form_error('remarks');?>
                    </div>
                </div>
            </div>
                     
    <div class="form-group">
        <div class="row">
            <div class="col-md-12">
                <?= form_submit(array('name'=>'btn_save','class'=>'btn btn-primary btn-loading pull-right','value'=>$this->lang->line('save')));?>
            </div>
        </div>
    </div>

	<?= form_close();
}
?>