<?= form_open(); ?>

<div class="panel panel-primary">

    <div class="panel-heading">
    <h6 class="panel-title"><i class="icon-database"></i><?= $this->lang->line("new")." ".$this->lang->line("$voucher_name")." ".$this->lang->line("bill"); ?></h6>
    </div>
    <div class="panel-body">

        <div class="form-group">
            <div class="row">
                <div class="col-md-4">
                    <label class="required"><?=$this->lang->line('voucher-types');?></label>
                    <?=form_dropdown("vtype_id",$voucher_types,set_value("vtype_id",$voucher_type),"class='form-control voucher-type'");?>
                    <?=form_error('vtype_id');?>
                </div>

                <div class="col-md-4">
                    <label class="required"><?=$this->lang->line('bill-no');?></label>
					<div class="input-group">
						<span class="input-group-addon text-bold" id="bill-prefix"><?= $bill_prefix; ?></span>
						<?=form_input('bill_no',set_value('bill_no',$voucher_no),"class='form-control text-right number' id='sbill-ajax'");?>
					</div>                    
                    <?= form_error('bill_no');?>
                </div>
                <div class="col-md-4">
                    <label class="required"><?=$this->lang->line('bill-date');?></label>
                    <?=form_input('bill_date',set_value('bill_date',cdateFormat(date('Y-m-d'))),"class='datepicker form-control bill-date' id='sdate-ajax'");?>
                    <?= form_error('bill_date');?>
                </div>
            </div>
        </div>

        <div class="form-group">
        <div class="row">
            <div class="col-md-4">
                <label><?=$this->lang->line('customer-types');?></label>
                <input type="text" class="form-control" disabled value="<?php if($sales_array[0]['customer_type_id'] == 1){echo "Branch";}elseif($sales_array[0]['customer_type_id'] == 2){echo "Customer";}else{echo "AR";}?>">
            </div>
            <div class="col-md-8">
                <label><?=$this->lang->line('customer-name');?></label>
                <input type="text" class="form-control" disabled value="<?=$customer_name;?>">
            </div>
        </div>
        </div>
        <div class="form-group">
        <div class="row">
            <div class="col-md-4">
                <label><?=$this->lang->line('user-type');?></label>
                <input type="text" class="form-control" disabled value="<?=$user_type;?>">
            </div>
            <div class="col-md-4">
                <label><?=$this->lang->line('user');?></label>
                <input type="text" class="form-control" disabled value="<?=$user;?>">
            </div>
            <?php /*<div class="col-md-4">
                <label><?=$this->lang->line('pricelist');?></label>
                <input type="text" class="form-control" disabled value="<?=$pricelist;?>">
            </div>*/?>
        </div>
        </div>

    </div>
</div>

<div class="row">
<div class="col-md-12">

    <div class='table-responsive'>
    <table class="table table-bordered table-striped">
    <thead>
    <tr class="bg-success">
    <th>#</th>
    <th><?= $this->lang->line('item-name');?></th>
    <th><?= $this->lang->line('quantity');?></th>
    <th><?= $this->lang->line('unit'); ?></th>
    <th><?= $this->lang->line('rate'); ?></th>
    <th><?= $this->lang->line('amount'); ?></th>
    <th><?= $this->lang->line('dis'); ?> <?= $this->lang->line('amt'); ?></th>
    <th><?= $this->lang->line('net-value'); ?></th>
    <?php $colspan = 2;if(empty($presumptive_tax) && $sales_cst){$colspan-=1;?>
    	<th><?= $this->lang->line('cst').". ".$this->lang->line('amt'); ?></th>
	<?php }?>
    <?php if(empty($presumptive_tax)){$colspan-=2;?>
    	<th><?= $this->lang->line('vat'); ?> (%)</th>
    	<th><?= $this->lang->line('vat'); ?> <?= $this->lang->line('amt'); ?></th>
    <?php }?>
    <th><?= $this->lang->line('net'); ?> <?= $this->lang->line('amt'); ?></th>
    </tr>
    </thead>
    <?php
    $i=0;$totalAmount=0;$totalDiscountAmt=0;$totalNetValue=0;$totalVatAmt=0;$totalNetAmount=0;//$totalFreight=0;
    $grandNetAmount=0;$total_cst_amount = 0;
	$cess = $sales_array[0]['cess'];
    foreach($sales_array as $key => $item)
    {
        $i++;
        $itemID = $item['item_id'];
        $item_details = $this->stock->get_item($itemID,array('item_code','item_name'));
        $qty = $item['qty'];
        $rate = $item['rate'];
        $discount_per = $item['discount_per'];
        $discount_amt = $item['discount_amt'];
        $cst_percent = $item['cst'];
        $vat = 0;$vatAmount = 0;$cst_amount = 0;
        $amount = $item['amount'];
        $totalAmount += $amount;
        $netValue = $amount-$discount_amt;
        if(empty($presumptive_tax)){
            if($cst_percent == 0){
                $vat = $this->stock->get_item_vat($itemID);
                $vatAmount = $item['vat_amt'];
                $totalVatAmt += $vatAmount;
            }else{
                $cst_amount = ($netValue*$cst_percent)/100;
            }
        }
        $total_cst_amount += $cst_amount;
        $totalNetValue += $netValue;
        $netAmount = $netValue+$vatAmount+$cst_amount;
        $totalNetAmount += $netAmount;
        $totalDiscountAmt += $discount_amt;
        ?>
        <tr>
        <td class="text-center"><?= $i; ?></td>
        <td><?= $item_details['item_code']; ?> / <?= $item_details['item_name']; ?></td>
        <td class="text-right"><?= $qty; ?></td>
        <td><?=$this->stock->get_unit_symbol($item['unit_id']); ?></td>
        <td class="text-right"><?= numberFormat($rate); ?></td>
        <td class="text-right"><?= numberFormat(round_this($amount)); ?></td>
        <td class="text-right"><?= numberFormat(round_this($discount_amt)); ?></td>
        <td class="text-right"><?= numberFormat(round_this($netValue)); ?></td>
        <?php if(empty($presumptive_tax) && $sales_cst){?>
        	<td class="text-right"><?= numberFormat(round_this($cst_amount)); ?></td><?php }?>
        <?php if(empty($presumptive_tax)){?>
            <td class="text-right"><?= $vat; ?></td>
            <td class="text-right"><?= numberFormat(round_this($vatAmount)); ?></td>
        <?php }?>
        <td class="text-right"><?= numberFormat(round_this($netAmount)); ?></td>
        </tr>
        <?php
    }
    $grandNetAmount = round_this($totalNetAmount);
    ?>
    <tr>
    <td class="text-right text-bold" colspan="5"><?= $this->lang->line('total'); ?></td>
    <td class="text-right text-bold"><?= numberFormat(round_this($totalAmount)); ?></td>
    <td class="text-right text-bold"><?= numberFormat(round_this($totalDiscountAmt)); ?></td>
    <td class="text-right text-bold"><?= numberFormat(round_this($totalNetValue)); ?></td>
    <?php if(empty($presumptive_tax) && $sales_cst){?>
    	<td class="text-right text-bold"><?= numberFormat(round_this($total_cst_amount)); ?></td>
	<?php }?>
    <?php if(empty($presumptive_tax)){?>
        <td class="disabled"></td>
        <td class="text-right text-bold"><?= numberFormat(round_this($totalVatAmt)); ?></td>
    <?php }?>
    <td class="text-right text-bold"><?= numberFormat(round_this($totalNetAmount)); ?></td>
    </tr>

    <?php $presumptive_tax_amt = 0;if(!empty($presumptive_tax)){
    $presumptive_tax_amt = ($totalNetAmount*$presumptive_tax[0])/100;
    $grandNetAmount += round_this($presumptive_tax_amt);
	$totalVatAmt = round_this($presumptive_tax_amt);
    ?>
    <tr>
    <td colspan="<?=(10-$colspan);?>" class="text-right">
    <span class="text-bold"><?=$this->lang->line('presum-tax');?> @ <?=$presumptive_tax[0];?> %</span></td>
    <td class="text-right"><?=numberFormat(round_this($presumptive_tax_amt));?></td>
    </tr>
    <?php }?>
    <?php $cess_amt = (($totalVatAmt+$total_cst_amount)*$cess)/100;
    $grandNetAmount += round_this($cess_amt);?>

    <tr>
    <td colspan="2" class="text-right text-bold"><?=$this->lang->line('area');?></td>
    <td colspan="<?=(8-$colspan);?>" class="text-right text-bold">
        <div class="row">
            <div class="col-md-9"><input class="form-control" type="text" disabled value="<?=$area_id;?>"></div>
            <div class="col-md-3 pull-right"><?=$this->lang->line('cess');?> @ <?=$cess;?> %</div>
        </div>
    </td>
    <td class="text-right"><?=numberFormat(round_this($cess_amt));?></td>
    </tr>

    <tr>
    <td colspan="2" class="text-right text-bold"><?=$this->lang->line('payment-mode');?></td>
    <td colspan="<?=(8-$colspan);?>" class="text-right text-bold">
    <div class="row">
        <div class="col-md-3"><?= form_dropdown('payment_mode',$payment_modes,set_value('payment_mode'),'class="form-control payment-mode"'); ?><?= form_error('payment_mode');?></div>
        <div class="col-md-3"><?= $this->lang->line('credit-period');?></div>
        <div class="col-md-3"><?= form_input(array('name'=>'credit_period','class'=>'form-control number text-right'),set_value('credit_period')); ?><?=form_error('credit_period');?></div>
        <div class="col-md-3 pull-right"><?= $this->lang->line('freight');?></div>
    </div>
    </td>
    <td class="text-right"><?= form_input(array('name'=>'freight','class'=>'form-control decimal text-right width-150 pull-right freight-amt'),set_value('freight',$sales_array[0]['bill_freight'])); ?><?=form_error('freight');?></td>
    </tr>

    <tr>
	<td colspan="<?=(10-$colspan);?>" class="text-right text-bold">
    <div class="cd-ajax <?php if($cd_status){?>hide<?php }?>">
    <div class="row">

        <div class="col-md-3">
            <?php $transaction_types = $this->dms->transaction_types();?>
            <?= form_dropdown('ccd',$transaction_types,set_value('ccd'),'class="form-control"'); ?>
            <?=form_error('ccd');?>
        </div>

        <div class="col-md-2"><label><?=$this->lang->line('cd-no');?></label></div>
        <div class="col-md-3">
            <?=form_input('cd_no',set_value('cd_no'),"class='form-control'");?>
            <?=form_error('cd_no');?>
        </div>

        <div class="col-md-2"><label><?=$this->lang->line('cheque-date');?></label></div>
        <div class="col-md-2">
        <?=form_input('cheque_date',set_value('cheque_date',cdateFormat(date('Y-m-d'))),"class='datepicker form-control'");?>
        <?=form_error('cheque_date');?>
        </div>
    </div>
    </div>
	</td>
    <td></td>
	</tr>

    <tr>
    <td class="text-right text-bold" colspan="2"><?=$this->lang->line('remarks');?></td>
    <td colspan="<?=(8-$colspan);?>" class="text-right text-bold">
        <div class="row">
        <div class="col-md-9 pull-left"><?= form_textarea(array('name'=>'remarks','class'=>'form-control','rows'=>2),set_value('remarks',$sales_array[0]['narration'])); ?><?=form_error('remarks');?></div>
        <div class="col-md-3 pull-right"><?= $this->lang->line('other-expense');?></div>
        </div>
    </td>
    <td class="text-right"><?= form_input(array('name'=>'other_expense','class'=>'form-control text-right width-150 pull-right other-expense decimal'),set_value('other_expense',$sales_array[0]['other_expense'])); ?><?=form_error('other_expense');?></td>
    <input type="hidden" id="gnTotalAmt" value="<?= round_this($grandNetAmount); ?>">
    </tr>
    <?php
	if($this->input->post('freight')){
		$grandNetAmount += $this->input->post('freight');
	}
	else{
		$grandNetAmount += $sales_array[0]['bill_freight'];
	}
	if($this->input->post('other_expense')){
		$grandNetAmount += $this->input->post('other_expense');
	}
	else{
		$grandNetAmount += $sales_array[0]['other_expense'];
	}
	if($this->input->post('bill_discount_amt')){
		$grandNetAmount -= $this->input->post('bill_discount_amt');
	}
	else{
		$grandNetAmount -= $sales_array[0]['bill_discount_amt'];
	}
	?>
    <?php if(show_round_off()){ ?>
    <tr>
    <td class="text-right text-bold" colspan="<?=(10-$colspan);?>">
    <div class="row">
        <div class="col-md-3 pull-right text-bold"><?=$this->lang->line('round-off');?></div>
    </div>
    </td>
    <td class="text-right text-bold"><div class="in-line" id="roundOff"><?= numberFormat(round_off($grandNetAmount)); ?></div></td>
    </tr>
    <?php }?>
    <tr>
    <td class="text-right text-bold" colspan="2"><?=$this->lang->line('discount');?> %</td>
    <td class="text-right text-bold" colspan="<?=(8-$colspan);?>">
    <div class="row">
        <div class="col-md-3 pull-left"><?= form_input(array('name'=>'bill_discount_per','class'=>'form-control text-right bill_discount_percent decimal'),set_value('bill_discount_per',$sales_array[0]['bill_discount_per'])); ?><?=form_error('bill_discount_per');?></div>
        <div class="col-md-3"><?= $this->lang->line('discount');?> <?=$this->lang->line('amount');?></div>
        <div class="col-md-3"><?= form_input(array('name'=>'bill_discount_amt','class'=>'form-control bill_discount_amount decimal text-right'),set_value('bill_discount_amt',$sales_array[0]['bill_discount_amt'])); ?><?=form_error('bill_discount_amt');?></div>
        <div class="col-md-3 pull-right text-bold"><?=$this->lang->line('net-amount');?></div>
    </div>
    </td>
    <td class="text-right text-bold"><div class="in-line" id="grandTotalAmount"><?= numberFormat(get_rounded($grandNetAmount)); ?></div></td>
    </tr>
    <input type="hidden" name="round_off_amount" id="round_value" value="<?= round_off($grandNetAmount); ?>">
    <input type="hidden" name="vat_total" value="<?=round_this($totalVatAmt); ?>">
    <input type="hidden" name="cess_total" value="<?=round_this($cess_amt); ?>">
	<input type="hidden" name="grand_total" value="<?=round_this($totalNetValue); ?>">
    </table>
    </div>

    <div class="row">
	<div class="col-md-12">
		<div class="form-group">
			<div class="text-right">
				<?= form_submit(array('name'=>'btn_save','class'=>'btn btn-primary btn-loading pull-right','value'=>$this->lang->line('generate-bill')));?>
			</div>
		</div>
	</div>
	</div>

</div>
</div>

<?= form_close();?>