<div class="panel panel-primary">
<div class="panel-heading">
<h6 class="panel-title"><i class="icon-database"></i><?= $this->lang->line("view")." ".$this->lang->line("bill"); ?></h6>
</div>
<div class="panel-body">

<?php if($this->uri->segment(1) == 'delivery_note'){ ?>
<div class="row">
    <div class="col-md-12">
        <?php app_export_menus('id/'.$sales_array[0]['primary_id'],542);?>
    </div>
</div>
<?php } ?>
<?php $bill_prefix = $this->stock->get_voucher_prefix($sales_array[0]['vtype_id']);?>
<div class="form-group">
<div class="row">
    <div class="col-md-4">
        <label><?=$this->lang->line('voucher-types');?></label>
        <input type="text" class="form-control" disabled value="<?=$voucher_type;?>">
    </div>

    <div class="col-md-4">
        <label><?=$this->lang->line('bill-no');?></label>
        <div class="input-group">
            <span class="input-group-addon text-bold" id="bill-prefix"><?= $bill_prefix; ?></span>
            <input type="text" class="form-control" disabled value="<?=$sales_array[0]['bill_no'];?>">
        </div>
    </div>
    <div class="col-md-4">
        <label><?=$this->lang->line('bill-date');?></label>
        <input type="text" class="form-control" disabled value="<?=dateFormat($sales_array[0]['bill_date']);?>">
    </div>
</div>
</div>

<div class="form-group">
<div class="row">
    <div class="col-md-3">
        <label><?=$this->lang->line('dno');?></label>
        <input type="text" class="form-control" disabled value="<?=$sales_array[0]['dno'];?>">
    </div>
    <div class="col-md-3">
        <label><?=$this->lang->line('customer-types');?></label>
        <input type="text" class="form-control" disabled value="<?php if($sales_array[0]['customer_type_id'] == 1){echo "Branch";}elseif($sales_array[0]['customer_type_id'] == 2){echo "Customer";}else{echo "AR";}?>">
    </div>
    <div class="col-md-6">
        <label><?=$this->lang->line('customer-name');?></label>
        <input type="text" class="form-control" disabled value="<?=$customer_name;?>">
    </div>
</div>
</div>
<div class="form-group">
<div class="row">
    <div class="col-md-4">
        <label><?=$this->lang->line('user-type');?></label>
        <input type="text" class="form-control" disabled value="<?=$user_type;?>">
    </div>
    <div class="col-md-4">
        <label><?=$this->lang->line('user');?></label>
        <input type="text" class="form-control" disabled value="<?=$user;?>">
    </div>
    <div class="col-md-4">
        <label><?=$this->lang->line('pricelist');?></label>
        <input type="text" class="form-control" disabled value="<?=$pricelist;?>">
    </div>
</div>
</div>

<div class="row">
<div class="col-md-12">

    <div class='table-responsive'>
    <table class="table table-bordered table-striped">
    <thead>
    <tr class="bg-success">
    <th>#</th>
    <th><?= $this->lang->line('item-name');?></th>
    <th><?= $this->lang->line('quantity');?></th>
    <th><?= $this->lang->line('unit'); ?></th>
    <th><?= $this->lang->line('rate'); ?></th>
    <th><?= $this->lang->line('amount'); ?></th>
    <th><?= $this->lang->line('dis'); ?> <?= $this->lang->line('amt'); ?></th>
    <th><?= $this->lang->line('net-value'); ?></th>
    <?php 
		$b_date = $sales_array[0]['bill_date'];
		$l_date = '2017-07-01';
		if($b_date < $l_date)
		{	
			$a=10;$b=8;	
			$colspan = 2;
			if(empty($presumptive_tax) && $sales_cst)
			{
				$colspan-=1;
	?>
    			<th><?= $this->lang->line('cst').". ".$this->lang->line('amt'); ?></th>
	<?php 
			}
	?>
    <?php 
			if(empty($presumptive_tax))
			{
				$colspan-=2;
	?>
        		<th><?= $this->lang->line('vat'); ?> (%)</th>
        		<th><?= $this->lang->line('vat'); ?> <?= $this->lang->line('amt'); ?></th>
    <?php 
			}
		}
		else
		{
			$a=12;$b=10;
	?>	
    		<th><?= $this->lang->line('cgst'); ?> (%)</th>
            <th><?= $this->lang->line('sgst'); ?> (%)</th>
        	<th><?= $this->lang->line('cgst'); ?> <?= $this->lang->line('amt'); ?></th>
        	<th><?= $this->lang->line('sgst'); ?> <?= $this->lang->line('amt'); ?></th>
	<?php		
		}
	?>
    <th class="width-150"><?= $this->lang->line('net'); ?> <?= $this->lang->line('amt'); ?></th>
    </tr>
    </thead>
    <?php
    $i=0;$totalAmount=0;$totalDiscountAmt=0;$totalNetValue=0;$totalVatAmt=0;$totalNetAmount=0;//$totalFreight=0;
    $grandNetAmount=0;$total_cst_amount = 0;
	$cess = $sales_array[0]['cess'];
    foreach($sales_array as $key => $item)
    {
        $i++;
        $itemID = $item['item_id'];
        $item_details = $this->stock->get_item($itemID,array('item_code','item_name'));
        $qty = $item['qty'];
        $rate = $item['rate'];
        $discount_per = $item['discount_per'];
        $discount_amt = $item['discount_amt'];
        $cst_percent = $item['cst'];
        $vat = 0;$vatAmount = 0;$cst_amount = 0;
        $amount = $item['amount'];
        $totalAmount += $amount;
        $netValue = $amount-$discount_amt;
		if($b_date < $l_date)
		{
			if(empty($presumptive_tax)){
				if($cst_percent == 0){
					$vat = $this->stock->get_item_vat($itemID);
					$vatAmount = $item['vat_amt'];
					$totalVatAmt += $vatAmount;
				}else{
					$cst_amount = ($netValue*$cst_percent)/100;
				}
			}
	        $total_cst_amount += $cst_amount;
			$netAmount = $netValue+$vatAmount+$cst_amount;
		}
		else
		{
			$cgst = $this->stock->get_item_cgst($itemID);
			$sgst = $this->stock->get_item_sgst($itemID);
			$cgstAmt = $item['cgst_amt'];
			$sgstAmt = $item['sgst_amt'];
			$vatAmount = $cgstAmt+$sgstAmt ;
			$totalVatAmt += $vatAmount;	
			$netAmount = $netValue+$vatAmount;
		}
        $totalNetValue += $netValue;
        $totalNetAmount += $netAmount;
        $totalDiscountAmt += $discount_amt;
        ?>
        <tr>
        <td class="text-center"><?= $i; ?></td>
        <td><?= $item_details['item_code']; ?> / <?= $item_details['item_name']; ?></td>
        <td class="text-right"><?= $qty; ?></td>
        <td><?=$this->stock->get_unit_symbol($item['unit_id']); ?></td>
        <td class="text-right"><?= numberFormat($rate); ?></td>
        <td class="text-right"><?= numberFormat(round_this($amount)); ?></td>
        <td class="text-right"><?= numberFormat(round_this($discount_amt)); ?></td>
        <td class="text-right"><?= numberFormat(round_this($netValue)); ?></td>
        <?php 
		if($b_date < $l_date)
		{
			if(empty($presumptive_tax) && $sales_cst)
			{
		?>
        		<td class="text-right"><?= numberFormat(round_this($cst_amount)); ?></td>
		<?php 
			}
		?>
        <?php 
			if(empty($presumptive_tax))
			{
		?>
            	<td class="text-right"><?= $vat; ?></td>
            	<td class="text-right"><?= numberFormat(round_this($vatAmount)); ?></td>
        <?php 
			}
		}
		else
		{
		?>
        	<td class="text-right"><?= $cgst; ?></td>
            <td class="text-right"><?= $sgst; ?></td>
            <td class="text-right"><?= numberFormat(round_this($cgstAmt)); ?></td>
            <td class="text-right"><?= numberFormat(round_this($sgstAmt)); ?></td>
        <?php	
		}
		?>
        <td class="text-right"><?= numberFormat(round_this($netAmount)); ?></td>
        </tr>
        <?php
    }
    $grandNetAmount = round_this($totalNetAmount);
    ?>
    <tr>
    <td class="text-right text-bold" colspan="5"><?= $this->lang->line('total'); ?></td>
    <td class="text-right text-bold"><?= numberFormat(round_this($totalAmount)); ?></td>
    <td class="text-right text-bold"><?= numberFormat(round_this($totalDiscountAmt)); ?></td>
    <td class="text-right text-bold"><?= numberFormat(round_this($totalNetValue)); ?></td>
    <?php
	if($b_date < $l_date)
	{
		if(empty($presumptive_tax) && $sales_cst)
		{
	?>
    		<td class="text-right text-bold"><?= numberFormat(round_this($total_cst_amount)); ?></td>
	<?php 
		}
	?>
    <?php 
		if(empty($presumptive_tax))
		{
	?>
      		<td class="disabled"></td>
        	<td class="text-right text-bold"><?= numberFormat(round_this($totalVatAmt)); ?></td>
    <?php 
		}
	}
	else
	{
	?>
    	<td class="disabled"></td>
        <td class="text-right text-bold" colspan="2">GST Amt.</td>
        <td class="text-right text-bold"><?= numberFormat(round_this($totalVatAmt)); ?></td>
    <?php
	}
	?>
    <td class="text-right text-bold"><?= numberFormat(round_this($totalNetAmount)); ?></td>
    </tr>

    <?php $presumptive_tax_amt = 0;if(!empty($presumptive_tax)){
    $presumptive_tax_amt = ($totalNetAmount*$presumptive_tax[0])/100;
    $grandNetAmount += round_this($presumptive_tax_amt);
    ?>
    <tr>
    <td colspan="<?=($a-$colspan);?>" class="text-right">
    <span class="text-bold"><?=$this->lang->line('presum-tax');?> @ <?=$presumptive_tax[0];?> %</span></td>
    <td class="text-right"><?=numberFormat(round_this($presumptive_tax_amt));?></td>
    </tr>
    <?php }?>
    <?php $cess_amt = (($totalVatAmt+$total_cst_amount+$presumptive_tax_amt)*$cess)/100;
    $grandNetAmount += round_this($cess_amt);?>

    <tr>
    <td colspan="2" class="text-right text-bold"><?=$this->lang->line('area');?></td>
    <td colspan="<?=($b-$colspan);?>" class="text-right text-bold">
        <div class="row">
            <div class="col-md-9"><input class="form-control" type="text" disabled value="<?=$area_id;?>"></div>
            <div class="col-md-3 pull-right"><?=$this->lang->line('cess');?> @ <?=$cess;?> %</div>
        </div>
    </td>
    <td class="text-right"><?=numberFormat(round_this($cess_amt));?></td>
    </tr>

    <tr>
	<td colspan="<?=($a-$colspan);?>" class="text-right text-bold">
    <div class="row">
    	<div class="col-md-12 pull-right"><?= $this->lang->line('freight');?></div>
    </div>
	</td>
	<td class="text-right"><?=numberFormat(round_this($sales_array[0]['bill_freight']));?></td>
	</tr>

    <tr>
    <td class="text-right text-bold" colspan="2"><?=$this->lang->line('remarks');?></td>
    <td colspan="<?=($b-$colspan);?>" class="text-right text-bold">
        <div class="row">
        <div class="col-md-9 pull-left"><textarea class="form-control" disabled><?=$sales_array[0]['narration'];?></textarea></div>
        <div class="col-md-3 pull-right"><?= $this->lang->line('other-expense');?></div>
        </div>
    </td>
    <td class="text-right"><?=numberFormat(round_this($sales_array[0]['other_expense']));?></td>
    </tr>
    <?php
	$grandNetAmount += (($sales_array[0]['bill_freight']+$sales_array[0]['other_expense'])-$sales_array[0]['bill_discount_amt']);
	?>

    <?php if(show_round_off()){ ?>
    <tr>
    <td class="text-right text-bold" colspan="<?=($a-$colspan);?>">
    <div class="row">
        <div class="col-md-3 pull-right text-bold"><?=$this->lang->line('round-off');?></div>
    </div>
    </td>
    <td class="text-right text-bold"><div class="in-line" id="roundOff"><?= numberFormat(round_off($grandNetAmount)); ?></div></td>
    </tr>
    <?php } ?>

    <tr>
    <td class="text-right text-bold" colspan="2"><?=$this->lang->line('discount');?> %</td>
    <td class="text-right text-bold" colspan="<?=($b-$colspan);?>">
    <div class="row">
        <div class="col-md-3 pull-left"><input class="form-control text-right" type="text" disabled value="<?=$sales_array[0]['bill_discount_per'];?>"></div>
        <div class="col-md-3"><?= $this->lang->line('discount');?> <?=$this->lang->line('amount');?></div>
        <div class="col-md-3"><input class="form-control text-right" type="text" disabled value="<?=$sales_array[0]['bill_discount_amt'];?>"></div>
        <div class="col-md-3 pull-right text-bold"><?=$this->lang->line('net-amount');?></div>
    </div>
    </td>
    <td class="text-right text-bold"><div class="in-line" id="grandTotalAmount"><?= numberFormat(get_rounded($grandNetAmount)); ?></div></td>
    </tr>
    </table>
    </div>

    <div class="row">
    <div class="col-md-7 pull-left text-bold"><?=$this->lang->line('last-updated-by')." : ".get_username($sales_array[0]['created_by']);?></div>
    <div class="col-md-5 text-right text-bold"><?=$this->lang->line('last-updated-on')." : ".dateTimeFormat($sales_array[0]['created_on']);?></div>
    </div>

</div>
</div>
</div>
</div>