<?= form_open();
$billDisable=$dateDisabled=NULL;
$uriArray = $this->uri->uri_to_assoc(3);
$uriString = $this->uri->assoc_to_uri($uriArray);
$customer_fname=$customer_lname=$address=$phone_no=$mobile_no=$quotation_type=NULL;
if(!empty($quotations)){
	$l_date = '2017-07-01';
	$billDisable = 'readonly';
	$bill_num = $quotations[0]['qt_no'];
	$bill_date = $quotations[0]['qt_date'];
	$customer_fname = $quotations[0]['customer_fname'];
	$customer_lname = $quotations[0]['customer_lname'];
	$address = $quotations[0]['address'];
	$phone_no = $quotations[0]['phone_no'];
	$mobile_no = $quotations[0]['mobile_no'];
	$quotation_type = $quotations[0]['qt_type'];
	$cess = $quotations[0]['cess'];
	$area_id = $quotations[0]['area_id'];
	$billDiscountPer = $quotations[0]['qt_discount_per'];
	$billDiscountAmt = $quotations[0]['qt_discount_amt'];
	$remarks = $quotations[0]['remarks'];;
}?>
<div class="panel panel-primary">
    <div class="panel-heading">
    	<h6 class="panel-title"><i class="icon-database"></i> <?= $this->lang->line('edit-quotation'); ?> </h6>
    </div>
	<div class="panel-body">
        <div class="form-group">
            <div class="row">
                <div class="col-md-6">
                    <label class="required"><?=$this->lang->line('bill-no');?></label>
                    <?= form_input(array('name'=>'bill_no','class'=>'form-control number text-right'),set_value('bill_no',$bill_num)); ?>
                    <?= form_error('bill_no');?>
                </div>
                <div class="col-md-6">
                    <label class="required"><?=$this->lang->line('bill-date');?></label>
                    <?= form_input(array('name'=>'bill_date','class'=>'form-control datepicker'),set_value('bill_date',cdateFormat($bill_date))); ?>
                    <?= form_error('bill_date');?>
                </div>
            </div>
        </div>

        <div class="form-group">
            <div class="row">
                <label class="col-md-3"><?= $this->lang->line('customer-name'); ?></label>
                <div class="col-md-5">
					<?= form_input(array('name'=>'customer_fname','class'=>'form-control','placeholder'=>$this->lang->line('first-name')),set_value('customer_fname',$customer_fname)); ?>
                    <?= form_error('customer_fname');?>
                </div>
                <div class="col-md-4">
					<?= form_input(array('name'=>'customer_lname','class'=>'form-control','placeholder'=>$this->lang->line('last-name')),set_value('customer_lname',$customer_lname)); ?>
                    <?= form_error('customer_lname');?>
                </div>
            </div>
        </div>

        <div class="form-group">
            <div class="row">
                <label class="col-md-3"><?= $this->lang->line('address'); ?></label>
                <div class="col-md-9">
					<?= form_input(array('name'=>'address','class'=>'form-control'),set_value('address',$address)); ?>
                    <?= form_error('address');?>
                </div>
            </div>
        </div>

        <div class="form-group">
            <div class="row">
                <div class="col-md-6">
                    <label class=""><?=$this->lang->line('phone');?></label>
                    <?= form_input(array('name'=>'phone_no','class'=>'form-control number'),set_value('phone_no',$phone_no)); ?>
                    <?= form_error('phone_no');?>
                </div>
                <div class="col-md-6">
                    <label class="required"><?=$this->lang->line('mobile');?></label>
                     <?= form_input(array('name'=>'mobile_no','class'=>'form-control number'),set_value('mobile_no',$mobile_no)); ?>
                    <?= form_error('mobile_no');?>
                </div>
            </div>
        </div>

        <div class="form-group">
            <div class="row">
                <label class="requiread col-md-3"><?= $this->lang->line('quotation-type'); ?></label>
                <div class="col-md-9">
					<?= form_dropdown('quotation_type',$quotation_types,set_value('quotation_type',$quotation_type),"class='form-control'"); ?>
                    <?= form_error('quotation_type');?>
                </div>
            </div>
        </div>


        <div class="form-group">
            <div class="row">
                <div class="col-md-6">
                    <label class="required"><?=$this->lang->line('item-name');?></label>
                    <?= form_dropdown('item_id',$items,set_value('item_id'),'class="form-control item_name"'); ?>
                    <?= form_error('item_id');?>
                </div>
                <?php $sales_CST = $this->stock->get_constant(array('sales_cst')); ?>
                <div class="col-md-<?= 6-($sales_CST)*2; ?>">
                    <label class="required"><?=$this->lang->line('godown');?></label>
                    <?= form_dropdown('godown_id',$goDowns,set_value('godown_id'),'class="form-control godown"'); ?>
                    <?= form_error('godown_id');?>
                </div>
                <div class="col-md-2">
					<?php if(!empty($sales_CST) && empty($presumtiveTax)){ ?>
                        <label><?=$this->lang->line('cst');?> %</label>
                        <?= form_input(array('name'=>'cst','class'=>'form-control text-right cst decimal'),set_value('cst')); ?>
                        <?= form_error('cst');?>
                    <?php } ?>
                </div>
            </div>
        </div>

        <div class="form-group">
            <div class="row">
                <div class="col-md-2">
                    <label class="required"><?=$this->lang->line('quantity');?></label>
                    <?= form_input(array('name'=>'qty','class'=>'form-control text-right qnty qty-rate decimal'),set_value('qty')); ?>
                    <?= form_error('qty');?>
                </div>
                <div class="col-md-2">
                    <label class="required"><?=$this->lang->line('unit');?></label>
                    <?= form_dropdown('unit_id',$units,set_value('unit_id'),'class="form-control unit"'); ?>
                    <?= form_error('unit_id');?>
                </div>
                <div class="col-md-2">
                    <label class="required"><?=$this->lang->line('rate');?></label>
                    <?= form_input(array('name'=>'rate','class'=>'form-control text-right rate qty-rate decimal'),set_value('rate')); ?>
                    <?= form_error('rate');?>
                </div>
                <div class="col-md-2">
                    <label class="required"><?=$this->lang->line('amount');?></label>
                    <?= form_input(array('name'=>'amount','class'=>'form-control text-right amount decimal'),set_value('amount')); ?>
                </div>
                <div class="col-md-2">
                    <label class=""><?=$this->lang->line('discount');?> %</label>
                    <?= form_input(array('name'=>'discount_per','class'=>'form-control text-right decimal discount_per','id'=>'discount_per'),set_value('discount_per')); ?>
                    <?= form_error('discount_per');?>
                </div>
                <div class="col-md-2">
                    <label class=""><?=$this->lang->line('discount');?> <?=$this->lang->line('amt');?></label>
                    <?= form_input(array('name'=>'discount_amt','class'=>'form-control text-right decimal discount_amt'),set_value('discount_amt')); ?>
                    <?= form_error('discount_amt');?>
                </div>
            </div>
        </div>

        <div class="form-group">
            <div class="row">
                <div class="col-md-3"><?=$this->lang->line('rate');?> : <label type="text" class="rate-per text-right"></label> <label id="primary-unit"></label></div>
                <div class="col-md-9">
                    <?=form_button(array('type'=>'submit','name'=>'add_to_bill','class'=>'btn btn-primary btn-loading pull-right','content'=>$this->lang->line('add-to-bill')));?>
                </div>
            </div>
        </div>

		<?php if(!empty($quotations)){	?>
        <div class="form-group">
            <div class="row">
                <div class="col-md-12">
                <div class='table-responsive'>
                <table class="table table-bordered table-striped">
                <thead>
                <tr class="bg-success">
                <th>#</th>
                <th><?=$this->lang->line('item-name');?></th>
                <th><?=$this->lang->line('quantity');?></th>
                <th><?= $this->lang->line('unit'); ?></th>
                <th><?= $this->lang->line('rate'); ?></th>
                <th><?= $this->lang->line('amount'); ?></th>
                <th><?= $this->lang->line('dis'); ?> <?= $this->lang->line('amt'); ?></th>
                <th><?= $this->lang->line('net-value'); ?></th>
                <?php 
					if($bill_date < $l_date)
					{
                                                $a=10;
						if(!empty($cst_enabled) && empty($presumtiveTax))
						{ 
				?>
							<th><?= $this->lang->line('cst'); ?></th>
				<?php 
						} 
				?>
				<?php 
						if(empty($presumtiveTax))
						{ 
				?>
							<th><?= $this->lang->line('vat'); ?> (%)</th>
							<th><?= $this->lang->line('vat'); ?> <?= $this->lang->line('amt'); ?></th>
				<?php 
						} 
					}
					else
					{
                                               $a=12;
				?>	
                		<th><?= $this->lang->line('cgst'); ?> (%)</th>
                        <th><?= $this->lang->line('sgst'); ?> (%)</th>
						<th><?= $this->lang->line('cgst'); ?> <?= $this->lang->line('amt'); ?></th>
						<th><?= $this->lang->line('sgst'); ?> <?= $this->lang->line('amt'); ?></th>	
				<?php		
					}
				?>
                <th><?= $this->lang->line('net'); ?> <?= $this->lang->line('amt'); ?></th>
                <th colspan="2"><?= $this->lang->line('actions'); ?></th>
                </tr>
                </thead>
                <?php
                $i=0;$totalAmount=0;$totalDiscountAmt=0;$totalNetValue=0;$totalVatAmt=0;$totalNetAmount=0;
                $grandNetAmount=0;$totalCst=0;
                $cst=0;
                foreach($quotations as $key=>$quotation){ $i++;

                    $qtnItemID = $quotation['dqi_id'];
                    $itemID = $quotation['item_id'];
                    $qty = $quotation['qty'];
                    $rate = $quotation['rate'];
                    $cstPercent = $quotation['cst'];
                    $discountPer = $quotation['discount_per'];
                    $discountAmt = $quotation['discount_amt'];
					$amount = $quotation['amount'];
                    $totalAmount += $amount;
                    $totalDiscountAmt += $discountAmt;
                    $netValue = $amount-$discountAmt;
					$totalNetValue += $netValue;
                    $vatAmount=0;$cstAmount=0;$vat=0;
					if($bill_date < $l_date)
					{
						if($cstPercent == 0){
							$vat = $this->stock->get_item_vat($itemID);
						}else{
							$cst=1;
						}
                   
						$cstAmount = ($cstPercent*$netValue)/100;
						if(empty($presumtiveTax)){
							$vatAmount = $quotation['vat_amt'];//($vat*$netValue)/100;
						}else{
							$cstAmount=0;
						}
						$netValue += $cstAmount;
						$totalCst += $cstAmount;
					}
					else
					{
						$cgst =  $this->stock->get_item_cgst($itemID);
						$sgst =  $this->stock->get_item_sgst($itemID);
						$cgstAmount = $quotation['cgst_amt'];	
						$sgstAmount = $quotation['sgst_amt'];
						$vatAmount = $cgstAmount+$sgstAmount;
						
					}
                    $totalVatAmt += $vatAmount;
                    $netAmount = $netValue+$vatAmount;
                    $totalNetAmount += $netAmount;
                    
                    ?>
                    <tr>
                    <td><?= $i; ?></td>
                    <td><?= $quotation['item_code']; ?> / <?= $quotation['item_name']; ?></td>
                    <td class="text-right"><?= $qty; ?></td>
                    <td><?= $quotation['symbol']; ?></td>
                    <td class="text-right"><?= numberFormat($rate); ?></td>
                    <td class="text-right"><?= numberFormat(round_this($amount)); ?></td>
                    <td class="text-right"><?= numberFormat(round_this($discountAmt)); ?></td>
                    <td class="text-right"><?= numberFormat(round_this($netValue)); ?></td>
                    <?php
						if($bill_date < $l_date)
						{
							if(!empty($cst_enabled) && empty($presumtiveTax))
							{ 
					?>
                        		<td class="text-right"><?= numberFormat(round_this($cstAmount)); ?></td>
                    <?php 
							} 
					?>
                    <?php 
							if(empty($presumtiveTax))
							{ 
					?>
                    			<td class="text-right"><?= $vat; ?></td>
                    			<td class="text-right"><?= numberFormat(round_this($vatAmount)); ?></td>
                    <?php 
							} 
						}
						else
						{
					?>
                    		<td class="text-right"><?= $cgst; ?></td>
                            <td class="text-right"><?= $sgst; ?></td>
                    		<td class="text-right"><?= numberFormat(round_this($cgstAmount)); ?></td>
                    		<td class="text-right"><?= numberFormat(round_this($sgstAmount)); ?></td>
                    <?php		
						}
					?>
                    <td class="text-right"><?= numberFormat(round_this($netAmount)); ?></td>
                    <td class="text-center">
                        <a href="<?= base_url('quotations/edit_item/'.$qtnItemID.'/'.$uriString); ?>" title="<?= $this->lang->line('edit'); ?>"><i class="glyphicon glyphicon-pencil"></i></a>
                    </td>
                    <td class="text-center">
                    <a href="<?= base_url('quotations/remove_item/'.$qtnItemID.'/'.$uriString); ?>" title="<?= $this->lang->line('remove'); ?>" class="text-danger delete"><i class="glyphicon glyphicon-remove delete danger"></i></a>
                    </td>
                    </tr>
                    <?php
                }
                $grandNetAmount = round_this($totalNetAmount);
                ?>
                <tr>
                <td class="text-right text-bold" colspan="5"><?= $this->lang->line('total'); ?></td>
                <td class="text-right text-bold"><?= numberFormat(round_this($totalAmount)); ?></td>
                <td class="text-right text-bold"><?= numberFormat(round_this($totalDiscountAmt)); ?></td>
                <td class="text-right text-bold"><?= numberFormat(round_this($totalNetValue)); ?></td>
                <?php
					if($bill_date < $l_date)
					{ 
						if(!empty($cst_enabled) && empty($presumtiveTax))
						{ 
				?>
                    		<td class="text-right text-bold"><?= numberFormat(round_this($totalCst)); ?></td>
                <?php 
						} 
				?>
                <?php 
						if(empty($presumtiveTax))
						{ 
				?>
                    		<td class="disabled"></td>
                    		<td class="text-right text-bold"><?= numberFormat(round_this($totalVatAmt)); ?></td>
                <?php 
						}
					}
					else
					{
				?>
                		<td class="disabled"></td>
                        <td class="text-right text-bold" colspan="2">GST Amt.</td>
                    	<td class="text-right text-bold"><?= numberFormat(round_this($totalVatAmt)); ?></td>
                <?php		
					}
				?>
                <td class="text-right text-bold"><?= numberFormat(round_this($totalNetAmount)); ?></td>
                <td class="disabled"></td>
                <td class="disabled"></td>
                </tr>
                <?php
                $gnTotalVatAmount=$totalVatAmt;
				if($bill_date < $l_date)
				{
					if(!empty($presumtiveTax)){
						$pmTaxAmt = ($presumtiveTax[0]*$totalNetAmount)/100;
						$gnTotalVatAmount = round_this($pmTaxAmt);
						$grandNetAmount += round_this($pmTaxAmt);
						?>
						<tr>
						<td class="text-right text-bold" colspan="<?= 8; ?>"><?= $this->lang->line('presum-tax') ?> @ <?= $presumtiveTax[0]; ?> %</td>
						<td class="text-right text-bold"><?= round_this($pmTaxAmt); ?></td>
						<td class="disabled"></td>
						<td class="disabled"></td>
						</tr>
						<?php
					}
					$cessAmount=0;
					$cess = $this->stock->get_cess();
					$cessAmount = ($cess*($gnTotalVatAmount+$totalCst))/100;
					$grandNetAmount += round_this($cessAmount);
				}
                ?>
                <tr>
                <td class="" colspan="<?= (empty($presumtiveTax))?$a+$cst:8; ?>">
                <div class="row">
                    <div class="col-md-4">
                        <label><?=$this->lang->line('discount');?> %</label>
                        <?= form_input(array('name'=>'bill_discount_per','class'=>'form-control bill_discount_per text-right decimal'),set_value('bill_discount_per',$billDiscountPer)); ?>
                        <?= form_error('bill_discount_per'); ?>
                    </div>
                    <div class="col-md-4">
                        <label><?=$this->lang->line('discount');?> <?=$this->lang->line('amount');?></label>
                        <?= form_input(array('name'=>'bill_discount_amt','class'=>'form-control bill_discount_amt text-right decimal'),set_value('bill_discount_amt',$billDiscountAmt)); ?>
                        <?= form_error('bill_discount_amt'); ?>
                    </div>
                    <div class="col-md-4">
                        <span class="text-bold pull-right"><?=$this->lang->line('cess');?> ( <?= $cess; ?> %)</span>
                    </div>
                </div>
                </td>
                <td class="text-right text-bold">
                <div id="cess_amount"><?= round_this($cessAmount); ?></div>
                </td>
                <td class="disabled"></td>
                <td class="disabled"><input type="hidden" id="gnTotalAmt" value="<?= round_this($grandNetAmount); ?>"></td>
                </tr>
    			<?php $grandNetAmount -= $billDiscountAmt; ?>

                <?php if(show_round_off()){ ?>
                <tr>
                <td class="text-right" colspan="<?= (empty($presumtiveTax))?$a+$cst:8; ?>">
                <div class="row">
                    <div class="col-md-3 pull-right text-bold"><?=$this->lang->line('round-off');?></div>
                </div>
                </td>
                <td class="text-right text-bold">
                    <div class="in-line" id="roundOff"><?= numberFormat(round_off($grandNetAmount)); ?></div>
                </td>
                <td class="disabled"></td>
                <td class="disabled"></td>
                </tr>
                <?php } ?>

                <tr>
                <td class="text-right text-bold" colspan="2">
                <label class="required"><?=$this->lang->line('area');?></label>
                </td>
                <td class="text-right" colspan="<?= (empty($presumtiveTax))?$a-2+$cst:6; ?>">
                <div class="row">
                    <div class="col-md-9 pull-left">
                    <?= form_dropdown('area_id',$areas,set_value('area_id',$area_id),'class="form-control"'); ?>
                    <?= form_error('area_id'); ?>
                    </div>
                    <div class="col-md-3 pull-right text-bold"><?=$this->lang->line('net-amount');?></div>
                </div>
                </td>
                <td class="text-right text-bold">
                    <div class="in-line" id="grandTotalAmount"><?= numberFormat(get_rounded($grandNetAmount)); ?></div>
                </td>
                <td class="disabled"></td>
                <td class="disabled"></td>
                </tr>

                <tr>
                <td class="text-right text-bold" colspan="2"><?=$this->lang->line('remarks');?></td>
                <td class="text-right" colspan="<?= (empty($presumtiveTax))?11+$cst:9; ?>">
                    <div class="row">
                        <div class="col-md-12 pull-left"><?= form_textarea(array('name'=>'remarks','class'=>'form-control','rows'=>2),set_value('remarks')); ?></div>
                    </div>
                </td>
                </tr>
                </table>
                </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="form-group">
                    <div class="text-right">
                        <?= form_button(array('type'=>'submit','name'=>'save_bill','class'=>'btn btn-primary btn-loading pull-right','content'=>$this->lang->line('save')));?>
                    </div>
                </div>
            </div>
        </div>
    <?php }	?>
	</div>
</div>
<?= form_close(); ?>