<?= form_open(); ?>
<?php
if(!empty($quotations)){

	$item_id = $quotations[0]['item_id'];
	$go_dwn_id = $quotations[0]['godown_id'];
	$item_name = $quotations[0]['item_code'].' '.$quotations[0]['item_name'];
	$unit_id = $quotations[0]['unit_id'];
	$qty = round_this($quotations[0]['qty']);
	$rate = round_this($quotations[0]['rate']);
	$amount = round_this($quotations[0]['amount']);
	$discountPer = round_this($quotations[0]['discount_per']);
	$discountAmt = round_this($quotations[0]['discount_amt']);
	$cst = round_this($quotations[0]['cst']);
	$cgst_amt = round_this($quotations[0]['cgst_amt']);
        $sgst_amt = round_this($quotations[0]['sgst_amt']);

	$primaryRate = $this->stock->get_item_rate($item_id);
	$itemPrimaryUnits = $this->stock->get_primary_unit($item_id);
	$primaryUnit = (!empty($itemPrimaryUnits))?$itemPrimaryUnits['symbol']:'';
}
?>
<div class="panel panel-primary">
    <div class="panel-heading">
    	<h6 class="panel-title"><i class="icon-database"></i><?= $this->lang->line('edit-quotation'); ?></h6>
    </div>
	<div class="panel-body">

	<div class="form-group">
	<div class="row">

	<div class="col-md-6">
	<label class="required"><?=$this->lang->line('item-name');?></label>
    <?= form_input(array('name'=>'item_id','class'=>'form-control decimal'),set_value('item_id',$item_name),"readonly disabled"); ?>
	<?= form_error('item_id');?>
	</div>

    <?php $sales_CST = $this->stock->get_constant(array('sales_cst')); ?>
	<div class="col-md-<?= 6-($sales_CST)*2; ?>">
	<label class="required"><?=$this->lang->line('godown');?></label>
	<?= form_dropdown('godown_id',$goDowns,set_value('godown_id',$go_dwn_id),'class="form-control godown"'); ?>
    <?= form_error('godown_id');?>
	</div>

   	<div class="col-md-2">
    <?php if(!empty($sales_CST) && empty($presumtiveTax)){ ?>
	<label><?=$this->lang->line('cst');?> %</label>
	<?= form_input(array('name'=>'cst','class'=>'form-control text-right cst decimal'),set_value('cst',$cst)); ?>
	<?= form_error('cst');?>
    <?php } ?>
	</div>
	</div>
	</div>

	<div class="form-group">
	<div class="row">
   	<div class="col-md-2">
	<label class="required"><?=$this->lang->line('quantity');?></label>
	<?= form_input(array('name'=>'qty','class'=>'form-control text-right qnty qty-rate decimal'),set_value('qty',$qty)); ?>
	<?= form_error('qty');?>
	</div>

   	<div class="col-md-2">
	<label class="required"><?=$this->lang->line('unit');?></label>
	<?= form_dropdown('unit_id',$units,set_value('unit_id',$unit_id),'class="form-control unit"'); ?>
    <?= form_error('unit_id');?>
	</div>

   	<div class="col-md-2">
	<label class="required"><?=$this->lang->line('rate');?></label>
	<?= form_input(array('name'=>'rate','class'=>'form-control text-right rate qty-rate decimal'),set_value('rate',$rate)); ?>
	<?= form_error('rate');?>
	</div>

   	<div class="col-md-2">
	<label class="required"><?=$this->lang->line('amount');?></label>
	<?= form_input(array('name'=>'amount','class'=>'form-control text-right amount decimal'),set_value('amount',$amount)); ?>
	</div>

   	<div class="col-md-2">
	<label class=""><?=$this->lang->line('discount');?> %</label>
	<?= form_input(array('name'=>'discount_per','class'=>'form-control text-right decimal discount_per','id'=>'discount_per'),set_value('discount_per',$discountPer)); ?>
	<?= form_error('discount_per');?>
	</div>

   	<div class="col-md-2">
	<label class=""><?=$this->lang->line('discount');?> <?=$this->lang->line('amt');?></label>
	<?= form_input(array('name'=>'discount_amt','class'=>'form-control text-right decimal discount_amt'),set_value('discount_amt',$discountAmt)); ?>
	<?= form_error('discount_amt');?>
	</div>
	</div>
	</div>

    <div class="form-group">
        <div class="row">
            <div class="col-md-2 float-left">
                <?=$this->lang->line('rate');?> :
                <label type="text" class="rate-per text-right"><?= numberFormat(round_this($primaryRate)); ?></label>
   				<label id="primary-unit"> / <?= $primaryUnit; ?></label>
            </div>

            <div class="col-md-2 pull-right">
                <?php $disabled_vat = "readonly";?>
                <label><?=$this->lang->line('cgst');?> <?=$this->lang->line('amt');?></label>
                <?=form_input('cgst_amt',set_value('cgst_amt',round_this($cgst_amt)),"class='form-control text-right vat_amt decimal' $disabled_vat");?>
                <?= form_error('cgst_amt');?>
            </div>
            <?php $vat_percent = $this->stock->get_item_cgst($item_id);?>
            <div class="col-md-2 pull-right">
                <label><?=$this->lang->line('cgst');?> %</label>
                <?= form_input(array('class'=>'form-control text-right vat-percent','readonly' => true,'value' => round_this($vat_percent))); ?>
            </div>
        </div>
    </div>

   <div class="form-group">
        <div class="row">
            <div class="col-md-2 pull-right">
                <?php $disabled_vat ="readonly";?>
                <label><?=$this->lang->line('sgst');?> <?=$this->lang->line('amt');?></label>
                <?=form_input('sgst_amt',set_value('sgst_amt',round_this($sgst_amt)),"class='form-control text-right vat_amt decimal' $disabled_vat");?>
                <?= form_error('sgst_amt');?>
            </div>
            <?php $vat_percent1 = $this->stock->get_item_vat($item_id);?>
            <div class="col-md-2 pull-right">
                <label><?=$this->lang->line('sgst');?> %</label>
                <?= form_input(array('class'=>'form-control text-right vat-percent','readonly' => true,'value' => round_this($vat_percent1))); ?>
            </div>
        </div>
    </div>

    <div class="form-group">
        <div class="text-right">
            <?=form_button(array('type' => 'submit','class'=>'btn btn-primary btn-loading pull-right','content'=>$this->lang->line('update')));?>
        </div>
    </div>
</div>
</div>
<?= form_close(); ?>