<?= form_open();
$presumtiveTax = $this->stock->get_tax_type();
$billDisable=$dateDisabled=NULL;
$customer_fname=$customer_lname=$address=$phone_no=$mobile_no=$quotation_type=NULL;
if(!empty($quotations)){
	$l_date = '2017-07-01';
    $quotationID = $quotations[0]['id'];
    $quotation_status = $quotations[0]['qt_status'];
	$billDisable = 'readonly';
	$dateDisabled = 'disabled';
	$bill_num = $quotations[0]['qt_no'];
	$bill_date = $quotations[0]['qt_date'];
	$customer_fname = $quotations[0]['customer_fname'];
	$customer_lname = $quotations[0]['customer_lname'];
	$address = $quotations[0]['address'];
	$phone_no = $quotations[0]['phone_no'];
	$mobile_no = $quotations[0]['mobile_no'];
	$quotation_type = $quotations[0]['qt_type'];
	$cess = $quotations[0]['cess'];
	$area_name = $quotations[0]['area'];
	$billDiscountPer = $quotations[0]['qt_discount_per'];
	$billDiscountAmt = $quotations[0]['qt_discount_amt'];
	$remarks = $quotations[0]['remarks'];
}?>
<div class="panel panel-primary">
    <div class="panel-heading">
    	<h6 class="panel-title"><i class="icon-database"></i> <?= $this->lang->line('view-quotation'); ?> </h6>
    </div>
	<div class="panel-body">
        <div class="row">
            <div class="col-md-12">
               <?php echo app_export_menus($quotationID,array(369)); ?>
            </div>
        </div>
        <div class="form-group">
            <div class="row">
                <div class="col-md-6">
                    <label class=""><?=$this->lang->line('bill-no');?></label>
                    <?= form_input(array('name'=>'bill_no','class'=>'form-control number text-right'),set_value('bill_no',$bill_num),"$billDisable"); ?>
                    <?= form_error('bill_no');?>
                </div>
                <div class="col-md-6">
                    <label class=""><?=$this->lang->line('bill-date');?></label>
                    <?= form_input(array('name'=>'bill_date','class'=>'form-control datepicker'),set_value('bill_date',cdateFormat($bill_date)),"$dateDisabled"); ?>
                    <?= form_error('bill_date');?>
                </div>
            </div>
        </div>

        <div class="form-group">
            <div class="row">
                <label class=" col-md-3"><?= $this->lang->line('customer-name'); ?></label>
                <div class="col-md-5">
                    <?= form_input(array('name'=>'customer_fname','class'=>'form-control','placeholder'=>$this->lang->line('first-name')),set_value('customer_fname',$customer_fname),$billDisable); ?>
                    <?= form_error('customer_fname');?>
                </div>
                <div class="col-md-4">
                    <?= form_input(array('name'=>'customer_lname','class'=>'form-control','placeholder'=>$this->lang->line('last-name')),set_value('customer_lname',$customer_lname),$billDisable); ?>
                    <?= form_error('customer_lname');?>
                </div>
            </div>
        </div>

        <div class="form-group">
            <div class="row">
                <label class=" col-md-3"><?= $this->lang->line('address'); ?></label>
                <div class="col-md-9">
					<?= form_input(array('name'=>'address','class'=>'form-control'),set_value('address',$address),$billDisable); ?>
                    <?= form_error('address');?>
                </div>
            </div>
        </div>

        <div class="form-group">
            <div class="row">
                <div class="col-md-6">
                    <label class=""><?=$this->lang->line('phone');?></label>
                    <?= form_input(array('name'=>'phone_no','class'=>'form-control number'),set_value('phone_no',$phone_no),$billDisable); ?>
                    <?= form_error('phone_no');?>
                </div>
                <div class="col-md-6">
                    <label class=""><?=$this->lang->line('mobile');?></label>
                     <?= form_input(array('name'=>'mobile_no','class'=>'form-control number'),set_value('mobile_no',$mobile_no),$billDisable); ?>
                    <?= form_error('mobile_no');?>
                </div>
            </div>
        </div>

        <div class="form-group">
            <div class="row">
                <label class="requiread col-md-3"><?= $this->lang->line('quotation-type'); ?></label>
                <div class="col-md-9">
					<?= form_input(array('name'=>'quotation_type','class'=>'form-control'),set_value('quotation_type',$quotation_types[$quotation_type]),$billDisable); ?>
                    <?= form_error('quotation_type');?>
                </div>
            </div>
        </div>

		<?php if(!empty($quotations)){	?>
        <div class="form-group">
            <div class="row">
                <div class="col-md-12">
                    <div class='table-responsive'>
                    <table class="table table-bordered table-striped">
                    <thead>
                    <tr class="bg-success">
                    <th>#</th>
                    <th><?=$this->lang->line('item-name');?></th>
                    <th><?=$this->lang->line('quantity');?></th>
                    <th><?= $this->lang->line('unit'); ?></th>
                    <th><?= $this->lang->line('rate'); ?></th>
                    <th><?= $this->lang->line('amount'); ?></th>
                    <th><?= $this->lang->line('dis'); ?> <?= $this->lang->line('amt'); ?></th>
                    <th><?= $this->lang->line('net-value'); ?></th>
                    <?php 
						if($bill_date < $l_date)
						{
							if(!empty($cst_enabled) && empty($presumtiveTax))
							{ 
					?>
								<th><?= $this->lang->line('cst'); ?></th>
					<?php 
							} 
					?>
							
					<?php 
							if(empty($presumtiveTax))
							{ 
					?>
								<th><?= $this->lang->line('vat'); ?> (%)</th>
								<th><?= $this->lang->line('vat'); ?> <?= $this->lang->line('amt'); ?></th>
					<?php 
							} 
						}
						else
						{
					?>	
                    		<th><?= $this->lang->line('cgst'); ?> (%)</th>
                            <th><?= $this->lang->line('sgst'); ?> (%)</th>
							<th><?= $this->lang->line('cgst'); ?> <?= $this->lang->line('amt'); ?></th>
							<th><?= $this->lang->line('sgst'); ?> <?= $this->lang->line('amt'); ?></th>	
					<?php		
						}
					?>
                    <th><?= $this->lang->line('net'); ?> <?= $this->lang->line('amt'); ?></th>
                    </tr>
                    </thead>
					<?php
                    $i=0;$totalAmount=0;$totalDiscountAmt=0;$totalNetValue=0;$totalVatAmt=0;$totalNetAmount=0;
                    $grandNetAmount=0;$totalCst=0;
                    $cst=0;
                    foreach($quotations as $key=>$quotation){ $i++;

						$tempItemID = $quotation['dqi_id'];
						$itemID = $quotation['item_id'];
						$qty = $quotation['qty'];
						$rate = $quotation['rate'];
						$cstPercent = $quotation['cst'];
						$discountPer = $quotation['discount_per'];
						$discountAmt = $quotation['discount_amt'];
						$vatAmount=0;$cstAmount=0;$vat=0;
						$amount = $quotation['amount'];
						$totalAmount += $amount;
						$totalDiscountAmt += $discountAmt;
						$netValue = $amount-$discountAmt;
						$totalNetValue += $netValue;
						if($bill_date < $l_date)
						{
                                                        $a=10;
							if($cstPercent == 0){
								$vat = $this->stock->get_item_vat($itemID);
							}else{
								$cst=1;
							}
							$cstAmount = ($cstPercent*$netValue)/100;
							
							if(empty($presumtiveTax)){
								$vatAmount = $quotation['vat_amt'];//($vat*$netValue)/100;
							}else{
								$cstAmount=0;
							}
							$netValue += $cstAmount;
							$totalCst += $cstAmount;
						}
						else
						{
                                                        $a=12;
							$cgst = $this->stock->get_item_cgst($itemID);
							$sgst = $this->stock->get_item_sgst($itemID);
							$cgstAmount = $quotation['cgst_amt'];
							$sgstAmount = $quotation['sgst_amt'];
							$vatAmount = $cgstAmount+$sgstAmount;
						}
						$totalVatAmt += $vatAmount;
						$netAmount = $netValue+$vatAmount;
						$totalNetAmount += $netAmount;
						
						?>
                        <tr>
                        <td><?= $i; ?></td>
                        <td><?= $quotation['item_code']; ?> / <?= $quotation['item_name']; ?></td>
                        <td class="text-right"><?= $qty; ?></td>
                        <td><?= $quotation['symbol']; ?></td>
                        <td class="text-right"><?= numberFormat($rate); ?></td>
                        <td class="text-right"><?= numberFormat(round_this($amount)); ?></td>
                        <td class="text-right"><?= numberFormat(round_this($discountAmt)); ?></td>
                        <td class="text-right"><?= numberFormat(round_this($netValue)); ?></td>
                        <?php 
							if($bill_date < $l_date)
							{
								if(!empty($cst_enabled) && empty($presumtiveTax))
								{ 
						?>
                        			<td class="text-right"><?= numberFormat(round_this($cstAmount)); ?></td>
                        <?php 
								} 
						?> 
                        <?php 
								if(empty($presumtiveTax))
								{ 
						?>
                        		    <td class="text-right"><?= $vat; ?></td>
                            		<td class="text-right"><?= numberFormat(round_this($vatAmount)); ?></td>
                        <?php 
								} 
							}
							else
							{
						?>	
                        		<td class="text-right"><?= $cgst; ?></td>
                                <td class="text-right"><?= $sgst; ?></td>
                            	<td class="text-right"><?= numberFormat(round_this($cgstAmount)); ?></td>
                            	<td class="text-right"><?= numberFormat(round_this($sgstAmount)); ?></td>	
						<?php		
							}
						?>
                        <td class="text-right"><?= numberFormat(round_this($netAmount)); ?></td>
                        </tr>
						<?php
					}
					$grandNetAmount = round_this($totalNetAmount);
					?>
					<tr>
					<td class="text-right text-bold" colspan="5"><?= $this->lang->line('total'); ?></td>
					<td class="text-right text-bold"><?= numberFormat(round_this($totalAmount)); ?></td>
					<td class="text-right text-bold"><?= numberFormat(round_this($totalDiscountAmt)); ?></td>
                    <td class="text-right text-bold"><?= numberFormat(round_this($totalNetValue)); ?></td>
					<?php 
						if($bill_date < $l_date)
						{
							if(!empty($cst_enabled) && empty($presumtiveTax))
							{ 
					?>
								<td class="text-right text-bold"><?= numberFormat(round_this($totalCst)); ?></td>
					<?php 
							} 
					?>
					<?php 
							if(empty($presumtiveTax))
							{ 
					?>
                    		    <td class="disabled"></td>
                        		<td class="text-right text-bold"><?= numberFormat(round_this($totalVatAmt)); ?></td>
					<?php 
							}
						}
						else
						{
					?>	
                    		<td class="disabled"></td>
                            <td class="text-right text-bold" colspan="2">GST Amt.</td>
                        	<td class="text-right text-bold"><?= numberFormat(round_this($totalVatAmt)); ?></td>	
					<?php		
						}
					?>
					<td class="text-right text-bold"><?= numberFormat(round_this($totalNetAmount)); ?></td>
					</tr>
					<?php
					$gnTotalVatAmount=$totalVatAmt;
					if($bill_date < $l_date)
					{
						if(!empty($presumtiveTax)){
							$pmTaxAmt = ($presumtiveTax[0]*$totalNetAmount)/100;
							$gnTotalVatAmount = round_this($pmTaxAmt);
							$grandNetAmount += round_this($pmTaxAmt);
							?>
							<tr>
							<td class="text-right text-bold" colspan="<?= ($a-2); ?>"><?= $this->lang->line('presum-tax') ?> @ <?= $presumtiveTax[0]; ?> %</td>
							<td class="text-right text-bold"><?= numberFormat(round_this($pmTaxAmt)); ?></td>
							</tr>
							<?php
						}
						$cessAmount=0;
						$cessAmount = ($cess*($gnTotalVatAmount+$totalCst))/100;
						$grandNetAmount += round_this($cessAmount);
					}
					?>
                    <tr>
                    <td class="" colspan="<?= (empty($presumtiveTax))?$a+$cst:8; ?>">
                    <div class="row">
                        <div class="col-md-4">
                            <label><?=$this->lang->line('discount');?> %</label>
                            <?= form_input(array('name'=>'bill_discount_per','class'=>'form-control bill_discount_per text-right decimal'),set_value('bill_discount_per',$billDiscountPer)); ?>
                        <?= form_error('bill_discount_per'); ?>
                        </div>
                        <div class="col-md-4">
                            <label><?=$this->lang->line('discount');?> <?=$this->lang->line('amount');?></label>
                            <?= form_input(array('name'=>'bill_discount_amt','class'=>'form-control bill_discount_amt text-right decimal'),set_value('bill_discount_amt',$billDiscountAmt)); ?>
                            <?= form_error('bill_discount_amt'); ?>
                        </div>
                        <div class="col-md-4">
                            <span class="text-bold pull-right"><?=$this->lang->line('cess');?> ( <?= $cess; ?> %)</span>
                        </div>
                    </div>
                    </td>
                    <td class="text-right text-bold">
                    <div id="cess_amount"><?= numberFormat(round_this($cessAmount)); ?></div>
                    <input type="hidden" id="gnTotalAmt" value="<?= round_this($grandNetAmount); ?>">
                    </td>
                    </tr>
					<?php $grandNetAmount -= $billDiscountAmt;?>

                    <?php if(show_round_off()){ ?>
                        <tr>
                        <td class="text-right" colspan="<?= (empty($presumtiveTax))?$a+$cst:10; ?>">
                            <div class="row">
                                <div class="col-md-3 pull-right text-bold"><?=$this->lang->line('round-off');?></div>
                            </div>
                        </td>
                        <td class="text-right text-bold">
                        <div class="in-line" id="roundOff"><?= numberFormat(round_off($grandNetAmount)); ?></div>
                        </td>
                        </tr>
                    <?php } ?>
                    <tr>
                    <td class="text-right text-bold" colspan="2">
                        <label class=""><?=$this->lang->line('area');?></label>
                    </td>
                    <td class="text-right" colspan="<?= (empty($presumtiveTax))?$a-2+$cst:6; ?>">
                        <div class="row">
                            <div class="col-md-9 pull-left">
                                <?= form_input(array('name'=>'area_id','class'=>'form-control bill_discount_amt decimal'),set_value('area_id',$area_name),$billDisable); ?>
                                <?= form_error('area_id'); ?>
                            </div>
                            <div class="col-md-3 pull-right text-bold"><?=$this->lang->line('net-amount');?></div>
                        </div>
                    </td>
                    <td class="text-right text-bold">
                    <div class="in-line" id="grandTotalAmount"><?= numberFormat(get_rounded($grandNetAmount)); ?></div>
                    </td>
                    </tr>
                    <tr>
                    <td class="text-right text-bold" colspan="2"><?=$this->lang->line('remarks');?></td>
                    <td class="text-right" colspan="<?= (empty($presumtiveTax))?$a-1+$cst:8; ?>">
                        <div class="row">
                        	<div class="col-md-12 pull-left"><?= form_textarea(array('name'=>'remarks','class'=>'form-control','rows'=>2),set_value('remarks',$remarks),$billDisable); ?></div>
                        </div>
                    </td>
                    </tr>
                </table>
                </div>
			</div>
		</div>
	</div>
    <div class="row">
    <div class="col-md-7 pull-left text-bold"><?=$this->lang->line('last-updated-by')." : ".get_username($quotations[0]['created_by']);?></div>
    <div class="col-md-5 text-right text-bold"><?=$this->lang->line('last-updated-on')." : ".dateTimeFormat($quotations[0]['created_on']);?></div>
    </div>
<?php }	?>
	</div>
</div>
<?= form_close(); ?>