<?=export_to_excel('excel/sales_excel/sales_registry'.$redirect); ?>
<div class="table-responsive block">
    <table class="table table-striped table-condensed table-bordered tbl-brdr">
        <tr class="bg-success">
            <th>#</th>
            <th><?=$this->lang->line('date');?></th>
            <th><?=$this->lang->line('particulars');?></th>
            <th><?=$this->lang->line('voucher-types');?></th>
            <th><?=$this->lang->line('bill-no');?></th>
            <th><?=$this->lang->line('item');?></th>
            <th><?=$this->lang->line('quantity');?></th>
            <th><?=$this->lang->line('rate');?></th>
            <th><?=$this->lang->line('value');?></th>
            <th><?=$this->lang->line('discount');?></th>
            <th><?=$this->lang->line('taxable')." ".$this->lang->line('amt');;?></th>
            <th><?=$this->lang->line('cgst')." ".$this->lang->line('amt');?></th>
            <th><?=$this->lang->line('sgst')." ".$this->lang->line('amt');?></th>
            <th><?=$this->lang->line('cess')." ".$this->lang->line('amt');?></th>
            <th><?=$this->lang->line('total');?></th>
        </tr>
        <? $TOTAL_VALUE=0; $TOTAL_DISCOUNT=0; $TOTAL_TAXABLE=0; $TOTAL_CGST=0; $TOTAL_SGST=0; $TOTAL_CESS=0; $TOTAL_AMOUNT=0;
	    foreach($sales_array as $key => $value):
	        $tax =0; $amount=0;
		    $bill_prefix = $this->stock->get_voucher_prefix($value['vtype_id']);
		    $item_details = $this->stock->get_item($value['item_id'],array('item_code','item_name'));
		    $tax = $value['cgst_amt']+$value['sgst_amt']+$value['cess_amt'];
		    $amount = $value['taxable_amt']+$tax;
		    
		    $TOTAL_VALUE += $value['amount'];
		    $TOTAL_DISCOUNT += $value['discount_amt'];
		    $TOTAL_TAXABLE += $value['taxable_amt'];
		    $TOTAL_CGST += $value['cgst_amt'];
		    $TOTAL_SGST += $value['sgst_amt'];
		    $TOTAL_CESS += $value['cess_amt'];
		    $TOTAL_AMOUNT += $amount; ?>
            <tr>
                <td class="text-center"><?=++$offset;?></td>
                <td class="text-center"><?=dateFormat($value['bill_date']);?></td>
                <td><?=$this->stock->get_customer($value['customer_type_id'],$value['customer_id']);?></td>
                <td><?=$value['vtype'];?></td>
                <td><?=$bill_prefix.' '.$value['bill_no'];?></td>
                <td><?= $item_details['item_code']; ?> / <?= $item_details['item_name']; ?></td>
    			<td class="text-right"><?php echo $value['qty']; echo " "; echo $this->stock->get_unit_symbol($value['unit_id']); ?></td>
                <td class="text-right"><?=numberFormat($value['rate']);?></td>
                <td class="text-right"><?=numberFormat($value['amount']);?></td>
                <td class="text-right"><?=numberFormat($value['discount_amt']);?></td>
                <td class="text-right"><?=numberFormat($value['taxable_amt']);?></td>
    			<td class="text-right"><?=numberFormat($value['cgst_amt']); ?></td>
                <td class="text-right"><?=numberFormat($value['sgst_amt']); ?></td>
                <td class="text-right"><?=numberFormat($value['cess_amt']); ?></td>
                <td class="text-right"><?=numberFormat($amount);?></td>
            </tr>
        <? endforeach; ?>
	    <tr>
	        <th colspan="8" class="text-right" >Grant Total</th>
    	    <th class="text-right"><?=numberFormat($TOTAL_VALUE); ?></th>
		    <th class="text-right"><?=numberFormat($TOTAL_DISCOUNT); ?></th>
		    <th class="text-right"><?=numberFormat($TOTAL_TAXABLE); ?></th>
		    <th class="text-right"><?=numberFormat($TOTAL_CGST); ?></th>
            <th class="text-right"><?=numberFormat($TOTAL_SGST); ?></th>
            <th class="text-right"><?=numberFormat($TOTAL_CESS); ?></th>
		    <th class="text-right"><?=numberFormat($TOTAL_AMOUNT); ?></th>
		</tr>
	</table>
</div>
<div class="row">
	<div class="col-md-12">
		<div class="pagination"><?=$links;?></div>
	</div>
</div>