<?php
echo form_open();
$billDisable=$customer_id=$user=$area_id=NULL;
$billDiscountPer = $billDiscountAmt =0;
$cust_type = 2;
if(!empty($sales_order)){
	$cust_type = $sales_order[0]['customer_type_id'];
	$customer_id = $sales_order[0]['customer_id'];
//	$user = $sales_order[0]['user_id'];
	$billDiscountPer = $sales_order[0]['discount_per'];
	$billDiscountAmt = $sales_order[0]['discount_amt'];
	$area_id = $sales_order[0]['area_id'];
}
if(!empty($customer_id)){
	$billDisable = 'disabled';
}
$bill_prefix = $this->stock->get_voucher_prefix(-1);
?>
<div class="panel panel-primary">
	<div class="panel-heading">
		<h6 class="panel-title"><i class="icon-database"></i> <?= $this->lang->line('sales-order'); ?> </h6>
	</div>
	<div class="panel-body">
        <div class="form-group">
            <div class="row">
                <div class="col-md-6">
                    <label class="required"><?=$this->lang->line('bill-no');?></label>
					<div class="input-group">
						<span class="input-group-addon text-bold"><?= $bill_prefix; ?></span>
						<?= form_input(array('name'=>'bill_no','class'=>'form-control number text-right'),set_value('bill_no',$bill_num)); ?>
					</div>                    
                    
                    <?= form_error('bill_no');?>
                </div>
                <div class="col-md-6">
                    <label class="required"><?=$this->lang->line('bill-date');?></label>
                    <?= form_input(array('name'=>'bill_date','class'=>'form-control datepicker'),set_value('bill_date',cdateFormat($bill_date))); ?>
                    <?= form_error('bill_date');?>
                </div>
            </div>
		</div>

        <div class="form-group">
            <div class="row">
                <label class="requiread col-md-3"> <label class="required"><?=$this->lang->line('customer-types');?></label>
                <?= form_dropdown('customer_type',$customerTypes,set_value('customer_type',$cust_type),"class='form-control customer_type' $billDisable"); ?>
                <?= form_error('customer_type');?>
                </label>
                <div class="col-md-9">
                    <label class="required"><?=$this->lang->line('customer-name');?></label>
                    <?php if($this->dms->have_access(485)){
                    $newCust = 'javascript:void();';
                    if($cust_type == 2){
                        $newCust = base_url('customer_master/add_customer/sales_order/add');
                    }
                    ?>
                    <input type="hidden" id="origin-url" value="<?= base_url('customer_master/add_customer/sales_order/add'); ?>">
                    <div class="input-group">
                        <?= form_dropdown('customer_id',$customers,set_value('customer_id',$customer_id),"class='form-control customers' $billDisable"); ?>
                        <span class="input-group-addon" title="<?= $this->lang->line('new'); ?>">
                        <a href="<?= $newCust; ?>" id="cust-link"><i class="icon-user"></i></a>
                        </span>
                    </div>
                    <?php }else{ ?>
                    <?= form_dropdown('customer_id',$customers,set_value('customer_id',$customer_id),"class='form-control customers' $billDisable"); ?>
                    <?php } ?>
                    <?= form_error('customer_id');?>
                </div>
            </div>
        </div>
		<?php
        $disableUsers=NULL;
        if(!empty($user)){
            $disableUsers='disabled';
        }
        ?>
       <!--- <div class="form-group">
            <div class="row">
                <div class="col-md-6">
                    <label class=""><?=$this->lang->line('user-type');?></label>
                    <?= form_dropdown('user_type',$userTypes,set_value('user_type',$user_type),"class='form-control user_type' "); ?>
                    <?= form_error('user_type');?>
                </div>
                <div class="col-md-6">
                    <label class=""><?=$this->lang->line('user');?></label>
                    <?= form_dropdown('user_id',$users,set_value('user_id',$user),"class='form-control users' "); ?>
                    <?= form_error('user_id');?>
                </div>
            </div>
        </div> ----->

        <div class="form-group">
            <div class="row">
                <div class="col-md-6">
                    <label class="required"><?=$this->lang->line('item-name');?></label>
                    <?= form_dropdown('item_id',$items,set_value('item_id'),'class=" form-control item_name select-full"'); ?>
                    <?= form_error('item_id');?>
                </div>
                <?php $sales_CST = $this->stock->get_constant(array('sales_cst')); ?>
                <div class="col-md-<?= 6-($sales_CST)*2; ?>">
                    <label class="required"><?=$this->lang->line('godown');?></label>
                    <?= form_dropdown('godown_id',$goDowns,set_value('godown_id'),'class="form-control godown"'); ?>
                    <?= form_error('godown_id');?>
                </div>
                <div class="col-md-2">
                    <?php if(!empty($sales_CST) && empty($presumtiveTax)){ ?>
                    <label class=""><?=$this->lang->line('cst');?> %</label>
                    <?= form_input(array('name'=>'cst','class'=>'form-control text-right cst decimal'),set_value('cst')); ?>
                    <?= form_error('cst');?>
                    <?php } ?>
                </div>
            </div>
        </div>

        <div class="form-group">
            <div class="row">
                <div class="col-md-2">
                    <label class="required"><?=$this->lang->line('quantity');?></label>
                    <?= form_input(array('name'=>'qty','class'=>'form-control text-right qnty qty-rate decimal'),set_value('qty')); ?>
                    <?= form_error('qty');?>
                </div>
                <div class="col-md-2">
                    <label class="required"><?=$this->lang->line('unit');?></label>
                    <?= form_dropdown('unit_id',$units,set_value('unit_id'),'class="form-control unit"'); ?>
                    <?= form_error('unit_id');?>
                </div>
                <div class="col-md-2">
                    <label class="required"><?=$this->lang->line('rate');?></label>
                    <?= form_input(array('name'=>'rate','class'=>'form-control text-right rate qty-rate decimal'),set_value('rate')); ?>
                    <?= form_error('rate');?>
                </div>
                <div class="col-md-2">
                    <label class="required"><?=$this->lang->line('amount');?></label>
                    <?= form_input(array('name'=>'amount','class'=>'form-control text-right amount decimal'),set_value('amount')); ?>
                </div>
                <div class="col-md-2">
                    <label class=""><?=$this->lang->line('discount');?> %</label>
                    <?= form_input(array('name'=>'discount_per','class'=>'form-control text-right decimal discount_per','id'=>'discount_per'),set_value('discount_per')); ?>
                    <?= form_error('discount_per');?>
                </div>
                <div class="col-md-2">
                    <label class=""><?=$this->lang->line('discount');?> <?=$this->lang->line('amt');?></label>
                    <?= form_input(array('name'=>'discount_amt','class'=>'form-control text-right decimal discount_amt'),set_value('discount_amt')); ?>
                    <?= form_error('discount_amt');?>
                </div>
            </div>
        </div>

        <div class="form-group">
            <div class="row">
                <div class="col-md-3">
                    <?=$this->lang->line('rate');?> : <label type="text" class="rate-per text-right"><?php echo $item_rate; ?></label><label id="primary-unit"><?php echo $primary_unit;?></label>
                </div>
                <div class="col-md-9">
                    <?=form_button(array('type'=>'submit','name'=>'add_to_bill','class'=>'btn btn-primary btn-loading pull-right','content'=>$this->lang->line('add-to-bill')));?>
                </div>
            </div>
        </div>

		<?php if(!empty($sales_order_items)){ ?>
	    <div class="form-group">
    		<div class="row">
    			<div class="col-md-12">
					<div class='table-responsive'>
    					<table class="table table-bordered table-striped">
        				<thead>
            				<tr class="bg-success">
                            <th>#</th>
                            <th><?=$this->lang->line('item-name');?></th>
                            <th><?=$this->lang->line('quantity');?></th>
                            <th><?= $this->lang->line('unit'); ?></th>
                            <th><?= $this->lang->line('rate'); ?></th>
                            <th><?= $this->lang->line('amount'); ?></th>
                            <th><?= $this->lang->line('dis'); ?> <?= $this->lang->line('amt'); ?></th>
                            <?php if(!empty($cst_enabled) && empty($presumtiveTax)){ ?>
                                <th><?= $this->lang->line('cst'); ?></th>
                            <?php } ?>
                        <!--    <th><?= $this->lang->line('net-value'); ?></th>  -->
                            <?php
							if($bill_date < $lm_date)
							{ $a=9;$b=7;
							 if(empty($presumtiveTax)){ ?>
                                <th><?= $this->lang->line('vat'); ?> (%)</th>
                                <th><?= $this->lang->line('vat'); ?> <?= $this->lang->line('amt'); ?></th>
                            <?php }
							}
							else
							{
                                                               $a=11;$b=9;
							?>
                            	 <th><?= $this->lang->line('cgst'); ?> (%)</th>
                                 <th><?= $this->lang->line('sgst'); ?> (%)</th>
                                 <th><?= $this->lang->line('cgst'); ?> <?= $this->lang->line('amt'); ?></th>
                                 <th><?= $this->lang->line('sgst'); ?> <?= $this->lang->line('amt'); ?></th>
							<?php	
							}
							 ?>
                            <th><?= $this->lang->line('net'); ?> <?= $this->lang->line('amt'); ?></th>
                            <th colspan="2"><?= $this->lang->line('actions'); ?></th>
            				</tr>
						</thead>
						<?php
						    $lm_date='2017-07-01';
							$i=0;$totalAmount=0;$totalDiscountAmt=0;$totalNetValue=0;$totalVatAmt=0;$totalNetAmount=0;$grandNetAmount=0;$totalCst=0;	$cst=0;
							foreach($sales_order_items as $key=>$item){$i++;
								$tempItemID = $item['id'];
								$mainTempID = $item['so_temp_id'];
								$itemID = $item['item_id'];
								$qty = $item['qty'];
								$rate = $item['rate'];
								$cstPercent = $item['cst'];
								$discountPer = $item['so_discount_per'];
								$discountAmt = $item['so_discount_amt'];
								$vatAmount=0;$cstAmount=0;$vat=0;
								
								if($bill_date < $lm_date)
								{
									
									if($cstPercent == 0)
									{
										$vat = $this->stock->get_item_vat($itemID);
									}
									else
									{
										$cst=1;
									}
								}
								else
								{
									
									$cgst = $this->stock->get_item_cgst($itemID);
									$sgst = $this->stock->get_item_sgst($itemID);
								}
								$amount = $item['amount'];
								$totalAmount += $amount;
								$totalDiscountAmt += $discountAmt;
								$netValue = $amount-$discountAmt;
								$cstAmount = ($cstPercent*$netValue)/100;
								$totalNetValue += $netValue;
								if($bill_date < $lm_date)
								{
									if(empty($presumtiveTax)){
										$vatAmount = $item['vat_amt'];//($vat*$netValue)/100;
									}else{
										$cstAmount=0;
									}
								}
								else
								{
									$cgstAmt= $item['cgst_amt'];
									$sgstAmt= $item['sgst_amt'];
									$vatAmount =  $cgstAmt + $sgstAmt;	
								}
								$netValue += $cstAmount;
								$totalVatAmt += $vatAmount;
								$netAmount = $netValue+$vatAmount;
								$totalNetAmount += $netAmount;
								$totalCst += $cstAmount;
								?>
                                <tr>
                                <td><?= $i; ?></td>
                                <td><?= $item['item_code']; ?> / <?= $item['item_name']; ?> / <?= $item['model_no']; ?></td>
                                <td class="text-right"><?= $qty; ?></td>
                                <td><?= $item['symbol']; ?></td>
                                <td class="text-right"><?= numberFormat($rate); ?></td>
                                <td class="text-right"><?= numberFormat(round_this($amount)); ?></td>
                                <td class="text-right"><?= numberFormat(round_this($discountAmt)); ?></td>
                                <?php 
									
										if(!empty($cst_enabled) && empty($presumtiveTax))
										{ 
								?>
										<td class="text-right"><?= numberFormat(round_this($cstAmount)); ?></td>
								<?php 	
										}
									
									
								?>
                                <!--	<td class="text-right"><?= numberFormat(round_this($netValue)); ?></td> -->
                                <?php 
								if($bill_date <$lm_date)
								{
									if(empty($presumtiveTax)){ ?>
                                    <td class="text-right"><?= $vat; ?></td>
                                    <td class="text-right"><?= numberFormat(round_this($vatAmount)); ?></td>
                                <?php } 
								}
								else
								{
								?>
								 	<td class="text-right"><?= $cgst; ?></td>
                                    <td class="text-right"><?= $sgst; ?></td>
                                    <td class="text-right"><?= numberFormat(round_this($cgstAmt)); ?></td>
                                    <td class="text-right"><?= numberFormat(round_this($sgstAmt)); ?></td>	
								<?php	
								}
								?>
                                <td class="text-right"><?= numberFormat(round_this($netAmount)); ?></td>
                                <td><a href="<?= base_url('sales_order/edit_temp_item/'.$tempItemID); ?>" title="<?= $this->lang->line('edit'); ?>"><i class="glyphicon glyphicon-pencil"></i></a></td>
                                <td><a href="<?= base_url('sales_order/remove_temp_item/'.$tempItemID); ?>" title="<?= $this->lang->line('remove'); ?>" class="red"><i class="glyphicon glyphicon-remove delete"></i></a></td>
                                </tr>
								<?php
							}
							$grandNetAmount = round_this($totalNetAmount);
							?>
                            <tr>
                            <td class="text-right text-bold" colspan="5"><?= $this->lang->line('total'); ?></td>
                            <td class="text-right text-bold"><?= numberFormat(round_this($totalAmount)); ?></td>
                            <td class="text-right text-bold"><?= numberFormat(round_this($totalDiscountAmt)); ?></td>
                            <?php 
                                 if($bill_date <$lm_date)
                                 {
                                       if(!empty($cst_enabled) && empty($presumtiveTax))
                                       { 
                            ?>
                                             <td class="text-right text-bold"><?= numberFormat(round_this($totalCst)); ?></td>
                            <?php 
                                       } 
                            ?>
                                       <td class="text-right text-bold"><?= numberFormat(round_this($totalNetValue)); ?></td>
                            <?php 
                                       if(empty($presumtiveTax))
                                       { 
                            ?>
                                              <td class="disabled"></td>
                                              <td class="text-right text-bold"><?= numberFormat(round_this($totalVatAmt)); ?></td>
                            <?php 
                                       }
                                 }
                                 else
                                 {
                            ?>
                                       <td class="disabled"></td>
                                       <td class="text-right text-bold" colspan="2">GST Amt.</td>
                                       <td class="text-right text-bold"><?= numberFormat(round_this($totalVatAmt)); ?></td>
                            <?php
                                 } 
                            ?>
                            <td class="text-right text-bold"><?= numberFormat(round_this($totalNetAmount)); ?></td>
                            <td class="disabled"></td>
                            <td class="disabled"></td>
                            </tr>
							<?php
							$gnTotalVatAmount=$totalVatAmt;
							if(!empty($presumtiveTax)){
								$pmTaxAmt = ($presumtiveTax[0]*$totalNetAmount)/100;
								$gnTotalVatAmount = round_this($pmTaxAmt);
								$grandNetAmount += round_this($pmTaxAmt);
								?>
                                <tr>
                                <td class="text-right text-bold" colspan="<?= 8; ?>"><?= $this->lang->line('presum-tax') ?> @ <?= $presumtiveTax[0]; ?> %</td>
                                <td class="text-right text-bold"><?= numberFormat(round_this($pmTaxAmt)); ?></td>
                                <td class="disabled"></td>
                                <td class="disabled"></td>
                                </tr>
								<?php
							}
							$cessAmount=0;
							$cess = $this->stock->get_cess();
							$cessAmount = ($cess*($gnTotalVatAmount+$totalCst))/100;
							$grandNetAmount += round_this($cessAmount);
							?>
        					<tr>
                            <td class="" colspan="<?= (empty($presumtiveTax))?$a+$cst:8; ?>">
                            <div class="row">
                                <div class="col-md-4">
                                    <label><?=$this->lang->line('discount');?> %</label>
                                    <?= form_input(array('name'=>'bill_discount_per','class'=>'form-control bill_discount_per text-right decimal'),set_value('bill_discount_per',$billDiscountPer)); ?>
                                    <?= form_error('bill_discount_per'); ?>
                                </div>
                                <div class="col-md-4">
                                    <label><?=$this->lang->line('discount');?> <?=$this->lang->line('amount');?></label>
                                    <?= form_input(array('name'=>'bill_discount_amt','class'=>'form-control bill_discount_amt text-right decimal'),set_value('bill_discount_amt',$billDiscountAmt)); ?>
                                    <?= form_error('bill_discount_amt'); ?>
                                </div>
                                <div class="col-md-4">
                                    <span class="text-bold pull-right"><?=$this->lang->line('cess');?> ( <?= $cess; ?> %)</span></div>
                                </div>
                            </td>
                            <td class="text-right text-bold">
                                <div id="cess_amount"><?= numberFormat(round_this($cessAmount)); ?></div>
                            </td>
                            <td class="disabled"></td>
                            <td class="disabled"><input type="hidden" id="gnTotalAmt" value="<?= round_this($grandNetAmount); ?>"></td>
                            </tr>
							<?php
                            if($this->input->post('bill_discount_amt')){
                                $grandNetAmount -= $this->input->post('bill_discount_amt');
                            }else{
                                $grandNetAmount -= $billDiscountAmt;
                            }
                            ?>
                            <?php if(show_round_off()){ ?>
                            <tr>
                            <td class="text-right" colspan="<?= (empty($presumtiveTax))?$a+$cst:8; ?>">
                                <div class="row">
                                    <div class="col-md-3 pull-right text-bold"><?=$this->lang->line('round-off');?></div>
                                </div>
                            </td>
                            <td class="text-right text-bold">
                                <div class="in-line" id="roundOff"><?= numberFormat(round_off($grandNetAmount)); ?></div>
                            </td>
                            <td class="disabled"></td>
                            <td class="disabled"></td>
                            </tr>
                            <?php } ?>
                            <tr>
                            <td class="text-right text-bold" colspan="2"><label class="required"><?=$this->lang->line('area');?></label></td>
                            <td class="text-right" colspan="<?= (empty($presumtiveTax))?$b+$cst:6; ?>">
                                <div class="row">
                                    <div class="col-md-9 pull-left"><?= form_dropdown('area_id',$areas,set_value('area_id',$area_id),'class="form-control"'); ?><?= form_error('area_id'); ?></div>
                                    <div class="col-md-3 pull-right text-bold"><?=$this->lang->line('net-amount');?></div>
                                </div>
                            </td>
                            <td class="text-right text-bold">
                                <div class="in-line" id="grandTotalAmount"><?= numberFormat(get_rounded($grandNetAmount)); ?></div>
                            </td>
                            <td class="disabled"></td>
                            <td class="disabled"></td>
                            </tr>

                            <tr>
                            <td class="text-right text-bold" colspan="2"><label><?=$this->lang->line('remarks');?></label></td>
                            <td class="text-right" colspan="<?= (empty($presumtiveTax))?$b+$cst:6; ?>">
                                <div class="row">
                                    <div class="col-md-9 pull-left">
<?= form_textarea(array('name'=>'remarks','class'=>'form-control','rows'=>2),set_value('remarks')); ?>
                                    </div>
								</div>
                            </td>
                            <td class="text-right text-bold">
                            </td>
                            <td class="disabled"></td>
                            <td class="disabled"></td>
                            </tr>
						</table>
					</div>
                </div>
			</div>
		</div>

		<div class="row">
            <div class="col-md-12">
                <div class="form-group">
                    <div class="text-right">
                        <?= form_button(array('type'=>'submit','name'=>'save_bill','class'=>'btn btn-primary btn-loading pull-right','content'=>$this->lang->line('save')));?>
                    </div>
                </div>
            </div>
		</div>
		<?php } ?>
	</div>
</div>
<?= form_close(); ?>