<?php
if(!empty($sales_order) && !empty($sales_order_items)){
	$uriArray = $this->uri->uri_to_assoc(3);
	$uriString = $this->uri->assoc_to_uri($uriArray);
	$sales_order = $sales_order[0];
	$custTypeID = $sales_order['customer_type_id'];
	$customerID = $sales_order['customer_id'];
	$SO_status = $sales_order['so_status'];
	$cess = $sales_order['cess'];
	$bill_prefix = $this->stock->get_voucher_prefix(-1);
	echo form_open();
	?>
	<div class="panel panel-primary">
		<div class="panel-heading">
			<h6 class="panel-title"><i class="icon-database"> </i><?= $this->lang->line('sales-order'); ?> </h6>
		</div>
		<div class="panel-body">

            <div class="form-group">
                <div class="row">
                    <div class="col-md-6">
                        <label class="required"><?=$this->lang->line('bill-no');?></label>
                        <div class="input-group">
                            <span class="input-group-addon text-bold"><?= $bill_prefix; ?></span>
                            <?= form_input(array('name'=>'bill_no','class'=>'form-control number text-right'),set_value('bill_no',$sales_order['so_no'])); ?>
                        </div>
                        <?= form_error('bill_no');?>
                    </div>
                    <div class="col-md-6">
                        <label class="required"><?=$this->lang->line('bill-date');?></label>
                        <?= form_input(array('name'=>'bill_date','class'=>'form-control datepicker'),set_value('bill_date',cdateFormat($sales_order['so_date']))); ?>
                        <?= form_error('bill_date');?>
                    </div>
                </div>
            </div>

            <div class="form-group">
                <div class="row">
                    <label class="requiread col-md-3"><label class="required"><?=$this->lang->line('customer-types');?></label>
                    	<?= form_dropdown('customer_type',$customerTypes,set_value('customer_type',$custTypeID),"class='form-control customer_type'"); ?>
                    </label>
                    <div class="col-md-9">
                    <label class="required"><?=$this->lang->line('customer-name');?></label>
                    <?php if($this->dms->have_access(485)){
                   	 	$newCust = 'javascript:void();';
						if($custTypeID == 2){
							$newCust = base_url('customer_master/add_customer/sales_order/edit/'.$uriString);
						}
                    	?>
                        <input type="hidden" id="origin-url" value="<?= base_url('customer_master/add_customer/sales_order/edit/'.$uriString); ?>">
                        <div class="input-group">
                            <?= form_dropdown('customer_id',$customers,set_value('customer_id',$customerID),"class='form-control customers'"); ?>
                            <span class="input-group-addon" title="<?= $this->lang->line('new'); ?>">
                                <a href="<?= $newCust; ?>"  id="cust-link"><i class="icon-user"></i></a>
                            </span>
                        </div>
                    <?php }else{ ?>
                    	<?= form_dropdown('customer_id',$customers,set_value('customer_id',$customerID),"class='form-control customers' $billDisable"); ?>
                    <?php } ?>
                    <?= form_error('customer_id');?>
                    </div>
                </div>
            </div>

            <div class="form-group">
                <div class="row">
                    <div class="col-md-6">
                        <label class=""><?=$this->lang->line('user-type');?></label>
                        <?= form_dropdown('user_type',$userTypes,set_value('user_type',$user_type),"class='form-control user_type'"); ?>
                        <?= form_error('user_type');?>
                    </div>
                    <div class="col-md-6">
                        <label class=""><?=$this->lang->line('user');?></label>
                        <?= form_dropdown('user_id',$users,set_value('user_id',$user),"class='form-control users'"); ?>
                        <?= form_error('user_id');?>
                    </div>
                </div>
            </div>

			<?php if($SO_status == 0){ ?>
			<?= form_open(); ?>

            <div class="form-group">
                <div class="row">
                    <div class="col-md-6">
                        <label class="required"><?=$this->lang->line('item-name');?></label>
                        <?= form_dropdown('item_id',$items,set_value('item_id'),'class="form-control item_name"'); ?>
                        <?= form_error('item_id');?>
                    </div>
                    <?php $sales_CST = $this->stock->get_constant(array('sales_cst')); ?>
                    <div class="col-md-<?= 6-($sales_CST)*2; ?>">
                        <label class="required"><?=$this->lang->line('godown');?></label>
                        <?= form_dropdown('godown_id',$goDowns,set_value('godown_id'),'class="form-control godown"'); ?>
                        <?= form_error('godown_id');?>
                    </div>
                    <div class="col-md-2">
						<?php if(!empty($sales_CST) && empty($presumtiveTax)){ ?>
                        <label><?=$this->lang->line('cst');?> %</label>
                        <?= form_input(array('name'=>'cst','class'=>'form-control text-right cst decimal'),set_value('qty')); ?>
                        <?= form_error('cst');?>
                        <?php } ?>
                    </div>
                </div>
            </div>

            <div class="form-group">
                <div class="row">
                    <div class="col-md-2">
                        <label class="required"><?=$this->lang->line('quantity');?></label>
                        <?= form_input(array('name'=>'qty','class'=>'form-control text-right qnty qty-rate decimal'),set_value('qty')); ?>
                        <?= form_error('qty');?>
                    </div>
                    <div class="col-md-2">
                        <label class="required"><?=$this->lang->line('unit');?></label>
                        <?= form_dropdown('unit_id',$units,set_value('unit_id'),'class="form-control unit"'); ?>
                        <?= form_error('unit_id');?>
                    </div>
                    <div class="col-md-2">
                        <label class="required"><?=$this->lang->line('rate');?></label>
                        <?= form_input(array('name'=>'rate','class'=>'form-control text-right rate qty-rate decimal'),set_value('rate')); ?>
                        <?= form_error('rate');?>
                    </div>
                    <div class="col-md-2">
                    	<label class="required"><?=$this->lang->line('amount');?></label>
                    	<?= form_input(array('name'=>'amount','class'=>'form-control text-right amount decimal'),set_value('amount')); ?>
                    </div>
                    <div class="col-md-2">
                        <label class=""><?=$this->lang->line('discount');?> %</label>
                        <?= form_input(array('name'=>'discount_per','class'=>'form-control text-right discount_per decimal','id'=>'discount_per'),set_value('discount_per')); ?>
                        <?= form_error('discount_per');?>
                    </div>
                    <div class="col-md-2">
                        <label class=""><?=$this->lang->line('discount');?> <?=$this->lang->line('amt');?></label>
                        <?= form_input(array('name'=>'discount_amt','class'=>'form-control text-right discount_amt decimal'),set_value('discount_amt')); ?>
                        <?= form_error('discount_amt');?>
                    </div>
                </div>
            </div>

            <div class="form-group">
                <div class="row">
                    <div class="col-md-3">
						<?=$this->lang->line('rate');?> : <label type="text" class="rate-per text-right"></label> <label id="primary-unit"></label></div>

                    <div class="col-md-9">
                        <?=form_button(array('type'=>'submit','name'=>'add_to_bill','class'=>'btn btn-primary btn-loading pull-right','content'=>$this->lang->line('add-to-bill')));?>
                    </div>
                </div>
            </div>
			<?= form_close(); ?>
			<?php }?>

            <div class="row">
                <div class="col-md-12">
                    <div class='table-responsive'>
                        <table class="table table-bordered table-striped">
                        <thead>
                        <tr class="bg-success">
                        <th>#</th>
                        <th><?=$this->lang->line('item-name');?></th>
                        <th><?=$this->lang->line('quantity');?></th>
                        <th><?= $this->lang->line('unit'); ?></th>
                        <th><?= $this->lang->line('rate'); ?></th>
                        <th><?= $this->lang->line('amount'); ?></th>
                        <th><?= $this->lang->line('dis'); ?> <?= $this->lang->line('amt'); ?></th>
                        <?php 
							$b_date=$sales_order['so_date'];
							$l_date = '2017-07-01';
							if($b_date < $l_date)
							{
								if(!empty($cst_enabled) && empty($presumtiveTax))
								{ 
						?>
                        			<th><?= $this->lang->line('cst'); ?></th>
                        <?php 
								} 
						?>
                        		<th><?= $this->lang->line('net-value'); ?></th>
                        <?php 
								if(empty($presumtiveTax))
								{ 
						?>
                            		<th><?= $this->lang->line('vat'); ?> (%)</th>
                            		<th><?= $this->lang->line('vat'); ?> <?= $this->lang->line('amt'); ?></th>
                        <?php 
								}
							}
							else
							{
						?>
                        		<th><?= $this->lang->line('cgst'); ?> (%)</th>
                                <th><?= $this->lang->line('sgst'); ?> (%)</th>
                            	<th><?= $this->lang->line('cgst'); ?> <?= $this->lang->line('amt'); ?></th>
                            	<th><?= $this->lang->line('sgst'); ?> <?= $this->lang->line('amt'); ?></th>
						<?php
							}
						?>
                        <th class="width-150"><?= $this->lang->line('net'); ?> <?= $this->lang->line('amt'); ?></th>
                        <?php if($SO_status == 0){ ?><th colspan="2" ><?= $this->lang->line('actions'); ?></th><?php } ?>
                        </tr>
                        </thead>
						<?php
						$i=0;$totalAmount=0;$totalDiscountAmt=0;$totalNetValue=0;$totalVatAmt=0;$totalNetAmount=0;
						$grandNetAmount=0;$totalCst=0;$cst=0;
						foreach($sales_order_items as $key=>$item){$i++;

							$soItemID = $item['id'];
							$itemID = $item['item_id'];
							$itemStatus = $item['item_status'];
							$qty = $item['qty'];
							$rate = $item['rate'];
							$cstPercent = $item['cst'];
							$discountPer = $item['discount_per'];
							$discountAmt = $item['discount_amt'];
							$vatAmount=0;$cstAmount=0;$vat=0;
							if($b_date <$l_date)
							{
								if($cstPercent == 0){
									$vat = $this->stock->get_item_vat($itemID);
								}else{
									$cst=1;
								}
								$cstAmount = ($cstPercent*$netValue)/100;
								if(empty($presumtiveTax))
								{
									$vatAmount = $item['vat_amt'];//($vat*$netValue)/100;
								}
								else
								{
									$cstAmount=0;
								}
								$netValue += $cstAmount;
								$totalCst += $cstAmount;
							}
							else
							{
								$cgst=	$this->stock->get_item_cgst($itemID);
								$sgst = $this->stock->get_item_sgst($itemID);
								$vat = $cgst + $sgst;
								$cgstAmt = $item['cgst_amt'];
								$sgstAmt = $item['sgst_amt'];
								$vatAmount = $cgstAmt + $sgstAmt;
							}
							$amount = $item['amount'];
							$totalAmount += $amount;
							$totalDiscountAmt += $discountAmt;
							$netValue = $amount-$discountAmt;
							$totalNetValue += $netValue;
							
							$totalVatAmt += $vatAmount;
							$netAmount = $netValue+$vatAmount;
							$totalNetAmount += $netAmount;
							
							?>
                            <tr>
                            <td class="text-center"><?= $i; ?></td>
                            <td><?= $item['item_code']; ?> / <?= $item['item_name']; ?></td>
                            <td class="text-right"><?= $qty; ?></td>
                            <td><?= $item['symbol']; ?></td>
                            <td class="text-right"><?= numberFormat($rate); ?></td>
                            <td class="text-right"><?= numberFormat(round_this($amount)); ?></td>
                            <td class="text-right"><?= numberFormat(round_this($discountAmt)); ?></td>
                            <?php 
								if($b_date <$l_date)
								{
									if(!empty($cst_enabled) && empty($presumtiveTax))
									{ 
							?>
                            			<td class="text-right"><?= numberFormat(round_this($cstAmount)); ?></td>
                            <?php 
									} 
							?>
                            		<td class="text-right"><?= numberFormat(round_this($netValue)); ?></td>
                            <?php 
									if(empty($presumtiveTax))
									{ 
							?>
                                		<td class="text-right"><?= $vat; ?></td>
                                		<td class="text-right"><?= numberFormat(round_this($vatAmount)); ?></td>
                            <?php 
									}
								}
								else
								{
							?>
                            		<td class="text-right"><?= $cgst; ?></td>
                                    <td class="text-right"><?= $sgst; ?></td>
                                	<td class="text-right"><?= numberFormat(round_this($cgstAmt)); ?></td>
                                	<td class="text-right"><?= numberFormat(round_this($sgstAmt)); ?></td>	
							<?php		
								}
							?>
                            <td class="text-right"><?= numberFormat(round_this($netAmount)); ?></td>
                            <?php if($SO_status == 0){ ?>
                                <td style="max-width:35px;">
                                <?php if($itemStatus == 0){ ?>
                                    <a href="<?= base_url('sales_order/edit_item/'.$soItemID.'/'.$uriString); ?>" title="<?= $this->lang->line('edit'); ?>"><i class="glyphicon glyphicon-pencil"></i></a>
                                <?php } ?>
                                </td>
                                <td style="max-width:35px;">
                                <?php if($itemStatus == 0){ ?>
                                    <a href="<?= base_url('sales_order/remove_item/'.$soItemID.'/'.$uriString); ?>" class="text-danger" title="<?= $this->lang->line('remove'); ?>"><i class="glyphicon glyphicon-remove delete"></i></a>
                                <?php } ?>
                                </td>
                            <?php } ?>
							</tr>
                            <?php
						}
						$grandNetAmount = round_this($totalNetAmount);
						?>
                        <tr>
                        <td class="text-right text-bold" colspan="5"><?= $this->lang->line('total'); ?></td>
                        <td class="text-right text-bold"><?= numberFormat(round_this($totalAmount)); ?></td>
                        <td class="text-right text-bold"><?= numberFormat(round_this($totalDiscountAmt)); ?></td>
                        <?php 
							if($b_date < $l_date)
							{
								if(!empty($cst_enabled) && empty($presumtiveTax))
								{ 
						?>
                        			<td class="text-right text-bold"><?= numberFormat(round_this($totalCst)); ?></td>
                        <?php 
								} 
						?>
                        		<td class="text-right text-bold"><?= numberFormat(round_this($totalNetValue)); ?></td>
                        <?php 
								if(empty($presumtiveTax))
								{ 
						?>
                            		<td class="disabled"></td>
                            		<td class="text-right text-bold"><?= numberFormat(round_this($totalVatAmt)); ?></td>
                        <?php 
								}
							}
							else
							{
						?>
                        		<td class="disabled"></td>
                                <td class="text-right text-bold" colspan="2">GST Amt.</td>
                            	<td class="text-right text-bold"><?= numberFormat(round_this($totalVatAmt)); ?></td>
                        <?php		
							}
						?>
                        <td class="text-right text-bold"><?= numberFormat(round_this($totalNetAmount)); ?></td>
                        <?php if($SO_status == 0){ ?><td class="disabled"  colspan="2"></td><?php } ?>
                        </tr>
						<?php
						$gnTotalVatAmount=$totalVatAmt;
						if(!empty($presumtiveTax)){
							$pmTaxAmt = ($presumtiveTax[0]*$totalNetAmount)/100;
							$gnTotalVatAmount = round_this($pmTaxAmt);
							$grandNetAmount += round_this($pmTaxAmt);
							?>
                            <tr>
                            <td class="text-right text-bold" colspan="<?= 8; ?>"><?= $this->lang->line('presum-tax') ?> @ <?= $presumtiveTax[0]; ?> %</td>
                            <td class="text-right text-bold"><?= numberFormat(round_this($pmTaxAmt)); ?></td>
                            <?php if($SO_status == 0){ ?><td class="disabled"  colspan="2"></td><?php } ?>
                            </tr>
							<?php
						}
						$cessAmount=0;
						$cessAmount = ($cess*($gnTotalVatAmount+$totalCst))/100;
						$grandNetAmount += round_this($cessAmount);
						?>
                        <tr>
                            <td class="" colspan="<?= (empty($presumtiveTax))?10+$cst:8; ?>">
                                <div class="row">
                                    <div class="col-md-4">
                                        <label><?=$this->lang->line('discount');?> %</label>
                                        <?= form_input(array('name'=>'bill_discount_per','class'=>'form-control bill_discount_per decimal text-right'),set_value('bill_discount_per',$sales_order['so_discount_per'])); ?>
                                        <?= form_error('bill_discount_per'); ?>
                                    </div>
                                    <div class="col-md-4">
                                        <label><?=$this->lang->line('discount');?> <?=$this->lang->line('amount');?></label>
                                        <?= form_input(array('name'=>'bill_discount_amt','class'=>'form-control bill_discount_amt decimal text-right'),set_value('bill_discount_amt',$sales_order['so_discount_amt'])); ?>
                                        <?= form_error('bill_discount_amt'); ?>
                                    </div>
                                    <div class="col-md-4">
                                        <span class="text-bold pull-right"><?=$this->lang->line('cess');?> ( <?= $cess; ?> %)</span>
									</div>
								</div>
                            </td>
                            <td class="text-right text-bold">
                            	<div id="cess_amount"><?= numberFormat(round_this($cessAmount)); ?></div>
                                <input type="hidden" id="gnTotalAmt" value="<?= round_this($grandNetAmount); ?>">
                            </td>
                            <?php if($SO_status == 0){ ?>
                            	<td class="disabled" colspan="2"></td>
							<?php } ?>
                        </tr>
						<?php
                        if($this->input->post('bill_discount_amt')){
                        	$grandNetAmount -= $this->input->post('bill_discount_amt');
                        }else{
                        	$grandNetAmount -= $sales_order['so_discount_amt'];
                        }
                        ?>
						<?php if(show_round_off()){ ?>
                        <tr>
                        <td class="text-right" colspan="<?= (empty($presumtiveTax))?10+$cst:8; ?>">
                            <div class="row">
                                <div class="col-md-7 pull-left"></div>
                                <div class="col-md-3 pull-right text-bold"><?=$this->lang->line('round-off');?></div>
                            </div>
                        </td>

                        <td class="text-right text-bold">
                        	<div class="in-line" id="roundOff"><?= numberFormat(round_off($grandNetAmount)); ?></div>
                        </td>
                        <?php if($SO_status == 0){ ?>
                        	<td class="disabled" colspan="2"></td>
						<?php } ?>
                        </tr>
                        <?php } ?>

                        <tr>
                        <td class="text-right text-bold" colspan="2"><?=$this->lang->line('area');?></td>
                        <td class="text-right" colspan="<?= (empty($presumtiveTax))?8+$cst:6; ?>">
                            <div class="row">
                                <div class="col-md-9 pull-left"><?= form_dropdown('area_id',$areas,set_value('area_id',$sales_order['area_id']),'class="form-control"'); ?><?= form_error('area_id'); ?></div>
                                <div class="col-md-3 pull-right text-bold"><?=$this->lang->line('net-amount');?></div>
                            </div>
                        </td>
                        <td class="text-right text-bold">
                        	<div class="in-line" id="grandTotalAmount"><?= numberFormat(get_rounded($grandNetAmount)); ?></div>
                        </td>
                        <?php if($SO_status == 0){ ?>
                        	<td class="disabled" colspan="2"></td>
						<?php } ?>
                        </tr>

                        <tr>
                        <td class="text-right text-bold" colspan="2"><?=$this->lang->line('remarks');?></td>
                        <td class="text-right" colspan="<?= (empty($presumtiveTax))?8+$cst:6; ?>">
                            <div class="row">
                                <div class="col-md-9 pull-left"><?= form_textarea(array('name'=>'remarks','class'=>'form-control','rows'=>4),set_value('remarks',$sales_order['remarks'])); ?></div>

                            </div>
                        </td>
                        <td class="text-right text-bold">
                        </td>
                        <?php if($SO_status == 0){ ?>
                        	<td class="disabled" colspan="2"></td>
						<?php } ?>
                        </tr>
						<?php $rmk=2;if($SO_status == 0){$rmk=0; }?>
					</table>
				</div>
			</div>
		</div>

        <div class="row">
            <div class="col-md-12">
                <div class="form-group">
                    <div class="text-right">
                        <?= form_button(array('type'=>'submit','name'=>'save_bill','class'=>'btn btn-primary btn-loading pull-right','content'=>$this->lang->line('save')));?>
                    </div>
                </div>
            </div>
        </div>
	</div>
</div>
<?php
}
echo form_close();
?>