<style>
*{	font-size:10px;}
.pdf-head{	font-weight:bold; margin-left:auto; margin-right:auto; text-align:center; font-size:12px;}
.data-table{	font-size:10px;}
.text-right{	text-align:right;}
.text-center{	text-align:center;}
.text-bold{	font-weight:bold;}
.vendor{ text-indent:20px;}
.data-list{	padding:2px;}
.data-list th{	font-size:10px; text-align:center; background-color:#E4E4E4; font-weight:700;}
.data-list td{	font-size:8px;}
.disabled{background-color:#E2E2E1;}
.italic{ font-style:italic;}

.has-border{ border:1px solid #999;}
.has-border-left{border-left:1px solid #999;}
.data-list tr td{  border-right:1px solid #999;}

.data-list tr th{border:1px solid #999;}
.declaration{font-size:8px;}
.terms-conditions{font-size:8px;}
</style>
<?php
if(!empty($sales_orders)){
$l_date='2017-07-01';
	$bill_prefix = $this->stock->get_voucher_prefix(-1);
	$so_date = $customerID = NULL;
	$so_details = $sales_orders[0];
	$so_no = $so_details['so_no'];
	$so_date = $so_details['so_date'];
	$custTypeID = $so_details['customer_type_id'];
	$customerID = $so_details['customer_id'];
	$customerType = $this->dms->get_desig($custTypeID,1);
	$customerDetails = $this->stock->get_customer($custTypeID,$customerID,1);
	$customer_name = $customerDetails['name'];
	$customer_address = $customerDetails['address'];
	$customer_mobile = (!empty($customerDetails['mobile_no']))?'Mob : '.$customerDetails['mobile_no'].', ':'';
	$customer_phone = (!empty($customerDetails['phone_no']))?'Ph : '.$customerDetails['phone_no'].', ':'';
	$customer_email = (!empty($customerDetails['email_id']))?'Email : '.$customerDetails['email_id']:'';
	$tin = NULL;
	$cess = $so_details['cess'];
	if(isset($customerDetails['tin'])){
		$tin = 'Tin :'.$customerDetails['tin'];
	}
        if(isset($customerDetails['gstn'])){
		$gstn = 'GSTN :'.$customerDetails['gstn'];
	}
	$presumtiveTax = $this->stock->get_tax_type();
	$users_name='';$user_type=NULL;
?>
<div class="pdf-head">SALES ORDER</div>
<table  class="data-table" border="0">
<tr>
<td class="text-right">
    <span class="text-bold">Order. No. : </span><?= $bill_prefix.' '.$so_no; ?><br/>
	<span class="text-bold">Order. Date : </span><?= dateFormat($so_date); ?>
</td>
</tr>
<tr><td>To ,</td></tr>
<tr><td class="vendor text-bold"><?= $customer_name; ?></td></tr>
<tr><td class="vendor"><?= $customer_address; ?><?= $customer_email; ?></td></tr>
  <tr><td class="vendor"><?= $customer_phone; ?><?= $customer_mobile; ?><?= $tin; ?></td></tr>
<tr><td class="vendor"><?= $gstn; ?></td></tr>
</table>
<div>
</div>
<?php
$itmSpc=$qtySpc=$untSpc=$rtSpc=$amtSpc=0;$cstSpc=0;
if(empty($cst_enabled)){
	$cstSpc = 45;
}
if(!empty($presumtiveTax)){
	$cstSpc = 150;
}
?>
	<table class="table data-table data-list">
    <thead>
    <tr>
    <th width="20">#</th>
    <th width="<?= 150+$cstSpc; ?>">Item</th>
    <th width="40">Qty.</th>
    <th width="45">Rate</th>
    <th width="60">Amount</th>
    <th width="45">Discount</th>
    <?php 
       if($so_date < $l_date)
       {
            if(!empty($cst_enabled) && empty($presumtiveTax))
            { 
    ?>
                <th width="45">CST</th>
    <?php 
            } 
    ?>
    <?php 
            if(empty($presumtiveTax))
            { 
    ?>
                 <th width="40">VAT<br>(%)</th>
                 <th width="50">VAT Amt.</th>
    <?php 
             }
        }
        else
        {
?>
             <th width="40">GST<br>(%)</th>
             <th width="50">GST Amt.</th>
             
<?php
        } 
    ?>
    <th width="70">Net Amount</th>
    </tr>
    </thead>
    <?php
	$i=0;$totalAmount=0;$totalDiscountAmt=0;$totalNetValue=0;$totalVatAmt=0;$totalNetAmount=0;
	$grandNetAmount=0;$totalCst=0;
	$cst=0;
	foreach($sales_orders as $key=>$item){$i++;

		$itemID = $item['item_id'];
		$qty = $item['qty'];
		$rate = $item['rate'];
		$cstPercent = $item['cst'];
		$discountPer = $item['discount_per'];
		$discountAmt = $item['discount_amt'];
		$vatAmount=0;$cstAmount=0;$vat=0;$cgstAmt=0;$sgstAmt=0;
		 
                if($so_date < $l_date)
                {
                        if($cstPercent == 0)
                        {
			        $vat = $this->stock->get_item_vat($itemID);
		        }
                        else
                        {
			        $cst=1;
		        }
                        $cstAmount = ($cstPercent*$netValue)/100;
                }
                else
                {
                        $cgst = $this->stock->get_item_cgst($itemID);
                        $sgst = $this->stock->get_item_sgst($itemID);
                        $vat=$cgst+$sgst;
                }
		$amount = $item['amount'];
		$totalAmount += $amount;
		$totalDiscountAmt += $discountAmt;
		$netValue = $amount-$discountAmt;
		$totalNetValue += $netValue;
                if($so_date < $l_date)
                {
		        if(empty($presumtiveTax))
                        {
			        $vatAmount = $item['vat_amt'];//($vat*$netValue)/100;
		        }
                        else
                        {
			        $cstAmount=0;
		        }
                        $totalCst += $cstAmount;
                }
                else
                {
                        $cgstAmt=$item['cgst_amt'];
                        $sgstAmt=$item['sgst_amt'];
                        $vatAmount = $cgstAmt+$sgstAmt; 
                }
		$netValue += $cstAmount;
		$totalVatAmt += $vatAmount;
		$netAmount = $netValue+$vatAmount;
		$totalNetAmount += $netAmount;
		
		?>
        <tr>
        <td width="20" class="text-center has-border-left"><?= $i; ?></td>
        <td width="<?= 150+$cstSpc; ?>"><?= $item['item_code']; ?> / <?= $item['item_name']; ?></td>
        <td width="40" class="text-right"><?= $qty; ?> <?= $item['symbol']; ?></td>
        <td width="45" class="text-right"><?= numberFormat($rate); ?></td>
        <td width="60" class="text-right"><?= numberFormat($amount); ?></td>
        <td width="45" class="text-right"><?= numberFormat(round_this($discountAmt)); ?></td>
        <?php 
             if($so_date < $l_date)
             {
                    if(!empty($cst_enabled) && empty($presumtiveTax))
                    { 
        ?>
                         <td width="45" class="text-right"><?= numberFormat(round_this($cstAmount)); ?></td>
        <?php 
                    } 
        ?>
        <?php 
                    if(empty($presumtiveTax))
                    { 
        ?>
                          <td width="40" class="text-right"><?= $vat; ?></td>
                          <td width="50" class="text-right"><?= numberFormat(round_this($vatAmount)); ?></td>
        <?php 
                    }
              }
              else
              {
        ?>
                     <td width="40" class="text-right"><?= $vat; ?></td>
                     
                    
                     <td width="50" class="text-right"><?= numberFormat(round_this($vatAmount)); ?></td>
        <?php
              } 
        ?>
        <td width="70" class="text-right"><?= numberFormat(round_this($netAmount)); ?></td>
        </tr>
        <?php
	}
	$grandNetAmount = round_this($totalNetAmount);
	?>
    <tr>
    <td class="text-right text-bold has-border disabled" colspan="4">Total</td>
    <td class="text-right text-bold has-border disabled"><?= numberFormat(round_this($totalAmount)); ?></td>
    <td class="text-right text-bold has-border disabled"><?= numberFormat(round_this($totalDiscountAmt)); ?></td>
    <?php 
          if($so_date < $l_date)
          {
                 if(!empty($cst_enabled) && empty($presumtiveTax))
                 { 
    ?>
                        <td class="text-right text-bold has-border disabled"><?= numberFormat(round_this($totalCst)); ?></td>
    <?php 
                 } 
    ?>
    <?php 
                 if(empty($presumtiveTax))
                 { 
    ?>
                       <td class="disabled has-border"></td>
                       <td class="text-right text-bold has-border disabled"><?= numberFormat(round_this($totalVatAmt)); ?></td>
    <?php    
                 }
           }
           else
           {
?>
                  <td class="disabled has-border"></td>
                  <td class="text-right text-bold has-border disabled"><?= numberFormat(round_this($totalVatAmt)); ?></td>
<?php
           } 
    ?>
    <td class="text-right text-bold has-border disabled"><?= numberFormat(round_this($totalNetAmount)); ?></td>
    </tr>
    <?php
	$gnTotalVatAmount=$totalVatAmt;
	if(!empty($presumtiveTax)){
		$pmTaxAmt = ($presumtiveTax[0]*$totalNetAmount)/100;
		$gnTotalVatAmount = round_this($pmTaxAmt);
		$grandNetAmount += round_this($pmTaxAmt);
		?>
		<tr>
		<td class="text-right" colspan="<?= (empty($presumtiveTax))?7+$cst:5; ?>">Presumptive Tax @ <?= $presumtiveTax[0]; ?> %</td>
		<td class="text-right has-border" colspan="2"><?= numberFormat(round_this($pmTaxAmt)); ?></td>
		</tr>
		<?php
	}
	$cessAmount=0;
	$cessAmount = ($cess*($gnTotalVatAmount+$totalCst))/100;
	$grandNetAmount += round_this($cessAmount);
	?>
    <tr>
    <td class=" text-right" colspan="<?= (empty($presumtiveTax))?7+$cst:5; ?>">Cess ( <?= $cess; ?> %)</td>
    <td class="text-right has-border" colspan="2"><?= numberFormat(round_this($cessAmount)); ?></td>
    </tr>

    <tr>
    <td class="  text-right" colspan="<?= (empty($presumtiveTax))?7+$cst:5; ?>">Discount </td>
    <td class="text-right has-border" colspan="2"><?= numberFormat(round_this($sales_orders[0]['so_discount_amt'])); ?></td>
    </tr>
	<?php $grandNetAmount -= $sales_orders[0]['so_discount_amt']; ?>
	<?php if(show_round_off()){ ?>
        <tr>
        <td class=" text-right" colspan="<?= (empty($presumtiveTax))?7+$cst:5; ?>">Round Off</td>
        <td class="text-right has-border" colspan="2"><?= numberFormat(round_off($grandNetAmount)); ?>
        </td>
        </tr>
	<?php } ?>

    <tr>
    <td class=" text-right" colspan="<?= (empty($presumtiveTax))?7+$cst:5; ?>"><label>Net Amount (<?= get_currency(); ?>)</label></td>
    <td class="text-right text-bold has-border" colspan="2">
    <label><?= numberFormat(get_rounded($grandNetAmount)); ?></label>
    </td>
    </tr>
	</table>
    <div class="text-left italic"><?= $this->to_words->num_to_words(get_rounded($grandNetAmount)); ?></div>
    <div><span class="">Remarks : <?= $sales_orders[0]['remarks']; ?></span></div>
    <div class="text-right text-bold">Authorised Signatory.</div>
<?php
}
?>