<?php if(!empty($sales_orders)){?>
<div class="panel panel-primary">
	<div class="panel-heading">
		<h6 class="panel-title"><i class="icon-database"></i><?= $this->lang->line('sales-order-report'); ?></h6>
	</div>
	<div class="panel-body">
		<?php
        if($this->uri->uri_to_assoc(4)){
            $uriArray = $this->uri->uri_to_assoc(3);
            $uriString = $this->uri->assoc_to_uri($uriArray);
        }else{
            $uriString = $from_date.'/'.$to_date;
        }
        $presumtiveTax = $this->stock->get_tax_type();
		$bill_prefix = $this->stock->get_voucher_prefix(-1);
        if(!empty($sales_orders)){?>
        <div class="row">
            <div class="col-md-12">
                <?= export_to_excel('excel/sales_order_excel/sales_order/'.$from_date.'/'.$to_date); ?>
                <div class='table-responsive'>
                    <table class="table table-bordered table-striped">
                    <thead>
                    <tr class="bg-success">
                    <th>#</th>
                    <th><?= $this->lang->line('bill-no'); ?></th>
                    <th><?= $this->lang->line('bill-date'); ?></th>
                    <th><?= $this->lang->line('customer-type'); ?></th>
                    <th><?= $this->lang->line('customer-name'); ?></th>
                    <th><?= $this->lang->line('area'); ?></th>
                    <th><?= $this->lang->line('net-amount'); ?></th>
                    <th colspan="6"><?= $this->lang->line('actions'); ?></th>
                    </tr>
                    </thead>
                    <?php
                    foreach($sales_orders as $key=>$sales_order){

                        $salesOrderID = $sales_order['id'];
                        $branchID = $sales_order['branch_id'];
                        $so_date = $sales_order['so_date'];
                        $l_date = '2017-07-01';
                        $custTypeID = $sales_order['customer_type_id'];
                        $customerID = $sales_order['customer_id'];
                        $SO_status = $sales_order['so_status'];
                        $cess = $sales_order['cess'];
                        $customer_name = $this->stock->get_customer($custTypeID,$customerID);

                        $totalVatAmt=0;$grandNetAmount=0;$totalCst=0;$cst=0;
                        foreach($sales_order_items[$salesOrderID] as $itmKey=>$item){

							$vatAmount=$vat=$amount=$netAmount=0;
                            $itemID = $item['item_id'];
                            $qty = $item['qty'];
                            $rate = $item['rate'];
                            $cstPercent = $item['cst'];
                            $discountPer = $item['discount_per'];
                            $discountAmt = $item['discount_amt'];
                            $vatAmount=0;$cstAmount=0;$vat=0;$cgst=0;$sgst=0;$cgstAmt=0;$sgstAmt=0;
                            $amount = $item['amount'];
                            $netValue = $amount-$discountAmt;
                            if($so_date < $l_date)
                            {
                                   if($cstPercent == 0)
                                   {
                                          $vat = $this->stock->get_item_vat($itemID);
                                   }
                                   else
                                   {
                                          $cst=1;
                                   }
                                   $cstAmount = ($cstPercent*$netValue)/100;
                                   if(empty($presumtiveTax))
                                   {
                                          $vatAmount = $item['vat_amt'];//($vat*$netValue)/100;

                                   }
                                   else
                                   {
                                          $cstAmount=0;
                                    }
                                   $netValue += $cstAmount;
                                   $totalCst += $cstAmount;
                            }
                            else
                            {
                                    $cgst = $this->stock->get_item_cgst($itemID);
                                    $sgst = $this->stock->get_item_sgst($itemID);
                                    $cgstAmt = $item['cgst_amt'];
                                    $sgstAmt = $item['sgst_amt'];
                                    $vatAmount = $cgstAmt + $sgstAmt;
                            }
                            $netValue += $vatAmount;
                            $totalVatAmt += $vatAmount;
                            $grandNetAmount += $netValue;   
                        }
                        $gnTotalVatAmount=$totalVatAmt;
                        if($so_date < $l_date)
                        {
                              if(!empty($presumtiveTax))
                              {
                                    $pmTaxAmt = ($presumtiveTax[0]*$grandNetAmount)/100;
                                    $gnTotalVatAmount = $pmTaxAmt;
							$grandNetAmount += $pmTaxAmt;
                              }
                        
                        $cessAmount=0;
                        $cessAmount = ($cess*($gnTotalVatAmount+$totalCst))/100;
                        $grandNetAmount += $cessAmount;
                        }
                        $grandNetAmount -= $sales_order['so_discount_amt'];
						$grandNetAmount = get_rounded($grandNetAmount);
                        ?>
                        <tr>
                        <td class="text-center"><?= $count++; ?></td>
                        <td><?= $bill_prefix.' '.$sales_order['so_no']; ?></td>
                        <td class="text-center date"><?= dateFormat($sales_order['so_date']); ?></td>
                        <td><?= $sales_order['customer_type']; ?></td>
                        <td><?= $customer_name; ?></td>
                        <td><?= $sales_order['area']; ?></td>
                        <td class="text-right"><?= numberFormat($grandNetAmount); ?></td>
                        <?php
						$menuArray = array(306,307,310,311,308,309);
						 if(empty($so_status_array[$salesOrderID])){
							 $menuArray = array(310,311);
						 }
						app_table_links($salesOrderID.'/'.$uriString,$menuArray,6);
                        ?>
                        </tr>
                        <?php
                    }
                    ?>
                    </table>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="pagination"><?=$links;?></div>
            </div>
        </div>
    <?php } ?>
	</div>
</div>
<?php } ?>