<?php
if(!empty($sales_order) && !empty($sales_order_items)){
	$sales_order = $sales_order[0];
	$custTypeID = $sales_order['customer_type_id'];
	$customerID = $sales_order['customer_id'];
	$SO_status = $sales_order['so_status'];
	$cess = $sales_order['cess'];
	$customer_name = $this->stock->get_customer($custTypeID,$customerID);
	$presumtiveTax = $this->stock->get_tax_type();
	$bill_prefix = $this->stock->get_voucher_prefix(-1);
	$users_name='';$user_type=NULL;

	if(!empty($sales_order['user_id']))
	{
		$userDtls = $this->dms->get_users(array('columns'=>array('id','fname','lname','designation_id'),'conditions'=>array('id'=>$sales_order['user_id'])))[$sales_order['user_id']];
		$users_name = $userDtls['fname'].' '.$userDtls['lname'];
		$user_type = $userDtls['designation_id'];
		
	}
	$uriArray = $this->uri->uri_to_assoc(4);
	$uriString = $this->uri->assoc_to_uri($uriArray);
	?>
	<div class="panel panel-primary">
		<div class="panel-heading">
			<h6 class="panel-title"><i class="icon-database"></i> <?= $this->lang->line('sales-order'); ?></h6>
		</div>
        <div class="row">
        	<div class="col-md-12">
            	<?php app_export_menus($salesOrderID.'/'.$uriString,array(310)); ?>
            </div>
        </div>
		<div class="panel-body">
    		<div class="form-group">
        		<div class="row">
                    <div class="col-md-6">
                        <label><?=$this->lang->line('bill-no');?></label>
                        <div class="input-group">
                            <span class="input-group-addon text-bold"><?= $bill_prefix; ?></span>
                            <?= form_input(array('name'=>'bill_no','class'=>'form-control number text-right'),set_value('bill_no',$sales_order['so_no'])); ?>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <label><?=$this->lang->line('bill-date');?></label>
                         <?= form_input(array('name'=>'so_date','class'=>'form-control text-bold','disabled'=>true),set_value('so_date',cdateFormat($sales_order['so_date']))); ?>
                    </div>
                </div>
            </div>

            <div class="form-group">
                <div class="row">
                    <div class="col-md-12">
                        <label><?= $sales_order['customer_type']; ?></label>
                        <?= form_input(array('name'=>'cname','class'=>'form-control text-bold','disabled'=>true),set_value('cname',$customer_name)); ?>
                    </div>
                </div>
            </div>

            <div class="form-group">
                <div class="row">
                        <div class="col-md-6">
                            <label><?=$this->lang->line('user-type');?></label>
                            <?php $userTypeName = (!empty($user_type))?$userTypes[$user_type]:''; ?>
                            <?= form_input(array('name'=>'user_type','class'=>'form-control text-bold','disabled'=>true),set_value('user_type',$userTypeName)); ?>
                        </div>
                        <div class="col-md-6">
                            <label><?=$this->lang->line('user');?></label>
                            <?= form_input(array('name'=>'user','class'=>'form-control text-bold','disabled'=>true),set_value('user',$users_name)); ?>
                        </div>
                </div>
            </div>

			<div class="row">
				<div class="col-md-12">
					<div class='table-responsive'>
                        <table class="table table-bordered table-striped">
                        <thead>
                        <tr class="bg-success">
                        <th>#</th>
                        <th><?=$this->lang->line('item-name');?></th>
                        <th><?=$this->lang->line('quantity');?></th>
                        <th><?= $this->lang->line('unit'); ?></th>
                        <th><?= $this->lang->line('rate'); ?></th>
                        <th><?= $this->lang->line('amount'); ?></th>
                        <th><?= $this->lang->line('dis'); ?> <?= $this->lang->line('amt'); ?></th>
<?php 
						$l_date='2017-07-01';
                                                $b_date = $sales_order['so_date'];
						if($b_date < $l_date)
						{	
							if(!empty($cst_enabled) && empty($presumtiveTax))
							{ 
?>
                        		<th><?= $this->lang->line('cst'); ?></th>
<?php 
							} 
?>
                        	<th><?= $this->lang->line('net-value'); ?></th>
<?php 
							if(empty($presumtiveTax))
							{ 
?>
	                            <th><?= $this->lang->line('vat'); ?> (%)</th>
    	                        <th><?= $this->lang->line('vat'); ?> <?= $this->lang->line('amt'); ?></th>
<?php 
							}
						}
						else
						{
?>	
							<th><?= $this->lang->line('cgst'); ?> (%)</th>
                            <th><?= $this->lang->line('sgst'); ?> (%)</th>
    	                    <th><?= $this->lang->line('cgst'); ?> <?= $this->lang->line('amt'); ?></th>
    	                    <th><?= $this->lang->line('sgst'); ?> <?= $this->lang->line('amt'); ?></th>							
<?php							
						}
?>
                        <th><?= $this->lang->line('net'); ?> <?= $this->lang->line('amt'); ?></th>
                        </tr>
                        </thead>
						<?php
							$i=0;$totalAmount=0;$totalDiscountAmt=0;$totalNetValue=0;$totalVatAmt=0;$totalNetAmount=0;
							$grandNetAmount=0;$totalCst=0;
							$cst=0;
							foreach($sales_order_items as $key=>$item){$i++;

								$soItemID = $item['id'];
								$itemID = $item['item_id'];
								$itemStatus = $item['item_status'];
								$qty = $item['qty'];
								$rate = $item['rate'];
								$cstPercent = $item['cst'];
								$discountPer = $item['discount_per'];
								$discountAmt = $item['discount_amt'];
								$vatAmount=0;$cstAmount=0;$vat=0;$cgstAmt=0; $sgstAmt=0;
								if($b_date < $l_date)
								{
									if($cstPercent == 0){
										$vat = $this->stock->get_item_vat($itemID);
									}else{
										$cst=1;
									}
								}
								else
								{
									$cgst = $this->stock->get_item_cgst($itemID);
									$sgst = $this->stock->get_item_sgst($itemID);	
								}
								$amount = $item['amount'];
								$totalAmount += $amount;
								$totalDiscountAmt += $discountAmt;
								$netValue = $amount-$discountAmt;
								
								$totalNetValue += $netValue;
								if($b_date < $l_date)
								{
									$cstAmount = ($cstPercent*$netValue)/100;
									if(empty($presumtiveTax))
									{
										$vatAmount = $item['vat_amt'];//($vat*$netValue)/100;
									}
									else
									{
										$cstAmount=0;
									}
									$netValue += $cstAmount;
									$totalCst += $cstAmount;
								}
								else
								{
									$cgstAmt = $item['cgst_amt'];	
									$sgstAmt = $item['sgst_amt'];	
									$vatAmount = $cgstAmt + $sgstAmt;
								}
								
								$totalVatAmt += $vatAmount;
								$netAmount = $netValue+$vatAmount;
								$totalNetAmount += $netAmount;
								
								?>
								<tr>
								<td class="text-center"><?= $i; ?></td>
								<td><?= $item['item_code']; ?> / <?= $item['item_name']; ?></td>
								<td class="text-right"><?= $qty; ?></td>
								<td><?= $item['symbol']; ?></td>
								<td class="text-right"><?= numberFormat($rate); ?></td>
								<td class="text-right"><?= numberFormat(round_this($amount)); ?></td>
								<td class="text-right"><?= numberFormat(round_this($discountAmt)); ?></td>
								<?php
									if($b_date < $l_date)
									{		 
										if(!empty($cst_enabled) && empty($presumtiveTax))
										{ 
								?>
                                        <td class="text-right"><?= numberFormat(round_this($cstAmount)); ?></td>
                                <?php 
										}
								?>
                                    <td class="text-right"><?= numberFormat(round_this($netValue)); ?></td>
                                <?php 
										if(empty($presumtiveTax))
										{ 
								?>
                                       		<td class="text-right"><?= $vat; ?></td>
                                        	<td class="text-right"><?= numberFormat(round_this($vatAmount)); ?></td>
                                <?php 
										} 
									}
									else
									{
								?>	
                                		<td class="text-right"><?= $cgst; ?></td>
                                        <td class="text-right"><?= $sgst; ?></td>
                                        <td class="text-right"><?= numberFormat(round_this($cgstAmt)); ?></td>
                                        <td class="text-right"><?= numberFormat(round_this($sgstAmt)); ?></td>	
								<?php		
									}
								?>
								<td class="text-right"><?= numberFormat(round_this($netAmount)); ?></td>
								</tr>
								<?php
							}
							$grandNetAmount = round_this($totalNetAmount);
							?>
                            <tr>
                            <td class="text-right text-bold" colspan="5"><?= $this->lang->line('total'); ?></td>
                            <td class="text-right text-bold"><?= numberFormat(round_this($totalAmount)); ?></td>
                            <td class="text-right text-bold"><?= numberFormat(round_this($totalDiscountAmt)); ?></td>
                            <?php 
								if($b_date < $l_date)
								{
									if(!empty($cst_enabled) && empty($presumtiveTax))
									{
							?>
                            			<td class="text-right text-bold"><?= numberFormat(round_this($totalCst)); ?></td>
                            <?php 	
									} 
							?>
                            		<td class="text-right text-bold"><?= numberFormat(round_this($totalNetValue)); ?></td>
                            <?php 
									if(empty($presumtiveTax))
									{ 
							?>
                                		<td class="disabled"></td>
                                		<td class="text-right text-bold"><?= numberFormat(round_this($totalVatAmt)); ?></td>
                            <?php 
									}
								}
								else
								{
							?>	
                            		<td class="disabled"></td>
                                        <td class="text-right text-bold" colspan="2">Total GST Amt.</td>
                                	<td class="text-right text-bold" ><?= numberFormat(round_this($totalVatAmt)); ?></td>	
							<?php		
								}
							?>
                            <td class="text-right text-bold"><?= numberFormat(round_this($totalNetAmount)); ?></td>
                            </tr>
							<?php
							$gnTotalVatAmount=$totalVatAmt;
							if(!empty($presumtiveTax)){
								$pmTaxAmt = ($presumtiveTax[0]*$totalNetAmount)/100;
								$gnTotalVatAmount = round_this($pmTaxAmt);
								$grandNetAmount += round_this($pmTaxAmt);
								?>
                                <tr>
                                <td class="text-right text-bold" colspan="<?= 8; ?>"><?= $this->lang->line('presum-tax') ?> @ <?= $presumtiveTax[0]; ?> %</td>
                                <td class="text-right text-bold"><?= numberFormat(round_this($pmTaxAmt)); ?></td>
                                </tr>
								<?php
							}
							$cessAmount=0;
							$cessAmount = ($cess*($gnTotalVatAmount+$totalCst))/100;
							$grandNetAmount += round_this($cessAmount);
							?>
                            <tr>
                                <td class="text-right text-bold" colspan="2">
                                <?=$this->lang->line('discount');?> <?=$this->lang->line('amount');?></td>
                                <td class="text-right" colspan="<?= (empty($presumtiveTax))?8+$cst:6; ?>">
                                    <span class="pull-left"><?= numberFormat(round_this($sales_order['so_discount_amt'])); ?></span>
                                    <span class="text-bold"><?=$this->lang->line('cess');?> ( <?= $cess; ?> %)</span>
                                </td>
                                <td class="text-right"><div id="cess_amount"><?= numberFormat(round_this($cessAmount)); ?></div></td>
							</tr>
    						<?php $grandNetAmount -= $sales_order['so_discount_amt']; ?>

                            <?php if(show_round_off()){ ?>
							<tr>
                                <td class="text-right text-bold" colspan="2"></td>
                                <td class="text-right" colspan="<?= (empty($presumtiveTax))?8+$cst:6; ?>">
                                <span class="pull-left"></span>
                                <span class="text-bold pull-right"><?=$this->lang->line('round-off');?></span>
                                </td>
                                <td class="text-right">
                                 <span><?= numberFormat(round_off($grandNetAmount)); ?></span>
                                </td>
                            </tr>
							<?php } ?>

                            <tr>
                                <td class="text-right text-bold" colspan="2"><?=$this->lang->line('area');?></td>
                                <td colspan="<?= (empty($presumtiveTax))?8+$cst:6; ?>">
                                    <div class="row">
                                    <div class="col-md-9"><?= $sales_order['area']; ?></div>
                                    <div class="col-md-3 text-right text-bold"><?=$this->lang->line('net-amount');?></div>
                                    </div>
                                </td>
                                <td class="text-right text-bold">
                                <label><?= numberFormat(get_rounded($grandNetAmount)); ?></label>
                                </td>
                            </tr>

                            <tr>
                            <td class="text-right text-bold" colspan="2"><?=$this->lang->line('remarks');?></td>
                            <td colspan="<?= (empty($presumtiveTax))?9+$cst:7; ?>">
                                <?= $sales_order['remarks']; ?>
                            </td>
                            </tr>
						</table>
					</div>
				</div>
			</div>   

            <div class="row">
            <div class="col-md-7 pull-left text-bold"><?=$this->lang->line('last-updated-by')." : ".get_username($sales_order['created_by']);?></div>
            <div class="col-md-5 text-right text-bold"><?=$this->lang->line('last-updated-on')." : ".dateTimeFormat($sales_order['created_on']);?></div>
            </div>
    	</div>
	</div>
<?php
}
?>