<?= form_open();?>

<div class="panel panel-primary">
    <?php $bill_prefix = $this->stock->get_voucher_prefix($sales_array[0]['vtype_id']); ?>
    <div class="panel-heading">
        <h6 class="panel-title"><i class="icon-database"> </i> <?= $this->lang->line("edit")." ".$this->lang->line("$voucher_name-bill"); ?></h6>
    </div>
    <div class="panel-body">

        <div class="form-group">
            <div class="row">
                <div class="col-md-4">
                    <label><?=$this->lang->line('voucher-types');?></label>
                    <input type="text" class="form-control" disabled value="<?=$voucher_type;?>">
                </div>
                <div class="col-md-4">
                    <label class="required"><?=$this->lang->line('bill-no');?></label>
                    <div class="input-group">
                        <span class="input-group-addon text-bold" id="bill-prefix"><?= $bill_prefix; ?></span>
                        <?=form_input('bill_no',set_value('bill_no',$sales_array[0]['bill_no']),"class='form-control text-right number' id='sbill-ajax'");?>
                    </div>
                    <?= form_error('bill_no');?>
                </div>
                <div class="col-md-4">
                    <label class="required"><?=$this->lang->line('bill-date');?></label>
    				<?=form_input('bill_date',set_value('bill_date',cdateFormat($sales_array[0]['bill_date'])),"class='datepicker form-control bill-date' id='sdate-ajax'");?>
                    <?= form_error('bill_date');?>
                </div>
            </div>
        </div>

        <div class="form-group">
            <div class="row">
            	<div class="col-md-3">
                    <label><?=$this->lang->line('invoice-no');?></label>
                    <input type="text" class="form-control" disabled value="<?=$return_bill_no;?>">
                </div>
            	<div class="col-md-3">
                    <label><?=$this->lang->line('customer-types');?></label>
                    <input type="text" class="form-control" disabled value="<?=$this->dms->desig_name($sales_array[0]['customer_type_id']);?>">
                </div>
                <div class="col-md-6">
                    <label><?=$this->lang->line('customer-name');?></label>
                    <input type="text" class="form-control" disabled value="<?=$customer_name;?>">
                </div>
            </div>
        </div>

        <div class="form-group">
            <div class="row">
                <div class="col-md-6">
                    <label class="required"><?=$this->lang->line('item-name');?></label>
                    <?= form_dropdown('item_id',$items,set_value('item_id'),'class="form-control item_name"'); ?>
                    <?= form_error('item_id');?>
                </div>
            </div>
        </div>

        <div class="form-group">
            <div class="row">
                <div class="col-md-3">
                    <label class="required"><?=$this->lang->line('quantity');?></label>
                    <?= form_input(array('name'=>'qty','class'=>'form-control text-right qnty amount-ajax decimal'),set_value('qty')); ?>
                    <?= form_error('qty');?>
                </div>
                <div class="col-md-3">
                    <label class="required"><?=$this->lang->line('unit');?></label>
                    <?= form_dropdown('unit_id',$units,set_value('unit_id'),'class="form-control unit"'); ?>
                    <?= form_error('unit_id');?>
                </div>
                <div class="col-md-3">
                    <label class="required"><?=$this->lang->line('rate');?></label>
                    <?= form_input(array('name'=>'rate','class'=>'form-control text-right rate amount-ajax decimal'),set_value('rate')); ?>
                    <?= form_error('rate');?>
                </div>
                <div class="col-md-3">
                    <label class="required"><?=$this->lang->line('amount');?></label>
                    <?= form_input(array('name'=>'amount','class'=>'form-control text-right amount'),set_value('amount')); ?>
                    <?= form_error('amount');?>
                </div>
            </div>
        </div>
        
        <div class="float-left"><?=$this->lang->line('stock-bal')." : ";?></div><div class="float-left text-bold marg-left-10" id="stock-balance"><?=$stock_count." ".$primary_unit;?></div>

        <div class="form-group">
            <div class="text-right">
                <?=form_submit(array('name' => 'btn_add','class'=>'btn btn-primary btn-loading pull-right','value'=>$this->lang->line('add-to-bill')));?>
            </div>
        </div>
	</div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class='table-responsive'>
            <table class="table table-bordered table-striped">
                <thead>
                <tr class="bg-success">
                    <th>#</th>
                    <th><?= $this->lang->line('item-name');?></th>
                    <th><?= $this->lang->line('quantity');?></th>
                    <th><?= $this->lang->line('rate'); ?></th>
                    <th><?= $this->lang->line('amount'); ?></th>
                    <th><?= $this->lang->line('discount'); ?></th>
                    <th><?= $this->lang->line('taxable'); ?></th>
        		    <th><?= $this->lang->line('cgst'); ?> (%)</th>
        		    <th><?= $this->lang->line('cgst'); ?> <?= $this->lang->line('amt'); ?></th>
                    <th><?= $this->lang->line('sgst'); ?> (%)</th>
        			<th><?= $this->lang->line('sgst'); ?> <?= $this->lang->line('amt'); ?></th>
        			<th><?= $this->lang->line('cess'); ?> <?= $this->lang->line('amt'); ?></th>
                    <th class="width-150"><?= $this->lang->line('net'); ?> <?= $this->lang->line('amt'); ?></th>
					<th colspan='2'><?=$this->lang->line('actions');?></th>
                </tr>
                </thead>
<?php
                $i=0; $a=12; $b=10; $totalNetValue=0; $totalCgstAmt=0; $totalSgstAmt=0; $totalTaxAmt=0; $totalNetAmount=0; $totalTaxable=0; $totalDiscount=0; $totalCessAmt=0; $grandNetAmount=0;
				$cess = $sales_array[0]['cess'];
                $disc_amt = $sales_array[0]['bill_discount_amt'];
				foreach($sales_array as $key => $item)
				{
					$i++;
                    $itemID = $item['item_id'];
                    $item_details = $this->stock->get_item($itemID,array('item_code','item_name'));
                    $qty = $item['qty'];
                    $rate = $item['rate'];
                    $netValue = $item['amount'];
                    $discount = $item['discount_amt'];
                            
                    $tax_amount=0; $taxable=0; $cgstAmt=0; $sgstAmt=0; $cessAmt=0;
                    $taxable = $item['taxable_amt'];
                	$cgst = $item['cgst'];
                	$sgst = $item['sgst'];
                	$cgstAmt = $item['cgst_amt'];
                	$sgstAmt = $item['sgst_amt'];
                	$cessAmt = $item['cess_amt'];
                			
                	$tax_amount = $cgstAmt+$sgstAmt;
                	$netAmount = $taxable+$tax_amount+$cessAmt;
                			
                	$totalNetValue += $netValue;
                	$totalDiscount += $discount;
                	$totalTaxable += $taxable;
                	$totalCgstAmt += $cgstAmt;
                	$totalSgstAmt += $sgstAmt;
                	$totalTaxAmt += $tax_amount;
                	$totalCessAmt += $cessAmt;
                	$totalNetAmount += $netAmount;
?>
					<tr>
						<td><?= $i; ?></td>
                        <td><?= $item_details['item_code']; ?> / <?= $item_details['item_name']; ?></td>
                        <td class="text-right"><?= $qty; ?> <?=$this->stock->get_unit_symbol($item['unit_id']); ?></td>
                        <td class="text-right"><?= numberFormat($rate); ?></td>
                        <td class="text-right"><?= numberFormat($netValue); ?></td>
                        <td class="text-right"><?= numberFormat($discount); ?></td>
                        <td class="text-right"><?= numberFormat($taxable); ?></td>
            		    <td class="text-right"><?= $cgst; ?></td>
            		    <td class="text-right"><?= numberFormat($cgstAmt); ?></td>
                        <td class="text-right"><?= $sgst; ?></td>
                		<td class="text-right"><?= numberFormat($sgstAmt); ?></td>
                		<td class="text-right"><?= numberFormat($cessAmt); ?></td>
                        <td class="text-right"><?= numberFormat($netAmount); ?></td>
					    <?php app_table_links('ida/'.$item['id'],array(465,466));?>
					</tr>
<?php
				}
				$grandNetAmount = round_this($totalNetAmount);
?>
                <tr>
                    <td class="text-right text-bold" colspan="4"><?= $this->lang->line('total'); ?></td>
        		    <td class="text-right text-bold"><?=numberFormat($totalNetValue); ?></td>
        		    <td class="text-right text-bold"><?=numberFormat($totalDiscount); ?></td>
        		    <td class="text-right text-bold"><?=numberFormat($totalTaxable); ?></td>
                    <td class="text-right text-bold"></td>	
            		<td class="text-right text-bold"><?= numberFormat($totalCgstAmt); ?></td>
            		<td class="text-right text-bold"></td>	
            		<td class="text-right text-bold"><?= numberFormat($totalCgstAmt); ?></td>
            		<td class="text-right text-bold"><?= numberFormat($totalCessAmt); ?></td>
                    <td class="text-right text-bold"><?= numberFormat($totalNetAmount); ?></td>
					<td colspan="2" class="disabled"></td>
				</tr>
                <tr>
					<td colspan="2" class="text-right text-bold required"><?=$this->lang->line('area');?></td>
				    <td colspan="<?=($b-$colspan);?>" class="text-right text-bold">
    				    <div class="row">
    					    <div class="col-md-8"><?= form_dropdown('area_id',$areas,set_value('area_id'),'class="form-control"'); ?><?= form_error('area_id');?></div>
    					    <div class="col-md-4 pull-right"><?=$this->lang->line('cess');?> @ <?=$cess;?> %</div>
    					</div>
					</td>
					<td class="text-right"><?=numberFormat(round_this($totalCessAmt));?></td>
				    <td colspan="2" class="disabled"></td>
				</tr>
                <tr>
    				<td colspan="2" class="text-right text-bold"><?=$this->lang->line('payment-mode');?></td>
					<td colspan="<?=($b-$colspan);?>" class="text-right text-bold">
						<div class="row">
						    <div class="col-md-8"><?= form_dropdown('payment_mode',$payment_modes,set_value('payment_mode'),'class="form-control payment-mode"'); ?><?= form_error('payment_mode');?></div>
						    <div class="col-md-4 pull-right"><?= $this->lang->line('freight');?></div>
						</div>
					</td>
					<td><?= form_input(array('name'=>'freight','class'=>'form-control decimal text-right width-150 pull-right freight-amt'),set_value('freight')); ?><?=form_error('freight');?></td>
					<td colspan="2" class="disabled"></td>
				</tr>
    			<tr>
					<td colspan="<?=($a-$colspan);?>" class="text-right text-bold">
    					<div class="cd-ajax <?php if($cd_status){?>hide<?php }?>">
    						<div class="row">
        						<div class="col-md-3">
            						<?php $transaction_types = $this->dms->transaction_types();?>
            						<?= form_dropdown('ccd',$transaction_types,set_value('ccd'),'class="form-control"'); ?>
            						<?=form_error('ccd');?>
        						</div>
                                <div class="col-md-2"><label><?=$this->lang->line('cd-no');?></label></div>
        						<div class="col-md-3">
            						<?=form_input('cd_no',set_value('cd_no'),"class='form-control'");?>
            						<?=form_error('cd_no');?>
        						</div>
                                <div class="col-md-2"><label><?=$this->lang->line('cheque-date');?></label></div>
        						<div class="col-md-2">
        							<?=form_input('cheque_date',set_value('cheque_date',cdateFormat($voucher_date)),"class='datepicker form-control'");?>
        							<?=form_error('cheque_date');?>
        						</div>
    						</div>
    					</div>
					</td>
    				<td></td>
    				<td colspan="2" class="disabled"></td>
				</tr>
                <tr>
					<td class="text-right text-bold" colspan="2"><?=$this->lang->line('remarks');?></td>
					<td colspan="<?=($b-$colspan);?>" class="text-right text-bold">
						<div class="row">
							<div class="col-md-8 pull-left"><?= form_textarea(array('name'=>'remarks','class'=>'form-control','rows'=>2),set_value('remarks')); ?><?=form_error('remarks');?></div>
        					<div class="col-md-4 pull-right"><?= $this->lang->line('other-expense');?></div>
						</div>
					</td>
					<td><?= form_input(array('name'=>'other_expense','class'=>'form-control text-right width-150 pull-right other-expense decimal'),set_value('other_expense')); ?><?=form_error('other_expense');?></td>
					<td colspan="2" class="disabled"><input type="hidden" id="gnTotalAmt" value="<?= round_this($grandNetAmount); ?>"></td>
				</tr>
<?php
				if($this->input->post('freight'))
				{
					$grandNetAmount += $this->input->post('freight');
				}
				if($this->input->post('other_expense'))
				{
					$grandNetAmount += $this->input->post('other_expense');
				}
?>
    			<?php if(show_round_off()){ ?>
				    <tr>
				    	<td class="text-right text-bold" colspan="<?=($a-$colspan);?>">
				    		<div class="row">
				        		<div class="col-md-12 pull-right text-bold"><?=$this->lang->line('round-off');?></div>
				    		</div>
				    	</td>
				    	<td class="text-right text-bold">
				    		<div class="in-line" id="roundOff"><?= numberFormat(round_off($grandNetAmount)); ?></div>
						</td>
						<td colspan="2" class="disabled"></td>
					</tr>				
				<?php } ?>
				<tr>
					<td class="text-right text-bold" colspan="2"><?= $this->lang->line('discount');?> <?=$this->lang->line('amount');?></td>
				    <td class="text-right text-bold" colspan="<?=($b-$colspan);?>">
				    	<div class="row">
				        	<div class="col-md-3"><?= form_input(array('name'=>'bill_discount_amt','class'=>'form-control bill_discount_amt decimal text-right'),set_value('bill_discount_amt',$disc_amt)); ?><?=form_error('bill_discount_amt');?></div>
				        	<div class="col-md-3 pull-right text-bold"><?=$this->lang->line('net-amount');?></div>
				    	</div>
				    </td>
				    <td class="text-right text-bold"><div class="in-line" id="grandTotalAmount"><?= numberFormat(get_rounded($grandNetAmount)); ?></div></td>
					<td colspan="2" class="disabled"></td>
				</tr>
				<input type="hidden" name="round_off_amount" id="round_value" value="<?= round_off($grandNetAmount); ?>">
				<input type="hidden" name="grand_total" value="<?=round_this($grandNetAmount); ?>">
			</table>
        </div>
    
        <div class="row">
        	<div class="col-md-12">
        		<div class="form-group">
        			<div class="text-right">
        				<?= form_submit(array('name'=>'btn_update','class'=>'btn btn-primary btn-loading pull-right','value'=>$this->lang->line('update')."  ".$this->lang->line('bill')));?>
        			</div>
        		</div>
        	</div>
    	</div>

    </div>
</div>

<?= form_close(); ?>