<?php if(!empty($sales_returns_requests)){ ?>
<div class="panel panel-primary">
<div class="panel-heading">
<h6 class="panel-title"><i class="icon-database"></i><?= $this->lang->line('sales-return-requests'); ?></h6>
</div>
<div class="panel-body">
<div class="row">
    <div class="col-md-12">
        <?= export_to_word('word/sales_return_requests_word/sales_return_requests/'); ?>
    </div>
    </div>

<div class="row">
<div class="col-md-12">
<div class='table-responsive'>
<table class="table table-bordered table-striped">
<thead>
<tr class="bg-success">
<th>#</th>
<th><?= $this->lang->line('bill-no'); ?></th>
<th><?= $this->lang->line('bill-date'); ?></th>
<th><?= $this->lang->line('requested-by'); ?></th>
<th><?= $this->lang->line('net-amount'); ?></th>
<th><?=$this->lang->line('payment-mode');?></th>
<th><?= $this->lang->line('status'); ?></th>
<th><?= $this->lang->line('view'); ?></th>
<th><?= $this->lang->line('sales-return'); ?></th>
</tr>
</thead>

<?php
foreach($sales_returns_requests as $key=>$sr_request){
	$bill_prefix = $this->stock->get_voucher_prefix($sr_request['vtype_id']);
	$bill_status = ($sr_request['bill_status'] == 0 || $sr_request['bill_status'] == 1)?'<span class="pending">'.$this->lang->line('pending').'</span>':'<span class="approved">'.$this->lang->line('approved').'</span>';
	?>
    <tr>
    <td class="text-center"><?= $count++; ?></td>
    <td><?= $bill_prefix.' '.$sr_request['bill_no']; ?></td>
    <td class="text-center	"><?= dateFormat($sr_request['bill_date']); ?></td>
    <td><?= $sr_request['requested_by']; ?></td>
    <td class="text-right"><?= numberFormat(get_rounded($sr_request['amount'])); ?></td>
    <td><?= $sr_request['payment_mode']; ?></td>
    <td><?= $bill_status; ?></td>
    <td class="text-center">
		<a href="javascript:void();" class="purchase_return" id="<?= $sr_request['id']; ?>" data-toggle="modal" data-target="#large_modal" title="<?= $this->lang->line('view'); ?>"><i class="glyphicon icon-zoom-in"></i></a> 
    </td>
    <?php 
	if($sr_request['bill_status'] != 2){
	app_table_links($sr_request['id'],array(479));
	}else{
		?><td class="text-center"><a href="javascript:void();" title="<?= $this->lang->line('sales-purchase-converted'); ?>"><i class="icon-box-add"></i></a></td> <?php
	}?>
    </tr>
    <?php
} ?>
</table>
</div>
</div>
</div>

<div class="row">
<div class="col-md-12">
<div class="pagination"><?= $links; ?></div>
</div>
</div>


</div>
</div>
<?php } ?>