<div class="panel panel-primary">
    <div class="panel-heading">
	    <h6 class="panel-title"><i class="icon-database"></i><?= $this->lang->line("view")." ".$this->lang->line("bill"); ?></h6>
    </div>
    <div class="panel-body">
        <?php $bill_prefix = $this->stock->get_voucher_prefix($sales_array[0]['vtype_id']); ?>
        <div class="row">
            <div class="col-md-12">
                <?php app_export_menus('id/'.$sales_array[0]['primary_id'],array(544));?>
            </div>
        </div>
    
        <div class="form-group">
            <div class="row">
                <div class="col-md-4">
                    <label><?=$this->lang->line('voucher-types');?></label>
                    <input type="text" class="form-control" disabled value="<?=$voucher_type;?>">
                </div>
            
                <div class="col-md-4">
                    <label><?=$this->lang->line('bill-no');?></label>
                    <div class="input-group">
                    	<span class="input-group-addon text-bold" id="bill-prefix"><?= $bill_prefix; ?></span>
                    	<input type="text" class="form-control" disabled value="<?=$sales_array[0]['bill_no'];?>">
                    </div>
                </div>
                <div class="col-md-4">
                    <label><?=$this->lang->line('bill-date');?></label>
                    <input type="text" class="form-control" disabled value="<?=dateFormat($sales_array[0]['bill_date']);?>">
                </div>
            </div>
        </div>
    
        <div class="form-group">
            <div class="row">
            	<div class="col-md-3">
                    <label><?=$this->lang->line('invoice-no');?></label>
                    <input type="text" class="form-control" disabled value="<?=$return_bill_no;?>">
                </div>
                <div class="col-md-3">
                    <label><?=$this->lang->line('customer-types');?></label>
                    <input type="text" class="form-control" disabled value="<?=$this->dms->desig_name($sales_array[0]['customer_type_id']);?>">
                </div>
                <div class="col-md-6">
                    <label><?=$this->lang->line('customer-name');?></label>
                    <input type="text" class="form-control" disabled value="<?=$customer_name;?>">
                </div>
            </div>
        </div>
    
        <div class="row">
            <div class="col-md-12">
    
                <div class='table-responsive'>
                    <table class="table table-bordered table-striped">
                        <thead>
                        <tr class="bg-success">
                            <th>#</th>
                            <th><?= $this->lang->line('item-name');?></th>
                            <th><?= $this->lang->line('quantity');?></th>
                            <th><?= $this->lang->line('rate'); ?></th>
                            <th><?= $this->lang->line('amount'); ?></th>
                            <th><?= $this->lang->line('discount'); ?></th>
                            <th><?= $this->lang->line('taxable'); ?></th>
        		            <th><?= $this->lang->line('cgst'); ?> (%)</th>
        		            <th><?= $this->lang->line('cgst'); ?> <?= $this->lang->line('amt'); ?></th>
                            <th><?= $this->lang->line('sgst'); ?> (%)</th>
        			        <th><?= $this->lang->line('sgst'); ?> <?= $this->lang->line('amt'); ?></th>
        			        <th><?= $this->lang->line('cess'); ?> <?= $this->lang->line('amt'); ?></th>
                            <th class="width-150"><?= $this->lang->line('net'); ?> <?= $this->lang->line('amt'); ?></th>
                        </tr>
                        </thead>
<?php
                        $i=0; $totalNetValue=0; $totalCgstAmt=0; $totalSgstAmt=0; $totalTaxAmt=0; $totalNetAmount=0; $totalTaxable=0; $totalDiscount=0; $totalCessAmt=0;
                        $grandNetAmount=0;
                    	$cess = $sales_array[0]['cess'];
                    	$disc_amt = $sales_array[0]['bill_discount_amt'];
                        foreach($sales_array as $key => $item)
                        {
                            $i++;
                            $itemID = $item['item_id'];
                            $item_details = $this->stock->get_item($itemID,array('item_code','item_name'));
                            $qty = $item['qty'];
                            $rate = $item['rate'];
                            $netValue = $item['amount'];
                            $discount = $item['discount_amt'];
                            
                            $tax_amount=0; $taxable=0; $cgstAmt=0; $sgstAmt=0; $cessAmt=0;
                            $taxable = $item['taxable_amt'];
                			$cgst = $item['cgst'];
                			$sgst = $item['sgst'];
                			$cgstAmt = $item['cgst_amt'];
                			$sgstAmt = $item['sgst_amt'];
                			$cessAmt = $item['cess_amt'];
                			
                			$tax_amount = $cgstAmt+$sgstAmt;
                			$netAmount = $taxable+$tax_amount+$cessAmt;
                			
                			$totalNetValue += $netValue;
                			$totalDiscount += $discount;
                			$totalTaxable += $taxable;
                			$totalCgstAmt += $cgstAmt;
                			$totalSgstAmt += $sgstAmt;
                			$totalTaxAmt += $tax_amount;
                			$totalCessAmt += $cessAmt;
                			$totalNetAmount += $netAmount;
?>
                            <tr>
                                <td><?= $i; ?></td>
                                <td><?= $item_details['item_code']; ?> / <?= $item_details['item_name']; ?></td>
                                <td class="text-right"><?= $qty; ?> <?=$this->stock->get_unit_symbol($item['unit_id']); ?></td>
                                <td class="text-right"><?= numberFormat($rate); ?></td>
                                <td class="text-right"><?= numberFormat($netValue); ?></td>
                                <td class="text-right"><?= numberFormat($discount); ?></td>
                                <td class="text-right"><?= numberFormat($taxable); ?></td>
            		            <td class="text-right"><?= $cgst; ?></td>
            		            <td class="text-right"><?= numberFormat($cgstAmt); ?></td>
                                <td class="text-right"><?= $sgst; ?></td>
                		        <td class="text-right"><?= numberFormat($sgstAmt); ?></td>
                		        <td class="text-right"><?= numberFormat($cessAmt); ?></td>
                                <td class="text-right"><?= numberFormat($netAmount); ?></td>
                            </tr>
<?php
                        }
                        $grandNetAmount = round_this($totalNetAmount);
?>
                        <tr>
                            <td class="text-right text-bold" colspan="4"><?= $this->lang->line('total'); ?></td>
        		            <td class="text-right text-bold"><?=numberFormat($totalNetValue); ?></td>
        		            <td class="text-right text-bold"><?=numberFormat($totalDiscount); ?></td>
        		            <td class="text-right text-bold"><?=numberFormat($totalTaxable); ?></td>
                            <td class="text-right text-bold"></td>	
            		        <td class="text-right text-bold"><?= numberFormat($totalCgstAmt); ?></td>
            		        <td class="text-right text-bold"></td>	
            		        <td class="text-right text-bold"><?= numberFormat($totalCgstAmt); ?></td>
            		        <td class="text-right text-bold"><?= numberFormat($totalCessAmt); ?></td>
                            <td class="text-right text-bold"><?= numberFormat($totalNetAmount); ?></td>
                        </tr>
                        <tr>
                            <td colspan="2" class="text-right text-bold"><?=$this->lang->line('area');?></td>
                            <td colspan="<?=(10-$colspan);?>" class="text-right text-bold">
                                <div class="row">
                                    <div class="col-md-8"><input class="form-control" type="text" disabled value="<?=$area_id;?>"></div>
                                    <div class="col-md-4 pull-right"><?=$this->lang->line('cess');?> @ <?=$cess;?> %</div>
                                </div>
                            </td>
                            <td class="text-right"><?=numberFormat(round_this($totalCessAmt));?></td>
                        </tr>
                        <tr>
                            <td colspan="2" class="text-right text-bold"><?=$this->lang->line('payment-mode');?></td>
                            <td colspan="<?=(10-$colspan);?>" class="text-right text-bold">
                                <div class="row">
                                    <div class="col-md-8"><input class="form-control" type="text" disabled value="<?=$payment_mode;?>"></div>
                                    <div class="col-md-4 pull-right"><?= $this->lang->line('freight');?></div>
                                </div>
                            </td>
                            <td class="text-right"><?=numberFormat(round_this($sales_array[0]['bill_freight']));?></td>
                        </tr>
                        <tr>
    	                    <td colspan="<?=(12-$colspan);?>" class="text-right text-bold">
                                <div class="cd-ajax <?php if($cd_status){?>hide<?php }?>">
                                    <div class="row">
                                        <div class="col-md-3">
                                            <?php $transaction_types = $this->dms->transaction_types();?>
                                            <?= form_dropdown('ccd',$transaction_types,set_value('ccd',$ccd),'class="form-control" disabled'); ?>
                                            <?=form_error('ccd');?>
                                        </div>
                                
                                        <div class="col-md-2"><label><?=$this->lang->line('cd-no');?></label></div>
                                        <div class="col-md-3">
                                            <?=form_input('cd_no',set_value('cd_no',$cd_no),"class='form-control' disabled");?>
                                            <?=form_error('cd_no');?>
                                        </div>
                                
                                        <div class="col-md-2"><label><?=$this->lang->line('cheque-date');?></label></div>
                                        <div class="col-md-2">
                                            <?=form_input('cheque_date',set_value('cheque_date',dateFormat($pdc)),"class='datepicker form-control' disabled");?>
                                            <?=form_error('cheque_date');?>
                                        </div>
                                    </div>
                                </div>
    	                    </td>
                            <td></td>
    	                </tr>
                        <tr>
                            <td class="text-right text-bold" colspan="2"><?=$this->lang->line('remarks');?></td>
                            <td colspan="<?=(10-$colspan);?>" class="text-right text-bold">
                                <div class="row">
                                    <div class="col-md-8 pull-left"><textarea class="form-control" disabled><?=$sales_array[0]['narration'];?></textarea></div>
                                    <div class="col-md-4 pull-right"><?= $this->lang->line('other-expense');?></div>
                                </div>
                            </td>
                            <td class="text-right"><?=numberFormat(round_this($sales_array[0]['other_expense']));?></td>
                        </tr>
<?php 
                        $grandNetAmount += ($sales_array[0]['bill_freight']+$sales_array[0]['other_expense']);
                    
                        if(show_round_off())
                        { 
?>
                            <tr>
                                <td class="text-right text-bold" colspan="<?=(12-$colspan);?>">
                                    <div class="row">
                                        <div class="col-md-12 pull-right text-bold"><?=$this->lang->line('round-off');?></div>
                                    </div>
                                </td>
                                <td class="text-right text-bold">
                                	<div class="in-line" id="grandTotalAmount"><?= numberFormat(round_off($grandNetAmount)); ?></div>
                            	</td>
                            </tr>
<?php 
                        } 
?>
                        <tr>
                            <td class="text-right text-bold" colspan="2"><?= $this->lang->line('discount');?> <?=$this->lang->line('amount');?></td>
                            <td class="text-right text-bold" colspan="<?=(10-$colspan);?>">
                                <div class="row">
				        			<div class="col-md-3"><?= form_input(array('name'=>'bill_discount_amt','class'=>'form-control bill_discount_amt decimal text-right  disabled','disabled'=>'disabled'),set_value('bill_discount_amt',$disc_amt)); ?><?=form_error('bill_discount_amt');?></div>
				        			<div class="col-md-3 pull-right text-bold"><?=$this->lang->line('net-amount');?></div>
				    			</div>
				    		</td>
                            <td class="text-right text-bold">
                            	<div class="in-line" id="grandTotalAmount"><?= numberFormat(get_rounded($grandNetAmount)); ?></div>
                        	</td>
                        </tr>
                    </table>
                </div>
                <div class="row">
                    <div class="col-md-7 pull-left text-bold"><?=$this->lang->line('last-updated-by')." : ".get_username($sales_array[0]['created_by']);?></div>
                    <div class="col-md-5 text-right text-bold"><?=$this->lang->line('last-updated-on')." : ".dateTimeFormat($sales_array[0]['created_on']);?></div>
                </div>
            </div>
        </div>
    </div>
</div>