<?= form_open(); ?>

<div class="panel panel-primary">
<div class="panel-heading">
<h6 class="panel-title"><i class="icon-cart-checkout"> <?= $this->lang->line('stock-transfer'); ?> </i></h6>
</div>
<div class="panel-body">

<div class="form-group">
    <div class="row">

        <div class="col-md-6">
            <label class="required"><?=$this->lang->line('transfer-id');?></label>
            <?= form_input(array('name'=>'transfer_no','class'=>'form-control text-right number'),set_value('transfer_no',$transfer_Id)); ?>
            <?= form_error('transfer_no');?>
        </div>
        <div class="col-md-6">
            <label class="required"><?=$this->lang->line('date');?></label>
            <?= form_input(array('name'=>'transfer_date','class'=>'form-control datepicker'),set_value('transfer_date',$transfer_date)); ?>
            <?= form_error('transfer_date');?>
        </div>
    </div>
</div>
   
 
<?php if(!empty($purchases)){ ?>
<div class="form-group">
<div class="row">
    <div class="col-md-12">
        <div class='table-responsive'>
        <table class="table table-bordered table-striped">
        <thead>
        <tr class="bg-success">
        <th>#</th>
        <th><?= $this->lang->line('item-name'); ?></th>
        <th><?= $this->lang->line('godown'); ?></th>
        <th><?= $this->lang->line('quantity'); ?></th>
        <th><?= $this->lang->line('unit'); ?></th>
        </tr>       
        </thead>
        <?php $i=0;
        foreach($purchases as $key=>$purchase){$i++;
            ?>
            <tr>
            <td><?= $i; ?></td>
            <td><?= $this->dms->get_item_name($purchase['item_id']);?></td>
                    <?php $godown_from = $this->stock->get_item_godowns(array('item_id'=>$purchase['item_id'],'listing'=>TRUE))?>
           <td>
                <?= form_dropdown('stock['.$key.'][godown_from_id]',$godown_from,set_value('stock['.$key.'][godown_from_id]'),'class="form-control godown"'); ?>
                <?= form_error('stock['.$key.'][godown_from_id]');?></td>
            <td><?= $purchase['qty']; ?></td>
            <td><?= $this->stock->get_unit_symbol($purchase['unit_id']); ?></td>
        </TR>
        <?php } ?>
        </table>
        </div>
    
    </div>
</div>
</div> 
<div class="form-group">
    
    <div class="row">

       <div class="col-md-4">
            <label class="required"><?=$this->lang->line('transfer-to');?></label>
            <?= form_dropdown('godown_to_id',$godown_to,set_value('godown_to_id'),'class="select2-container select-full godown"'); ?>
            <?= form_error('godown_to_id');?>
        </div>
        <div class="col-md-4">

              <label><?=$this->lang->line('freight');?></label>
              <?=form_input(array('name'=>'freight','class'=>'form-control'),set_value('freight'));?>
              <?=form_error('freight');?>
        </div>
        <div class="col-md-4">

              <label><?=$this->lang->line('other-expense');?></label>
              <?=form_input(array('name'=>'other_expense','class'=>'form-control'),set_value('other_expense'));?>
              <?=form_error('other_expense');?>
        </div>

    
    </div>    
</div>

<div class="form-group">

    <div class="row">
        <div class="col-md-12">
            <label><?=$this->lang->line('narration');?></label>
            <?= form_textarea(array('name'=>'narration','rows'=>3,'class'=>'form-control'),set_value('narration')); ?>
            <?= form_error('narration');?>
        </div>
    </div>    
</div>

<div class="form-group">
    <div class="row">
        <div class="col-md-12">
        	<?=form_submit(array('name'=>'save_stock','class'=>'btn btn-primary pull-right','value'=>$this->lang->line('save')));?>
        </div>
    </div>    
</div>
<?php } ?>

</div>
</div>
<?= form_close(); ?>