<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, user-scalable=no, initial-scale=1, maximum-scale=1">
<title><?php title();?></title>

<link rel="stylesheet" href="<?=base_url();?>assets/londinium/theme_style.css" />
<!--<link href="http://fonts.googleapis.com/css?family=Open+Sans:400,300,600,700&amp;subset=latin,cyrillic-ext" rel="stylesheet" type="text/css">-->

<script type="text/javascript" src="<?= base_url(); ?>assets/jquery/jquery.min.js"></script>
<script type="text/javascript" src="<?= base_url(); ?>assets/jquery/jquery-ui.min.js"></script>
<script type="text/javascript" src="<?= base_url(); ?>assets/londinium/scripts/plugins/charts/sparkline.min.js"></script>
<script type="text/javascript" src="<?= base_url(); ?>assets/londinium/scripts/plugins/forms/uniform.min.js"></script>
<script type="text/javascript" src="<?= base_url(); ?>assets/londinium/scripts/plugins/forms/select2.min.js"></script>
<script type="text/javascript" src="<?= base_url(); ?>assets/londinium/scripts/plugins/forms/inputmask.js"></script>
<script type="text/javascript" src="<?= base_url(); ?>assets/londinium/scripts/plugins/forms/autosize.js"></script>
<script type="text/javascript" src="<?= base_url(); ?>assets/londinium/scripts/plugins/forms/inputlimit.min.js"></script>
<script type="text/javascript" src="<?= base_url(); ?>assets/londinium/scripts/plugins/forms/listbox.js"></script>
<script type="text/javascript" src="<?= base_url(); ?>assets/londinium/scripts/plugins/forms/multiselect.js"></script>
<script type="text/javascript" src="<?= base_url(); ?>assets/londinium/scripts/plugins/forms/validate.min.js"></script>
<script type="text/javascript" src="<?= base_url(); ?>assets/londinium/scripts/plugins/forms/tags.min.js"></script>
<script type="text/javascript" src="<?= base_url(); ?>assets/londinium/scripts/plugins/forms/switch.min.js"></script>

<script type="text/javascript" src="<?= base_url(); ?>assets/londinium/scripts/plugins/forms/uploader/plupload.full.min.js"></script>
<script type="text/javascript" src="<?= base_url(); ?>assets/londinium/scripts/plugins/forms/uploader/plupload.queue.min.js"></script>

<script type="text/javascript" src="<?= base_url(); ?>assets/londinium/scripts/plugins/forms/wysihtml5/wysihtml5.min.js"></script>
<script type="text/javascript" src="<?= base_url(); ?>assets/londinium/scripts/plugins/forms/wysihtml5/toolbar.js"></script>

<script type="text/javascript" src="<?= base_url(); ?>assets/londinium/scripts/globalize/globalize.js"></script>
<script type="text/javascript" src="<?= base_url(); ?>assets/londinium/scripts/globalize/globalize.culture.de-DE.js"></script>
<script type="text/javascript" src="<?= base_url(); ?>assets/londinium/scripts/globalize/globalize.culture.ja-JP.js"></script>

<script type="text/javascript" src="<?= base_url(); ?>assets/londinium/scripts/plugins/interface/daterangepicker.js"></script>
<script type="text/javascript" src="<?= base_url(); ?>assets/londinium/scripts/plugins/interface/fancybox.min.js"></script>
<script type="text/javascript" src="<?= base_url(); ?>assets/londinium/scripts/plugins/interface/moment.js"></script>
<script type="text/javascript" src="<?= base_url(); ?>assets/londinium/scripts/plugins/interface/mousewheel.js"></script>
<script type="text/javascript" src="<?= base_url(); ?>assets/londinium/scripts/plugins/interface/jgrowl.min.js"></script>
<script type="text/javascript" src="<?= base_url(); ?>assets/londinium/scripts/plugins/interface/datatables.min.js"></script>
<script type="text/javascript" src="<?= base_url(); ?>assets/londinium/scripts/plugins/interface/colorpicker.js"></script>
<script type="text/javascript" src="<?= base_url(); ?>assets/londinium/scripts/plugins/interface/fullcalendar.min.js"></script>


<script type="text/javascript" src="<?= base_url(); ?>assets/londinium/scripts/bootstrap.min.js"></script>
<script type="text/javascript" src="<?= base_url(); ?>assets/londinium/scripts/dms_script.js"></script>
<script type="text/javascript" src="<?= base_url(); ?>assets/londinium/scripts/application_blank.js"></script>

<!--dynamic styles go here-->
<?php styles();?>

<!--dynamic scripts go here-->
<?php scripts();?>
</head>

<body class="sidebar-right">

	<!-- Navbar -->
	<div class="navbar navbar-inverse" role="navigation">
		<div class="navbar-header">
			<a class="navbar-brand" href="#"><?=SITE_NAME;?></a>
			<a class="sidebar-toggle"><i class="icon-paragraph-justify2"></i></a>
			<button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#navbar-icons">
				<span class="sr-only">Toggle navbar</span>
				<i class="icon-grid3"></i>
			</button>
			<button type="button" class="navbar-toggle offcanvas">
				<span class="sr-only">Toggle navigation</span>
				<i class="icon-paragraph-justify2"></i>
			</button>
		</div>

		<ul class="nav navbar-nav navbar-right collapse" id="navbar-icons">


				<li class="user dropdown">
				<a class="dropdown-toggle" data-toggle="dropdown">
					<img src="http://placehold.it/300" alt="">
					<span><?php the_user();?></span>
					<i class="caret"></i>
				</a>

				<!--user profile-logout menu-->
				<ul class="dropdown-menu dropdown-menu-right icons-right">
					<li><a href="<?=base_url('users/profile');?>"><i class="icon-user"></i><?=$this->lang->line('profile');?></a></li>
					<?php settings_menu(4);?>
					<li><a href="<?=base_url('users/logout');?>"><i class="icon-exit"></i><?=$this->lang->line('logout');?></a></li>
				</ul>
			</li>
		</ul>
	</div>
	<!-- /navbar -->


	<!-- Page container -->
 	<div class="page-container">


		<!-- Sidebar -->
		<div class="sidebar">
			<div class="sidebar-content">

				<!-- User dropdown -->
				<div class="user-menu dropdown">
					<a href="#" class="dropdown-toggle" data-toggle="dropdown">
						<img src="http://placehold.it/300" alt="">
						<div class="user-info">
							<?php the_user();?> <span><?php the_designation();?></span>
						</div>
					</a>
					<div class="popup dropdown-menu dropdown-menu-right">
					    <div class="thumbnail">
					    	<div class="thumb">
								<img alt="" src="http://placehold.it/300">
								<div class="thumb-options">
									<span>
										<a href="#" class="btn btn-icon btn-success"><i class="icon-pencil"></i></a>
										<a href="#" class="btn btn-icon btn-success"><i class="icon-remove"></i></a>
									</span>
								</div>
						    </div>
					    
					    	<div class="caption text-center">
					    		<h6><?php the_user();?> <small><?php the_designation();?></small></h6>
					    	</div>
				    	</div>

				    	<ul class="list-group">
						<li class="list-group-item"><i class="icon-stack text-muted"></i> <?php the_branch();?></li>						</ul>
					</div>
				</div>
				<!-- /user dropdown -->


				<!-- Main navigation -->
				<ul class="navigation">
					<li><a href="#"><span><?=$this->lang->line('dashboard');?></span> <i class="icon-screen2"></i></a></li>
					<?php app_dashboard_menu();?>  
				</ul>
				<!-- /main navigation -->
				
			</div>
		</div>
		<!-- /sidebar -->


		<!-- Page content -->
	 	<div class="page-content">


			<!-- Page header -->
			<div class="page-header">
				<div class="page-title">
					<h3><?php main_heading();?></h3>
				</div>

				<div id="reportrange" class="range">
					<div class="visible-xs header-element-toggle">
						<a class="btn btn-primary btn-icon"><i class="icon-calendar"></i></a>
					</div>
					<div class="date-range"><?php the_fiscal_year_display();?></div>
					<span class="label label-danger">9</span>
				</div>
			</div>
			<!-- /page header -->


			<!-- Breadcrumbs line -->
			<div class="breadcrumb-line">
				<?php app_breadcrumb();?>

				<div class="visible-xs breadcrumb-toggle">
					<a class="btn btn-link btn-lg btn-icon" data-toggle="collapse" data-target=".breadcrumb-buttons"><i class="icon-menu2"></i></a>
				</div>

				<ul class="breadcrumb-buttons collapse">
					
					<!--language-->
					<li class="language dropdown">
						<a href="#" class="dropdown-toggle" data-toggle="dropdown"><span><?= $this->lang->line(strtolower(the_language()));?></span> <b class="caret"></b></a>
						<ul class="dropdown-menu dropdown-menu-right icons-right">
							<li class="active"><a href="<?=base_url();?>dms/change_lang/english/<?=$this->uri->segment(1);?>/<?=$this->uri->segment(2);?>"><img src="<?=base_url();?>assets/flags/english.png" alt=""> English</a></li>
							<li class="active"><a href="<?=base_url();?>dms/change_lang/malayalam/<?=$this->uri->segment(1);?>/<?=$this->uri->segment(2);?>"><img src="<?=base_url();?>assets/flags/malayalam.png" alt=""> മലയാളം</a></li>
						</ul>
					</li>

				</ul>
			</div>
			<!-- /breadcrumbs line -->

			<div class="row">
            <div class="col-md-12">
            	<?php content();?>
            </div>
            </div>
	      


	        <!-- Footer -->
	        <div class="footer clearfix">
		         <div class="pull-left"><?=APP_NAME;?> | <?=APP_VER;?></div>
	        </div>
	        <!-- /footer -->


		</div>
		<!-- /page content -->


	</div>
	<!-- /page container -->

</body>
</html>