<?= form_open(); ?>
<div class="panel panel-primary">
<div class="panel-heading">
<h6 class="panel-title"><i class="icon-database"></i> <?= $this->lang->line('user-points'); ?> </h6>
</div>
<div class="panel-body">

	<div class="form-group">
        <div class="row">
            <div class="col-md-6">
                <label class=""><?=$this->lang->line('user-type');?></label>
                <?= form_dropdown('user_type',$user_types,set_value('user_type'),"class='form-control user_type' "); ?>
                <?= form_error('user_type');?>
            </div>
            <div class="col-md-6">
                <label class=""><?=$this->lang->line('user');?></label>
                <?= form_dropdown('user_id',$users,set_value('user_id'),"class='form-control users'"); ?>
                <?= form_error('user_id');?>
            </div>
        </div>
	</div> 
    
    <div class="form-group">
        <div class="row">
            <div class="col-md-12">
                <?=form_button(array('type'=>'submit','class'=>'btn btn-primary pull-right','content'=>$this->lang->line('get')));?>
            </div>
        </div>
    </div>    
    
</div>
</div>  
<?= form_close(); ?>

<?php if(!empty($user_points)){ ?>
<div class="form-group">
    <div class="row">
        <div class="col-md-12">
        <div class='table-responsive'>
            <table class="table table-bordered table-striped">
            <thead>
            <tr class="bg-success">
            <th>#</th>
            <th><?=$this->lang->line('date');?></th>
            <th><?=$this->lang->line('points');?></th>
			<th><?= $this->lang->line('bill-ref-no'); ?></th>
            <th><?= $this->lang->line('message'); ?></th>
            <th><?= $this->lang->line('sms-status'); ?></th>
            </tr>
            </thead>
            <?php
			
			foreach($user_points as $key=>$point){
				$scored_point = $point['sms_point'];
				?>
                <tr>
                <td class="text-center"><?= $count++; ?></td>
                <td><?= dateFormat($point['point_date']); ?></td>
                <td><?= $scored_point; ?></td>
                <td><?= $point['bill_ref_no']; ?></td>
                <td><?= $point['message']; ?></td>
                <td><?= $msg_status[$point['msg_status']]; ?></td>
                </tr>
                <?php
			}
			?>
            </table>
        </div>
    </div>
    

</div>
<div class="pagination"><?= $links; ?></div>

<div class="form-group">
    <div class="row">
        <div class="col-md-6">
            <label><?= $this->lang->line('total-scored-point'); ?> : <?= $total_points; ?></label>
        </div>
         <?php if($this->dms->have_access(578)){?>
    	<div class="col-md-6 text-right">
	        <a href="<?=base_url('user_points/add/utype/'.$user_type_id.'/uid/'.$user_id);?>"><input type="button" class="btn btn-info" value="Click here to add bonus point"></a>
        </div>
        <?php } ?>
    </div>
</div>
<?php
}
?>