$(document).ready(function(){

	var screenWidth = $(window).width();
	if(screenWidth >950 && screenWidth <1100){
		$('body').addClass('sidebar-narrow');
	}
	
	var base_url = $('body').data('baseurl');
	var app_path = base_url+'ajax/';
	
	var doc_height = $(document).height();
	var win_height = $(window).height();
	var ulht = $('.user-list-holder').offset();
	
	$('.user-list-holder').css('max-height',win_height-ulht.top-100).css('border','#666666').css('width','200px');
	$('.chat').css('height',win_height-ulht.top-200).css('border','#666666');

	get_online_users();
	$(".user-nasme").click(function(){
		get_chat_msg($(this));
	});
	$(".refresh").click(function(){ get_online_users(); });
	chat_count();

	$('.chat-clear').click(function(e) {
        var to_user = $("#chat-text").attr("data-current-user");
		if(to_user != 0){
			fun_clear_chat(to_user);
		}
    });
});


	
	//GET ONLINE USERS-------------------------------------------------------------------------
	function get_online_users(){

		var base_url = $('body').data('baseurl');
		var app_path = base_url+'ajax/';
		$(".user-list").html('Refreshing the chat list...<i class="typing loader-small"></i>');
		var w = $.ajax({
			url:app_path+ 'Chat_ajax/get_online_users',
			dataType: "json",
			success: function(users){
				$(".user-list").html('');
				if(users.length > 0){
					$.each(users,function(i,item){
						$(".user-list").append('<li class="list-group-item member-'+ item.id +'"><img src="'+base_url+'assets/images/chat/online_status_'+item.online_status+'.png" > '+item.fname+' ' + item.lname+'<a href="javascript:void();" class="user-name" data-active="'+item.id+'"><i class="icon-bubbles6 pull-right"></i></a><span class="badge pull-right hide chat-new">'+item.msg+'</span></li>');
					});
					$(".user-list").on('click','.user-name',function(){ 
						get_chat_msg($(this));
					});										
				}
			},
			timeout:15000,
		});
	}

	/*-------------------------------------------------------------------------------------------------*/
	
	//get the chat message
	function get_chat_msg(element){
		var user = element.attr("data-active");
		$(".icon-bubbles6").removeClass('green');
		$(".list-group-item").removeClass("bg-success");
		$('.member-photo').html('<i class="typing loader-small"></i>');
		$(".chat-member").html('Loading...');
		element.children("i").addClass('green');
		element.parent().addClass("bg-success");
		$("#chat-text").attr("data-current-user",user);
		$(".ichat").html('');
		load_chat(0);
	}

	/*-------------------------------------------------------------------------------------------------*/

	//GET NEW CHAT COUNTS
	function chat_count(t_count){

		var base_url = $('body').data('baseurl');
		var app_path = base_url+'ajax/';	
		var totalMsg = 0;
		var t_count = typeof t_count !== 'undefined' ? t_count : {};
		$.getJSON(app_path+ 'Chat_ajax/new_msg_counts',{'counts':t_count},function(counts){
			$(".chat-new").addClass('hide').html('');
				$.each(counts,function(i,items){
					$(".member-" + i).children("span").removeClass('hide').html(items);
					totalMsg = totalMsg+parseFloat(items);
				});
				if(totalMsg >0){
					load_chat();
					$('.chat-count').html(totalMsg);
				}
				//setTimeout(chat_count,15000);
				//chat_count(counts);
		});
	}
	
	/*--------------------------------------------------------------------------------------------------*/

	//load chat messages
	function load_chat(total){

		var base_url = $('body').data('baseurl');
		var app_path = base_url+'ajax/';
		chat_count();
		$("#chat-text").removeClass("hide");
		var user = $("#chat-text").attr("data-current-user");
		if(isNaN(total)){total=0;}
		total = typeof(total) !== 'undefined' ? total : 0;

		$.getJSON(app_path+ 'Chat_ajax/get_msgs',{'user':user,'total':total},function(msgs){

			$('.member-photo').html(msgs.chat_user_img);
			$(".chat-member").html(msgs.chat_user);
			$('.chat-status').html('<img src="'+base_url+'assets/images/chat/online_status_'+msgs.online_status+'.png" >');
			$(".ichat").html('');
			var align = photo = '';

			$.each(msgs.result,function(i,item){
				var append_elem='';
				total = total+1;
				if(item.m_from == msgs.me){ 
					align = 'reversed';
				}else{ 
					align = '';
				}
				var image_file = 'no_profile_pic.jpg';
				if(item.f_photo.length >0){
					image_file = item.f_photo;
				}else if(item.f_gender.length >0){
					image_file =item.f_gender+'.jpg';
				}
				append_elem = '<div class="message ' + align + '">';
				//append_elem += '<img src="'+base_url+'assets/images/photos/'+image_file+'" alt="" style="margin:10px">';
				append_elem += '<div class="message-body">'+ item.msg ;
				append_elem += '<span class="attribution">';
				if(item.m_from == msgs.me){ 
					append_elem += '<img src="'+base_url+'assets/images/chat/seen_status_'+item.seen_status+'.png" class="seen-status" title="'+ item.seen_on+' "> ';
				}
				append_elem += item.sent_on+'</span></div></div>';
				$(".ichat").append(append_elem);
			});
			if(msgs.result.length != total){
				$(".chat").scrollTop($(".chat")[0].scrollHeight);
			}
			setTimeout(load_chat(total),10000);
			//load_chat(msgs.result.length);
			
			$('.chat-user-img').click(function(e) {
				var image_file = $(this).attr('id');
			}); 	
		});
	}
	
	/*-------------------------------------------------------------------------------------------------------*/

	//SAVE CHAT MESSAGES
	$(document).keypress(function(e) {
		
		var base_url = $('body').data('baseurl');
		var app_path = base_url+'ajax/';
		
		if(e.which == 13) {
			$("#chat-text").attr('disabled','diabled');
			$("#msg-status").html("Sending...").css('display','block');
			var chat_text = $("#chat-text").val();
			var m_to = $("#chat-text").attr("data-current-user");
			if(chat_text.trim() != ''){
				$.post(app_path+'Chat_ajax/send_message',{'m_to':m_to,'msg':chat_text},function(resonse){
					if(resonse == 'true'){
						$("#msg-status").html("Send !");
						load_chat(0);
						$("#chat-text").val('');
						$("#chat-text").attr('disabled',false).focus();
						$(".chat").scrollTop($(".chat").prop("scrollHeight"));
						$("#msg-status").fadeOut('slow');
					}else{
						$("#msg-status").html("Sorry ! You can't send message to this user. ");
						$("#chat-text").val('').focus();						
					}
				});
			}else{
				$.Jgrowl('No message entered!');
			}
		}
	});

	/*---------------------------------------------------------------------*/

	function fun_clear_chat(to_user){
		
		var base_url = $('body').data('baseurl');
		var app_path = base_url+'ajax/';
		$("#msg-status").html("Clearing history....Please wait.").css('display','block');
		$.post(app_path+'Chat_ajax/clear_history',{'m_to':to_user},function(resonse){
			if(resonse == 'true'){
				load_chat(0);
				$("#msg-status").html("History cleared !");
			}else{
				$("#msg-status").html("Something went wrong try again. ");
											
			}
		});
		$("#msg-status").fadeOut(3500);
		$("#chat-text").val('').focus();
	}
	
