/**
 * AJAX long-polling
 *
 * 1. sends a request to the server (without a timestamp parameter)
 * 2. waits for an answer from server.php (which can take forever)
 * 3. if server.php responds (whenever), put data_from_file into #response
 * 4. and call the function again
 *
 * @param timestamp
 */
function getTarget(currentCount)
{
    var queryString = {'cc' : currentCount};

    $.ajax(
        {
            type: 'GET',
            url: window.location.origin + '/dms/ajax/Notify/notify_my_targets',
            data: queryString,
            success: function(data){
                // put result data into "obj"
                var obj = jQuery.parseJSON(data);

                //show count
                $('.notify-count').html(obj.count);
                //alert(obj.count);
                //list
                $.each(obj.targets, function(index, element) {
                    $(".target-li-holder").append('<li><i class="icon-target text-danger"></i><div><a href="'+window.location.origin+'/dms/employees/my_targets">'+ element.qty  +' ' + element.symbol + '  of '+ element.item_name +' before ' + element.valid_to + '</div></li>');
                });

                getTarget(obj.count);
                //$('.notify-count').html(data);getTarget(data);
            }
        }
    );
}

// initialize jQuery
$(document).ready(function(){
    getTarget();
});
