$(document).ready(function(e) {

	var base_url = $('body').data('baseurl');
	$('input').attr('autocomplete','off');
	var screenWidth = $(window).width();
	if(screenWidth >950 && screenWidth <1100){
		$('body').addClass('sidebar-narrow');
	}
	var app_path = base_url+'ajax/';

	/*----------------------------------------------------------*/

	$('.customer_type').change(function(e) {

		var cust_type = $(this).val();

		if(cust_type  != "" && !isNaN(cust_type)){
			$(".customers").html('<option value="">Select</option>');
			$.getJSON(app_path+'stock_ajax/get_customers',{'cust_type':cust_type},function(data){

				$.each(data[0],function(key,value){
					$('.customers').append('<option value="'+key+'">'+value+'</value>');
				});
			});

		}else{
			$(".customers").html('<option value="">Select</option>');
		}
    });

	/*----------------------------------------------------------*/

	$('.item_name').change(function(e) {
		var item_ID = $(this).val();
		if(item_ID != "")
		{
			$(".godown").html('');
			$(".unit").html('');
			$.getJSON(app_path+'stock_ajax/get_item_godowns',{'item_id':item_ID},function(data){
				$(".godown").append('<option value="">Select</option>');
				$.each(data,function(key,value){
					$(".godown").append('<option value="' + key + '">'+ value +'</option>');
				});
			});
			$.getJSON(app_path+'stock_ajax/get_item_units',{'item_id':item_ID},function(data){
				//alert(JSON.stringify(data[0]));
				$.each(data[0],function(key,value){
					var sel = '';
					if(key == data[1]){
						var sel = 'selected';
						$('#primary-unit').html(' / '+value);
					}
					$(".unit").append('<option value="' + key + '" '+sel+'>'+ value +'</option>');
				});
			});
			$.ajax({url:app_path+'stock_ajax/get_item_rate/'+item_ID,
				success: function(data){
					$('.rate').val(data);
					if(data == null || data == ''){data=0;}
					$('.rate-per').html(data);
				}
			});
		}
		else
		{
			$(".godown").html('<option value="">Select</option>');
			$(".unit").html('<option value="">Select</option>');
		}
		$('.rate').val('');
		$('.qnty').val('');
		$('.amount').val('');
		$('#stock-balance').html('');
    });

	/*----------------------------------------------------------*/

	$('.amount-ajax').keyup(function(e) {
		var qty = parseFloat($('.qnty').val());
		var rate = parseFloat($('.rate').val());
		if(qty == "" || isNaN(qty)){
			qty = 0;
		}
		if(rate == "" || isNaN(rate)){
			rate = 0;
		}
		var vat_percent = 0;
		if($(".vat-percent").length){
			vat_percent = parseFloat($(".vat-percent").val());
		}
		var cst = 0;
		if($(".cst").length){
			cst = parseFloat($(".cst").val());
			if(isNaN(cst) || cst == null){
				cst = 0;
			}
		}

		$.ajax({url:base_url+'ajax/stock_ajax/get_rounded_amt/rate/'+rate+'/qty/'+qty+'/vat/'+vat_percent,dataType:'json',
			success: function(data){
				$(".amount").val(data.round);
				if($(".vat-percent").length && cst == 0){
					$(".vat_amt").val(data.vat);
				}
			}
		});
	});

	/*----------------------------------------------------------*/

	$('.unit').change(function(e) {
       $('.rate').val('');
    });

	/*-----------------------------------------------------------*/

	$('.freight-amt').keyup(function(e) {
		var freight_amt = parseFloat($(this).val());
		var other_expense = parseFloat($('.other-expense').val());
		var gnd_total = parseFloat($('#gnTotalAmt').val());
		if(isNaN(freight_amt) || freight_amt == null || freight_amt < 0){freight_amt=0;}
		if(isNaN(other_expense) || other_expense == null || other_expense < 0){other_expense=0;}
		if(freight_amt > gnd_total){freight_amt = gnd_total;$(this).val(freight_amt);}
		gnd_total+=(freight_amt+other_expense);
		gnd_total=gnd_total.toFixed(2);
		$.getJSON(app_path+'stock_ajax/get_rounded/',{'amount':gnd_total},function(data){
			$('#grandTotalAmount').html(data[0]);
			$('#grand_total').val(data[0]);
			$('#roundOff').html(data[1]);
			$('#round_value').val(data[1]);
		});
		//$('#grandTotalAmount').html(gnd_total);
		//$('#grand_total').val(gnd_total);
	});

	/*----------------------------------------------------------*/

	$('.other-expense').keyup(function(e) {
		var other_expense = parseFloat($(this).val());
		var freight_amt = parseFloat($('.freight-amt').val());
		var gnd_total = parseFloat($('#gnTotalAmt').val());
		if(isNaN(freight_amt) || freight_amt == null || freight_amt < 0){freight_amt=0;}
		if(isNaN(other_expense) || other_expense == null || other_expense < 0){other_expense=0;}
		if(other_expense > gnd_total){other_expense = gnd_total;$(this).val(other_expense);}
		gnd_total+=(freight_amt+other_expense);
		gnd_total=gnd_total.toFixed(2);
		$.getJSON(app_path+'stock_ajax/get_rounded/',{'amount':gnd_total},function(data){
			$('#grandTotalAmount').html(data[0]);
			$('#grand_total').val(data[0]);
			$('#roundOff').html(data[1]);
			$('#round_value').val(data[1]);
		});
		//$('#grandTotalAmount').html(gnd_total);
		//$('#grand_total').val(gnd_total);
	});

	/*----------------------------------------------------------*/

	$('.godown').change(function(e) {
		var godown_id = $(this).val();
		var item_id = $(".item_name").val();
		var bill_date = $(".bill-date").val();
		if(item_id != "" && godown_id != "" && bill_date != "")
		{
			var url = app_path+'stock_ajax/get_stock_bal/'+godown_id+'/'+item_id+'/'+bill_date;
			ajax_function(url,'stock-balance');
		}
    });

	/*-----------------------------------------------------------*/

	$(".voucher-type").change(function(){
		var id = $(this).val();
		$.getJSON(base_url+'ajax/sales_return_ajax/get_next_bill',{'vtype':id},function(data){
			if(data.vstatus == 1){
				$("#sdate-ajax").prop('readonly',true);
				$("#sbill-ajax").prop('readonly',true);
			}
			else{
				$("#sdate-ajax").prop('readonly',false);
				$("#sbill-ajax").prop('readonly',false);
			}
			$("#sdate-ajax").val(data.bill_date);
			$("#sbill-ajax").val(data.bill_no);
		});
	});

	/*-----------------------------------------------------------*/

	$(".return-bill").change(function(){
		var id = $(this).val();
		$.getJSON(app_path+'sales_return_ajax/get_customer_types',{'bill_no':id},function(data){
			$(".customer_type").html('');
			$(".customers").html('');
			$(".customers").append('<option value="">Select</option>');
			if(id == ""){
				$(".customer_type").append('<option value="">Select</option>');
			}
			$.each(data[0],function(key,value){
				$(".customer_type").append('<option value="' + key + '">'+ value +'</option>');
			});
			if(id != "")
			{
				$(".customers").html('');
				$.each(data[1],function(key,value){
					$(".customers").append('<option value="' + key + '">'+ value +'</option>');
				});
			}
		});
		$.getJSON(app_path+'sales_return_ajax/get_items',{'bill_no':id},function(data){
			$(".item_name").html('');
			$(".item_name").append('<option value="">Select</option>');
			$.each(data,function(key,value){
				$(".item_name").append('<option value="' + key + '">'+ value +'</option>');
			});
		});
		$(".godown").html('<option value="">Select</option>');
		$(".unit").html('<option value="">Select</option>');
		$('#stock-balance').html('');
	});

	/*-----------------------------------------------------------*/

	$(".payment-mode").change(function(){
		var id = parseInt($(this).val());
		if(id > 2)
		{
			$('.cd-ajax').removeClass('hide');
			$('.cd-ajax').css('display','block');
		}
		else
		{
			$('.cd-ajax').addClass('hide');
			$('.cd-ajax').css('display','none');
		}
	});

	/*-----------------------------------------------------------*/

    $('.amount').keyup(function(e) {
		var amount = parseFloat($(this).val());
		var qty = parseFloat($(".qnty").val());
		var vat_percent = 0;
		if($(".vat-percent").length){
			vat_percent = parseFloat($(".vat-percent").val());
		}
		var cst = 0;
		if($(".cst").length){
			cst = parseFloat($(".cst").val());
			if(isNaN(cst) || cst == null){
				cst = 0;
			}
		}
		$.ajax({url:base_url+'ajax/stock_ajax/get_rounded_rate/amount/'+amount+'/qty/'+qty+'/vat/'+vat_percent,dataType:'json',
			success: function(data){
				$(".rate").val(data.round);
				if($(".vat-percent").length && cst == 0){
					$(".vat_amt").val(data.vat);
				}
			}
		});
	});

	/*-----------------------------------------------------------*/

	$(".cst").keyup(function(e){
		var cst = parseFloat($(this).val());
		if(cst != 0 && !isNaN(cst))
		{
			if(cst > 100){$('.cst').val(100);}
			$(".cst").prop('readonly',false);
			$(".vat_amt").prop('readonly',true);
			$(".vat_amt").val('');
		}
		else
		{
			if($(".vat-percent").length)
			{
				$(".cst").prop('readonly',true);
				$(".vat_amt").prop('readonly',false);
				var amount = parseFloat($(".amount").val());
				var qty = parseFloat($(".qnty").val());
				var vat_percent = parseFloat($(".vat-percent").val());
				var discount = parseFloat($(".discount_amt").val());
				$.ajax({url:base_url+'ajax/stock_ajax/get_rounded_rate/amount/'+amount+'/qty/'+qty+'/vat/'+vat_percent+'/discount/'+discount,dataType:'json',
					success: function(data){
						$(".vat_amt").val(data.vat);
					}
				});
			}
		}
	});

	/*-----------------------------------------------------------*/

    $(".vat_amt").keyup(function(e){
		var vat = parseFloat($(this).val());
		if(vat != 0 && !isNaN(vat))
		{
			$(".cst").prop('readonly',true);
			$(".vat_amt").prop('readonly',false);
		}
		else
		{
			$(".cst").prop('readonly',false);
			$(".vat_amt").prop('readonly',true);
		}
	});
});