$(document).ready(function(e) {

	$('input').attr('autocomplete','off');
	var screenWidth = $(window).width();
	if(screenWidth >950 && screenWidth <1100)
	{
		$('body').addClass('sidebar-narrow');
	}
	var base_url = $('body').data('baseurl');
	var app_path = base_url+'ajax/';

	/*----------------------------------------------------------*/
	
	$(document).on("keydown", ":input:not(textarea)", function(event) {
        if (event.key == "Enter") 
        {
            event.preventDefault();
        }
    });
	
	

	$('.customer_type').change(function(e) {

		var cust_type = $(this).val();
		if(cust_type  != "" && !isNaN(cust_type))
		{
			$(".customers").html('<option value="">Select</option>');
			var OrigUrl = $('#origin-url').val();

			if(cust_type != 2)
			{
				$('#cust-link').prop('href','javascript:void();');
			}
			else
			{
				$('#cust-link').prop('href',OrigUrl);
			}
			$.getJSON(app_path+'Stock_ajax/get_customers',{'cust_type':cust_type},function(data){

    			$.each(data[0],function(key,value){
    			    $('.customers').append('<option value="'+key+'">'+value+'</value>');
    			});
    
    			/*$.each(data[1],function(key1,value1){
    				$('.user_type').append('<option value="'+key1+'">'+value1+'</value>');
    			});*/
            });

		}
		else
		{
			$(".customers").html('<option value="">Select</option>');
			//$('.user_type').html('<option value="">Select</option>');
		}
		//$(".users").html('<option value="">Select</option>');
    });
    
    $(".mob").keyup(function(e){ 
		var mobile = $(this).val(); 
		$.getJSON(app_path+'Stock_ajax/get_customer',{'mob':mobile},function(data){
			$('.customer-name').val(data[0]);
			$('.addr').val(data[1]);
			$('.mail').val(data[2]);
		});  
	});

	/*----------------------------------------------------------*/

	$('.item_name').change(function(e) {
		var item_ID = $(this).val();
		var bill_date = $(".bill-date").val();
		var minus_stock = $("#minus-stock").val();
		
		$('.amount').val('');
		$(".godown").html('');
		$(".unit").html('');
		$('.rate').val('');
        $('.hsn').val('');
		$('.qnty').val('');
		$('.pricelists').val('');
		$('#stock-balance').html('');
        $('#discount_per').val('');
        $('.discount_amt').val('');
        
		if(item_ID != "")
		{
			$.getJSON(app_path+'Stock_ajax/get_item_godowns',{'item_id':item_ID},function(data){
    		    
    			var url = app_path+'Stock_ajax/get_stock_bal/'+item_ID+'/'+bill_date;
    			ajax_function(url,'stock-balance');
    			
    			$.ajax({url:app_path+'Stock_ajax/get_stock_bal/'+item_ID+'/'+bill_date,
    				success: function(data){
    				    if(minus_stock=='0')
    				    {
        					if(data=='Out of Stock')
        					{
        					    $("#sbmt").hide();
        					}
        					else
        					{
        					    $("#sbmt").show();
        					}
    				    }	
    				}
    			});
    		    
    			$.each(data[0],function(key,value){
    				$(".godown").append('<option value="' + key + '">'+ value +'</option>');
    			});
			});
			
			$.getJSON(app_path+'Stock_ajax/get_item_units',{'item_id':item_ID},function(data){
				$.each(data[0],function(key,value){
					var sel = '';
					if(key == data[1]){
						var sel = 'selected';
						$('#primary-unit').html(' / '+value);
					}
					$(".unit").append('<option value="' + key + '" '+sel+'>'+ value +'</option>');
				});
			});
			$.ajax({url:app_path+'Stock_ajax/get_item_rate/'+item_ID,
				success: function(data){
					$('.rate').val(data);
					if(data == null || data == ''){data=0;}
					$('.rate-per').html(data);
				}
			});
            $.ajax({url:app_path+'Stock_ajax/get_item_hsn/'+item_ID,
				success: function(data){
                    $('.hsn').val(data);
				}
			});
		}else{
			$(".godown").html('<option value="">Select</option>');
			$(".unit").html('<option value="">Select</option>');
		}
    });
    
    $(".item_group").change(function(){
		var id = $(this).val();
		var a = 0;
		if(id == 1){
		    a = 'lens';
		}else if(id == 2){
		    a = 'frame';
		}else if(id == 4){
		    a = 'contact';
		}else if(id == 5){
		    a = 'sunglass';
		}else if(id == 6){
		    a = 'reading';
		}else if(id == 7){
		    a = 'solution';
		}else if(id == 9){
		    a = 'accessories';
		}else if(id == 11){
		    a = 'oframe';
		}else if(id == 12){
		    a = 'olens';
		}
		
		$.getJSON(app_path+'Json_ajax/get_item_prefix',{'type':a},function(data){ 
			$(".item-code1").val(data.code);
		});
	});

	/*----------------------------------------------------------*/

/*	$('.user_type').change(function(e) {
		var userTypeID = $(this).val();
		$.getJSON(app_path+'Stock_ajax/get_users',{'user_type':userTypeID},function(data){
			$(".users").html('');
			$(".users").append('<option value="">Select</option>');
			$.each(data,function(key,value){
				$(".users").append('<option value="' + key + '">'+ value +'</option>');
			});
		});

    });*/

	/*----------------------------------------------------------*/

	$('.pricelists').change(function(e) {
		var priceListID = $(this).val();
		if(!isNaN(priceListID) && priceListID != ""){
			$('.qnty').val('');
			$('#discount_per').val('');
			$('.amount').val('');
			$('.discount_amt').val('');
		}
    });
	/*----------------------------------------------------------*/

	$('.unit').change(function(e) {
        $('.rate').val('');
        $('.amount').val('');
        $('#discount_per').val('');
        $('.discount_amt').val('');
    });

    /*---------------------------------------------------------*/
	$('.qty-rate').on('keyup',function(e) {

        $('#discount_per').val('');
        $('.discount_amt').val('');
        $('.amount').val('');
		var rate = parseFloat($('.rate').val());
		var qnty = parseFloat($('.qnty').val());
		if(isNaN(rate) || rate == null){rate=0;}
		if(isNaN(qnty) || qnty == null){qnty=0;}

		var vat_percent = 0;
		if($(".vat-percent").length){
			vat_percent = parseFloat($(".vat-percent").val());
		}
		
		var cess_percent = 0;
		if($(".cess-percent").length){
			cess_percent = parseFloat($(".cess-percent").val());
		}
		
	//	$.getJSON(app_path+'Stock_ajax/get_qty_rate_amt',{'rate':rate,'qnty':qnty,'vat':vat_percent,'cess':cess_percent},function(data){
	    $.getJSON(app_path+'Stock_ajax/get_tax_amt',{'rate':rate,'qnty':qnty,'gst':vat_percent,'cess':cess_percent},function(data){
			$('.amount').val(data[0]);
			if($(".vat-percent").length)
			{
				$(".vat_amt").val(data[1]);
			}
			if($(".cess-percent").length)
			{
				$(".cess_amt").val(data[2]);
			}
		});
    });

	/*---------------------------------------------------------*/
	$('.discount_per').on('change keyup',function(e) {

        var disc_per = parseFloat($('#discount_per').val());
		var amount = parseFloat($('.amount').val());

		if(isNaN(disc_per) || disc_per == null){disc_per =0;}
		if(isNaN(amount) || amount == null){amount=0;}

		if(disc_per >100){disc_per=100;$('#discount_per').val(disc_per);}

		var vat_percent = 0;
		if($(".vat-percent").length){
			vat_percent = parseFloat($(".vat-percent").val());
		}
		var cst = 0;
		if($(".cst").length){
			cst = parseFloat($(".cst").val());
			if(isNaN(cst) || cst == null){
				cst = 0;
			}
		}
		$.getJSON(app_path+'Stock_ajax/get_so_dis_amt',{'disc_per':disc_per,'amount':amount,'vat':vat_percent},function(data){
			$('.discount_amt').val(data[0]);
			if($(".vat-percent").length && cst == 0){
				$(".vat_amt").val(data[1]);
			}
		});
    });

	/*----------------------------------------------------------*/

	$('.discount_amt').keyup(function(e) {

		var amount = parseFloat($('.amount').val());
		var disc_amt = parseFloat($('.discount_amt').val());

		if(isNaN(amount) || amount == null){amount=0;}
		if(isNaN(disc_amt) || disc_amt == null){disc_amt=0;}
		if(amount < disc_amt){disc_amt=amount;$('.discount_amt').val(amount);}

		var vat_percent = 0;
		if($(".vat-percent").length){
			vat_percent = parseFloat($(".vat-percent").val());
		}
		var cst = 0;
		if($(".cst").length){
			cst = parseFloat($(".cst").val());
			if(isNaN(cst) || cst == null){
				cst = 0;
			}
		}

		$.getJSON(app_path+'Stock_ajax/get_so_dis_per',{'disc_amt':disc_amt,'amount':amount,'vat':vat_percent},function(data){
			$('#discount_per').val(data[0]);
			if($(".vat-percent").length && cst == 0){
				$(".vat_amt").val(data[1]);
			}
		});

    });

	/*----------------------------------------------------------*/

	$('.bill_discount_per').keyup(function(e) {

		var disc_per = parseFloat($(this).val());
		var gnd_total = parseFloat($('#gnTotalAmt').val());
		if(disc_per > 100){disc_per=100;$('.bill_discount_per').val(disc_per);}
		$.getJSON(app_path+'Stock_ajax/get_so_bill_dis_amt/',{'disc_per':disc_per,'total':gnd_total},function(data){
			$('.bill_discount_amt').val(data[0]);
			$('#grandTotalAmount').html(data[1]);
			$('#roundOff').html(data[2]);
			$('#round_value').val(data[2]);
		});

    });

	/*-----------------------------------------------------------*/

	$('.bill_discount_amt').keyup(function(e) { 

		var disc_amt = parseFloat($(this).val());
		var gnd_total = parseFloat($('#gnTotalAmt').val());
		if(isNaN(disc_amt) || disc_amt == null){disc_amt=0;}
		if(disc_amt > gnd_total){disc_amt = gnd_total;$(this).val(disc_amt)}
		$.getJSON(app_path+'Stock_ajax/get_so_bill_dis_per/',{'disc_amt':disc_amt,'total':gnd_total},function(data){
			$('.bill_discount_per').val(data[0]);
			$('#grandTotalAmount').html(data[1]);
			$('#roundOff').html(data[2]);
			$('#round_value').val(data[2]);
		});

    });

	/*-----------------------------------------------------------*/

	$('.freight-amt').keyup(function(e) {

		var freight_amt = parseFloat($(this).val());
		var other_expense = parseFloat($('.other-expense').val());
		var gnd_total = parseFloat($('#gnTotalAmt').val());
		var bill_discount = parseFloat($('.bill_discount_amount').val());
        var paid_amt =  parseFloat($('.bill_advance').val());
               
		if(isNaN(freight_amt) || freight_amt == null || freight_amt < 0){freight_amt=0;}
		if(isNaN(other_expense) || other_expense == null || other_expense < 0){other_expense=0;}
		if(isNaN(bill_discount) || bill_discount == null || bill_discount < 0){bill_discount=0;}
        if(isNaN(paid_amt) || paid_amt == null || paid_amt < 0){paid_amt=0;}
		gnd_total-=bill_discount;
		if(freight_amt > gnd_total){freight_amt = gnd_total;$(this).val(freight_amt);}
		gnd_total+=(freight_amt+other_expense);
		gnd_total=gnd_total.toFixed(2);
        var bal = gnd_total - paid_amt;
		$.getJSON(app_path+'Stock_ajax/get_rounded/',{'amount':gnd_total},function(data){
		    $('#grandTotalAmount').html(data[0]);
			$('#roundOff').html(data[1]);
			$('#round_value').val(data[1]);                         
		});
        
        $.getJSON(app_path+'Stock_ajax/get_rounded/',{'amount':bal},function(data){
		    $('.bill_balance').val(data[0]);			                                             
		});
		//$('#grandTotalAmount').html(gnd_total);

	});

	/*----------------------------------------------------------*/

	$('.other-expense').keyup(function(e) {
		var other_expense = parseFloat($(this).val());
		var freight_amt = parseFloat($('.freight-amt').val());
		var gnd_total = parseFloat($('#gnTotalAmt').val());
		var bill_discount = parseFloat($('.bill_discount_amount').val());
                var paid_amt =  parseFloat($('.bill_advance').val());

		if(isNaN(freight_amt) || freight_amt == null || freight_amt < 0){freight_amt=0;}
		if(isNaN(other_expense) || other_expense == null || other_expense < 0){other_expense=0;}
		if(isNaN(bill_discount) || bill_discount == null || bill_discount < 0){bill_discount=0;}
                if(isNaN(paid_amt) || paid_amt == null || paid_amt < 0){paid_amt=0;}
		gnd_total-=bill_discount;
		if(other_expense > gnd_total){other_expense = gnd_total;$(this).val(other_expense);}
		gnd_total+=(freight_amt+other_expense);
		gnd_total=gnd_total.toFixed(2);
                var bal = gnd_total - paid_amt;

		$.getJSON(app_path+'Stock_ajax/get_rounded/',{'amount':gnd_total},function(data){
			$('#grandTotalAmount').html(data[0]);
			$('#roundOff').html(data[1]);
			$('#round_value').val(data[1]);
		});
            
                 $('.bill_balance').val(bal);
		//$('#grandTotalAmount').html(gnd_total);
	});

	/*----------------------------------------------------------*/

	$('.bill_discount_percent').keyup(function(e) {
		var disc_per = parseFloat($(this).val());
		var gnd_total = parseFloat($('#gnTotalAmt').val());
		var freight_amt = parseFloat($('.freight-amt').val());
		var other_expense = parseFloat($('.other-expense').val());
                var paid_amt =  parseFloat($('.bill_advance').val());

		if(isNaN(disc_per) || disc_per == null || disc_per < 0){disc_per=0;}
		if(isNaN(freight_amt) || freight_amt == null || freight_amt < 0){freight_amt=0;}
		if(isNaN(other_expense) || other_expense == null || other_expense < 0){other_expense=0;}
                if(isNaN(paid_amt) || paid_amt == null || paid_amt < 0){paid_amt=0;}
		gnd_total+=(freight_amt+other_expense);

		if(disc_per > 100){
			disc_per=100;$('.bill_discount_percent').val(disc_per);
		}
		var discount_amount = parseFloat((gnd_total*disc_per)/100);
		discount_amount = discount_amount.toFixed(2);
		gnd_total-=discount_amount;
		gnd_total = gnd_total.toFixed(2);
                 var bal = gnd_total - paid_amt;
		$('.bill_discount_amount').val(discount_amount);
		$.getJSON(app_path+'Stock_ajax/get_rounded/',{'amount':gnd_total},function(data){
			$('#grandTotalAmount').html(data[0]);
			$('#roundOff').html(data[1]);
			$('#round_value').val(data[1]);
		});

                 $('.bill_balance').val(bal);
		//$('#grandTotalAmount').html(gnd_total);
    });

	/*-----------------------------------------------------------*/

	$('.bill_discount_amount').keyup(function(e) {

		var disc_amt = parseFloat($(this).val());
		var gnd_total = parseFloat($('#gnTotalAmt').val());
		var freight_amt = parseFloat($('.freight-amt').val());
		var other_expense = parseFloat($('.other-expense').val());
                var paid_amt =  parseFloat($('.bill_advance').val());

		if(isNaN(disc_amt) || disc_amt == null || disc_amt < 0){disc_amt=0;}
		if(isNaN(freight_amt) || freight_amt == null || freight_amt < 0){freight_amt=0;}
		if(isNaN(other_expense) || other_expense == null || other_expense < 0){other_expense=0;}
                if(isNaN(paid_amt) || paid_amt == null || paid_amt < 0){paid_amt=0;}
		gnd_total+=(freight_amt+other_expense);
		if(disc_amt > gnd_total){disc_amt = gnd_total;$(this).val(disc_amt)}
		var discount_per = parseFloat((disc_amt*100)/gnd_total);
		discount_per = discount_per.toFixed(2);
		gnd_total-=disc_amt;
		gnd_total = gnd_total.toFixed(2);
                var bal = gnd_total - paid_amt;
		$('.bill_discount_percent').val(discount_per);
		$.getJSON(app_path+'Stock_ajax/get_rounded/',{'amount':gnd_total},function(data){
			$('#grandTotalAmount').html(data[0]);
			$('#roundOff').html(data[1]);
			$('#round_value').val(data[1]);
		});
                $('.bill_balance').val(bal);
		//$('#grandTotalAmount').html(gnd_total);
    });
    
    $('.bill_discount_percent_old').keyup(function(e) {
		var disc_per = parseFloat($(this).val());
		var gnd = parseFloat($('#gnTotalAmt').val());
		var freight_amt = parseFloat($('.freight-amt').val());
		var other_expense = parseFloat($('.other-expense').val());
        var paid_amt =  parseFloat($('.bill_advance').val());
        var old_per = parseFloat($('#old_per').val());
        
        var gnd_total = (gnd*100)/(100-old_per);

		if(isNaN(disc_per) || disc_per == null || disc_per < 0){disc_per=0;}
		if(isNaN(freight_amt) || freight_amt == null || freight_amt < 0){freight_amt=0;}
		if(isNaN(other_expense) || other_expense == null || other_expense < 0){other_expense=0;}
        if(isNaN(paid_amt) || paid_amt == null || paid_amt < 0){paid_amt=0;}
		gnd_total+=(freight_amt+other_expense);

		if(disc_per > 100){
			disc_per=100;$('.bill_discount_percent').val(disc_per);
		}
		var discount_amount = parseFloat((gnd_total*disc_per)/100);
		discount_amount = discount_amount.toFixed(2);
		gnd_total-=discount_amount;
		gnd_total = gnd_total.toFixed(2);
                 var bal = gnd_total - paid_amt;
		$('.bill_discount_amount_old').val(discount_amount);
		$.getJSON(app_path+'Stock_ajax/get_rounded/',{'amount':gnd_total},function(data){
			$('#grandTotalAmount').html(data[0]);
			$('#roundOff').html(data[1]);
			$('#round_value').val(data[1]);
		});

                 $('.bill_balance').val(bal);
		//$('#grandTotalAmount').html(gnd_total);
    });
    
    
    $('.bill_discount_amount_old').keyup(function(e) {

		var disc_amt = parseFloat($(this).val());
		var gnd = parseFloat($('#gnTotalAmt').val());
		var freight_amt = parseFloat($('.freight-amt').val());
		var other_expense = parseFloat($('.other-expense').val());
        var paid_amt =  parseFloat($('.bill_advance').val());
        var old_per = parseFloat($('#old_per').val());
        
        var gnd_total = (gnd*100)/(100-old_per);

		if(isNaN(disc_amt) || disc_amt == null || disc_amt < 0){disc_amt=0;}
		if(isNaN(freight_amt) || freight_amt == null || freight_amt < 0){freight_amt=0;}
		if(isNaN(other_expense) || other_expense == null || other_expense < 0){other_expense=0;}
        if(isNaN(paid_amt) || paid_amt == null || paid_amt < 0){paid_amt=0;}
		gnd_total+=(freight_amt+other_expense);
		if(disc_amt > gnd_total){disc_amt = gnd_total;$(this).val(disc_amt)}
		var discount_per = parseFloat((disc_amt*100)/gnd_total);
		discount_per = discount_per.toFixed(2);
		gnd_total-=disc_amt;
		gnd_total = gnd_total.toFixed(2);

		$('.bill_discount_percent_old').val(discount_per);
		$.getJSON(app_path+'Stock_ajax/get_rounded/',{'amount':gnd_total},function(data){
			$('#grandTotalAmount').html(data[0]);
			$('#roundOff').html(data[1]);
			$('#round_value').val(data[1]);
		});
    });
    

	/*----------------------------------------------------------*/

	$('.godown').change(function(e) {
		var godown_id = $(this).val();
		var item_id = $(".item_name").val();
		var bill_date = $(".bill-date").val();
		if(item_id != "" && godown_id != "" && bill_date != ""){
			var url = app_path+'Stock_ajax/get_stock_bal/'+godown_id+'/'+item_id+'/'+bill_date;
			ajax_function(url,'stock-balance');
		}
		$.getJSON(app_path+'Stock_ajax/get_so_bill_dis_per/',{'disc_amt':disc_amt,'total':gnd_total},function(data){
			$('.bill_discount_per').val(data[0]);
			$('#grandTotalAmount').html(data[1]);
		});
    }); 

    $('.customer').change(function(e) {
        var custID = $(this).val();
		if(item_id != "")
		{
			var url = app_path+'Stock_ajax/get_tpoint/'+custID;
			ajax_function(url,'rate');
		}
    });

	/*-----------------------------------------------------------*/

	$(".voucher-type").change(function(){
		var id = $(this).val();
		$.getJSON(base_url+'ajax/Sales_ajax/get_next_bill',{'vtype':id},function(data){
			if(data.vstatus == 1){
				$("#sdate-ajax").prop('readonly',true);
				$("#sbill-ajax").prop('readonly',true);
			}else{
				$("#sdate-ajax").prop('readonly',false);
				$("#sbill-ajax").prop('readonly',false);
			}
			$("#sdate-ajax").val(data.bill_date);
			$("#sbill-ajax").val(data.bill_no);
			$('#bill-prefix').html(data.bill_prefix);
		});
		
	/*	$.getJSON(base_url+'ajax/sales_ajax/get_offer_items',{'vtype':id},function(data){
		
		}*/
	});

	/*-----------------------------------------------------------*/

	$(".voucher-types").change(function(){
		var id = $(this).val();
		$.ajax({url:base_url+'ajax/Sales_ajax/get_next_bill_no/'+id,
			success: function(data){
				$('#sbill-ajax').val(data);
			}
		});
	});

	/*-----------------------------------------------------------*/

	$(".d-voucher-type").change(function(){
		var id = $(this).val();
		$.getJSON(base_url+'ajax/Sales_ajax/get_delivery_next_bill',{'vtype':id},function(data){
			if(data.vstatus == 1){
				$("#sdate-ajax").prop('readonly',true);
				$("#sbill-ajax").prop('readonly',true);
			}else{
				$("#sdate-ajax").prop('readonly',false);
				$("#sbill-ajax").prop('readonly',false);
			}
			$("#sdate-ajax").val(data.bill_date);
			$("#sbill-ajax").val(data.bill_no);
			$('#bill-prefix').html(data.bill_prefix);
		});
	});

	/*-----------------------------------------------------------*/

	$(".payment-mode").change(function(){
		var id = parseInt($(this).val());
		if(id > 2){
			$('.cd-ajax').removeClass('hide');
			$('.cd-ajax').css('display','block');
		}else{
			$('.cd-ajax').addClass('hide');
			$('.cd-ajax').css('display','none');
		}
	});

	/*-----------------------------------------------------------*/

    $('.amount').keyup(function(e) {
		var amount = parseFloat($(this).val());
		var qty = parseFloat($(".qnty").val());
		$("#discount_per").val('');
		$(".discount_amt").val('');
		var vat_percent = 0;
		if($(".vat-percent").length){
			vat_percent = parseFloat($(".vat-percent").val());
		}
		var cst = 0;
		if($(".cst").length){
			cst = parseFloat($(".cst").val());
			if(isNaN(cst) || cst == null){
				cst = 0;
			}
		}
		$.ajax({url:base_url+'ajax/Stock_ajax/get_rounded_rate/amount/'+amount+'/qty/'+qty+'/vat/'+vat_percent,dataType:'json',
			success: function(data){
				$(".rate").val(data.round);
				if($(".vat-percent").length && cst == 0){
					$(".vat_amt").val(data.vat);
				}
			}
		});
	});

	/*-----------------------------------------------------------*/

	$(".cst").keyup(function(e){
		var cst = parseFloat($(this).val());
		if(cst != 0 && !isNaN(cst))
		{
			if(cst > 100){$('.cst').val(100);}
			$(".cst").prop('readonly',false);
			$(".vat_amt").prop('readonly',true);
			$(".vat_amt").val('');
		}
		else
		{
			if($(".vat-percent").length)
			{
				$(".cst").prop('readonly',true);
				$(".vat_amt").prop('readonly',false);
				var amount = parseFloat($(".amount").val());
				var qty = parseFloat($(".qnty").val());
				var vat_percent = parseFloat($(".vat-percent").val());
				var discount = parseFloat($(".discount_amt").val());
				$.ajax({url:base_url+'ajax/Stock_ajax/get_rounded_rate/amount/'+amount+'/qty/'+qty+'/vat/'+vat_percent+'/discount/'+discount,dataType:'json',
					success: function(data){
						$(".vat_amt").val(data.vat);
					}
				});
			}
		}
	});

	/*-----------------------------------------------------------*/

    $(".vat_amt").keyup(function(e){
		var vat = parseFloat($(this).val());
		if(vat != 0 && !isNaN(vat))
		{
			$(".cst").prop('readonly',true);
			$(".vat_amt").prop('readonly',false);
		}
		else
		{
			$(".cst").prop('readonly',false);
			$(".vat_amt").prop('readonly',true);
		}
	});
         
    

    $('.simple-unit1').change(function(e) {
		var unit_ID = $(this).val();		
		$(".unit").html('');
		
		if(unit_ID != "")
		{																
			$.getJSON(app_path+'Stock_ajax/get_unit_name',{'unit_id':unit_ID},function(data){
				$.each(data[0],function(key,value){
					var sel = '';
					if(key == data[1]){
						var sel = 'selected';
						$('#primary-unit').html(' / '+value);
					}
					$(".unit").append('<option value="' + key + '" '+sel+'>'+ value +'</option>');
				});
			});			                       
		}
		else
		{			
			$(".unit").html('<option value="">Select</option>');
		}
    });
    
    $('.bill_advance').keyup(function(e) {

        var advance = parseFloat($(this).val());
		var freight_amt = parseFloat($('.freight-amt').val());
		var other_expense = parseFloat($('.other-expense').val());
		var gnd_total = parseFloat($('#gnTotalAmt').val());
		var bill_discount = parseFloat($('.bill_discount_amount').val());
        var paid_amt =  parseFloat($('.bill_advance').val());
               
		if(isNaN(freight_amt) || freight_amt == null || freight_amt < 0){freight_amt=0;}
		if(isNaN(other_expense) || other_expense == null || other_expense < 0){other_expense=0;}
		if(isNaN(bill_discount) || bill_discount == null || bill_discount < 0){bill_discount=0;}
        if(isNaN(paid_amt) || paid_amt == null || paid_amt < 0){paid_amt=0;}
		gnd_total-=bill_discount;
		if(freight_amt > gnd_total){freight_amt = gnd_total;$(this).val(freight_amt);}
		gnd_total+=(freight_amt+other_expense);
		//gnd_total=gnd_total.toFixed(2);
		
		if(advance > gnd_total)
		{
		    advance = gnd_total;
		    $('.bill_advance').val(advance);
		}
	});
	
	$('#rset').on('click',function(){
            var rdv1 = $("#rdv1").val();         
            var rdv2 = $("#rdv2").val();
            var rdv3 = $("#rdv3").val();
            var rdv4 = $("#rdv4").val();
            var rnv1 = $("#rnv1").val();         
            var rnv2 = $("#rnv2").val();
            var rnv3 = $("#rnv3").val();
            var rnv4 = $("#rnv4").val();
            var radd = $("#radd").val();                     
            $.getJSON(app_path+'Stock_ajax/get_match_items',{'dv1':rdv1,'dv2':rdv2,'dv3':rdv3,'dv4':rdv4,'nv1':rnv1,'nv2':rnv2,'nv3':rnv3,'nv4':rnv4,'radd':radd},function(data){
			$(".item_name").html('');
			  var sel = '';
			$(".item_name").append('<option value="">Select</option>');
			$.each(data,function(key,value){
			    var sel = 'selected';
				$(".item_name").append('<option value="' + key + '" '+ sel + ' >'+ value +'</option>');
			   
			});
	    }); 

     });
     $('#lset').on('click',function(){                  
            var ldv1 = $("#ldv1").val();
            var ldv2 = $("#ldv2").val();
            var ldv3 = $("#ldv3").val();
            var ldv4 = $("#ldv4").val();
            var lnv1 = $("#lnv1").val();         
            var lnv2 = $("#lnv2").val();
            var lnv3 = $("#lnv3").val();
            var lnv4 = $("#lnv4").val();
            var ladd = $("#ladd").val();
            $.getJSON(app_path+'Stock_ajax/get_match_items',{'dv1':ldv1,'dv2':ldv2,'dv3':ldv3,'dv4':ldv4,'nv1':lnv1,'nv2':lnv2,'nv3':lnv3,'nv4':lnv4,'radd':ladd},function(data){
			$(".item_name").html('');
			$(".item_name").append('<option value="">Select</option>');
				var sel = '';
			$.each(data,function(key,value){
			      var sel = 'selected';
				$(".item_name").append('<option value="' + key + '" '+ sel +'>'+ value +'</option>');
			});
	    }); 
     });

});