<?php if( ! defined('BASEPATH')) exit('No direct script access allowed');

class Account_groups extends MY_Controller
{
	public function __construct()
	{
		parent :: __construct();
		$this->check_access_right();
		
		#---------------- Checking Financial year is enabled / closed-----------------#
		$method_array = array('index','update','delete');
		fiscal_status($this->uri->segment(2),$method_array,"account_groups/report");	
		#---------------- Checking Financial year is enabled / closed-----------------#
		
		$this->load->model('accounts/Account_groups_model','agroup');
		$this->template->title('Account Groups');
		$this->template->main_heading($this->lang->line('account-groups-settings'));
	}
	
	public function index()
	{	
		$this->form_validation->set_rules('primary_group_id','lang:primary-group','required|xss_clean');
		$this->form_validation->set_rules('sub_group','lang:sub-group','required|xss_clean|max_length[64]|is_unique[account_sub_groups.sub_group]');
		if($this->form_validation->run() === true)
		{
			$data = $this->input->post(NULL,true);
			if($this->agroup->insert($data))
			{
				$this->message->set($this->lang->line('account-group-add-success'));				
			}
			else
			{		
				$this->message->set($this->lang->line('account-group-add-error'),'e');
			}
			redirect('account_groups/index');
		}

		#-----------account primary groups		
		$account_groups = $this->agroup->get_primary_groups(array('select' => 1));

		#-----------account sub groups	
		$accounts_array = $this->agroup->get_sub_group();

		#-----------template
		$this->template->breadcrumb(array($this->lang->line('settings') => 'preferences/index',$this->lang->line('accounts') => 'accounts/index',$this->lang->line('account-groups') => 'no_link',$this->lang->line('report') => 'account_groups/report'));
		$this->template->slice('dms/message');	
		$this->template->slice('preferences/account_groups/add',array('account_groups' => $account_groups));				
		$this->template->slice('preferences/account_groups/report',array('accounts_array' => $accounts_array));
		$this->template->render();		
	}
	
	public function update()
	{
		$id = $this->uri->segment(3,0);
		$agroup_data = $this->agroup->get_data($id);		
		if($agroup_data)
		{
			if($agroup_data['company_id'] != 0)
			{
				#----------validation
				$this->form_validation->set_rules('primary_group_id','lang:primary-group','required|xss_clean');
				$this->form_validation->set_rules('sub_group','lang:sub-group',"required|xss_clean|max_length[64]|is_edit_unique[account_sub_groups.sub_group.$id]");
				if($this->form_validation->run() == true)
				{
					$data = $this->input->post(NULL,true);
					if($this->agroup->update(array('data' => array('primary_group_id' => $data['primary_group_id'],'sub_group' => $data['sub_group']),'conditions' => array('id' => $data['as_id'])))){
						$this->message->set($this->lang->line('account-group-edit-success'));
					}
					else{
						$this->message->set($this->lang->line('account-group-edit-error'),'e');
					}
					redirect('account_groups/report');
				}			
				$account_groups = $this->agroup->get_primary_groups(array('select' => 1));

				$this->template->breadcrumb(array($this->lang->line('settings') => 'preferences/index',$this->lang->line('accounts') => 'accounts/index',$this->lang->line('account-groups') => 'account_groups/index',$this->lang->line('update') => 'no_link',$this->lang->line('report') => 'account_groups/report'));
						
				$this->template->slice('dms/message');
				$this->template->slice('preferences/account_groups/edit',array('account_groups' => $account_groups,'agroup_data' => $agroup_data));
				$this->template->render();
			}
			else
			{
				$this->message->set($this->lang->line('def-data-not-changed'),'e');
				redirect('account_groups/report');
			}
		}
		else
		{
			redirect('account_groups/report');
		}
	}
	
	public function report()
	{
		$this->template->breadcrumb(array($this->lang->line('settings') => 'preferences/index',$this->lang->line('accounts') => 'accounts/index',$this->lang->line('account-groups') => 'account_groups/index',$this->lang->line('report') => 'no_link'));
		$this->template->slice('dms/message');		
		$accounts_array = $this->agroup->get_sub_group();
		$this->template->slice('preferences/account_groups/report',array('accounts_array' => $accounts_array));
		$this->template->slice('dms/modals/delete_confirm');
		$this->template->render();
	}
	
	public function delete()
	{
		$id = $this->uri->segment(3,0);		
		$agroup_data = $this->agroup->get_data($id);	
		if($agroup_data)
		{
			if($agroup_data['company_id'] != 0)
			{
				if(!$this->agroup->check_account_group($id)){			
					if($this->agroup->update(array('data' => array('status' => 0),'conditions' => array('id' => $id)))){
						$this->message->set($this->lang->line('account-group-delete-success'));
					}
					else{
						$this->message->set($this->lang->line('account-group-delete-error'),'e');
					}
				}
				else{
					$this->message->set($this->lang->line('account-group-ledger-delete-error'),'w');
				}
			}
			else
			{
				$this->message->set($this->lang->line('def-data-not-changed'),'e');
			}
		}
		redirect('account_groups/report');
	}
}