<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Account_reports extends MY_Controller{
	
	var $companyID;
	var $branchID;
	var $createdBY;
	var $fiscal_start_date;
	var $fiscal_end_date;
		
	#------------------------------------------------------------------------------
	
	public function __construct(){
		
		parent::__construct();
		$this->check_access_right();

		$this->companyID = $this->session->userdata('company_id');
		$this->branchID = $this->session->userdata('under_id');
		$this->createdBY = $this->session->userdata('id');
		$fiscals = $this->dms->get_fiscal_year();
		$this->fiscal_start_date = $fiscals['start_date'];
		$this->fiscal_end_date = $fiscals['end_date'];		
	}
	
	#------------------------------------------------------------------------------
	
	public function debtors(){
		
		#-----------debtors / customers  reports---
		$this->template->title($this->lang->line('account-reports'));
		$this->template->main_heading($this->lang->line('debtors-reports'));
		$this->template->breadcrumb(array($this->lang->line('debtors-reports') => 'no_link'));
		$this->load->model('accounts/Debtors_model','debtors');
		#$this->load->library('Stock');


		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('accounts/reports/debtor_reports');
		$this->template->render();

	}
	
	#------------------------------------------------------------------------------
	
	public function creditors(){
		
		$this->template->title($this->lang->line('account-reports'));
		$this->template->main_heading($this->lang->line('creditors'));
		$this->template->breadcrumb(array($this->lang->line('creditors') => 'no_link'));
		
		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('accounts/reports/creditor_reports');
		$this->template->render();
			
	}
		
	#------------------------------------------------------------------------------
}
?>	