<?php if( ! defined('BASEPATH')) exit('No direct script access allowed');

	class Areas extends MY_Controller{

		public function __construct(){

			parent ::__construct();
			$this->check_access_right();

			#---------------- Checking Financial year is enabled / closed-----------------#
			$method_array = array('add','update','delete');
			fiscal_status($this->uri->segment(2),$method_array,"areas/report");
			#---------------- Checking Financial year is enabled / closed-----------------

			$this->load->model('areas/Area_model','area');

		}

	 	#-----------------------------------------------------------------
		#purpose:add master areas in first
		public function add(){

			#set validation rate
			$this->form_validation->set_rules('area','lang:area-name','required|trim|xss_clean|callback_area_exists');
			$this->form_validation->set_rules('cordinate_x','lang:cordinate-1','trim|xss_clean');
			$this->form_validation->set_rules('cordinate_y','lang:cordinate-2','trim|xss_clean');
			if($this->form_validation->run() === TRUE){

				$data =$this->input->post(NULL,TRUE);
				$data['company_id'] = $this->session->userdata('company_id');
				$data['created_by'] = $this->session->userdata('id');
				if($this->db->insert('area_master',$data)){
					$this->message->set($this->lang->line('area-saved'),'s');
				}else{
					$this->massage->set($this->lang->line('area-not-saved'),'e');
				}
				redirect('areas/report');
			}

			#template
			$this->template->title($this->lang->line('area-settings'));
			$this->template->main_heading($this->lang->line('area-settings'));
			$this->template->breadcrumb(array($this->lang->line('settings')=>'preferences/index',$this->lang->line('manage-areas')=>'no_link',$this->lang->line('report')=>'areas/report'));
			$this->template->slice('preferences/areas/new');
			$this->template->render();

		}

	 	#-----------------------------------------------------------------

	 	#purpose:all areas report
	 	public function report(){

			#report with pagination
			$this->load->library('Pagination');
			$config['per_page'] = $this->per_page();
			$config['total_rows'] = $this->area->get_all(array('numrows'=>1,'conditions'=>array('status'=>1)));

			$config['base_url'] = base_url('areas/report');
			$config['uri_segment'] = 3;
			# Pagination Config Customizations
			$config['full_tag_open'] = '<ul class="pagination">';
			$config['full_tag_close'] = '</ul>';
			$config['first_link'] = 'First';
			$config['last_link'] = 'Last';
			$config['next_link'] = '&raquo;';
			$config['prev_link'] = '&laquo;';
			$config['cur_tag_open'] = '<li class="active"><a href="#">';
			$config['cur_tag_close'] = '</a></li>';
			$config['num_tag_open'] = '<li>';
			$config['num_tag_close'] = '</li>';
			$this->pagination->initialize($config);
			$links = $this->pagination->create_links();
			$offset = $this->uri->segment(3,0);

			$areas = $this->area->get_all(array('order_by'=>'created_on','order'=>'DESC','limit'=>$config['per_page'],'offset'=>$offset,'conditions'=>array('status'=>1)));
			if(empty($areas)){
				$this->message->set($this->lang->line('no-area-found'),'i');
			}
	 		#template
	 		$this->template->title($this->lang->line('area-settings'));
	 		$this->template->main_heading($this->lang->line('area-settings'));
	 		$this->template->breadcrumb(array($this->lang->line('settings')=>'preferences/index',$this->lang->line('manage-areas')=>'areas/add',$this->lang->line('report')=>'no_link'));
	 		$this->template->slice('dms/message');
	 		$this->template->slice('preferences/areas/report',array('links'=>$links,'offset'=>$offset,'areas'=>$areas));
	 		$this->template->render();

	 	}

		#-----------------------------------------------------------------

	 	#purpose:Update area details
	 	public function update(){

	 		if(!$this->uri->segment(3)){
				redirect('users/logout');
			}

			$area_id = $this->uri->segment(3);
			if($this->if_exists('area_master',array('id'=>$area_id,'status'=>1)) === false){
				redirect('areas/report');
			}

	 		#get details of corresponding area_id
	 		$areas = $this->db->select()->get_where('area_master',array('id'=>$area_id))->row_array();

	 		#set validation rate
			$this->form_validation->set_rules('area','lang:area-name',"required|trim|xss_clean|callback_area_exists[$area_id]");
			$this->form_validation->set_rules('cordinate_x','lang:cordinate-1','trim|xss_clean');
			$this->form_validation->set_rules('cordinate_y','lang:cordinate-2','trim|xss_clean');

			if($this->form_validation->run() === TRUE){

				$data =$this->input->post(NULL,TRUE);
				$data['created_by'] = $this->session->userdata('id');
				if($this->db->update('area_master',$data,array('id'=>$area_id))){

					$this->message->set($this->lang->line('area-update'),'s');
				}else{
					$this->massage->set($this->lang->line('area-not-update'),'e');
				}
				redirect('areas/report');
			}

	 		#template
	 		$this->template->title('Edit Area Details');
	 		$this->template->main_heading($this->lang->line('area-settings'));
	 		$this->template->breadcrumb(array($this->lang->line('settings')=>'preferences/index',$this->lang->line('manage-areas')=>'areas/add',$this->lang->line('update')=>'no_link',$this->lang->line('report')=>'areas/report'));
	 		$this->template->slice('preferences/areas/edit',array('areas'=>$areas));
	 		$this->template->render();
	 	}

		#-----------------------------------------------------------------

	 	#purpose:delete area details
	 	public function delete(){

	 		if(!$this->uri->segment(3)){
				redirect('users/logout');
			}

			$area_id = $this->uri->segment(3);
			if($this->if_exists('area_master',array('id'=>$area_id,'status'=>1)) === false){
				redirect('areas/report');
			}

			$total_branch = $this->db->select('id')->get_where('branch_master',array('area_id'=>$area_id,'status'=>1))->num_rows();
			$total_customers = $this->db->select('id')->get_where('customer_master',array('area_id'=>$area_id,'status'=>1))->num_rows();
			$total_retailers = $this->db->select('id')->get_where('retailer_master',array('area_id'=>$area_id,'status'=>1))->num_rows();
			$total_users = $this->db->select('id')->get_where('users',array('area_id'=>$area_id,'status'=>1))->num_rows();

			if(empty($total_branch) && empty($total_customers) && empty($total_retailers) && empty($total_users)){
				if($this->db->update('area_master',array('status'=>0),array('id'=>$area_id))){
					$this->message->set($this->lang->line('area-delete'),'s');
				}else{
					$this->message->set($this->lang->line('area-not-delete'),'e');
				}
			}else{
				$this->message->set($this->lang->line('can-not-delete-area'),'i');
			}
	 		redirect('areas/report');
	 	}

	 	#-----------------------------------------------------------------

	 	public function area_exists($str,$area_id = NULL)
	 	{
	 		if($this->area->check_area_exists($str,$area_id)){
	 			return false;
	 		}
	 		return true;
	 	}
	}
?>