<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

	class Bank  extends MY_Controller{

		public function __construct(){

			
			parent ::__construct();
			$this->check_access_right();
		}
	   #---------------------------------------------------
		public function reconciliation(){
			$this->load->model('vouchers/Voucher_model','voucher');
			$this->load->library('Stock');

			$filter_data = array('item_id'=>'','from_date'=>cdateFormat($this->dms->get_fiscal_year()['start_date']),'to_date'=>cdateFormat(date('Y-m-d')));

			if(isset($_POST['search']) || $this->uri->segment(3) !=''){

				$filter_data = $this->input->post(NULL,TRUE);
					
				if(isset($_POST['search'])){

					$filter_data = $this->input->post(NULL,TRUE);
				}
				else{
						
					$filter_data = $this->uri->uri_to_assoc(3);
			
				}
				$filter_data = array_filter($filter_data);
				$count = count($filter_data);

				if($count==0){
					$this->message->set($this->lang->line('use-one-search'),'e');
				}
				else{

					if(isset($_POST['search'])){

						$this->form_validation->set_rules('bank_id','lang:bank','trim|xss_clean|required');
						$this->form_validation->set_rules('from_date','lang:date','valid_date|required');
						$this->form_validation->set_rules('to_date','lang:date','valid_date|required');
						if(isset($filter_data['from_date']) && $filter_data['from_date'] != ''){
							$this->form_validation->set_rules('from_date','lang:date','valid_date|required');
						}

						if(isset($filter_data['to_date']) && $filter_data['to_date'] != ''){
							$this->form_validation->set_rules('to_date','lang:date','valid_date|required');
						}
						$filter_data['from_date'] = $this->input->post('from_date');
						$filter_data['to_date'] = $this->input->post('to_date');
									
					}

					if($this->form_validation->run() == TRUE || $this->uri->segment(3)){

						#v_condition->voucher conditions,
						$conditions = array();
						if(isset($filter_data['from_date']) && $filter_data['from_date']!=''){
							$from_date =date('Y-m-d',strtotime($filter_data['from_date']));
							$filter_data['from_date'] = $from_date;
						}

						if(isset($filter_data['to_date']) && $filter_data['to_date']!=''){
							$to_date =date('Y-m-d',strtotime($filter_data['to_date']));
							$filter_data['to_date'] = $to_date;
						}
						if(isset($filter_data['bank_id']) && $filter_data['bank_id'] != ''){
							$v_conditions['ls.id']  = $filter_data['bank_id'];
						}

						$this->load->model('bank/Bank_model','bank');
						$v_conditions['vs.reconciliation_status'] = 0;
						$vouchers = $this->bank->get_reconciliation_vouchers(array('conditions'=>$v_conditions),$from_date,$to_date);
						#for bank amount calculation status change 
						$v_conditions['vs.reconciliation_status'] = 1;
						$voucher_amts  = $this->bank->get_reconciliation_vouchers(array('conditions'=>$v_conditions),$from_date,$to_date);{
							 $total = 0;
							foreach ($voucher_amts as $key => $voucher) {
								 $total = $total+$voucher['vamount'];
							}
						}

						if(!empty($vouchers)){
							$this->template->append('bank/report',array('vouchers'=>$vouchers,'bank_id'=>$filter_data['bank_id'],'bank_amount'=>$total));
						}
						else{
							$this->message->set($this->lang->line('no-reconciliation'),'e');
						}
					}
				}
			}		

			$this->load->library('Stock');
			$banks = $this->stock->bank_list();
			$banks[''] = 'Select';
			ksort($banks);
			#template
			$this->template->title($this->lang->line('bank-reconciliation'));
			$this->template->main_heading($this->lang->line('bank-reconciliation'));
			$this->template->breadcrumb(array($this->lang->line('bank-reconciliation') =>'no_link'));
			$this->template->slice('dms/message');
			$this->template->slice('bank/select_search',array('banks'=>$banks,'data'=>$filter_data));
			$this->template->other_script('bank/reconciliation');
			$this->template->render(); 
		}
	   #---------------------------------------------------	
	}
?>