<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Book_to_sales extends MY_Controller{

	public function __construct()
	{
		parent::__construct();
		$this->check_access_right();
		$this->companyID = $this->session->userdata('company_id');
		$this->branchID = $this->session->userdata('under_id');
	
		$method_array = array('sales');
		fiscal_status($this->uri->segment(2),$method_array,"booking/report");
		
		$this->load->model('booking/Booking_model','delivery');
		$this->load->model('sales/Sales_model','sales');
		$this->load->model('vouchers/Voucher_model','vouchers');
		$this->load->library(array('Stock','Targets','Sales_lib'));

		$this->vtype = 6;
	}

	public function sales()
	{   
		if($this->uri->segment(4))
		{
			$delivery_id = $this->uri->segment(4);
            $delivery_array = $this->delivery->get_sales(array('columns' => array('a.id','a.vtype_id','a.branch_id','a.bill_date','a.group_id','a.customer_type_id','a.customer_id','doctor','a.user_id','a.area_id','a.bill_discount_per','a.bill_discount_amt','a.offer_discount','a.bill_freight','a.other_expense','a.cess','a.pricelist_id','a.narration','a.paid_amount','a.balance_amount','a.delivery_date','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.taxable_amt','b.discount_per','b.discount_amt','b.godown_id','b.vat','b.vat_amt','b.cess_amt'),'conditions' => array('a.id' => $delivery_id,'a.book_status' => 0,'b.item_status >' => 0,'b.status !=' => 0))); 
             
			if(!empty($delivery_array))
			{ 
			    $bvtype = $delivery_array[0]['vtype_id'];
			    $group_id = $delivery_array[0]['group_id'];
                $paid_amt = $delivery_array[0]['paid_amount'];
                $bal_amt  = $delivery_array[0]['balance_amount'];  
                $doctor =  $delivery_array[0]['doctor'];
                $del_date = $delivery_array[0]['delivery_date'];
                $offer_disc = $delivery_array[0]['offer_discount'];

				$redirection_uri = $this->sales_lib->ds_group_id_exists1($group_id);
				if($redirection_uri)
				{ 
					redirect($redirection_uri);
				}
				else
				{
					$bill_details = $delivery_array[0];

					$this->load->model('designations/Designation_master_model','desig');
					$this->load->model('customers/Customer_type_model','customer_type');
					
					$voucher_types = $this->vouchers->voucher_types($this->vtype);
					
					if($bvtype == '40')
					{
					    $this->vtype = 41;
					}
					
					$bill_prefix = $this->stock->get_voucher_prefix($this->vtype);
					$voucher_name = $this->vouchers->voucher_name($this->vtype);

					$result_array = $this->sales->next_bill_no($this->vtype);
            		$vtype_id = $result_array['vtype_id'];
            		$voucher_no = $result_array['bill_no'];

					$this->form_validation->set_rules('vtype_id','lang:voucher-types','required|xss_clean');
					$this->form_validation->set_rules('bill_no','lang:bill-no',"required|xss_clean|is_natural_no_zero|callback_bill_no_exists");
					$this->form_validation->set_rules('bill_date','lang:bill-date',"required|xss_clean|valid_date|check_date[$bill_details[bill_date].>=]");
					$this->form_validation->set_rules('payment_mode','lang:payment-mode','required|xss_clean');
					$this->form_validation->set_rules('amount1','lang:amount1','required|xss_clean');
					if($this->input->post('payment_mode',true) == 2)
					{
						$this->form_validation->set_rules('credit_period','lang:credit-period','required|xss_clean|is_natural');
					}
					elseif($this->input->post('bill_date',true) && $this->input->post('payment_mode',true) > 2)
					{
						$bill_date1 = date('Y-m-d',strtotime($this->input->post('bill_date',true)));
						$this->form_validation->set_rules('ccd','lang:cash-cheque-dd','required|xss_clean');
						$this->form_validation->set_rules('cd_no','lang:cd-no','required|xss_clean|max_length[64]');
						$this->form_validation->set_rules('cheque_date','lang:cheque-date',"required|xss_clean|is_date|check_date[$bill_date1.>=]");
					}
					$this->form_validation->set_rules('remarks','lang:remarks','xss_clean');
					$this->form_validation->set_rules('freight','lang:freight','xss_clean|greater_or_equal[0]|less_than[100000000]');
					$this->form_validation->set_rules('other_expense','lang:other-expense','xss_clean|greater_or_equal[0]|less_than[100000000]');
					$this->form_validation->set_rules('bill_discount_per','lang:discount %','xss_clean|greater_or_equal[0]|less_or_equal[100]');
					$this->form_validation->set_rules('bill_discount_amt','lang:discount','xss_clean|greater_or_equal[0]|less_than[100000000]');

					if($this->form_validation->run() === true)
					{
						$vtype_id = $this->input->post('vtype_id',true);
						$bill_no = $this->input->post('bill_no',true);
						$bill_date = date('Y-m-d',strtotime($this->input->post('bill_date',true)));
						$narration = $this->input->post('remarks',true);
						$bill_discount_amt = $this->input->post('bill_discount_amt',true);
						$freight = $this->input->post('freight',true);
						$balance = $this->input->post('bill_bal',true);
						$other_expense = $this->input->post('other_expense',true);
                        $grand_total = $this->input->post('gnTotalAmt',true);
                        
                        $vendor_id = $this->input->post('vendors',true);
                        $lens_quantity = $this->input->post('lens_quantity',true);
                        $lens_refno = $this->input->post('lens_refno',true);
                        
                        $payment_mode = 0; $amount1 = 0;
                        if(!empty($this->input->post('amount1')) && !empty($this->input->post('payment_mode')))
                        {
                            $payment_mode = $this->input->post('payment_mode');
                            $amount1 = $this->input->post('amount1');
                        }
                            
                        $payment_mode2 = 0; $amount2 = 0;        
                        if(!empty($this->input->post('payment_mode2')) && !empty($this->input->post('amount2')))
                        {
                            $payment_mode2 = $this->input->post('payment_mode2');
                            $amount2 = $this->input->post('amount2');
                        }
                        
                        $payment = $amount1+$amount2;
                        
                        $bl = $balance-$payment;
						$sales_array = array('vtype_id' => $vtype_id,'branch_id' => $bill_details['branch_id'],'bill_no' => $bill_no,'bill_date' => $bill_date,'group_id' => $bill_details['group_id'],'sid' => $bill_details['id'],'s_status' => 3,'s_type'=>'sale','user_id' =>$bill_details['user_id'] ,'customer_type_id' => $bill_details['customer_type_id'],'customer_id' => $bill_details['customer_id'],'area_id' => $bill_details['area_id'],'bill_discount_per' => $this->input->post('bill_discount_per',true),'bill_discount_amt' => $bill_discount_amt,'offer_discount'=>$offer_disc,'bill_freight' => $freight,'other_expense' => $other_expense,'cess' => $bill_details['cess'],'balance'=>$bl,'narration' => $narration,'pricelist_id' => $bill_details['pricelist_id'],'payment_mode' => $payment_mode,'amount1' => $amount1,'payment_mode2' => $payment_mode2,'amount2' => $amount2,'cr_period' => $this->input->post('credit_period',true),'status' => 1);

						$this->db->trans_start();

						if($this->delivery->insert('dms_sales',$sales_array))
                        {
							$this->delivery->update_others(array('table' => 'dms_booking','data' => array('book_status' => 1),'conditions' => array('id' => $bill_details['id']))); 
                            $book_sales_array = $this->db->select(array('id','item_id','qty','unit_id','rate','amount','discount_per','discount_amt','godown_id','vat','vat_amt'))->from('dms_sales_items')->where('group_id',$group_id)->get()->result_array();
                            foreach($book_sales_array as $item_array)
                            {
                                $this->delivery->update_others(array('table' => 'dms_sales_items','data' => array('vendor_id' => $vendor_id,'lens_quantity' => $lens_quantity,'lens_refno' =>$lens_refno),'conditions' => array('group_id' => $group_id,'item_id' => $item_array['item_id']))); 
                                $this->delivery->insert('dms_stocks',array('company_id' => $this->session->userdata('company_id'),'branch_id'=>$this->session->userdata('under_id'),'godown_id' => $item_array['godown_id'],'item_id' => $item_array['item_id'],'qty' => $item_array['qty'],'unit_id' => $item_array['unit_id'],'rate' => $item_array['rate'],'amount' => $item_array['amount'],'stock_date' => $bill_date,'stock_status' => 6,'table_group_id' => $group_id,'table_id' => $item_array['id'],'status' => 1));
						    }  

                            $user_id = $bill_details['user_id'];
							$designation_id = $this->dms->get_desig($user_id);
							$customer = $this->dms->get_data(array('table' => 'customer_master','columns' => array('fname','mobile_no','ledger_id'),'conditions' => array('id' => $bill_details['customer_id'])));
							
							$bill_date_time = strtotime($bill_date);
							if($payment > 0)
                            {
                                $voucher_status1 = $voucher_status2 = 1;
                                $voucher_array = array('company_id' => $this->session->userdata('company_id'),'branch_id' => $this->session->userdata('under_id'),'vtype_id' => $vtype_id,'vno' => $bill_details['group_id'],'vorder_no' => 1,'vdate' => $bill_date,'cr_ledger' => 4,'table_name' => 'dms_sales','table_group_id' => $bill_details['group_id']);
    						    
                                if(!empty($payment_mode) && !empty($amount1) && $amount1 > 0)
                                {
                                    if($payment_mode > 2)
        							{
        								$cheque_date = date('Y-m-d',strtotime($this->input->post('cheque_date',true)));
        								$cheque_date_time = strtotime($cheque_date);
        								if($this->input->post('ccd',true) == 1 && $cheque_date_time > $bill_date_time)
        								{
        									$voucher_status1 = 3;
        								}
        							}
        							else if($payment_mode == 2)
                					{
                						$payment_mode = $customer[0]['ledger_id'];
                					}
            						
                					$voucher_group_id1 = $this->stock->get_group_id('dms_vouchers');
                						
                					$voucher_array['group_id'] = $voucher_group_id1;
                					$voucher_array['dr_ledger'] = $payment_mode;
                					$voucher_array['vamount'] = $amount1;
                					$voucher_array['status'] = $voucher_status1;
            						
            					    $voucher_success1 = $this->delivery->insert('dms_vouchers',$voucher_array);
    						
            						if($payment_mode > 2)
                                    {
                                        $this->delivery->insert('dms_voucher_banks',array('group_id' => $voucher_group_id1,'cash_type' => $this->input->post('ccd',true),'cd_no' => $this->input->post('cd_no',true),'pdc' => $cheque_date,'vdate' => $bill_date));
									}
                                }
                                
                                if(!empty($payment_mode2) && !empty($amount2) && $amount2 > 0)
                                {
                                    if($payment_mode2 > 2)
        							{
        								$cheque_date2 = date('Y-m-d',strtotime($this->input->post('cheque_date2',true)));
        								$cheque_date_time2 = strtotime($cheque_date2);
        								if($this->input->post('ccd2',true) == 1 && $cheque_date_time2 > $bill_date_time)
        								{
        									$voucher_status2 = 3;
        								}
        							}
        							else if($payment_mode2 == 2)
                					{
                						$payment_mode2 = $customer[0]['ledger_id'];
                					}
            					
                					$voucher_group_id2 = $this->stock->get_group_id('dms_vouchers');
                					$voucher_array['group_id'] = $voucher_group_id2;
                					$voucher_array['dr_ledger'] = $payment_mode2;
                					$voucher_array['vamount'] = $amount2;
                					$voucher_array['status'] = $voucher_status2;
            						
                					$voucher_success2 = $this->delivery->insert('dms_vouchers',$voucher_array);
    					
            						if($payment_mode2 > 2)
                                    {
                                        $this->delivery->insert('dms_voucher_banks',array('group_id' => $voucher_group_id2,'cash_type' => $this->input->post('ccd2',true),'cd_no' => $this->input->post('cd_no2',true),'pdc' => $cheque_date2,'vdate' => $bill_date));
									}
                                }
                            }
                            
                        /*    if($this->branchID == '24')
                            {*/
                                $this->load->model('sms/Sms_model','sms');
    							
    							$temp_id = 1707164620458880687;
    											
    							$message = "Dear ".$customer[0]['fname'].", Your vision is in good hands with the right partner. You can now enjoy lifetime service on your eyeglasses. Thank you, ALLEN & HABOUR";					
    											
    							$cust_mobile = $customer[0]['mobile_no'];
    							$msg_send_status = $this->sms->send($cust_mobile,$message,$temp_id);
    					//	}
							
						    $this->message->set($this->lang->line('sales-save-success'));
						}
						else
						{
							$this->message->set($this->lang->line('sales-save-error'),'e');
						} 

						$this->db->trans_complete();
                        redirect('sales/report');
					}

					$this->load->model('customers/Customer_type_model','customer_type');
					
					$voucher_type = $this->vtype; 

					$customer_name = $this->stock->get_customer($bill_details['customer_type_id'],$bill_details['customer_id']);
					$cust_qr = $this->dms->get_data(array('table' =>'customer_master','columns' => 'mobile_no','conditions' => array('id' => $bill_details['customer_id'])));
                    $cust_mob = $cust_qr[0]['mobile_no'];
					
					$area_id = $this->dms->get_area($bill_details['area_id']);
					$payment_modes = $this->stock->payment_modes();

					$cd_status = 1;
					if($this->input->post('payment_mode',true) > 2)
					{
						$cd_status = 0;
					}

            		$vendors = $this->stock->get_vendors();
            		$vendors[''] = 'Select';
            		ksort($vendors);
            		
					$this->template->title("New $voucher_name Voucher");
					$this->template->main_heading($this->lang->line("$voucher_name"));
					$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("$voucher_name") => 'no_link'));
					$this->template->slice('dms/message');
					$this->template->slice('booking/sales',array('sales_array' => $delivery_array,'presumptive_tax' => $presumptive_tax,'sales_cst' => $sales_cst,'voucher_name' => $voucher_name,'voucher_types' => $voucher_types,'voucher_type' => $voucher_type,'voucher_no' => $voucher_no,'customer_name' => $customer_name,'customer_mob'=>$cust_mob,'doctor'=>$doctor,'del_date'=>$del_date,'area_id' => $area_id,'payment_modes' => $payment_modes,'cd_status' => $cd_status,'bill_prefix'=>$bill_prefix,'paid_amt'=>$paid_amt,'balance_amt'=>$bal_amt,'vendors'=>$vendors));
					$this->template->other_script('sales/sales_order');
					$this->template->render();
				}
			}
		}
	}

	public function bill_no_exists($bill_no)
	{
		$this->load->model('sales/Sales_model','sales');
		$vtype_id = $this->input->post('vtype_id',true);
		$row = $this->sales->get_bills(array('columns' => array('id'),'conditions' => array('vtype_id' => $vtype_id,'bill_no' => $bill_no,'status !=' => 0),'numrows' => true));
		if($row == 0){
			return true;
		}
		return false;
	}
	
	public function update()
	{
	    $vtype_id = $this->vtype;
                
		$uri_array = $this->uri->uri_to_assoc(3);
		if(isset($uri_array['id']))
		{
		    $sales_id = $uri_array['id'];
			$redirect = "/".$this->uri->assoc_to_uri($uri_array);
			unset($uri_array['id']);

			$redirect_uri = "sales/report/".$this->uri->assoc_to_uri($uri_array);

			$update_uri = $this->uri->assoc_to_uri($this->uri->uri_to_assoc(1));

			$voucher_name = $this->vouchers->voucher_name($this->vtype);
			$presumptive_tax = $this->stock->get_tax_type();
			$cess = $this->stock->get_cess();

			$item_details = $this->sales->get_group($sales_id);
			
			if($item_details['s_status']=='3' && $item_details['sid']>0)
			{
			    $delivery_id = $item_details['sid']; 
                $delivery_array = $this->delivery->get_sales(array('columns' => array('a.id','a.branch_id','a.bill_date','a.group_id','a.customer_type_id','a.customer_id','doctor','a.user_id','a.area_id','a.bill_discount_per','a.bill_discount_amt','a.bill_freight','a.other_expense','a.cess','a.pricelist_id','a.narration','a.paid_amount','a.balance_amount','a.delivery_date','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.taxable_amt','b.discount_per','b.discount_amt','b.godown_id','b.vat','b.vat_amt','b.cess_amt'),'conditions' => array('a.id' => $delivery_id,'a.status' => 1,'b.item_status >' => 0,'b.status !=' => 0))); 
             
    			if(!empty($delivery_array))
    			{
    			    $group_id = $delivery_array[0]['group_id']; 
                    $paid_amt = $delivery_array[0]['paid_amount'];
                    $bal_amt  = $delivery_array[0]['balance_amount'];  
                    $doctor =  $delivery_array[0]['doctor'];
                    $del_date = $delivery_array[0]['delivery_date'];

                    $bill_details = $delivery_array[0];
    
    				$voucher_types = $this->vouchers->voucher_types($this->vtype);
    				$bill_prefix = $this->stock->get_voucher_prefix($this->vtype);
    					
    				$voucher_name = $this->vouchers->voucher_name($this->vtype);
    
    				$vtype_id = $item_details['vtype_id'];
                	$voucher_no = $item_details['bill_no'];
                	$voucher_date = $item_details['bill_date'];
    
    				$this->form_validation->set_rules('vtype_id','lang:voucher-types','required|xss_clean');
    				$this->form_validation->set_rules('bill_date','lang:bill-date',"required|xss_clean|valid_date|check_date[$bill_details[bill_date].>=]");
    				$this->form_validation->set_rules('payment_mode','lang:payment-mode','required|xss_clean');
    				if($this->input->post('payment_mode',true) == 2)
    				{
    					$this->form_validation->set_rules('credit_period','lang:credit-period','required|xss_clean|is_natural');
    				}
    				elseif($this->input->post('bill_date',true) && $this->input->post('payment_mode',true) > 2)
    				{
    					$bill_date1 = date('Y-m-d',strtotime($this->input->post('bill_date',true)));
    					$this->form_validation->set_rules('ccd','lang:cash-cheque-dd','required|xss_clean');
    					$this->form_validation->set_rules('cd_no','lang:cd-no','required|xss_clean|max_length[64]');
    					$this->form_validation->set_rules('cheque_date','lang:cheque-date',"required|xss_clean|is_date|check_date[$bill_date1.>=]");
    				}
    				
    				$this->form_validation->set_rules('remarks','lang:remarks','xss_clean');
    				$this->form_validation->set_rules('freight','lang:freight','xss_clean|greater_or_equal[0]|less_than[100000000]');
    				$this->form_validation->set_rules('other_expense','lang:other-expense','xss_clean|greater_or_equal[0]|less_than[100000000]');
    				$this->form_validation->set_rules('bill_discount_per','lang:discount %','xss_clean|greater_or_equal[0]|less_or_equal[100]');
    				$this->form_validation->set_rules('bill_discount_amt','lang:discount','xss_clean|greater_or_equal[0]|less_than[100000000]');
    
    				if($this->form_validation->run() === true)
    				{
    					$vtype_id = $this->input->post('vtype_id',true);
    					$bill_no = $this->input->post('bill_no',true);
    					$bill_date = date('Y-m-d',strtotime($this->input->post('bill_date',true)));
    					$payment_mode = $this->input->post('payment_mode',true);
    					$narration = $this->input->post('remarks',true);
    					$bill_discount_amt = $this->input->post('bill_discount_amt',true);
    					$freight = $this->input->post('freight',true);
    					$balance = $this->input->post('bill_bal',true);
    					$other_expense = $this->input->post('other_expense',true);
                        $grand_total = $this->input->post('gnTotalAmt',true);
                            
                        $vendor_id = $this->input->post('vendors',true);
                        $lens_quantity = $this->input->post('lens_quantity',true);
                        $lens_refno = $this->input->post('lens_refno',true);
                            
                        $bl = $bal_amt-$balance;
    					$sales_array = array('vtype_id' => $vtype_id,'bill_date' => $bill_date,'bill_discount_per' => $this->input->post('bill_discount_per',true),'bill_discount_amt' => $bill_discount_amt,'bill_freight' => $freight,'other_expense' => $other_expense,'cess' => $bill_details['cess'],'balance'=>$bl,'narration' => $narration,'payment_mode' => $payment_mode,'cr_period' => $this->input->post('credit_period',true));
    
    					$this->db->trans_start();
    
    					if($this->delivery->update_others(array('table' => 'dms_sales','data' =>$sales_array,'conditions'=>array('group_id' => $group_id))))
                        {
    						$book_sales_array = $this->db->select(array('id','item_id','qty','unit_id','rate','amount','discount_per','discount_amt','godown_id','vat','vat_amt'))->from('dms_sales_items')->where('group_id',$group_id)->get()->result_array();
                            foreach($book_sales_array as $item_array)
                            {
                                $this->delivery->update_others(array('table' => 'dms_sales_items','data' => array('vendor_id' => $vendor_id,'lens_quantity' => $lens_quantity,'lens_refno' =>$lens_refno),'conditions' => array('group_id' => $group_id,'item_id' => $item_array['item_id']))); 
                                $this->delivery->update_others(array('table' => 'dms_stocks','data' => array('stock_date' => $bill_date),'conditions' => array('stock_status' => 6,'table_group_id' => $group_id))); 
                            }  
                            
                            $this->delivery->update_others(array('table' => 'dms_vouchers','data' => array('status' => 0),'conditions' => array('table_name' => 'dms_sales','table_group_id' => $group_id))); 
                            
                            $voucher_status = 1;
    						$voucher_amount = $balance;
    						
    						$vat_amount = $this->input->post('vat_total',true);
    						$cess_amount = $this->input->post('cess_total',true);
    						if($payment_mode > 2)
    						{
    							$bill_date_time = strtotime($bill_date);
    							$cheque_date = date('Y-m-d',strtotime($this->input->post('cheque_date',true)));
    							$cheque_date_time = strtotime($cheque_date);
    							if($this->input->post('ccd',true) == 1 && $cheque_date_time > $bill_date_time)
    							{
    								$voucher_status = 3;
    							}
    						}
    						elseif($payment_mode == 2)
    						{
    							$payment_mode = $customer[0]['ledger_id'];//customer
    						}
                                                            
    						$voucher_group_id = $this->stock->get_group_id('dms_vouchers');
    							
    						$voucher_data = $this->dms->get_data(array('table' =>'dms_vouchers','columns' => 'id','conditions' => array('table_name' => 'dms_sales','table_group_id' => $bill_details['group_id'])));
    
    						if(empty($voucher_data))
    						{
                                $voucher_array = array('company_id' => $this->session->userdata('company_id'),'branch_id' => $this->session->userdata('under_id'),'group_id' => $voucher_group_id,'vtype_id' => $vtype_id,'vno' => $bill_details['group_id'],'vorder_no' => 1,'vdate' => $bill_date,'dr_ledger' => $payment_mode,'cr_ledger' => 4,'vamount' => $voucher_amount,'narration' => $narration,'table_name' => 'dms_sales','table_group_id' => $bill_details['group_id'],'status' => $voucher_status);
    							$voucher_success = $this->delivery->insert('dms_vouchers',$voucher_array);
    							if($voucher_success)
    							{
    								if($payment_mode > 2)
    								{
    									$this->delivery->insert('dms_voucher_banks',array('group_id' => $voucher_group_id,'cash_type' => $this->input->post('ccd',true),'cd_no' => $this->input->post('cd_no',true),'pdc' => $cheque_date,'vdate' => $bill_date));
    								}
    							}
    						}
                            else
                            {  
                                $voucher_array = array('vno' => $bill_details['group_id'],'vdate' => $bill_date,'dr_ledger' => $payment_mode,'vamount' => $voucher_amount,'narration' => $narration,'status' => $voucher_status);    
                                $this->delivery->update_others(array('table' => 'dms_vouchers','data' => $voucher_array,'conditions' => array('id' => $voucher_data[0]['id'])));
                            } 
    							
    						$this->message->set($this->lang->line('sales-update-success'));
    					}
    					else
    					{
    						$this->message->set($this->lang->line('sales-update-error'),'e');
    					} 
    
    					$this->db->trans_complete();
                        redirect('sales/report');
    				}
    
    				$this->load->model('customers/Customer_type_model','customer_type');
    					
    				$voucher_type = $this->vouchers->voucher_name($this->vtype); 
    
    				$customer_name = $this->stock->get_customer($bill_details['customer_type_id'],$bill_details['customer_id']);
    				$cust_qr = $this->dms->get_data(array('table' =>'customer_master','columns' => 'mobile_no','conditions' => array('id' => $bill_details['customer_id'])));
                    $cust_mob = $cust_qr[0]['mobile_no'];
    					
    				$area_id = $this->dms->get_area($bill_details['area_id']);
    
    				$payment_modes = $this->stock->payment_modes();
    
    				$cd_status = 1;
    				if($this->input->post('payment_mode',true) > 2)
    				{
    					$cd_status = 0;
    				}
    
                	$vendors = $this->stock->get_vendors();
                	$vendors[''] = 'Select';
                	ksort($vendors);
                		
    				$this->template->title("Edit $voucher_name Voucher");
    				$this->template->main_heading($this->lang->line("$voucher_name"));
    				$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("$voucher_name") => 'no_link'));
    				$this->template->slice('dms/message');
    				$this->template->slice('booking/sales_update',array('sales_array' => $delivery_array,'presumptive_tax' => $presumptive_tax,'sales_cst' => $sales_cst,'voucher_name' => $voucher_name,'voucher_types' => $voucher_types,'voucher_type' => $voucher_type,'voucher_no' => $voucher_no,'voucher_date' => $voucher_date,'customer_name' => $customer_name,'customer_mob'=>$cust_mob,'doctor'=>$doctor,'del_date'=>$del_date,'area_id' => $area_id,'payment_modes' => $payment_modes,'cd_status' => $cd_status,'bill_prefix'=>$bill_prefix,'paid_amt'=>$paid_amt,'balance_amt'=>$bal_amt,'vendors'=>$vendors));
    				$this->template->other_script('sales/sales_order');
    				$this->template->render();
    			}
    		}   
		}
	}    
}
?>