<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Booking1 extends MY_Controller{

	public function __construct()
	{
		parent::__construct();

		$this->check_access_right();
		$this->companyID = $this->session->userdata('company_id');
        $this->branchID = $this->session->userdata('under_id');
		#---------------- Checking Financial year is enabled / closed-----------------#
		$method_array = array('add','delete_temp','update_temp','update','delete','barcode');
		fiscal_status($this->uri->segment(2),$method_array,"booking/report");
		#---------------- Checking Financial year is enabled / closed-----------------#

		$this->load->model('booking/booking_model','sales_obj');
		$this->load->model('vouchers/voucher_model','vouchers');
        $this->load->model('products/item_model','item');
        $this->load->model('products/unit_model','unit');
        $this->load->model('branches/branch_model','brch');
		
		$this->branch_status = 0;
		if($this->dms->branch_type())
		{
			$this->branch_status = 1;
		}

		$this->vtype = 15;
	}

	public function add()
	{       
        $this->load->model('designations/designation_master_model','desig');
		$this->load->model('customers/customer_type_model','customer_type');
        $this->load->model('products/unit_model','unit');

		$vtype_id = $this->vtype;

		$voucher_types = $this->vouchers->voucher_types($this->vtype);
		$bill_prefix = $this->stock->get_voucher_prefix($this->vtype);
		
		$voucher_name = $this->vouchers->voucher_name($this->vtype);

		$cess = $this->stock->get_cess();
	
		$rules = "callback_bill_no_exists";
		$disabled = "";
		$result_array = $this->sales_obj->next_bill_no($this->vtype);
		$vtype_id = $result_array['vtype_id'];
		$voucher_no = $result_array['bill_no'];
		$voucher_date = $result_array['bill_date'];
		
		if($result_array['vstatus'])
		{
			if($result_array['s_status'] == 2)
			{
				redirect("order_to_sales/so_sales/".$result_array['sid']);
			}			
			elseif($result_array['s_status'] == 1)
			{
				redirect("request_to_sales/pr_sales/".$result_array['sid']);
			}

			$disabled = "readonly";
			$group_id = $result_array['group_id'];
			$rules = "callback_bill_no_exists[$vtype_id.$group_id]";

			$voucher_details = $this->dms->get_data(array('table' => 'dms_vouchers as a','join' => array('table' => 'dms_booking as b','on' => 'a.table_group_id = b.group_id'),'columns' => 'b.id','conditions' => array('a.table_name' => 'dms_booking','a.table_group_id' => $group_id)));
			if(!empty($voucher_details))
			{
				redirect("booking/update/id/".$voucher_details[0]['id']);
			}   						
		}
		else
        {
		 	$group_id = $this->stock->get_group_id('dms_sales_items1');
		}
    
    
        $branchs_id = $this->session->userdata('under_id');

        $previous_status = $this->brch->get_previous_status($branchs_id);
    
		if(isset($_POST['btn_add']))
		{
			$this->form_validation->set_rules('vtype_id','lang:voucher-types','required|xss_clean');
			$this->form_validation->set_rules('sales[bill_no]','lang:bill-no',"required|xss_clean|".$rules);
			$this->form_validation->set_rules('sales[bill_date]','lang:bill-date','required|xss_clean|valid_date');
			$this->form_validation->set_rules('sales[customer_id]','lang:customer-name','required|xss_clean');
            $this->form_validation->set_rules('sales[mobile]','lang:mobile','xss_clean');
            $this->form_validation->set_rules('sales[salesman]','lang:sales-man','required|xss_clean');
            if(isset($_POST['newp'])) 
            {
                $this->form_validation->set_rules('new_item[item_group_id]','lang:item-type','required|xss_clean');
                $this->form_validation->set_rules('new_item[item_code]','lang:item-code','required|xss_clean|is_unique[item_master.item_code]');
                $this->form_validation->set_rules('new_item[item_name]','lang:item-name','required|xss_clean');
                $this->form_validation->set_rules('new_item[unit_id]','lang:unit','required|xss_clean');
                $this->form_validation->set_rules('new_item[venor_id]','lang:item-type','required|xss_clean');
            }
            else
            {
			    $this->form_validation->set_rules('item_id','lang:item-name','required|xss_clean');
			    $this->form_validation->set_rules('unit_id','lang:unit','required|xss_clean');
            }
			$this->form_validation->set_rules('qty','lang:quantity','required|xss_clean|greater_than[0]|less_than[100000000]');
			$this->form_validation->set_rules('rate','lang:rate','required|xss_clean|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('amount','lang:amount','xss_clean|required|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('discount_per','lang:discount %','xss_clean|greater_than[0]|less_or_equal[100]');
			$this->form_validation->set_rules('discount_amt','lang:discount','xss_clean|greater_or_equal[0]|less_than[100000000]');

			if($this->form_validation->run('btn_add') === true)
			{ 
				$item_array['item_id'] = $this->input->post('item_id',true);
				$item_array['godown_id'] = $this->stock->get_branch_godown($this->branchID); //$this->input->post('godown_id',true);
				$item_array['hsn'] = $this->input->post('hsn',true);
				$item_array['qty'] = $this->input->post('qty',true);
				$item_array['unit_id'] = $this->input->post('unit_id',true);
				$item_array['rate'] = $this->input->post('rate',true);
                $item_array['amount'] = $this->input->post('amount',true);
                $item_array['discount_per'] = $this->input->post('discount_per',true);
                $item_array['discount_amt'] = $this->input->post('discount_amt',true);
                
                $sal_tem = $this->input->post('sales',true);
                $des_array = $this->input->post('des',true);
                $new_item = $this->input->post('new_item',true);
                
                if(isset($_POST['newp'])) 
                {                               
                    $new_stats = 1;
                    $new_item_details = array();
                    $new_item_details['company_id']=$this->companyID;
                    $new_item_details['item_group_id']=$new_item['item_group_id'];
                    $new_item_details['item_manufacturer_id'] = $new_item['venor_id'];
                    $new_item_details['lens_refno'] = $new_item['lense_refno'];
                    $new_item_details['item_code'] = $new_item['item_code'];
                	$new_item_details['item_name'] = $new_item['item_name'];
                	$new_it = $this->db->select(array('item_type'))->from('item_type_master')->where('id',$new_item['item_group_id'])->where('status',1)->get()->row_array();                                
                	$new_item_details['item_types'] = strtolower($new_it['item_type']);
                	$tp=$new_item_details['item_types'];
                	$cd=$new_item_details['item_code'];
                	if($tp=='contact' || $tp=='solution')
        			{
        			    $new_item_details['code_id'] = substr($cd,2);
        			}
        			else
        			{
        			    $new_item_details['code_id'] = substr($cd,1);
        			}
                	
                	$new_item_details['unit_id'] = $new_item['unit_id'];
                	$new_item_details['model_no'] = $new_item['model_no'];
                	$new_item_details['hsn'] = $new_item['hsn'];
                   	$new_item_details['stock_type'] = 1;
                	$new_item_details['status'] = 1;

                    $new_item_id = $this->sales_obj->insert("item_master",$new_item_details);
                    if($new_item_id)
                    {
                        $new_stock = array();
                        $new_stock['company_id'] = $this->companyID;
                        $new_stock['branch_id'] = $this->branchID;
                        $new_stock['godown_id'] = $this->stock->get_branch_godown($this->branchID);
                        $new_stock['item_id'] = $new_item_id;
                        if($new_item['lense_quantity']!='')
                        {
                          $new_stock['qty'] = $new_item['lense_quantity'];  
                        }
                        else
                        {
                          $new_stock['qty']=0;  
                        }
                        
                        $new_stock['unit_id'] = $new_item['unit_id'];
                    	$new_stock['rate'] = $item_array['rate'];
                    	$new_stock['stock_date'] = $this->fiscal_start_date;
                    	$new_stock['status'] = 1;
                        $this->sales_obj->insert("dms_stocks",$new_stock);
                        
                        $new_rate = array();
                        $new_rate['company_id'] = $this->companyID;
                        $new_rate['item_id'] = $new_item_id;
                        $new_rate['rate'] = $item_array['rate'];
                        $new_rate['valid_from'] = $sal_tem['bill_date'];
                        $new_rate['status'] = 1; 
                        $this->sales_obj->insert("dms_item_rates",$new_rate);
                        
                        $new_itmstk = array();
                        $new_itmstk['company_id'] =  $this->companyID;
                        $new_itmstk['branch_id'] =   $this->branchID;
                        $new_itmstk['item_id'] = $new_item_id;
                        $new_itmstk['godown_id'] = $this->stock->get_branch_godown($this->branchID);
                        if($new_item['lense_quantity']!='')
                        {
                          $new_itmstk['qty'] = $new_item['lense_quantity'];  
                        }
                        else
                        {
                           $new_itmstk['qty'] = 0; 
                        }
                     
                        $new_itmstk['unit_id'] = $new_item['unit_id'];
                        $this->sales_obj->insert("item_stock",$new_itmstk);
                    }
                    
                    $item_array['item_id'] = $new_item_id;
                    $item_array['godown_id'] = $this->stock->get_branch_godown($this->branchID);
                    $item_array['hsn']=$new_item['hsn'];
                }

				unset($item_array['sales']);
				unset($item_array['vtype_id']);
				unset($item_array['btn_add']);
                unset($item_array['des']);
                unset($item_array['gstin']);
                unset($item_array['new_item']);  
                unset($item_array['newp']);      

				$item_array['group_id'] = $group_id;
				$item_array['status'] = -1;
				$item_array['item_status'] = 2;//sales only items

				$item_array['rate'] = 0;
				if($item_array['qty'] != 0)
				{
					$item_array['rate'] = $item_array['amount'] / $item_array['qty'];
				}
                
                if($item_array['qty'] != 0)
                {                              
                    $qty = $item_array['qty'];
                    $bill_no = $sal_tem['bill_no'];                          
				}	 		
                
                $sales_temp_item_result = $this->sales_obj->get_sales(array('columns' => array('b.id'),'conditions' => array('b.group_id' => $group_id,'item_id' => $item_array['item_id'],'godown_id' => $item_array['godown_id'],'unit_id' => $item_array['unit_id'],'a.status !=' => 0,'b.status !=' => 0,'b.item_status >' => 0),'numrows' => true));

				if($sales_temp_item_result == 0)
				{				
					$cgst = $this->stock->get_item_cgst($item_array['item_id']);
					$sgst = $this->stock->get_item_sgst($item_array['item_id']);
                    $item_array['taxable_amt'] = (($item_array['amount']-$item_array['discount_amt'])*100)/(100+$cgst+$sgst+$cess);
                    
                    $item_array['cgst'] = $cgst;
					$item_array['sgst'] = $sgst;
					
					$item_array['cgst_amt'] = ($item_array['taxable_amt'] * $cgst) / 100;
					$item_array['sgst_amt'] = ($item_array['taxable_amt'] * $sgst) / 100;
					$item_array['cess_amt'] = ($item_array['taxable_amt'] * $cess) / 100;
                                        
					$sales_temp_array = $this->input->post('sales',true);
					$sales_temp_array['vtype_id'] = $this->input->post('vtype_id',true);
					$sales_temp_array = array_filter($sales_temp_array);

					$this->db->trans_start();

					if($result_array['vstatus'] == 0)//data not in dms_sales
					{					
						$vtype_id = $sales_temp_array['vtype_id'];
						$voucher_no = $sales_temp_array['bill_no'];
						$voucher_date = date('Y-m-d',strtotime($sales_temp_array['bill_date']));
						$customer_type = 2;
						$customer_name = $sales_temp_array['customer_id'];
                        $cust_mob = $sales_temp_array['mobile'];
                        $cust_addr = $sales_temp_array['address'];
                        $cust_mail = $sales_temp_array['email_id'];
                        $cust_dob = date('Y-m-d',strtotime($sales_temp_array['dob']));

                        if(empty($cust_addr)){ $cust_addr=" ";}
                        if(empty($cust_mail)){ $cust_mail=" ";}
                        if(empty($cust_dob)){ $cust_dob = " ";}

                        $doctor = $sales_temp_array['doctor']; if(empty($doctor)){ $doctor=" ";}
                        $user_idsal = $sales_temp_array['salesman'] ; if(empty($user_idsal)){ $user_idsal = " ";}

                        $customer_id = $this->sales_obj->save_customer(array('fname'=>$customer_name,'mobile_no'=>$cust_mob,'address'=>$cust_addr,'email_id'=>$cust_mail,'dob'=>$cust_dob,'status'=>1));
                        
						$data_sales_temp=array('vtype_id' =>$vtype_id,'branch_id' => $this->session->userdata('under_id'),'bill_no' => $voucher_no,'bill_date' => $voucher_date,'group_id' => $group_id,'customer_type_id' => $customer_type,'customer_id' => $customer_id,'doctor'=>$doctor,'user_id'=>$user_idsal,'cess'=>$cess,'status' =>-1);
						
						if(array_key_exists('pricelist_id',$sales_temp_array))
						{
							$data_sales_temp['pricelist_id'] = $sales_temp_array['pricelist_id'];
						}

						$sales_in_id=$this->sales_obj->insert("dms_booking",$data_sales_temp);
                        $ldv1=$des_array['ldv1']; $ldv2=$des_array['ldv2']; $ldv3=$des_array['ldv3']; $ldv4=$des_array['ldv4']; $lnv1=$des_array['lnv1']; $lnv2=$des_array['lnv2']; $lnv3=$des_array['lnv3']; $lnv4=$des_array['lnv4']; $ladd=$des_array['ladd']; $lipg=$des_array['lipg']; $rdv1=$des_array['rdv1']; $rdv2=$des_array['rdv2']; $rdv3=$des_array['rdv3']; $rdv4=$des_array['rdv4'];
                        $rnv1=$des_array['rnv1']; $rnv2=$des_array['rnv2']; $rnv3=$des_array['rnv3']; $rnv4=$des_array['rnv4']; $radd=$des_array['radd']; $ripg=$des_array['ripg'];

                        $this->db->query("insert into doctor_description(group_id,customer_id,ldv1,ldv2,ldv3,ldv4,lnv1,lnv2,lnv3,lnv4,ladd,lipg,rdv1,rdv2,rdv3,rdv4,rnv1,rnv2,rnv3,rnv4,radd,ripg) values('$group_id','$customer_id','$ldv1','$ldv2','$ldv3','$ldv4','$lnv1','$lnv2','$lnv3','$lnv4','$ladd','$lipg','$rdv1','$rdv2','$rdv3','$rdv4','$rnv1','$rnv2','$rnv3','$rnv4','$radd','$ripg')");
					}
					
					$ldv1=$des_array['ldv1']; $ldv2=$des_array['ldv2']; $ldv3=$des_array['ldv3']; $ldv4=$des_array['ldv4']; $lnv1=$des_array['lnv1']; $lnv2=$des_array['lnv2']; $lnv3=$des_array['lnv3']; $lnv4=$des_array['lnv4']; $ladd=$des_array['ladd']; $lipg=$des_array['lipg']; $rdv1=$des_array['rdv1']; $rdv2=$des_array['rdv2']; $rdv3=$des_array['rdv3']; $rdv4=$des_array['rdv4'];
                    $rnv1=$des_array['rnv1']; $rnv2=$des_array['rnv2']; $rnv3=$des_array['rnv3']; $rnv4=$des_array['rnv4']; $radd=$des_array['radd']; $ripg=$des_array['ripg'];

                    $this->db->query("UPDATE doctor_description SET ldv1='$ldv1',ldv2='$ldv2',ldv3='$ldv3',ldv4='$ldv4',lnv1='$lnv1',lnv2='$lnv2',lnv3='$lnv3',lnv4='$lnv4',ladd='$ladd',lipg='$lipg',rdv1='$rdv1',rdv2='$rdv2',rdv3='$rdv3',rdv4='$rdv4',rnv1='$rnv1',rnv2='$rnv2',rnv3='$rnv3',rnv4='$rnv4',radd='$radd',ripg='$ripg' WHERE group_id=$group_id and customer_id=$customer_id");
 
                    $sales_items_id = $this->sales_obj->insert("dms_sales_items1",$item_array);                                         					        

                    if($sales_items_id)
					{
						#--------------adding temporary stock balance in dms_stocks
					    /*	$stock_bal_temp = $this->stock->unit_conversion($item_array['item_id'],$item_array['unit_id'],$item_array['qty'],$item_array['rate'],$item_array['amount']);
						if($stock_bal_temp)
						{
							$this->sales_obj->insert('dms_stocks',array('company_id' => $this->session->userdata('company_id'),'branch_id'=>$this->session->userdata('under_id'),'godown_id' => $item_array['godown_id'],'item_id' => $item_array['item_id'],'qty' => $stock_bal_temp['qty'],'unit_id' => $stock_bal_temp['primary_unit'],'rate' => $stock_bal_temp['rate'],'amount' => $stock_bal_temp['amount'],'stock_date' => $voucher_date,'stock_status' => 6,'table_group_id' => $group_id,'table_id' => $sales_items_id,'status' => -1));
						}  */
						$this->message->set($this->lang->line('sales-add-success')); 
						echo '<script>window.location.href = "'.base_url('booking/add').'";</script>';
					}
					else
					{
						$this->message->set($this->lang->line('sales-add-error'),'e');
					}

					$this->db->trans_complete();
					echo '<script>window.location.href = "'.base_url('booking/add').'";</script>';
				}
				else
                {
					$this->message->set($this->lang->line('sales-add-error'),'e');
				}
				echo '<script>window.location.href = "'.base_url('booking/add').'";</script>';
			}
		}

		if(isset($_POST['btn_save']))
		{
			#-----------validation
			$this->form_validation->set_rules('area_id','lang:area','required|xss_clean');
            $this->form_validation->set_rules('bill_advance','lang:advance','required|xss_clean');
			$this->form_validation->set_rules('payment_mode','lang:payment-mode','required|xss_clean');
			$this->form_validation->set_rules('amount1','lang:amount','required|xss_clean');
			if($this->input->post('payment_mode',true) == 2)
            {
				$this->form_validation->set_rules('credit_period','lang:credit-period','required|xss_clean|is_natural');
			}
			elseif($this->input->post('payment_mode',true) > 2)
            {
				$this->form_validation->set_rules('ccd','lang:transaction-type','required|xss_clean');
				$this->form_validation->set_rules('cd_no','lang:cd-no','required|xss_clean|max_length[64]');
				$this->form_validation->set_rules('cheque_date','lang:cheque-date',"required|xss_clean|is_date");
			}
			$this->form_validation->set_rules('remarks','lang:remarks','xss_clean');
			$this->form_validation->set_rules('freight','lang:freight','xss_clean|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('other_expense','lang:other-expense','xss_clean|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('bill_discount_per','lang:discount %','xss_clean|greater_or_equal[0]|less_or_equal[100]');
			$this->form_validation->set_rules('bill_discount_amt','lang:discount','xss_clean|greater_or_equal[0]|less_than[100000000]');

			if($this->form_validation->run('btn_save') === true)
			{
				$narration = $this->input->post('remarks',true);
				$bill_discount_amt = $this->input->post('bill_discount_amt',true);
				$bill_discount_per = $this->input->post('bill_discount_per',true);
                $bill_advance = $this->input->post('bill_advance',true);
                $del_date = date('Y-m-d',strtotime($this->input->post('d_date',true)));
				$freight = $this->input->post('freight',true);
				$other_expense = $this->input->post('other_expense',true);
				$des_array = $this->input->post('des',true);
				
				$payment_mode = 0; $amount1 = 0;
                if(!empty($this->input->post('amount1')) && !empty($this->input->post('payment_mode')))
                {
                    $payment_mode = $this->input->post('payment_mode');
                    $amount1 = $this->input->post('amount1');
                }
                    
                $payment_mode2 = 0; $amount2 = 0;        
                if(!empty($this->input->post('payment_mode2')) && !empty($this->input->post('amount2')))
                {
                    $payment_mode2 = $this->input->post('payment_mode2');
                    $amount2 = $this->input->post('amount2');
                }
				
				$sales_entry_array = array('area_id' => $this->input->post('area_id',true),'bill_discount_per' => $bill_discount_per,'bill_discount_amt' => $bill_discount_amt,'bill_freight' => $freight,'other_expense' => $other_expense,'cess' => $cess,'narration' => $narration,'payment_mode' => $payment_mode,'amount1' => $amount1,'payment_mode2' => $payment_mode2,'amount2' => $amount2,'cr_period' => $this->input->post('credit_period',true),'delivery_date'=>$del_date,'status' => 1);

                $sales_entry_check = $this->sales_obj->get_sales(array('columns' => array('a.vtype_id','a.bill_no','a.bill_date','a.customer_type_id','a.customer_id'),'conditions' => array('a.group_id' => $group_id,'a.status !=' => 0,'b.item_status >' => 0)));

				if($sales_entry_check)
				{
					$bill_date = $sales_entry_check[0]['bill_date'];
					$vtype_id = $sales_entry_check[0]['vtype_id'];
					$bill_no = $sales_entry_check[0]['bill_no'];
                    $customer_id = $sales_entry_check[0]['customer_id'];                                    
                    $amount = $this->input->post('grand_total',true);
                    $vat = $this->input->post('vat_total',true);
                    $cesstotal = $this->input->post('cess_total',true);
                    
                    $tot_amount = $amount+$vat+$cesstotal;
                    $balance_amt = get_rounded($tot_amount+$freight+$other_expense-$bill_discount_amt-$bill_advance);
                    
                    $sales_entry_array['paid_amount']=$bill_advance;
                    $sales_entry_array['balance_amount']=$balance_amt;

                    if($bill_discount_amt)
                    {
                        if($bill_discount_amt != 0)
                        {
                            $sqlu1 = "update customer_total_point set point='0' where cid='$customer_id'";
                            $this->db->query($sqlu1);
                        }
                    }

                    $sql = "insert into customer_quantity (customer_id,bill_no,group_id,amount) values ('$customer_id','$bill_no','$group_id','$tot_amount')";
                    $this->db->query($sql);

					#----------start transaction
					$this->db->trans_start();
					if($this->sales_obj->update(array('table' => 'dms_booking','data' => $sales_entry_array,'conditions' => array('group_id' => $group_id))))
					{
					    $ldv1=$des_array['ldv1']; $ldv2=$des_array['ldv2']; $ldv3=$des_array['ldv3']; $ldv4=$des_array['ldv4']; $lnv1=$des_array['lnv1']; $lnv2=$des_array['lnv2']; $lnv3=$des_array['lnv3']; $lnv4=$des_array['lnv4']; $ladd=$des_array['ladd']; $lipg=$des_array['lipg']; $rdv1=$des_array['rdv1']; $rdv2=$des_array['rdv2']; $rdv3=$des_array['rdv3']; $rdv4=$des_array['rdv4'];
                        $rnv1=$des_array['rnv1']; $rnv2=$des_array['rnv2']; $rnv3=$des_array['rnv3']; $rnv4=$des_array['rnv4']; $radd=$des_array['radd']; $ripg=$des_array['ripg'];

                        $this->db->query("UPDATE doctor_description SET ldv1='$ldv1',ldv2='$ldv2',ldv3='$ldv3',ldv4='$ldv4',lnv1='$lnv1',lnv2='$lnv2',lnv3='$lnv3',lnv4='$lnv4',ladd='$ladd',lipg='$lipg',rdv1='$rdv1',rdv2='$rdv2',rdv3='$rdv3',rdv4='$rdv4',rnv1='$rnv1',rnv2='$rnv2',rnv3='$rnv3',rnv4='$rnv4',radd='$radd',ripg='$ripg' WHERE group_id=$group_id");
 
                        if($bill_discount_per>0)
                        {
                            $sales_items_array = $this->sales_obj->get_sales_items(array('columns' => array('id','item_id','qty','unit_id','rate','godown_id'),'conditions' => array('group_id' => $group_id,'status!=' => 0,'item_status >' => 0)));
   						
    						foreach($sales_items_array as $key => $value)
    						{
    						    $it_up_id = $value['id'];
    						    $itid = $value['item_id']; 
    						    $itamt = $value['qty']*$value['rate'];
    						    $itdiscamt = ($itamt*$bill_discount_per)/100;
    						    $it_cgst = $this->stock->get_item_cgst($itid);
    						    $it_sgst = $this->stock->get_item_sgst($itid);
    						    
    						    $it_taxable = (($itamt-$itdiscamt)*100)/(100+$it_cgst+$it_sgst+$cess);
    						    $it_cgst_amt = ($it_taxable*$it_cgst)/100; 
    						    $it_sgst_amt = ($it_taxable*$it_sgst)/100; 
    						    $it_cess_amt = ($it_taxable*$cess)/100; 
    						    
    						    $it_up_array = array('discount_per'=>$bill_discount_per,'discount_amt'=>$itdiscamt,'taxable_amt'=>$it_taxable,'cgst'=>$it_cgst,'sgst'=>$it_sgst,'cgst_amt'=>$it_cgst_amt,'sgst_amt'=>$it_sgst_amt,'cess_amt'=>$it_cess_amt);
    						
    						    $this->sales_obj->update(array('table' => 'dms_sales_items1','data' => $it_up_array,'conditions' => array('id' => $it_up_id)));
    						}
                        }
 
                        $this->sales_obj->update(array('table' => 'dms_sales_items1','data' => array('status' => 1),'conditions' => array('group_id' => $group_id,'status !=' =>0,'item_status >' => 0)));                     
                        $sls_qr = $this->db->select(array('id'))->from('dms_booking')->where('group_id',$group_id)->get()->row_array();							
                        $sls_id = $sls_qr['id']; 

						#--------------checking for user points and dr_ledger
						$user_points = 0;$user_type = "";
						if($sales_entry_check[0]['customer_type_id'] == 2)//customer
						{							
							$customer = $this->dms->get_data(array('table' => 'customer_master','columns' => 'ledger_id','conditions' => array('id' => $sales_entry_check[0]['customer_id'])));
						}
						else//branch or AR
						{
							$designation_id = $sales_entry_check[0]['customer_type_id'];
							if($designation_id == 3)
							{
								$customer = $this->dms->get_data(array('table' => 'retailer_master','columns' => 'ledger_id','conditions' => array('id' => $sales_entry_check[0]['customer_id'])));
							}
							else
							{
								$customer = $this->dms->get_data(array('table' => 'branch_master','columns' => 'ledger_id','conditions' => array('id' => $sales_entry_check[0]['customer_id'])));
							}
						}
						
						$customer_id = $sales_entry_check[0]['customer_id'];
						$designation_id = $sales_entry_check[0]['customer_type_id'];
                        $bill_no = $sales_entry_check[0]['bill_no'];
						$amt= $this->dms->get_qty($customer_id,$bill_no);
                        $customer_points = $this->targets->get_customer_bill_points($amt);
                        $c_point = $this->db->select(array('point'))->from('customer_total_point')->where('cid',$customer_id)->get()->row_array();
			            if($c_point)
			            {
			                $cur_point = $c_point['point'];			
			                $new_point = $cur_point+$customer_points;
			                $sqlu = "update customer_total_point set point='$new_point' where cid='$customer_id'";
			                $this->db->query($sqlu);
			            }
			            else
			            {
			                $sql1 = "insert into customer_total_point(cid,point) values('$cust_id','$customer_points')";			
			                $this->db->query($sql1);
			            }
                        
                        $target_id2 = $this->targets->get_targets(array('columns' => 'a.id','conditions' => array('a.designation_id' => 0,'a.user_id' => 0,'a.status' => 1),'bill_date' => $bill_date));
						if($target_id2)
						{
							$this->sales_obj->insert('customer_points',array('designation_id' => 0,'user_id' => $customer_id,'targets_id' => $target_id2['id'],'group_id' => $group_id,'sms_point' => $customer_points,'actual_point' => $customer_points));
						}
						
						#-------------adding bill to dms_vouchers
						$bill_date_time = strtotime($bill_date);
    					if(!empty($this->input->post('bill_advance')))
                        {
                            $voucher_status1 = $voucher_status2 = 1;
                                
                            $voucher_array = array('company_id' => $this->session->userdata('company_id'),'branch_id' => $this->session->userdata('under_id'),'vtype_id' => $vtype_id,'vno' => $group_id,'vorder_no' => 1,'vdate' => $bill_date,'cr_ledger' => 20,'table_name' => 'dms_booking','table_group_id' => $group_id);
    						
                            if(!empty($payment_mode) && !empty($amount1) && $amount1 > 0)
                            {
                                if($payment_mode > 2)
    						    {
                                    $cheque_date1 = date('Y-m-d',strtotime($this->input->post('cheque_date',true)));
            						$cheque_date_time1 = strtotime($cheque_date1);
            						if($this->input->post('ccd',true) == 1 && $cheque_date_time1 > $bill_date_time)
            						{
            							$voucher_status1 = 3;
            						}
    						    }
    						    elseif($payment_mode == 2)
            					{
            						$payment_mode = $customer[0]['ledger_id'];
            					}
            						
            					$voucher_group_id1 = $this->stock->get_group_id('dms_vouchers');
            						
            					$voucher_array['group_id'] = $voucher_group_id1;
            					$voucher_array['dr_ledger'] = $payment_mode;
            					$voucher_array['vamount'] = $amount1;
            					$voucher_array['status'] = $voucher_status1;
            				
            					$voucher_success1 = $this->sales_obj->insert('dms_vouchers',$voucher_array);
    						
        						if($payment_mode1 > 2)
                                {
                                    $this->sales_obj->insert('dms_voucher_banks',array('group_id' => $voucher_group_id1,'cash_type' => $this->input->post('ccd',true),'cd_no' => $this->input->post('cd_no',true),'pdc' => $cheque_date1,'vdate' => $bill_date));
        						}
                            }
                                
                            if(!empty($payment_mode2) && !empty($amount2) && $amount2 > 0)
                            {
                                if($payment_mode2 > 2)
    						    {
                                    $cheque_date2 = date('Y-m-d',strtotime($this->input->post('cheque_date2',true)));
            						$cheque_date_time2 = strtotime($cheque_date2);
            						if($this->input->post('ccd2',true) == 1 && $cheque_date_time2 > $bill_date_time)
            						{
            							$voucher_status2 = 3;
            						}
    						    }
    						    elseif($payment_mode2 == 2)
            					{
            						$payment_mode2 = $customer[0]['ledger_id'];
            					}
            					
            					$voucher_group_id2 = $this->stock->get_group_id('dms_vouchers');
            					$voucher_array['group_id'] = $voucher_group_id2;
            					$voucher_array['dr_ledger'] = $payment_mode2;
            					$voucher_array['vamount'] = $amount2;
            					$voucher_array['status'] = $voucher_status2;
            						
            					$voucher_success2 = $this->sales_obj->insert('dms_vouchers',$voucher_array);
    						
        						if($payment_mode2 > 2)
                                {
                                    $this->sales_obj->insert('dms_voucher_banks',array('group_id' => $voucher_group_id2,'cash_type' => $this->input->post('ccd2',true),'cd_no' => $this->input->post('cd_no2',true),'pdc' => $cheque_date2,'vdate' => $bill_date));
        						}
                            }
                        }
                        
					    $branch_id = $this->session->userdata('under_id');
                        $godown_id = $this->stock->get_branch_godown($branch_id); 
                        
                        $sales_items_array = $this->sales_obj->get_sales_items(array('columns' => array('id','item_id','qty','unit_id','rate','godown_id'),'conditions' => array('group_id' => $group_id,'status' => 1,'item_status >' => 0)));
   						
						foreach($sales_items_array as $key => $value)
						{
							#-------------enabling temporarily added stocks
						//	$this->sales_obj->update_others(array('table' => 'dms_stocks','data' => array('status' => 1),'conditions' => array('stock_status' => 6,'table_id' => $value['id'])));
							
							#---------------------------------------------------------------------------#
							$stock_count = $this->stock->get_stock_count($godown_id,$value['item_id']);

							$this->sales_obj->update_others(array('table' => 'item_stock','data' => array('qty' => $stock_count),'conditions' => array('branch_id' => $this->session->userdata('under_id'),'item_id' => $value['item_id']))); 
							
							#---------------------------------------------------------------------------#
                            /*  if(!empty($customer_id))//cust_new
							{
								$customer_points += $this->targets->get_bill_points(0,1,$value['item_id'],$value['unit_id'],$value['qty'],$value['rate'],$bill_date);
							} */
						}

					    /*  if($customer_points > 0)//new_cust_28
						{
							$target_id2 = $this->targets->get_targets(array('columns' => 'a.id','conditions' => array('a.designation_id' => 0,'a.user_id' => 0,'a.status' => 1),'bill_date' => $bill_date));
							if($target_id2)
							{
								$this->sales_obj->insert('customer_points',array('designation_id' => 0,'user_id' => $customer_id,'targets_id' => $target_id2['id'],'group_id' => $group_id,'sms_point' => $customer_points,'actual_point' => $customer_points));
							}
						}
                        if(!empty($customer_type))//new_cust
						{
							$customer_data = $this->dms->get_data(array('table' =>'customer_master','columns' => 'mobile','conditions' => array('id' => $customer_id)));
							if(!empty($customer_data))
							{
								$customer_type_mobile=$customer_data[0]['mobile'];
								$this->sales_obj->insert('dms_sms_customer',array('company_id' =>$this->companyID,'bill_ref_no' => $group_id,'user_type'=>$customer_type_id,'user_id'=>$customer_id,'status'=>3));
							}
						} */

                        #----------------------- sms to customer ----------------------------------------------

                        $this->load->model('sms/sms_model','sms');
						$this->load->library('stock');
						$this->load->library('targets');
						$offset =0;$links=NULL;
						$this->load->library('pagination');
			
						$sms_users = $this->sms->sms_user();
						$sms_user = $sms_users[0];
						$username = $sms_user['username'];
						$password = $sms_user['password'];
						$route = $sms_user['sms_type'];
						$msg_balance = $this->sms->sms_balance($username,$password,$route);		
														
                        $this->load->model('customers/customer_master_model','customer_master');
                        $args = array('conditions'=>array('id'=>$customer_id));
                        $cust_data = $this->customer_master->get($args);
                        $cust_name = $cust_data[0]['fname'];
                        $cust_mob = $cust_data[0]['mobile_no'];
                                                                  			
						$message="Dear ".$cust_name.", Your payment of Rs.".$bill_advance." for bill no. ".$bill_no." is success. Balance Amount is Rs.".$balance_amt." . Delivery date - ".date('d/m/Y',strtotime($del_date))." ";					
																	
						if($msg_balance > 0 )
						{
			                $message = $message;
							//$msg_send_status = $this->sms->send($cust_mob,$message);
												
							$this->db->insert('customer_sms',array('customer_id'=>$customer_id,'customer_name'=>$cust_name,'mobile'=>$cust_mob,'message'=>$message));
						}		

                        #-------------------------------------------------------------------------------------------

						$this->message->set($this->lang->line('sales-save-success'));
                        $lnk = 'booking/print_bill/id/'.$sls_id;
						//redirect($lnk);
						echo '<script>window.location.href = "'.base_url($lnk).'";</script>';
					}
					else
					{
						$this->message->set($this->lang->line('sales-save-error'),'e');
					}

					#----------transaction completed
					$this->db->trans_complete();		
				}
				else
				{
					$this->message->set($this->lang->line('sales-save-error'),'e');
				}
				echo '<script>window.location.href = "'.base_url('booking/add').'";</script>';
			}
		}
	
		#------------customer type
		$user_types = array();$custType = 2;
		if($this->branch_status)
		{
			$customerTypes = $this->desig->listing(array('department_id'=>0,'utype_status >'=>1));
		}
		else
		{
			$customerTypes = $this->desig->listing(array('id'=>2));
		}

		#------------item details / unit details / godown details
		#------------vendor details
		$vendors = $this->stock->get_vendors();
		//$vendor_id = "";
		$vendors[''] = 'Select';
		ksort($vendors);

		$units = array();$goDowns = array();
		$units[''] = "Select";
		$args['select'] = array('id','item_code','item_name','model_no');
		$items = $this->stock->get_stock_items($args);
		//$items = $this->stock->get_branch_stock_items();
		if(empty($items))
		{
			$this->message->set($this->lang->line('no-items-found'),'i');
		}
		if($this->input->post('item_id',true))
		{
			$itemID = $this->input->post('item_id',true);
			$goDowns = $this->stock->get_item_godowns(array('item_id'=>$itemID,'listing'=>1));
			$units = $this->stock->get_units($itemID);
		}

		#------------sales temp data
		$sales_temp_data = array();$cust_id="";$users = array();$user = "";$pricelists=array();$desig_id="";
		$price_list_id="";$stock_count="";$primary_unit['symbol']="";
		if($result_array['vstatus'])
		{
			#------------area details
			$this->load->model('areas/area_model','area');
			$areas = $this->area->listing();
		
            $sales_temp_data = $this->sales_obj->get_sales(array('columns' => array('a.group_id','a.customer_type_id','a.customer_id','a.doctor','a.user_id','a.pricelist_id','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.taxable_amt','b.discount_per','b.discount_amt','b.godown_id','b.cgst','b.sgst','b.cgst_amt','b.sgst_amt','b.cess_amt'),'conditions' => array('a.created_by' => $this->session->userdata('id'),'vtype_id' => $vtype_id,'bill_no' => $voucher_no,'a.status =' => -1,'b.status !=' => 0)));

            $gr_id = $sales_temp_data[0]['group_id']; 

            $des_array = $this->sales_obj->get_description($gr_id);

			#------------customer type
			$custType = $sales_temp_data[0]['customer_type_id'];
            $user_ids = $sales_temp_data[0]['user_id'];
			#------------customer
			$cust_id = $sales_temp_data[0]['customer_id'];
            $this->load->model('customers/customer_master_model','customer_master');
            $args = array('conditions'=>array('id'=>$cust_id));
            $cust_data = $this->customer_master->get($args);
            $cust_name = $cust_data[0]['fname'];
            $cust_mob = $cust_data[0]['mobile_no'];
            $cust_addr = $cust_data[0]['address'];
            $cust_mail = $cust_data[0]['email_id'];
            $cust_dob = $cust_data[0]['dob'];
            
			#------------user
            $doctor = $sales_temp_data[0]['doctor'];

			#------------user designation
			$desig_id = $this->dms->get_desig($user);

			#------------user details
			$users = $this->dms->get_users(array('conditions' => array('designation_id' => $desig_id,'branch_id' => $this->session->userdata('under_id'))));

			#------------pricelist id
			$price_list_id = $sales_temp_data[0]['pricelist_id'];;
		}
		else
		{
			$sales_array = $this->input->post('sales',true);
			$des_array = $this->input->post('des',true);
			
			#------------customer type
			if($sales_array['customer_type'] != "")
			{
				$custType = $sales_array['customer_type'];
			}
			if($sales_array['customer_id'] != "")
			{
				$cust_name = $sales_array['customer_id'];
			}
			
			$cust_mob = $sales_array['mobile'];
			$cust_addr = $sales_array['address'];
			$cust_mail = $sales_array['email_id'];
			$cust_dob = $sales_array['dob'];
			$doctor = $sales_array['doctor'];

			#------------user details
			if($sales_array['user_type'] != "")
			{
				$desig_id = $sales_array['user_type'];
				$users = $this->dms->get_users(array('conditions' => array('designation_id' => $desig_id,'branch_id' => $this->session->userdata('under_id'))));
				if($sales_array['user_id'] != "")
				{
					$user = $sales_array['user_id'];
				}
			}

			#------------pricelist
			if(isset($sales_array['pricelist_id']) && $sales_array['pricelist_id'] != "")
			{
				$price_list_id = $sales_array['pricelist_id'];
			}

			#------------stock count of this item
			if($this->input->post('item_id',true) && $sales_array['bill_date'] != "")
			{
				$stock_count = $this->stock->get_stock_count($this->stock->get_branch_godown($this->branchID),$this->input->post('item_id',true),$sales_array['bill_date']);
				$primary_unit = $this->stock->get_primary_unit($this->input->post('item_id',true));
			}
		}

		#------------customer details
		if($this->branch_status)
		{
			if($custType == 1)
			{
				$this->load->model('branches/branch_model','branches');
				$customers = $this->branches->listing(array('id !='=>$this->session->userdata('under_id')));
			}
			else if($custType ==2)
			{
				$this->load->model('customers/customer_master_model','customer_master');
				$customers = $this->customer_master->listing();
				#array('conditions'=>array('branch_id'=>$this->session->userdata('under_id')))
			}
			else
			{
				$this->load->model('retailers/counter_model','retailer_master');
				$customers = $this->retailer_master->listing(array('company_id'=>$this->session->userdata('company_id')));
			}
		}
		else
		{
			$this->load->model('customers/customer_master_model','customer_master');
			$customers = $this->customer_master->listing();
			#array('conditions'=>array('branch_id'=>$this->session->userdata('under_id')))
		}

        $this->load->model('products/manufacture_model','manu');		
        $this->load->model('godown/godown_model','godown');

        $branch_det = $this->db->select(array('id','branch_name','ledger_id','area_id','minus_stock_entry'))->from('branch_master')->where('id',$this->branchID)->get()->row_array();
        $branch_area = $branch_det['area_id'];
        $minus_stock = $branch_det['minus_stock_entry'];

        $units1 = $this->unit->listing();
        $item_groups = $this->item->item_group_listing();
        $godowns1 = $this->godown->listing();
          
		$user_types = $this->desig->listing(array('utype_status' => 1));

		$pricelists = $this->customer_type->listing();

		ksort($areas);
		$customers[''] = "Select";ksort($customers);
		$user_types[''] = "Select";ksort($user_types);
		$pricelists[''] = 'Select';ksort($pricelists);
		$items[''] = 'Select';ksort($items);
		$goDowns[''] = 'Select';ksort($goDowns);
		$users[''] = 'Select';ksort($users);
		$item_groups[''] = 'Select';ksort($item_groups);

		$payment_mode = $this->stock->payment_modes();

		$cd_status = 1;
		if($this->input->post('payment_mode',true) > 2)
		{
			$cd_status = 0;
		}
        
        $unmae = $this->sales_obj->listing();
		
		$this->template->title("New Sales Voucher");
		$this->template->main_heading($this->lang->line("$voucher_name")." ".$this->lang->line('booking'));
		$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line('booking') => 'no_link',$this->lang->line('report') => 'booking/report'));
		$this->template->slice('dms/message');
		$this->template->slice('booking/add',array('voucher_types' => $voucher_types,'voucher_type' => $vtype_id,'voucher_name' => $voucher_name,'voucher_no' => $voucher_no,'voucher_date' => $voucher_date,'custType' => $custType,'vendors' => $vendors,'customerTypes' => $customerTypes,'customers' => $customers,'user_types' => $user_types,'users' => $users,'pricelists' => $pricelists,'price_list_id' => $price_list_id,'items' => $items,'units' => $units,'goDowns' => $goDowns,'sales_temp_status' =>$result_array['vstatus'],'sales_temp_data' => $sales_temp_data,'areas' => $areas,'cess' => $cess,'payment_mode' => $payment_mode,'disabled' => $disabled,'cust_name' => $cust_name,'cust_mob'=>$cust_mob,'cust_addr'=>$cust_addr,'cust_mail'=>$cust_mail,'cust_dob'=>$cust_dob,'doctor'=>$doctor,'desig_id' => $desig_id,'stock_count' => $stock_count,'primary_unit' => $primary_unit['symbol'],'cd_status' => $cd_status,'bill_prefix'=>$bill_prefix,'des_array'=>$des_array,'units1'=>$units1,'groups'=>$item_groups,'godowns1'=>$godowns1,'branch_area'=>$branch_area,'minus_stock'=>$minus_stock,'previous_status'=>$previous_status,'user_name'=>$unmae,'user_id'=>$user_ids));
        $this->template->slice('dms/modals/search');
		$this->template->other_script('sales/sales_order');
        $this->template->other_script('products/search');
		$this->template->render();
	}

	public function delete_temp()
	{
		#----------sales temp data
		$uri_array = $this->uri->uri_to_assoc(3);
		if(isset($uri_array['idu']) || isset($uri_array['ida']))
		{
			if(isset($uri_array['idu']))
			{
				$id = $uri_array['idu'];
				unset($uri_array['idu']);

				#-----------redirect uri
				$redirect_uri = "booking/update/".$this->uri->assoc_to_uri($uri_array);
			}
			else
			{
				$id = $uri_array['ida'];
                $gid= $uri_array['gida'];
				unset($uri_array['ida']);
                unset($uri_array['gida']);

				#-----------redirect uri
				$redirect_uri = "booking/add/".$this->uri->assoc_to_uri($uri_array);
			}

            $s=$this->sales_obj->get_bills(array('columns' => array('bill_date'),'conditions' => array('group_id'=> $gid),'numrows' => true));
            $result = $this->sales_obj->get_sales_items(array('columns' => array('group_id','status','item_status','created_by'),'conditions' => array('id' => $id,'status !=' => 0)));

			if(!empty($result))
			{
				$row = $result[0];
				if($row['status'] == -1)
				{
					if($row['created_by'] == $this->session->userdata('id'))
					{
						#----------start transaction
						$this->db->trans_start();

                        if($this->sales_obj->delete(array('table' => 'dms_sales_items1','conditions' => array('id' => $id))))
						{
							#-------------deleting stock bal. from dms_stocks
						//	$this->sales_obj->delete(array('table' => 'dms_stocks','conditions' => array('table_id' => $id,'stock_status' => 6)));

							$count = $this->sales_obj->get_sales_items(array('columns' => array('group_id'),'conditions' => array('group_id' => $row['group_id'],'status !=' => 0),'numrows' => true));
							if($count == 0)
							{
								$this->sales_obj->delete(array('table' => 'dms_booking','conditions' => array('group_id' => $row['group_id'])));
                                $this->sales_obj->delete(array('table' => 'doctor_description','conditions' => array('group_id' => $row['group_id'])));                                                              
                                $this->sales_obj->update_others(array('table' => 'dms_vouchers','data' => array('status' => 0),'conditions' => array('table_name' => 'dms_booking','table_group_id' => $row['group_id'])));
							}
							$this->message->set($this->lang->line('sales-item-delete-success'));
						}
						else
						{
							$this->message->set($this->lang->line('sales-item-delete-error'),'e');
						}

						#----------end transaction
						$this->db->trans_complete();
					}
					else
					{
						redirect('users/logout');
					}
				}
				else
				{
					#----------start transaction
					$this->db->trans_start();

                    #-------------deleting item from dms_sales_items
					if($row['item_status'] == 2)
					{
						$this->sales_obj->update(array('table' => 'dms_sales_items1','data' => array('status' => 0),'conditions' => array('id' => $id)));
					}
					else
					{
						$this->sales_obj->update(array('table' => 'dms_sales_items1','data' => array('item_status' => -1),'conditions' => array('id' => $id)));
					}

					#-------------changing sales bill status
					$this->sales_obj->update(array('table' => 'dms_booking','data' => array('status' => -1),'conditions' => array('group_id' => $row['group_id'])));

					#-------------deleting stock bal. from dms_stocks
				//	$this->sales_obj->update_others(array('table' => 'dms_stocks','data' => array('status' => 0),'conditions' => array('table_id' => $id,'stock_status' => 6)));

					#-------------checking whether sales bill is deleted
                    $count = $this->sales_obj->get_sales_items(array('columns' => array('group_id'),'conditions' => array('group_id' => $row['group_id'],'status !=' => 0,'item_status >' => 0),'numrows' => true));

					if($count == 0)
					{
						#-------------deleting sales bill
						$this->sales_obj->update(array('table' => 'dms_booking','data' => array('status' => 0),'conditions' => array('group_id' => $row['group_id'])));

						#-------------deleting stock from dms_vouchers
						$this->sales_obj->update_others(array('table' => 'dms_vouchers','data' => array('status' => 0),'conditions' => array('table_name' => 'dms_booking','table_group_id' => $row['group_id'])));

						#-------------deleting stock from dms_voucher_banks
						$cheque_details = $this->vouchers->cheque_data(array('columns' => 'b.id','conditions' => array('table_name' => 'dms_booking','table_group_id' => $row['group_id'])));
						if(!empty($cheque_details))
						{
							$this->sales_obj->update_others(array('table' => 'dms_voucher_banks','data' => array('status' => 0),'conditions' => array('id' => $cheque_details[0]['id'])));
						}

						#-------------deleting user points achieved through this bill
						$this->sales_obj->update_others(array('table' => 'user_points','data' => array('status' => 0),'conditions' => array('group_id' => $row['group_id'])));

						#-------------deleting sms
						$this->sales_obj->update_others(array('table' => 'dms_sms','data' => array('status' => 0),'conditions' => array('bill_ref_no' => $row['group_id'])));

						#-----------redirect uri
						$redirect_uri = "booking/report/".$this->uri->assoc_to_uri($uri_array);
					}
					$this->message->set($this->lang->line('sales-item-delete-success'));

					#----------end transaction
					$this->db->trans_complete();
				}
			}
			echo '<script>window.location.href = "'.base_url().$redirect_uri.'";</script>';
			//redirect($redirect_uri);
		}
		redirect('users/logout');
	}  

	public function update_temp()
	{
		#----------sales temp data
		$uri_array = $this->uri->uri_to_assoc(3);
		if(isset($uri_array['idu']) || isset($uri_array['ida']))
		{
		    $cess = $this->stock->get_cess();
		    
			if(isset($uri_array['idu']))
			{
				$sales_temp_id = $uri_array['idu'];
				unset($uri_array['idu']);

				#-----------redirect uri
				$redirect_uri = "booking/update/".$this->uri->assoc_to_uri($uri_array);
			}
			else
			{
				$sales_temp_id = $uri_array['ida'];
				unset($uri_array['ida']);

				#-----------redirect uri
				$redirect_uri = "booking/add/".$this->uri->assoc_to_uri($uri_array);
			}

            $row = $this->sales_obj->get_sales_items(array('columns' => array('id','group_id','item_id','hsn','qty','unit_id','rate','amount','taxable_amt','discount_per','discount_amt','cgst','sgst','cgst_amt','sgst_amt','cess_amt','godown_id','status','item_status','created_by'),'conditions' => array('id' => $sales_temp_id,'status !=' => 0)));

			if(!empty($row))
			{
			    
				$sales_temp_data = $row[0];$continue = 1;
				if($sales_temp_data['status'] == -1)
                {
					if($sales_temp_data['created_by'] != $this->session->userdata('id'))
					{
						$continue = 0;
					}
				}
				if($continue == 1)
				{
					#-----------validation
					$this->form_validation->set_rules('godown_id','lang:godown','required|xss_clean');					
					$this->form_validation->set_rules('qty','lang:quantity','required|xss_clean|greater_than[0]|less_than[100000000]');
					$this->form_validation->set_rules('unit_id','lang:unit','required|xss_clean');
					$this->form_validation->set_rules('rate','lang:rate','required|xss_clean|greater_or_equal[0]|less_than[100000000]');
					$this->form_validation->set_rules('amount','lang:amount','xss_clean|required|greater_or_equal[0]|less_than[100000000]');
					$this->form_validation->set_rules('discount_per','lang:discount %','xss_clean|greater_or_equal[0]|less_or_equal[100]');
					$this->form_validation->set_rules('discount_amt','lang:discount','xss_clean|greater_or_equal[0]|less_than[100000000]');
					
					#-----------updating temporary data
					if($this->form_validation->run() === true)
					{
						$item_temp_array = $this->input->post(NULL,true);

                        unset($item_temp_array['gstin']);

						#----------rate calculation
						$item_temp_array['rate'] = 0;
						if($item_temp_array['qty'] != 0)
						{
							$item_temp_array['rate'] = $item_temp_array['amount'] / $item_temp_array['qty'];
						}

						#------------presumptive tax checking
						$presumptive_tax = $this->stock->get_tax_type();

						#----------GST calculation
					
                        $item_temp_array['cgst'] = $this->stock->get_item_cgst($sales_temp_data['item_id']);
                        $item_temp_array['sgst'] = $this->stock->get_item_sgst($sales_temp_data['item_id']);
                        
                        $item_temp_array['taxable_amt'] = (($item_temp_array['amount']-$item_temp_array['discount_amt'])*100)/(100+$item_temp_array['cgst']+$item_temp_array['sgst']+$cess);
                        
						#----------start transaction
						$this->db->trans_start();

                        if($sales_temp_data['item_status'] == 1 && ($sales_temp_data['qty'] != $item_temp_array['qty'] || $sales_temp_data['unit_id'] != $item_temp_array['unit_id'] || $sales_temp_data['rate'] != $item_temp_array['rate'] || $sales_temp_data['discount_per'] != $item_temp_array['discount_per'] || $sales_temp_data['discount_amt'] != $item_temp_array['discount_amt'] || $sales_temp_data['godown_id'] != $item_temp_array['godown_id']))
						{ 
							$item_temp_array['group_id'] = $sales_temp_data['group_id'];
							$item_temp_array['item_id'] = $sales_temp_data['item_id'];
							$item_temp_array['status'] = -1;
							$item_temp_array['item_status'] = 2;
							$sales_temp_data['item_status'] = 2;
							if($this->sales_obj->update_others(array('table' => 'dms_sales_items1','data' => array('item_status' => -1),'conditions' => array('id' => $sales_temp_id))))
							{
								$sales_temp_id = $this->sales_obj->insert('dms_sales_items1',$item_temp_array);
								$this->message->set($this->lang->line('sales-edit-temp-success'));
							}
						}
						else
						{ 
							$item_temp_array['status'] = -1;
							$this->sales_obj->update_others(array('table' =>'dms_sales_items1','data' => $item_temp_array,'conditions' => array('id' => $sales_temp_id)));
							$this->message->set($this->lang->line('sales-edit-temp-success'));
						}

						#--------------updating bill status in dms_sales
						$this->sales_obj->update_others(array('table' => 'dms_booking','data' => array('status' => -1),'conditions' => array('group_id' => $sales_temp_data['group_id'])));

						#--------------updating temporary stock balance in dms_stocks
						if($sales_temp_data['item_status'] == 2)
						{
						/*	$stock_bal_temp = $this->stock->unit_conversion($sales_temp_data['item_id'],$item_temp_array['unit_id'],$item_temp_array['qty'],$item_temp_array['rate'],$item_temp_array['amount']);
							if($stock_bal_temp)
							{
								$this->sales_obj->update_others(array('table' => 'dms_stocks','data' => array('godown_id' => $item_temp_array['godown_id'],'qty' => $stock_bal_temp['qty'],'unit_id' => $stock_bal_temp['primary_unit'],'rate' => $stock_bal_temp['rate'],'amount' => $stock_bal_temp['amount'],'status' => $item_temp_array['status']),'conditions' => "(stock_status = 6 or stock_status = 5) and table_id = $sales_temp_id"));
							}*/
						}

						#----------end transaction
						$this->db->trans_complete();

						//redirect($redirect_uri);
						echo '<script>window.location.href = "'.base_url().$redirect_uri.'";</script>';
					}

					#----------voucher name
					$voucher_name = $this->vouchers->voucher_name($this->vtype);

					#------------item details / unit details / godown details
					$units = array();$goDowns = array();
					$item_details = $this->stock->get_item($sales_temp_data['item_id'],array('item_code','item_name','model_no'));
					$items[$sales_temp_data['item_id']] = $item_details['item_code']." / ".$item_details['item_name']." / ".$item_details['model_no'];
					$goDowns = $this->stock->get_item_godowns(array('item_id'=>$sales_temp_data['item_id'],'listing'=>1)); 
					$goDowns[''] = 'Select';
					ksort($goDowns);
					$units = $this->stock->get_units($sales_temp_data['item_id']);
					

					#------------sale date
					$sale_date = $this->sales_obj->get_sales(array('columns' => array('bill_date'),'conditions' => array('a.group_id' => $sales_temp_data['group_id'],'a.status !=' => 0,'b.item_status >' => 0)))[0];

					#------------stock count of this item
					$stock_count = $this->stock->get_stock_count($sales_temp_data['godown_id'],$sales_temp_data['item_id'],$sale_date['bill_date']);

					#------------primary unit details
					$primary_unit = $this->stock->get_primary_unit($sales_temp_data['item_id']);

					#------------template
					$this->template->title("Update Sales Booking");
					$this->template->main_heading($this->lang->line("$voucher_name"));
					$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("booking") => 'booking/add',$this->lang->line("update") => 'no_link',$this->lang->line('report') => 'booking/report',$this->lang->line('go-back') => array($redirect_uri)));
					$this->template->slice('dms/message');
					$this->template->slice('booking/edit_temp',array('voucher_name' => $voucher_name,'items' => $items,'units' => $units,'goDowns' => $goDowns,'sales_temp_data' => $sales_temp_data,'presumptive_tax' => $presumptive_tax,'cess'=>$cess,'stock_count' => $stock_count,'unit_symbol' => $primary_unit['symbol'],'sale_date' => $sale_date['bill_date']));
					$this->template->other_script('sales/sales_order');
					$this->template->render();
				}
				else
				{
					redirect('users/logout');
				}
			}
			else
			{
				redirect('users/logout');
			}
		}
		else
		{
			redirect('users/logout');
		}
	}

	public function bill_no_exists($bill_no,$v_details = NULL)
	{
		if($v_details == NULL){
			$where = array('vtype_id' => $this->input->post('vtype_id',true),'bill_no' => $bill_no,'status !=' => 0);
		}
		else
		{
			$exp = explode('.', $v_details);
			$where = array('vtype_id' => $exp[0],'bill_no' => $bill_no,'group_id !=' => $exp[1],'status !=' => 0);
		}
		$row = $this->sales_obj->get_bills(array('columns' => array('id'),'conditions' => $where,'numrows' => true));
		if($row == 0)
		{
			return true;
		}
		return false;
	}

	public function report()
	{
		#----------loading models
		$this->load->model('designations/designation_master_model','desig');
        $this->load->model('products/item_model','item');

		#----------voucher type
		$vtype_id = $this->vtype;
		$conditions = array('vtype_id' => $vtype_id,'status' => 1);
		$like_array = array();$vnos="";

		#----------voucher name
		$voucher_name = $this->vouchers->voucher_name($this->vtype);

		#----------voucher type array
		$voucher_types = $this->vouchers->voucher_types($this->vtype);

		#----------uri array
		$uri_array  = $this->uri->uri_to_assoc(3);

		#----------redirect
		$redirect = "";

		#----------pagination
		$this->load->library('pagination');
		$config['per_page'] = $this->per_page();
		$config['base_url'] = base_url('booking/report');
		$config['uri_segment'] = 3;

		#----------dates within financial year
		$cur_date = date('Y-m-d');
		$from_date = $cur_date;
		$to_date = $cur_date;
		$cur_fiscal_yr = $this->dms->get_fiscal_year();
		if($from_date < $cur_fiscal_yr['start_date'] || $from_date > $cur_fiscal_yr['end_date'] || $to_date < $cur_fiscal_yr['start_date'] || $to_date > $cur_fiscal_yr['end_date'])
		{
			$from_date = $cur_fiscal_yr['end_date'];
			$to_date = $cur_fiscal_yr['end_date'];
		}

		#----------validation
		$this->form_validation->set_rules('vtype_id','voucher-types','required|xss_clean');
		$this->form_validation->set_rules('from_date','From Date','required|xss_clean|valid_date');
		$this->form_validation->set_rules('to_date','To Date','required|xss_clean|valid_date');
		$this->form_validation->set_rules('bill_no','bill-no','xss_clean|trim');
		if($this->form_validation->run() === true)
		{
			$vtype_id = $this->input->post('vtype_id',true);
			$from_date = date('Y-m-d',strtotime($this->input->post('from_date',true)));
			$to_date = date('Y-m-d',strtotime($this->input->post('to_date',true)));
			$conditions['vtype_id'] = $vtype_id;
			$config['base_url'] .= '/vt/'.$vtype_id.'/fdate/'.$from_date.'/tdate/'.$to_date;
			$config['uri_segment'] += 6;
			$redirect .= '/vt/'.$vtype_id.'/fdate/'.$from_date.'/tdate/'.$to_date;
			if(!empty($this->input->post('bill_no',true)))
			{
				$vnos = $this->input->post('bill_no',true);
				$like_array['bill_no'] = $vnos;
				$config['base_url'] .= '/vn/'.$vnos;
				$config['uri_segment'] += 2;
				$redirect .= '/vn/'.$vnos;
			}
            if(!empty($this->input->post('customer_id',true)))
			{
                $cust_ids = $this->input->post('customer_id',true);                                                                                   
                $conditions['customer_id'] = $cust_ids;                        
            }
		}
		elseif(isset($uri_array['vt']))
		{
			$vtype_id = $uri_array['vt'];
			$conditions['vtype_id'] = $vtype_id;
			$config['base_url'] .= '/vt/'.$conditions['vtype_id'];
			$config['uri_segment'] += 2;
			$redirect .= '/vt/'.$vtype_id;
			if(isset($uri_array['fdate']) && isset($uri_array['tdate']))
			{
				$from_date = date('Y-m-d',strtotime($uri_array['fdate']));
				$to_date = date('Y-m-d',strtotime($uri_array['tdate']));
				$config['base_url'] .= '/fdate/'.$from_date.'/tdate/'.$to_date;
				$config['uri_segment'] += 4;
				$redirect .= '/fdate/'.$from_date.'/tdate/'.$to_date;
			}
			if(isset($uri_array['vn']))
			{
				$vnos = $uri_array['vn'];
				$like_array['bill_no'] = $vnos;
				$config['base_url'] .= '/vn/'.$vnos;
				$config['uri_segment'] += 2;
				$redirect .= '/vn/'.$vnos;
			}
		}

		#----------between condition
		$between = "bill_date between '$from_date' and '$to_date'";

		#----------total rows

		$config['total_rows'] = $this->sales_obj->get_bills(array('columns' => array('id'),'conditions' => $conditions,'between' => $between,'like' => $like_array,'numrows'=>true));

		if($config['total_rows'] == 0)
		{
			$this->message->set($this->lang->line('no-voucher'),'i');
		}

		#----------pagination
		$offset = $this->uri->segment($config['uri_segment'],0);
		$this->pagination->initialize($config);
		$links = $this->pagination->create_links();
		$redirect .= '/'.$offset;

        $this->load->model('customers/customer_master_model','customer_master');
		$customers = $this->customer_master->listing();
        $customers['']= "Select";
        ksort($customers);

		#------------presumptive tax checking
		$presumptive_tax = $this->stock->get_tax_type();

		#----------sales report datas
		$sales_array=$this->sales_obj->get_bills(array('conditions' => $conditions,'between' => $between,'like' => $like_array,'order_by'=>'bill_no','order'=>'DESC','limit'=>$config['per_page'],'offset'=>$offset));

		#----------template
		$this->template->title("Booking Report");
		$this->template->main_heading($this->lang->line("$voucher_name")." ".$this->lang->line("booking")." ".$this->lang->line("report"));
		$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("$voucher_name")." ".$this->lang->line('booking') => 'booking/add',$this->lang->line('report') => 'no_link'));
		$this->template->slice('booking/search',array('voucher_types' => $voucher_types,'vtype_id' => $vtype_id,'vnos' => $vnos,'from_date' => $from_date,'to_date' => $to_date,'rtype' => 'sales','customers'=>$customers,'cust'=>$cust_ids));
		$this->template->slice('dms/message');
		$this->template->other_script('sales/sales_order');
		if(!empty($sales_array))
		{
			$this->template->slice('booking/report',array('sales_array' => $sales_array,'presumptive_tax' => $presumptive_tax,'offset' => $offset,'links' => $links,'vtype_id' => $conditions['vtype_id'],'redirect' => $redirect));
			$this->template->slice('dms/modals/delete_confirm');
		} 
		$this->template->render();
	}
#-----------------------------------------------------------------------------cancelled report1--------------------------------------------------------------------

public function cancelled_report()
	{
		#----------loading models
		$this->load->model('designations/designation_master_model','desig');
        $this->load->model('products/item_model','item');

		#----------voucher type
		$vtype_id = $this->vtype;
		$conditions = array('vtype_id' => $vtype_id,'status' => 1);
		$like_array = array();$vnos="";

		#----------voucher name
		$voucher_name = $this->vouchers->voucher_name($this->vtype);

		#----------voucher type array
		$voucher_types = $this->vouchers->voucher_types($this->vtype);

		#----------uri array
		$uri_array  = $this->uri->uri_to_assoc(3);

		#----------redirect
		$redirect = "";

		#----------pagination
		$this->load->library('pagination');
		$config['per_page'] = $this->per_page();
		$config['base_url'] = base_url('booking/cancelled_report');
		$config['uri_segment'] = 3;

		#----------dates within financial year
		$cur_date = date('Y-m-d');
		$from_date = $cur_date;
		$to_date = $cur_date;
		$cur_fiscal_yr = $this->dms->get_fiscal_year();
		if($from_date < $cur_fiscal_yr['start_date'] || $from_date > $cur_fiscal_yr['end_date'] || $to_date < $cur_fiscal_yr['start_date'] || $to_date > $cur_fiscal_yr['end_date'])
		{
			$from_date = $cur_fiscal_yr['end_date'];
			$to_date = $cur_fiscal_yr['end_date'];
		}

		#----------validation
		$this->form_validation->set_rules('vtype_id','voucher-types','required|xss_clean');
		$this->form_validation->set_rules('from_date','From Date','required|xss_clean|valid_date');
		$this->form_validation->set_rules('to_date','To Date','required|xss_clean|valid_date');
		$this->form_validation->set_rules('bill_no','bill-no','xss_clean|trim');
		if($this->form_validation->run() === true)
		{
			$vtype_id = $this->input->post('vtype_id',true);
			$from_date = date('Y-m-d',strtotime($this->input->post('from_date',true)));
			$to_date = date('Y-m-d',strtotime($this->input->post('to_date',true)));
			$conditions['vtype_id'] = $vtype_id;
			$config['base_url'] .= '/vt/'.$vtype_id.'/fdate/'.$from_date.'/tdate/'.$to_date;
			$config['uri_segment'] += 6;
			$redirect .= '/vt/'.$vtype_id.'/fdate/'.$from_date.'/tdate/'.$to_date;
			if(!empty($this->input->post('bill_no',true)))
			{
				$vnos = $this->input->post('bill_no',true);
				$like_array['bill_no'] = $vnos;
				$config['base_url'] .= '/vn/'.$vnos;
				$config['uri_segment'] += 2;
				$redirect .= '/vn/'.$vnos;
			}
            if(!empty($this->input->post('customer_id',true)))
			{
                $cust_ids = $this->input->post('customer_id',true);                                                                                   
                $conditions['customer_id'] = $cust_ids;                        
            }
		}
		elseif(isset($uri_array['vt']))
		{
			$vtype_id = $uri_array['vt'];
			$conditions['vtype_id'] = $vtype_id;
			$config['base_url'] .= '/vt/'.$conditions['vtype_id'];
			$config['uri_segment'] += 2;
			$redirect .= '/vt/'.$vtype_id;
			if(isset($uri_array['fdate']) && isset($uri_array['tdate']))
			{
				$from_date = date('Y-m-d',strtotime($uri_array['fdate']));
				$to_date = date('Y-m-d',strtotime($uri_array['tdate']));
				$config['base_url'] .= '/fdate/'.$from_date.'/tdate/'.$to_date;
				$config['uri_segment'] += 4;
				$redirect .= '/fdate/'.$from_date.'/tdate/'.$to_date;
			}
			if(isset($uri_array['vn']))
			{
				$vnos = $uri_array['vn'];
				$like_array['bill_no'] = $vnos;
				$config['base_url'] .= '/vn/'.$vnos;
				$config['uri_segment'] += 2;
				$redirect .= '/vn/'.$vnos;
			}
		}

		#----------between condition
		$between = "bill_date between '$from_date' and '$to_date'";
        $conditions['book_status'] = '0';
        $conditions['status'] = '2';
		#----------total rows

		$config['total_rows'] = $this->sales_obj->get_bills(array('columns' => array('id'),'conditions' => $conditions,'between' => $between,'like' => $like_array,'numrows'=>true));

		if($config['total_rows'] == 0)
		{
			$this->message->set($this->lang->line('no-voucher'),'i');
		}

		#----------pagination
		$offset = $this->uri->segment($config['uri_segment'],0);
		$this->pagination->initialize($config);
		$links = $this->pagination->create_links();
		$redirect .= '/'.$offset;

        $this->load->model('customers/customer_master_model','customer_master');
		$customers = $this->customer_master->listing();
        $customers['']= "Select";
        ksort($customers);

		#------------presumptive tax checking
		$presumptive_tax = $this->stock->get_tax_type();

		#----------sales report datas
		$sales_array=$this->sales_obj->get_bills(array('conditions' => $conditions,'between' => $between,'like' => $like_array,'order_by'=>'bill_no','order'=>'DESC','limit'=>$config['per_page'],'offset'=>$offset));

		#----------template
		$this->template->title("Cancelled Booking Report");
		$this->template->main_heading($this->lang->line("$voucher_name")." ".$this->lang->line("cancelled")." ".$this->lang->line("booking")." ".$this->lang->line("report"));
		$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("$voucher_name")." ".$this->lang->line('booking') => 'booking/add',$this->lang->line('report') => 'no_link'));
		$this->template->slice('booking/search_cancelledreprt',array('voucher_types' => $voucher_types,'vtype_id' => $vtype_id,'vnos' => $vnos,'from_date' => $from_date,'to_date' => $to_date,'rtype' => 'sales','customers'=>$customers,'cust'=>$cust_ids));
		$this->template->slice('dms/message');
		$this->template->other_script('sales/sales_order');
		if(!empty($sales_array))
		{
			$this->template->slice('booking/cancelled_report',array('sales_array' => $sales_array,'presumptive_tax' => $presumptive_tax,'offset' => $offset,'links' => $links,'vtype_id' => $conditions['vtype_id'],'redirect' => $redirect));
			$this->template->slice('dms/modals/delete_confirm');
		} 
		$this->template->render();
	}

#-------------------------------------------------------------------------------not deliverd report------------------------------------------------------

	public function not_delivered_report()
	{
		#----------loading models
		$this->load->model('designations/designation_master_model','desig');
        $this->load->model('products/item_model','item');

		#----------voucher type
		$vtype_id = $this->vtype;
		$conditions = array('vtype_id' => $vtype_id,'status' => 1);
		$like_array = array();$vnos="";

		#----------voucher name
		$voucher_name = $this->vouchers->voucher_name($this->vtype);

		#----------voucher type array
		$voucher_types = $this->vouchers->voucher_types($this->vtype);

		#----------uri array
		$uri_array  = $this->uri->uri_to_assoc(3);

		#----------redirect
		$redirect = "";

		#----------pagination
		$this->load->library('pagination');
		$config['per_page'] = $this->per_page();
		$config['base_url'] = base_url('booking/not_delivered_report');
		$config['uri_segment'] = 3;

		#----------dates within financial year
		$cur_date = date('Y-m-d');
		$from_date = $cur_date;
		$to_date = $cur_date;
		$cur_fiscal_yr = $this->dms->get_fiscal_year();
		if($from_date < $cur_fiscal_yr['start_date'] || $from_date > $cur_fiscal_yr['end_date'] || $to_date < $cur_fiscal_yr['start_date'] || $to_date > $cur_fiscal_yr['end_date'])
		{
			$from_date = $cur_fiscal_yr['end_date'];
			$to_date = $cur_fiscal_yr['end_date'];
		}

		#----------validation
		$this->form_validation->set_rules('vtype_id','voucher-types','required|xss_clean');
		$this->form_validation->set_rules('from_date','From Date','required|xss_clean|valid_date');
		$this->form_validation->set_rules('to_date','To Date','required|xss_clean|valid_date');
		$this->form_validation->set_rules('bill_no','bill-no','xss_clean|trim');
		if($this->form_validation->run() === true)
		{
			$vtype_id = $this->input->post('vtype_id',true);
			$from_date = date('Y-m-d',strtotime($this->input->post('from_date',true)));
			$to_date = date('Y-m-d',strtotime($this->input->post('to_date',true)));
			$conditions['vtype_id'] = $vtype_id;
			$config['base_url'] .= '/vt/'.$vtype_id.'/fdate/'.$from_date.'/tdate/'.$to_date;
			$config['uri_segment'] += 6;
			$redirect .= '/vt/'.$vtype_id.'/fdate/'.$from_date.'/tdate/'.$to_date;
			if(!empty($this->input->post('bill_no',true)))
			{
				$vnos = $this->input->post('bill_no',true);
				$like_array['bill_no'] = $vnos;
				$config['base_url'] .= '/vn/'.$vnos;
				$config['uri_segment'] += 2;
				$redirect .= '/vn/'.$vnos;
			}
            if(!empty($this->input->post('customer_id',true)))
			{
                $cust_ids = $this->input->post('customer_id',true);                                                                                   
                $conditions['customer_id'] = $cust_ids;                        
            }
		}
		elseif(isset($uri_array['vt']))
		{
			$vtype_id = $uri_array['vt'];
			$conditions['vtype_id'] = $vtype_id;
			$config['base_url'] .= '/vt/'.$conditions['vtype_id'];
			$config['uri_segment'] += 2;
			$redirect .= '/vt/'.$vtype_id;
			if(isset($uri_array['fdate']) && isset($uri_array['tdate']))
			{
				$from_date = date('Y-m-d',strtotime($uri_array['fdate']));
				$to_date = date('Y-m-d',strtotime($uri_array['tdate']));
				$config['base_url'] .= '/fdate/'.$from_date.'/tdate/'.$to_date;
				$config['uri_segment'] += 4;
				$redirect .= '/fdate/'.$from_date.'/tdate/'.$to_date;
			}
			if(isset($uri_array['vn']))
			{
				$vnos = $uri_array['vn'];
				$like_array['bill_no'] = $vnos;
				$config['base_url'] .= '/vn/'.$vnos;
				$config['uri_segment'] += 2;
				$redirect .= '/vn/'.$vnos;
			}
		}

		#----------between condition
		$between = "bill_date between '$from_date' and '$to_date'";
        $conditions['book_status'] = '0';
        
		#----------total rows

		$config['total_rows'] = $this->sales_obj->get_bills(array('columns' => array('id'),'conditions' => $conditions,'between' => $between,'like' => $like_array,'numrows'=>true));

		if($config['total_rows'] == 0)
		{
			$this->message->set($this->lang->line('no-voucher'),'i');
		}

		#----------pagination
		$offset = $this->uri->segment($config['uri_segment'],0);
		$this->pagination->initialize($config);
		$links = $this->pagination->create_links();
		$redirect .= '/'.$offset;

        $this->load->model('customers/customer_master_model','customer_master');
		$customers = $this->customer_master->listing();
        $customers['']= "Select";
        ksort($customers);

		#------------presumptive tax checking
		$presumptive_tax = $this->stock->get_tax_type();

		#----------sales report datas
		$sales_array=$this->sales_obj->get_bills(array('conditions' => $conditions,'between' => $between,'like' => $like_array,'order_by'=>'bill_no','order'=>'DESC','limit'=>$config['per_page'],'offset'=>$offset));

		#----------template
		$this->template->title("Booking Report");
		$this->template->main_heading($this->lang->line("$voucher_name")." ".$this->lang->line("booking")." ".$this->lang->line("report"));
		$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("$voucher_name")." ".$this->lang->line('booking') => 'booking/add',$this->lang->line('report') => 'no_link'));
		$this->template->slice('booking/search_notdeliverd',array('voucher_types' => $voucher_types,'vtype_id' => $vtype_id,'vnos' => $vnos,'from_date' => $from_date,'to_date' => $to_date,'rtype' => 'sales','customers'=>$customers,'cust'=>$cust_ids));
		$this->template->slice('dms/message');
		$this->template->other_script('sales/sales_order');
		if(!empty($sales_array))
		{
			$this->template->slice('booking/not_deliverd_report',array('sales_array' => $sales_array,'presumptive_tax' => $presumptive_tax,'offset' => $offset,'links' => $links,'vtype_id' => $conditions['vtype_id'],'redirect' => $redirect));
			$this->template->slice('dms/modals/delete_confirm');
		} 
		$this->template->render();
	}

#---------------------------------------------------------------------------------------------------------------------------------------------------------
public function report1()
	{
		#----------loading models
		$this->load->model('designations/designation_master_model','desig');
        $this->load->model('products/item_model','item');

		#----------voucher type
		$vtype_id = $this->vtype;
		$conditions = array('vtype_id' => $vtype_id,'status' => 1);
		$like_array = array();$vnos="";

		#----------voucher name
		$voucher_name = $this->vouchers->voucher_name($this->vtype);

		#----------voucher type array
		$voucher_types = $this->vouchers->voucher_types($this->vtype);

		#----------uri array
		$uri_array  = $this->uri->uri_to_assoc(3);

		#----------redirect
		$redirect = "";

		#----------pagination
		$this->load->library('pagination');
		$config['per_page'] = $this->per_page();
		$config['base_url'] = base_url('booking/report1');
		$config['uri_segment'] = 3;

		#----------dates within financial year
		$cur_date = date('Y-m-d');
		$from_date = $cur_date;
		$to_date = $cur_date;
		$cur_fiscal_yr = $this->dms->get_fiscal_year();
		if($from_date < $cur_fiscal_yr['start_date'] || $from_date > $cur_fiscal_yr['end_date'] || $to_date < $cur_fiscal_yr['start_date'] || $to_date > $cur_fiscal_yr['end_date'])
		{
			$from_date = $cur_fiscal_yr['end_date'];
			$to_date = $cur_fiscal_yr['end_date'];
		}

		#----------validation
		//$this->form_validation->set_rules('vtype_id','voucher-types','required|xss_clean');
		$this->form_validation->set_rules('from_date','From Date','required|xss_clean|valid_date');
		$this->form_validation->set_rules('to_date','To Date','required|xss_clean|valid_date');
	//	$this->form_validation->set_rules('bill_no','bill-no','xss_clean|trim');
		if($this->form_validation->run() === true)
		{
			//$vtype_id = $this->input->post('vtype_id',true);
			$from_date = date('Y-m-d',strtotime($this->input->post('from_date',true)));
			$to_date = date('Y-m-d',strtotime($this->input->post('to_date',true)));
			//$conditions['vtype_id'] = $vtype_id;
			//$config['base_url'] .= '/vt/'.$vtype_id.'/fdate/'.$from_date.'/tdate/'.$to_date;
			$config['base_url'] .= '/fdate/'.$from_date.'/tdate/'.$to_date;

			$config['uri_segment'] += 6;
			$redirect .= '/fdate/'.$from_date.'/tdate/'.$to_date;
			if(!empty($this->input->post('bill_no',true)))
			{
				$vnos = $this->input->post('bill_no',true);
				$like_array['bill_no'] = $vnos;
				$config['base_url'] .= '/vn/'.$vnos;
				$config['uri_segment'] += 2;
				$redirect .= '/vn/'.$vnos;
			}
            if(!empty($this->input->post('customer_id',true)))
			{
                $cust_ids = $this->input->post('customer_id',true);                                                                                   
                $conditions['customer_id'] = $cust_ids;                        
            }
		}
		//elseif(isset($uri_array['vt']))
		//{
			//$vtype_id = $uri_array['vt'];
			//$conditions['vtype_id'] = $vtype_id;
			//$config['base_url'] .= '/vt/'.$conditions['vtype_id'];
			//$config['uri_segment'] += 2;
			//$redirect .= '/vt/'.$vtype_id;
			if(isset($uri_array['fdate']) && isset($uri_array['tdate']))
			{
				$from_date = date('Y-m-d',strtotime($uri_array['fdate']));
				$to_date = date('Y-m-d',strtotime($uri_array['tdate']));
				$config['base_url'] .= '/fdate/'.$from_date.'/tdate/'.$to_date;
				$config['uri_segment'] += 4;
				$redirect .= '/fdate/'.$from_date.'/tdate/'.$to_date;
			}
			/*if(isset($uri_array['vn']))
			{
				$vnos = $uri_array['vn'];
				$like_array['bill_no'] = $vnos;
				$config['base_url'] .= '/vn/'.$vnos;
				$config['uri_segment'] += 2;
				$redirect .= '/vn/'.$vnos;
			}*/
		//}

		#----------between condition
		$between = "bill_date between '$from_date' and '$to_date'";

		#----------total rows

		$config['total_rows'] = $this->sales_obj->get_bills(array('columns' => array('id'),'conditions' => $conditions,'between' => $between,'like' => $like_array,'numrows'=>true));

		if($config['total_rows'] == 0)
		{
			$this->message->set($this->lang->line('no-voucher'),'i');
		}

		#----------pagination
		$offset = $this->uri->segment($config['uri_segment'],0);
		$this->pagination->initialize($config);
		$links = $this->pagination->create_links();
		$redirect .= '/'.$offset;

        $this->load->model('customers/customer_master_model','customer_master');
		$customers = $this->customer_master->listing();
        $customers['']= "Select";
        ksort($customers);

		#------------presumptive tax checking
		$presumptive_tax = $this->stock->get_tax_type();

		#----------sales report datas
		$sales_array=$this->sales_obj->get_bills(array('conditions' => $conditions,'between' => $between,'like' => $like_array,'order_by'=>'bill_no','order'=>'DESC','limit'=>$config['per_page'],'offset'=>$offset));

		#----------template
		$this->template->title("Booking Report");
		$this->template->main_heading($this->lang->line("$voucher_name")." ".$this->lang->line("booking")." ".$this->lang->line("report"));
		$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("$voucher_name")." ".$this->lang->line('booking') => 'booking/add',$this->lang->line('report') => 'no_link'));
		$this->template->slice('booking/search1',array('voucher_types' => $voucher_types,'vtype_id' => $vtype_id,'vnos' => $vnos,'from_date' => $from_date,'to_date' => $to_date,'rtype' => 'sales','customers'=>$customers,'cust'=>$cust_ids));
		$this->template->slice('dms/message');
		$this->template->other_script('sales/sales_order');
		if(!empty($sales_array))
		{
			$this->template->slice('booking/report1',array('sales_array' => $sales_array,'presumptive_tax' => $presumptive_tax,'offset' => $offset,'links' => $links,'vtype_id' => $conditions['vtype_id'],'redirect' => $redirect));
			$this->template->slice('dms/modals/delete_confirm');
		} 
		$this->template->render();
	}

#------------------------------------------------------------------------------end-----------------------------------------------------------------------
	public function view()
	{
		#----------voucher type
		$vtype_id = $this->vtype;

		$uri_array = $this->uri->uri_to_assoc(3);
		if(isset($uri_array['id']) || isset($uri_array['group_id']))
		{
			#----------voucher name
			$voucher_name = $this->vouchers->voucher_name($this->vtype);

			#----------breadcrumb
			$breadcrumb = array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("$voucher_name")." ".$this->lang->line("booking") => 'booking/add',$this->lang->line('report') => 'booking/report',$this->lang->line("view") => 'no_link');

			if($this->uri->segment(3) == 'group_id')
			{
				$conditions = array('a.group_id' => $this->uri->segment(4),'a.status !=' => 0,'b.status !=' => 0,'b.item_status >' => 0);
				if($this->uri->segment(5) && $this->uri->segment(5) == 'vt')
				{
					$breadcrumb_url = "daybooks/index/vt/".$this->uri->segment(6);
					$breadcrumb[$this->lang->line("go-back")] = $breadcrumb_url;
				}
				elseif($this->uri->segment(5) && ($this->uri->segment(5) == 'id' || $this->uri->segment(5) == 'mid' || $this->uri->segment(5) == 'sid'))
				{
					$breadcrumb_url = "stock_item_register/index/".$this->uri->segment(5)."/".$this->uri->segment(6);
					if($this->uri->segment(7) && $this->uri->segment(7) == 'rtype')
					{
						$breadcrumb_url .= "/rtype/".$this->uri->segment(8);
					}
					$breadcrumb[$this->lang->line("go-back")] = $breadcrumb_url;
				}
				elseif($this->uri->segment(5) && $this->uri->segment(5) == 'vp')
				{
					$breadcrumb[$this->lang->line("go-back")] = "vat_detailed_reports/index/ttyp/1/vp/".$this->uri->segment(6)."/fdate/".$this->uri->segment(8)."/tdate/".$this->uri->segment(10);
				}
				else
				{
					$breadcrumb_url = "ledger_reports/index/";
					if($this->uri->segment(5))
					{
						$breadcrumb_url .= $this->uri->segment(5);
					}
					if($this->uri->segment(6))
					{
						$breadcrumb_url .= "/sid/".$this->uri->segment(6);
					}
					if($this->uri->segment(7))
					{
						$breadcrumb_url .= "/tbp/".$this->uri->segment(7);
					}
					$breadcrumb[$this->lang->line("go-back")] = $breadcrumb_url;
				}
			}
			else
			{
				#----------sales primary key
				$sales_id = $uri_array['id'];
				unset($uri_array['id']);
				$conditions = array('a.id' => $sales_id,'a.status !=' => 0,'b.status !=' => 0,'b.item_status >' => 0);
				$breadcrumb[$this->lang->line("go-back")] = "booking/report/".$this->uri->assoc_to_uri($uri_array);
			}

			#----------sales data
            $sales_array = $this->sales_obj->get_sales(array('columns' => array('a.id as primary_id','a.vtype_id','a.branch_id','a.bill_no','a.bill_date','a.group_id','a.customer_type_id','a.customer_id','a.area_id','a.bill_discount_per','a.bill_discount_amt','a.bill_freight','a.other_expense','a.cess','a.narration','a.pricelist_id','a.payment_mode','a.cr_period','a.created_by','a.created_on','a.paid_amount','a.balance_amount','a.doctor','a.delivery_date','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.taxable_amt','b.discount_per','b.discount_amt','b.godown_id','b.cgst','b.sgst','b.cgst_amt','b.sgst_amt','b.cess_amt','b.vendor_id','b.lens_refno','b.lens_quantity'),'conditions' => $conditions));
                        
			if(!empty($sales_array))
			{
				#------------loading model
				$this->load->model('customers/customer_type_model','customer_type');			

				$voucher_type = $this->vouchers->voucher_name($sales_array[0]['vtype_id']);
				$customer_name = $this->stock->get_customer($sales_array[0]['customer_type_id'],$sales_array[0]['customer_id']);
				$vendor_name = $this->stock->vendor_name($sales_array[0]['vendor_id']);
				$lens_refno = $sales_array[0]['lens_refno'];
				$lens_qty = $sales_array[0]['lens_quantity'];
                $cust_qr = $this->dms->get_data(array('table' =>'customer_master','columns' => 'mobile_no','conditions' => array('id' => $sales_array[0]['customer_id'])));
                $cust_mob = $cust_qr[0]['mobile_no'];	
                $doctor = $sales_array[0]['doctor'];
                $paid_amt = $sales_array[0]['paid_amount'];
                $bal_amt = $sales_array[0]['balance_amount'];
                $del_date = $sales_array[0]['delivery_date'];	
				$pricelist = $this->customer_type->get_pricelist($sales_array[0]['pricelist_id']);
				$area_id = $this->dms->get_area($sales_array[0]['area_id']);
				$payment_mode = $this->stock->ledger_name($sales_array[0]['payment_mode']);
				$des_array = $this->sales_obj->get_description($sales_array[0]['group_id']);

				#--------------cheque / dd details
				$cd_status = 1;$ccd = $cd_no = $pdc = "";
				$cheque_dd_array = $this->vouchers->cheque_data(array('columns' => array('b.cash_type','b.cd_no','b.pdc'),'conditions' => array('a.table_name' => 'dms_booking','a.table_group_id' => $sales_array[0]['group_id'])));
				if(!empty($cheque_dd_array))
				{
					$cd_status = 0;
					$ccd = $cheque_dd_array[0]['cash_type'];
					$cd_no = $cheque_dd_array[0]['cd_no'];
					$pdc = $cheque_dd_array[0]['pdc'];
				}

				#----------template
				$this->template->title("Sales Booking Report");
				$this->template->main_heading($this->lang->line("$voucher_name")." ".$this->lang->line("view"));
				$this->template->breadcrumb($breadcrumb);
				$this->template->slice('dms/message');
				$this->template->slice('booking/view',array('sales_array' => $sales_array,'b_date'=>$b_date,'presumptive_tax' => $presumptive_tax,'sales_cst' => $sales_cst,'voucher_type' => $voucher_type,'customer_name' => $customer_name,'customer_mob'=>$cust_mob,'doctor'=>$doctor,'vendor_name'=>$vendor_name,'lens_refno'=>$lens_refno,'lens_qty'=>$lens_qty,'paid_amt'=>$paid_amt,'bal_amt'=>$bal_amt,'del_date'=>$del_date,'pricelist' => $pricelist,'area_id' => $area_id,'payment_mode' => $payment_mode,'cd_status' => $cd_status,'ccd' =>$ccd,'cd_no' =>$cd_no,'pdc' => $pdc,'des_array'=>$des_array));
				$this->template->other_script('sales/sales_order');
				$this->template->render();
			}
			else
			{
				redirect($breadcrumb[$this->lang->line("go-back")]);
			}
		}
		else
		{
			redirect('users/logout');
		}
	}

    public function update()
	{
		#----------voucher type 
		$vtype_id = $this->vtype;

		#----------sales primary key
		$uri_array = $this->uri->uri_to_assoc(3);
		if(isset($uri_array['id']))
		{
			$sales_id = $uri_array['id'];
			$redirect = "/".$this->uri->assoc_to_uri($uri_array);
			unset($uri_array['id']);

			#----------redirect uri
			$redirect_uri = "booking/report/".$this->uri->assoc_to_uri($uri_array);

			#----------redirect uri while updating
			$update_uri = $this->uri->assoc_to_uri($this->uri->uri_to_assoc(1));
			
			#------------cess %
		    $cess = $this->stock->get_cess();

			#----------voucher name
			$voucher_name = $this->vouchers->voucher_name($this->vtype);

			#------------bill group_id and date
			$item_details = $this->sales_obj->get_group($sales_id);

			#-------------adding items to sales bill
			if(isset($_POST['btn_add']))
			{
				#-----------validation
				$this->form_validation->set_rules('item_id','lang:item-name','required|xss_clean|is_natural_no_zero');
				//$this->form_validation->set_rules('godown_id','lang:godown','required|xss_clean');
				//$this->form_validation->set_rules('cst','lang:cst','xss_clean|greater_or_equal[0]|less_or_equal[100]');
				$this->form_validation->set_rules('qty','lang:quantity','required|xss_clean|greater_than[0]|less_than[100000000]');
				$this->form_validation->set_rules('unit_id','lang:unit','required|xss_clean');
				$this->form_validation->set_rules('rate','lang:rate','required|xss_clean|greater_or_equal[0]|less_than[100000000]');
				$this->form_validation->set_rules('amount','lang:amount','xss_clean|required|greater_or_equal[0]|less_than[100000000]');
				$this->form_validation->set_rules('discount_per','lang:discount %','xss_clean|greater_or_equal[0]|less_or_equal[100]');
				$this->form_validation->set_rules('discount_amt','lang:discount','xss_clean|greater_or_equal[0]|less_than[100000000]');

				#-----------adding items
				if($this->form_validation->run('btn_add') === true)
				{
					$item_array['group_id'] = $item_details['group_id'];
					$item_array['item_id'] = $this->input->post('item_id',true);
                    $item_array['hsn'] = $this->input->post('hsn',true);
					$item_array['qty'] = $this->input->post('qty',true);
					$item_array['unit_id'] = $this->input->post('unit_id',true);
					//$item_array['rate'] = $this->input->post('rate',true);
					$item_array['amount'] = $this->input->post('amount',true);
                    
					#----------rate calculation
					$item_array['rate'] = 0;
					if($item_array['qty'] != 0)
					{
						$item_array['rate'] = $item_array['amount'] / $item_array['qty'];
					}

					$item_array['discount_per'] = $this->input->post('discount_per',true);
					$item_array['discount_amt'] = $this->input->post('discount_amt',true);
					$item_array['godown_id'] = $this->stock->get_branch_godown($this->branchID); //$this->input->post('godown_id',true);
					$item_array['status'] = -1;
					$item_array['item_status'] = 2;//sales only items

					$sales_temp_item_result = $this->sales_obj->get_sales(array('columns' => array('b.id','a.bill_date'),'conditions' => array('b.group_id' => $item_array['group_id'],'item_id' => $item_array['item_id'],'godown_id' => $item_array['godown_id'],'unit_id' => $item_array['unit_id'],'a.status !=' => 0,'b.status !=' => 0,'b.item_status >' => 0),'numrows' => true));

					if($sales_temp_item_result == 0)
					{ 
						#----------TAX calculation
                        $sale_temp=$this->input->post('sales',true);
                        
                        $cgst = $this->stock->get_item_cgst($item_array['item_id']);
					    $sgst = $this->stock->get_item_sgst($item_array['item_id']);
                        
                        $item_array['taxable_amt'] = (($item_array['amount']-$item_array['discount_amt'])*100)/(100+$cgst+$sgst+$cess);
    					$item_array['cgst'] = $cgst;
    					$item_array['sgst'] = $sgst;
    					
    					$item_array['cgst_amt'] = ($item_array['taxable_amt'] * $cgst) / 100;
    					$item_array['sgst_amt'] = ($item_array['taxable_amt'] * $sgst) / 100;
    					$item_array['cess_amt'] = ($item_array['taxable_amt'] * $cess) / 100;

						#----------start transaction
						$this->db->trans_start();
                        $sales_items_id = $this->sales_obj->insert("dms_sales_items1",$item_array);
                                        
						if($sales_items_id)
						{ 
							#--------------updating bill status in dms_sales
							$this->sales_obj->update_others(array('table' => 'dms_booking','data' => array('status' => -1),'conditions' => array('group_id' => $item_array['group_id'])));

							#--------------adding stock balance in dms_stocks
						/*	$stock_bal = $this->stock->unit_conversion($item_array['item_id'],$item_array['unit_id'],$item_array['qty'],$item_array['rate'],$item_array['amount']);
							if($stock_bal)
							{*/
							//	$this->sales_obj->insert('dms_stocks',array('company_id' => $this->session->userdata('company_id'),'branch_id' => $this->session->userdata('under_id'),'godown_id' => $item_array['godown_id'],'item_id' => $item_array['item_id'],'qty' => $item_array['qty'],'unit_id' => $item_array['unit_id'],'rate' => $item_array['rate'],'amount' => $item_array['amount'],'stock_date' => $item_details['bill_date'],'stock_status' => 6,'table_group_id' => $item_array['group_id'],'table_id' => $sales_items_id));
						//	}
							$this->message->set($this->lang->line('sales-add-success'));
						}
						else
						{
							$this->message->set($this->lang->line('sales-add-error'),'e');
						}

						#----------end transaction
						$this->db->trans_complete();
					}
					else
					{ 
						$this->message->set($this->lang->line('sales-add-error'),'e');
					}
					redirect($update_uri);
				}
			}

			#------------saving sales voucher
			if(isset($_POST['btn_update']))
			{
				#-----------validation
				$this->form_validation->set_rules('bill_no','lang:bill-no',"required|xss_clean|callback_bill_no_exists[$item_details[vtype_id].$item_details[group_id]]");

				$row = $this->sales_obj->get_bills(array('columns' => array('sid','s_status'),'conditions' => array('id' => $sales_id,'s_status >' => 0)));
				if(!empty($row))
				{ 
					$this->load->library('sales_lib');
					$pre_bill_date = $this->sales_lib->get_bill_date($row[0]['sid'],$row[0]['s_status']);
					$this->form_validation->set_rules('bill_date','lang:bill-date',"required|xss_clean|valid_date|check_date[$pre_bill_date.>=]");
				}
				else
				{ 
					$this->form_validation->set_rules('bill_date','lang:bill-date','required|xss_clean|valid_date');
				}

				$this->form_validation->set_rules('sales[customer_id]','lang:customer-name','required|xss_clean');
                $this->form_validation->set_rules('sales[mobile]','lang:customer-name','xss_clean');
				$this->form_validation->set_rules('area_id','lang:area','required|xss_clean');
				$this->form_validation->set_rules('payment_mode','lang:payment-mode','required|xss_clean');
				if($this->input->post('payment_mode',true) == 2)
				{
					$this->form_validation->set_rules('credit_period','lang:credit-period','required|xss_clean|is_natural');
				}
				elseif($this->input->post('payment_mode',true) > 2)
				{
					$this->form_validation->set_rules('ccd','lang:transaction-type','xss_clean');
					$this->form_validation->set_rules('cd_no','lang:cd-no','xss_clean|max_length[64]');
					$this->form_validation->set_rules('cheque_date','lang:cheque-date',"xss_clean|is_date"); 
				}
				$this->form_validation->set_rules('remarks','lang:remarks','xss_clean');
				$this->form_validation->set_rules('freight','lang:freight','xss_clean|greater_or_equal[0]|less_than[100000000]');
				$this->form_validation->set_rules('other_expense','lang:other-expense','xss_clean|greater_or_equal[0]|less_than[100000000]');
				$this->form_validation->set_rules('bill_discount_per','lang:discount %','xss_clean|greater_or_equal[0]|less_or_equal[100]');
				$this->form_validation->set_rules('bill_discount_amt','lang:discount','xss_clean|greater_or_equal[0]|less_than[100000000]');

				if($this->form_validation->run('btn_update') === true)
				{ 
					$bill_date = date('Y-m-d',strtotime($this->input->post('bill_date',true)));
					$bill_no = $this->input->post('bill_no',true);
					$narration = $this->input->post('remarks',true);
					$payment_mode = $this->input->post('payment_mode',true);
                    $bill_advance = $this->input->post('bill_advance',true);
                    $del_date = date('Y-m-d',strtotime($this->input->post('d_date',true)));
					$bill_discount_amt = $this->input->post('bill_discount_amt',true);
					$bill_discount_per = $this->input->post('bill_discount_per',true);
					$old_per = $this->input->post('old_perc',true);
					$freight = $this->input->post('freight',true);
					$other_expense = $this->input->post('other_expense',true);
                    $amount = $this->input->post('grand_total',true);                                        
                    $vat = $this->input->post('vat_total',true);
                    $cesstotal = $this->input->post('cess_total',true);
                    $tot_amount = $amount+$vat+$cesstotal;
                    $tot_amount1 = get_rounded(($tot_amount*100)/(100-$old_per));
                    $bal_amt = round_this($tot_amount1-$bill_discount_amt-$bill_advance);
                    
                    $sales_entry_array['paid_amount']=$bill_advance;
                    $sales_entry_array['balance_amount']=$bal_amt;
                    $sales_temp_array = $this->input->post('sales',true);
                    $des_array = $this->input->post('des',true);

                    $customer_name = $sales_temp_array['customer_id'];
                    $cust_mob = $sales_temp_array['mobile'];
                    $cust_addr = $sales_temp_array['address'];
                    $cust_mail = $sales_temp_array['email_id'];
                    
                    $doctor = $this->input->post('doctor',true);
                    $user_id = $sales_temp_array['salesman'];
                    
                    $payment_mode = 0; $amount1 = 0;
                    if(!empty($this->input->post('amount1')) && !empty($this->input->post('payment_mode')))
                    {
                        $payment_mode = $this->input->post('payment_mode');
                        $amount1 = $this->input->post('amount1');
                    }
                        
                    $payment_mode2 = 0; $amount2 = 0;        
                    if(!empty($this->input->post('payment_mode2')) && !empty($this->input->post('amount2')))
                    {
                        $payment_mode2 = $this->input->post('payment_mode2');
                        $amount2 = $this->input->post('amount2');
                    }
                    
                    $customer_id = $this->sales_obj->save_customer(array('fname'=>$customer_name,'mobile_no'=>$cust_mob,'address'=>$cust_addr,'email_id'=>$cust_mail,'status'=>1));
                        
					$sales_entry_array=array('bill_no' => $bill_no,'bill_date' => $bill_date,'customer_type_id' => 2,'customer_id' => $customer_id,'doctor'=>$doctor,'user_id'=>$user_id,'area_id' => $this->input->post('area_id',true),'bill_discount_per' => $this->input->post('bill_discount_per',true),'bill_discount_amt' => $bill_discount_amt,'paid_amount'=>$bill_advance,'balance_amount'=>$bal_amt,'delivery_date'=>$del_date,'bill_freight' => $freight,'other_expense' => $other_expense,'cess' => $cess,'narration' => $narration,'payment_mode' => $payment_mode,'amount1'=>$amount1,'payment_mode2' => $payment_mode2,'amount2'=>$amount2,'cr_period' => $this->input->post('credit_period',true),'status' => 1);

					#----------start transaction
					$this->db->trans_start();
					$group_id1 = $item_details['group_id'];

					if($this->sales_obj->update(array('table' => 'dms_booking','data' => $sales_entry_array,'conditions' => array('id' => $sales_id))))
					{ 
					    $ldv1=$des_array['ldv1']; $ldv2=$des_array['ldv2']; $ldv3=$des_array['ldv3']; $ldv4=$des_array['ldv4']; $lnv1=$des_array['lnv1']; $lnv2=$des_array['lnv2']; $lnv3=$des_array['lnv3']; $lnv4=$des_array['lnv4']; $ladd=$des_array['ladd']; $lipg=$des_array['lipg']; $rdv1=$des_array['rdv1']; $rdv2=$des_array['rdv2']; $rdv3=$des_array['rdv3']; $rdv4=$des_array['rdv4'];
                        $rnv1=$des_array['rnv1']; $rnv2=$des_array['rnv2']; $rnv3=$des_array['rnv3']; $rnv4=$des_array['rnv4']; $radd=$des_array['radd']; $ripg=$des_array['ripg'];

                        $this->db->query("UPDATE doctor_description SET ldv1='$ldv1',ldv2='$ldv2',ldv3='$ldv3',ldv4='$ldv4',lnv1='$lnv1',lnv2='$lnv2',lnv3='$lnv3',lnv4='$lnv4',ladd='$ladd',lipg='$lipg',rdv1='$rdv1',rdv2='$rdv2',rdv3='$rdv3',rdv4='$rdv4',rnv1='$rnv1',rnv2='$rnv2',rnv3='$rnv3',rnv4='$rnv4',radd='$radd',ripg='$ripg' WHERE group_id='$item_details[group_id]'");
 
                        if($bill_discount_per>0)
                        {
                            $sales_items_array = $this->sales_obj->get_sales_items(array('columns' => array('id','item_id','qty','unit_id','rate','godown_id'),'conditions' => array('group_id' => $group_id1,'status!=' => 0,'item_status >' => 0)));
   						
    						foreach($sales_items_array as $key => $value)
    						{
    						    $it_up_id = $value['id'];
    						    $itid = $value['item_id']; 
    						    $itamt = $value['qty']*$value['rate'];
    						    $itdiscamt = ($itamt*$bill_discount_per)/100;
    						    $it_cgst = $this->stock->get_item_cgst($itid);
    						    $it_sgst = $this->stock->get_item_sgst($itid);
    						    
    						    $it_taxable = (($itamt-$itdiscamt)*100)/(100+$it_cgst+$it_sgst+$cess);
    						    $it_cgst_amt = ($it_taxable*$it_cgst)/100; 
    						    $it_sgst_amt = ($it_taxable*$it_sgst)/100; 
    						    $it_cess_amt = ($it_taxable*$cess)/100; 
    						    
    						    $it_up_array = array('discount_per'=>$bill_discount_per,'discount_amt'=>$itdiscamt,'taxable_amt'=>$it_taxable,'cgst'=>$it_cgst,'sgst'=>$it_sgst,'cgst_amt'=>$it_cgst_amt,'sgst_amt'=>$it_sgst_amt,'cess_amt'=>$it_cess_amt);
    						
    						    $this->sales_obj->update(array('table' => 'dms_sales_items1','data' => $it_up_array,'conditions' => array('id' => $it_up_id)));
    						}
                        }
 
 
						$this->sales_obj->update_others(array('table' => 'dms_sales_items1','data' => array('status' => 1),'conditions' => array('group_id' => $item_details['group_id'],'status !=' => 0,'item_status >' => 0)));

					//	$this->sales_obj->update_others(array('table' => 'dms_stocks','data' => array('status' => 1,'stock_date'=>$bill_date),'conditions' => "table_group_id = ".$item_details['group_id']." and (stock_status = 5 or stock_status = 6)"));

						$user_points = 0;$user_type = "";
						if($sales_entry_array['customer_type_id'] == 2)//customer
						{
							$user_id = $sales_entry_array['user_id'];
							$designation_id = $this->dms->get_desig($user_id);
							if($designation_id == 4)
							{
								$user_type = "c";
							}
							elseif($designation_id == 5)
							{
								$user_type = "m";
							}
							elseif($designation_id == 6)
							{
								$user_type = "e";
							}
							$customer = $this->dms->get_data(array('table' => 'customer_master','columns' => 'ledger_id','conditions' => array('id' => $sales_entry_array['customer_id'])));
						}
						else//branch or AR
						{
							$des_id = $sales_entry_array['customer_type_id'];
							$user_id = $sales_entry_array['user_id'];
                                                       
							if($des_id == 3)
							{
								$customer = $this->dms->get_data(array('table' => 'retailer_master','columns' => 'ledger_id','conditions' => array('id' => $sales_entry_array['customer_id'])));
							}
							else
							{
								$customer = $this->dms->get_data(array('table' => 'branch_master','columns' => 'ledger_id','conditions' => array('id' => $sales_entry_array['customer_id'])));
							}
                            
                            $designation_id = $this->dms->get_desig($user_id);
							if($designation_id == 4)
							{
								$user_type = "c";
							}
							elseif($designation_id == 5)
							{
								$user_type = "m";
							}
							elseif($designation_id == 6)
							{
								$user_type = "e";
							}
						}

						#-------------adding bill to dms_vouchers
						$voucher_status = 1;
						$voucher_amount = $bill_advance;//$this->input->post('grand_total',true);
						$round_off_amount = $this->input->post('round_off_amount',true);
						$vat_amount = $this->input->post('vat_total',true);
						$cess_amount = $this->input->post('cess_total',true);
						if($payment_mode > 2)
						{
							$bill_date_time = strtotime($bill_date);
							$cheque_date = date('Y-m-d',strtotime($this->input->post('cheque_date',true)));
							$cheque_date_time = strtotime($cheque_date);
							if($this->input->post('ccd',true) == 1 && $cheque_date_time > $bill_date_time)
							{
								$voucher_status = 3;
							}
						}
						elseif($payment_mode == 2){
							$payment_mode = $customer[0]['ledger_id'];
						}
					//	$voucher_amount -= $bill_discount_amt;
					//	$voucher_amount += $round_off_amount;

						$voucher_data = $this->dms->get_data(array('table' => 'dms_vouchers','columns' => array('id','group_id'),'conditions' => array('table_name' => 'dms_booking','table_group_id' => $item_details['group_id']),'order_by' => 'vorder_no','order' => 'asc','limit' => 1,'offset' => 0));
						if(empty($voucher_data))
						{
							$voucher_group_id = $this->stock->get_group_id('dms_vouchers');							
                            $voucher_array = array('company_id' => $this->session->userdata('company_id'),'branch_id' => $this->session->userdata('under_id'),'group_id' => $voucher_group_id,'vtype_id' => $item_details['vtype_id'],'vno' => $item_details['group_id'],'vorder_no' => 1,'vdate' => $bill_date,'dr_ledger' => $payment_mode,'cr_ledger' => 20,'vamount' => $voucher_amount,'narration' => $narration,'table_name' => 'dms_booking','table_group_id' => $item_details['group_id'],'status' => $voucher_status);
							$voucher_success = $this->sales_obj->insert('dms_vouchers',$voucher_array);
							if($voucher_success)
							{
								#-----------VAT
							/*	$voucher_array['cr_ledger'] = 12;
								$voucher_array['vorder_no'] = 2;
								$voucher_array['vamount'] = $vat_amount;
								$this->sales_obj->insert('dms_vouchers',$voucher_array);
								#-----------CESS
								$voucher_array['cr_ledger'] = 15;
								$voucher_array['vorder_no'] = 3;
								$voucher_array['vamount'] = $cess_amount;
								$this->sales_obj->insert('dms_vouchers',$voucher_array);
								#-----------Freight
								$voucher_array['dr_ledger'] = 13;
								$voucher_array['cr_ledger'] = $payment_mode;
								$voucher_array['vorder_no'] = 4;
								$voucher_array['vamount'] = $freight;
								$this->sales_obj->insert('dms_vouchers',$voucher_array);
								#-----------Other Expense
								$voucher_array['dr_ledger'] = 14;
								$voucher_array['vorder_no'] = 5;
								$voucher_array['vamount'] = $other_expense;
								$this->sales_obj->insert('dms_vouchers',$voucher_array); */
 
								if($payment_mode > 2)
								{
									$this->sales_obj->insert('dms_voucher_banks',array('group_id' => $voucher_group_id,'cash_type' => $this->input->post('ccd',true),'cd_no' => $this->input->post('cd_no',true),'pdc' => $cheque_date,'vdate' => $bill_date));
								}
							}
						}
						else
						{
							$voucher_array = array('vno' =>$item_details['group_id'],'vdate' => $bill_date,'dr_ledger' => $payment_mode,'vamount' => $voucher_amount,'narration' => $narration,'status' => $voucher_status);
							$voucher_success = $this->sales_obj->update_others(array('table' => 'dms_vouchers','data' => $voucher_array,'conditions' => array('id' => $voucher_data[0]['id'])));
							if($voucher_success)
							{
								#-----------VAT
							/*	$voucher_array['vamount'] = $vat_amount;
								$this->sales_obj->update_others(array('table' => 'dms_vouchers','data' => $voucher_array,'conditions' => array('group_id' => $voucher_data[0]['group_id'],'cr_ledger' => 12)));
								#-----------CESS
								$voucher_array['vamount'] = $cess_amount;
								$this->sales_obj->update_others(array('table' => 'dms_vouchers','data' => $voucher_array,'conditions' => array('group_id' => $voucher_data[0]['group_id'],'cr_ledger' => 15)));
								#-----------Freight
								$voucher_array['cr_ledger'] = $payment_mode;
								unset($voucher_array['dr_ledger']);
								$voucher_array['vamount'] = $freight;
								$this->sales_obj->update_others(array('table' => 'dms_vouchers','data' => $voucher_array,'conditions' => array('group_id' => $voucher_data[0]['group_id'],'dr_ledger' => 13)));
								#-----------Other Expense
								$voucher_array['vamount'] = $other_expense;
								$this->sales_obj->update_others(array('table' => 'dms_vouchers','data' => $voucher_array,'conditions' => array('group_id' => $voucher_data[0]['group_id'],'dr_ledger' => 14))); */

								if($payment_mode > 2)
								{
									if($this->dms->get_data(array('table' => 'dms_voucher_banks','columns' => array('id'),'conditions' => array('group_id' => $voucher_data[0]['group_id']),'numrows' => true)) == 0)
									{
										$this->sales_obj->insert('dms_voucher_banks',array('group_id' => $voucher_data[0]['group_id'],'cash_type' => $this->input->post('ccd',true),'cd_no' => $this->input->post('cd_no',true),'pdc' => $cheque_date,'vdate' => $bill_date));
									}
									else
									{
										$this->sales_obj->update_others(array('table' => 'dms_voucher_banks','data' => array('cash_type' => $this->input->post('ccd',true),'cd_no' => $this->input->post('cd_no',true),'pdc' => $cheque_date,'vdate' => $bill_date),'conditions' => array('group_id' => $voucher_data[0]['group_id'])));
									}
								}
							}
						}

						$this->message->set($this->lang->line('sales-edit-success'));
					}
					else
					{
						$this->message->set($this->lang->line('sales-edit-error'),'e');
					}

					#----------end transaction
					$this->db->trans_complete();

					redirect('booking/report');
				}
			}

			#----------sales data
            $sales_array = $this->sales_obj->get_sales(array('columns' => array('a.vtype_id','a.bill_no','a.bill_date','a.group_id','a.customer_type_id','a.customer_id','a.area_id','a.bill_discount_per','a.bill_discount_amt','a.bill_freight','a.other_expense','a.cess','a.narration','a.pricelist_id','a.payment_mode','a.amount1','a.payment_mode2','a.amount2','a.cr_period','a.status','a.bill_status','a.created_by','a.paid_amount','a.balance_amount','a.doctor','a.user_id','a.delivery_date','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.taxable_amt','b.discount_per','b.discount_amt','b.cgst','b.sgst','b.godown_id','b.cgst_amt','b.sgst_amt','b.cess_amt'),'conditions' => array('a.id' => $sales_id,'a.status !=' => 0,'b.status !=' => 0,'b.item_status >' => 0)));        

			#----------template
			if(!empty($sales_array))
			{
			    $grid = $sales_array[0]['group_id'];
			    $des_array = $this->sales_obj->get_description($grid);
				if($sales_array[0]['bill_status'] >= 2)
				{
					$this->message->set($this->lang->line('bill-already-converted'),'e');
					redirect($redirect_uri);
				}
				$continue = 1;
				if($sales_array[0]['status'] == -1)
				{
					if($sales_array[0]['created_by'] != $this->session->userdata('id'))
					{
						$continue = 0;
					}
				}
				if($continue == 1)
				{
					$stock_count="";$primary_unit['symbol']="";

					#------------loading model
					$this->load->model('designations/designation_master_model','desig');
					$this->load->model('customers/customer_type_model','customer_type');
					$this->load->model('areas/area_model','area');

					#------------customer type and customer details
					$user_types = array();$desig_id="";$user="";$users=array();
					if($this->branch_status)
					{
						$customerTypes = $this->desig->listing(array('department_id'=>0,'utype_status >'=>1));

						#------------customer details
						if($sales_array[0]['customer_type_id'] == 1)
						{
							$this->load->model('branches/branch_model','branches');
							$customers = $this->branches->listing(array('id !='=>$this->session->userdata('under_id')));
						}
						else if($sales_array[0]['customer_type_id'] ==2)
						{
							$this->load->model('customers/customer_master_model','customer_master');
							$customers = $this->customer_master->listing();
							#array('conditions'=>array('branch_id'=>$this->session->userdata('under_id')))
							#------------usertype details
							$user_types = $this->desig->listing(array('utype_status' => 1));
							if($sales_array[0]['user_id'] > 0)
							{
								$user = $sales_array[0]['user_id'];
								$desig_id = $this->dms->get_desig($sales_array[0]['user_id']);

								#------------user details
								$users = $this->dms->get_users(array('conditions' => array('designation_id' => $desig_id,'branch_id' => $this->session->userdata('under_id'))));
							}
						}
						else
						{
							$this->load->model('retailers/counter_model','retailer_master');
							$customers = $this->retailer_master->listing(array('company_id'=>$this->session->userdata('company_id')));
                            $user_types = $this->desig->listing(array('utype_status' => 1));
                            if($sales_array[0]['user_id'] > 0)
							{
								$user = $sales_array[0]['user_id'];
								$desig_id = $this->dms->get_desig($sales_array[0]['user_id']);

								#------------user details
								$users = $this->dms->get_users(array('conditions' => array('designation_id' => $desig_id,'branch_id' => $this->session->userdata('under_id'))));
							}
						}
					}
					else
					{
						$customerTypes = $this->desig->listing(array('id' => 2));
						$this->load->model('customers/customer_master_model','customer_master');
						$customers = $this->customer_master->listing(array('conditions'=>array('branch_id'=>$this->session->userdata('under_id'))));

						#------------usertype details
						$user_types = $this->desig->listing(array('utype_status' => 1));
						if($sales_array[0]['user_id'] > 0)
						{
							$user = $sales_array[0]['user_id'];
							$desig_id = $this->dms->get_desig($sales_array[0]['user_id']);

							#------------user details
							$users = $this->dms->get_users(array('conditions' => array('designation_id' => $desig_id,'branch_id' => $this->session->userdata('under_id'))));
						}
					}

					#------------pricelist details
					$pricelists = $this->customer_type->listing();

					#------------area details
					$areas = $this->area->listing();

					#------------payment modes
					$payment_modes = $this->stock->payment_modes();
					
					$item_groups = $this->item->item_group_listing();
                    $item_groups[''] = 'Select';ksort($item_groups);
                    $units1 = $this->unit->listing();

					#------------item details / unit details / godown details
					$units = array();$goDowns = array();
					$units[''] = "Select";
					$args['select'] = array('id','item_code','item_name');
					 $items = $this->stock->get_stock_items($args);
					//$items = $this->stock->get_branch_stock_items();
					if(empty($items))
					{
						$this->message->set($this->lang->line('no-items-found'),'i');
					}
					if($this->input->post('item_id',true))
					{
						$itemID = $this->input->post('item_id',true);
						$goDowns = $this->stock->get_item_godowns(array('item_id'=>$itemID,'listing'=>1));
						$units = $this->stock->get_units($itemID);
					}

					#------------stock count of this item
					if($this->input->post('item_id',true) &&  $sales_array[0]['bill_date'] != "")
					{
						$stock_count = $this->stock->get_stock_count($this->stock->get_branch_godown($this->branchID),$this->input->post('item_id',true),$sales_array[0]['bill_date']);
						$primary_unit = $this->stock->get_primary_unit($this->input->post('item_id',true));
					}

					$voucher_type = $this->vouchers->voucher_name($sales_array[0]['vtype_id']);

					#--------------cheque / dd details
					$cd_status = 1;$ccd = $cd_no = $pdc = "";
					$cheque_dd_array = $this->vouchers->cheque_data(array('columns' => array('b.cash_type','b.cd_no','b.pdc'),'conditions' => array('a.table_name' => 'dms_booking','a.table_group_id' => $sales_array[0]['group_id'])));
					if(!empty($cheque_dd_array))
					{
						$cd_status = 0;
						$ccd = $cheque_dd_array[0]['cash_type'];
						$cd_no = $cheque_dd_array[0]['cd_no'];
						$pdc = $cheque_dd_array[0]['pdc'];
					}
					
					$branch_det = $this->db->select(array('id','branch_name','ledger_id','area_id','minus_stock_entry'))->from('branch_master')->where('id',$this->branchID)->get()->row_array();
                    $branch_area = $branch_det['area_id'];
                    $minus_stock = $branch_det['minus_stock_entry'];
					
					#------------salesman
					$user_ids = $sales_array[0]['user_id'];
					$unmae = $this->sales_obj->listing();
					#------------customer
            		$cust_id = $sales_array[0]['customer_id'];
                    $this->load->model('customers/customer_master_model','customer_master');
                    $args = array('conditions'=>array('id'=>$cust_id));
                    $cust_data = $this->customer_master->get($args);
                    $cust_name = $cust_data[0]['fname'];
                    $cust_mob = $cust_data[0]['mobile_no'];
                    $cust_addr = $cust_data[0]['address'];
                    $cust_mail = $cust_data[0]['email_id'];
                       
            		#------------user
                    $doctor = $sales_array[0]['doctor'];
                    
                    $cust_qr = $this->dms->get_data(array('table' =>'customer_master','columns' => 'mobile_no,fname','conditions' => array('id' => $sales_array[0]['customer_id'])));
                    $cust_mob = $cust_qr[0]['mobile_no'];
                    $cust_name = $cust_qr[0]['fname']; 
                    $paid_amt = $sales_array[0]['paid_amount'];
                    $del_date = $sales_array[0]['delivery_date'];
					$areas[''] = 'Select';ksort($areas);
					$customers[''] = "Select";ksort($customers);
					$user_types[''] = "Select";ksort($user_types);
					$pricelists[''] = 'Select';ksort($pricelists);
					$items[''] = 'Select';ksort($items);
					$goDowns[''] = 'Select';ksort($goDowns);
					$users[''] = 'Select';ksort($users);
					
					$this->template->title("Edit Booking");
					$this->template->main_heading($this->lang->line("edit")." ".$this->lang->line("booking"));
					$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("$voucher_name")." ".$this->lang->line("booking") => 'booking/add',$this->lang->line('report') => 'booking/report',$this->lang->line("update") => 'no_link',$this->lang->line("go-back") => array($redirect_uri)));
					$this->template->slice('dms/message');
					$this->template->slice('booking/edit',array('sales_array' => $sales_array,'presumptive_tax' => $presumptive_tax,'sales_cst' => $sales_cst,'voucher_type' => $voucher_type,'desig_id' => $desig_id,'b_date'=>$b_date,'user' => $user,'price_list_id' => $sales_array[0]['pricelist_id'],'area_id' => $sales_array[0]['area_id'],'payment_mode' => $sales_array[0]['payment_mode'],'voucher_name' => $voucher_name,'customerTypes' => $customerTypes,'customers' => $customers,'cust_name' => $cust_name,'cust_mob'=>$cust_mob,'cust_addr'=>$cust_addr,'cust_mail'=>$cust_mail,'doctor'=>$doctor,'paid_amt'=>$paid_amt,'del_date'=>$del_date,'pricelists' => $pricelists,'areas' => $areas,'payment_modes' => $payment_modes,'items' => $items,'goDowns' => $goDowns,'units' => $units,'stock_count' => $stock_count,'primary_unit' => $primary_unit['symbol'],'cd_status' => $cd_status,'ccd' => $ccd,'cd_no' => $cd_no,'pdc' => $pdc,'redirect' => $redirect,'des_array'=>$des_array,'groups'=>$item_groups,'units1'=>$units1,'minus_stock'=>$minus_stock,'user_name'=>$unmae,'user_id'=>$user_ids));
					$this->template->other_script('sales/sales_order');
					$this->template->render();
				}
				else
				{
					redirect('users/logout');
				}
			}
			else
			{
			    redirect('users/logout');
			}
		}
		else
		{
	        redirect('users/logout');
		} 
	}

	public function delete()
	{
		#----------delivery primary key
		$uri_array = $this->uri->uri_to_assoc(3);
		if(isset($uri_array['id']))
		{
			$id = $uri_array['id'];
			unset($uri_array['id']);

			#----------redirect uri
			$redirect_uri = "booking/report/".$this->uri->assoc_to_uri($uri_array);

			$result = $this->sales_obj->get_sales(array('columns' => array('a.group_id','a.status','a.created_by','b.id'),'conditions' => array('a.id' => $id)));
			if(!empty($result))
			{
				$row = $result[0];$continue = 1;
				if($row['status'] == -1){
					if($row['created_by'] != $this->session->userdata('id')){
						$continue = 0;
					}
				}
				if($continue == 1)
				{
					if($this->sales_obj->update_others(array('table' => 'dms_booking','data' => array('status' => 0),'conditions' => array('id' => $id))))
					{
                                                $this->sales_obj->update_others(array('table' => 'dms_vouchers','data' => array('status' => 0),'conditions' => array('table_name' => 'dms_booking','table_group_id' => $row['group_id'])));

						#-------------deleting sales_items
						$this->sales_obj->update_others(array('table' => 'dms_sales_items1','data' => array('status' => 0),'conditions' => array('group_id' => $row['group_id'])));

					/*	foreach($result as $key => $value)
						{
							#-------------deleting stock bal. from dms_stocks
							$this->sales->update_others(array('table' => 'dms_stocks','data' => array('status' => 0),'conditions' => array('table_id' => $value['id'],'stock_status' => 5)));
						} */

                        $this->sales_obj->delete(array('table' => 'doctor_description','conditions' => array('group_id' => $row['group_id'])));

						$this->message->set($this->lang->line('delivery-delete-success'));
					}
					else
					{
						$this->message->set($this->lang->line('delivery-delete-error'),'e');
					}
				}
				else
				{
					redirect('users/logout');
				}
			}
			redirect($redirect_uri);
		}
		redirect('users/logout');
	}

	#------------------------------------------------------------------------------------
	
	public function cancel()
	{
		#----------delivery primary key
		$uri_array = $this->uri->uri_to_assoc(3);
		if(isset($uri_array['id']))
		{
			$id = $uri_array['id'];
			unset($uri_array['id']);

			#----------redirect uri
			$redirect_uri = "booking/report/".$this->uri->assoc_to_uri($uri_array);

			$result = $this->sales_obj->get_sales(array('columns' => array('a.group_id','a.status','a.created_by','b.id'),'conditions' => array('a.id' => $id)));
			if(!empty($result))
			{
				$row = $result[0];$continue = 1;
				if($row['status'] == -1){
					if($row['created_by'] != $this->session->userdata('id')){
						$continue = 0;
					}
				}
				if($continue == 1)
				{
					if($this->sales_obj->update_others(array('table' => 'dms_booking','data' => array('status' => 2),'conditions' => array('id' => $id))))
					{
                                                $this->sales_obj->update_others(array('table' => 'dms_vouchers','data' => array('status' => 2),'conditions' => array('table_name' => 'dms_booking','table_group_id' => $row['group_id'])));

						#-------------deleting sales_items
						$this->sales_obj->update_others(array('table' => 'dms_sales_items1','data' => array('status' => 2),'conditions' => array('group_id' => $row['group_id'])));

					/*	foreach($result as $key => $value)
						{
							#-------------deleting stock bal. from dms_stocks
							$this->sales->update_others(array('table' => 'dms_stocks','data' => array('status' => 0),'conditions' => array('table_id' => $value['id'],'stock_status' => 5)));
						} */
						//$this->sales_obj->update_others(array('table' => 'doctor_description','data' => array('status' => 2),'conditions' => array('group_id' => $row['group_id'])));

                                                //$this->sales_obj->delete(array('table' => 'doctor_description','conditions' => array('group_id' => $row['group_id'])));

						$this->message->set($this->lang->line('delivery-cancel-success'));
					}
					else
					{
						$this->message->set($this->lang->line('delivery-cancel-error'),'e');
					}
				}
				else
				{
					redirect('users/logout');
				}
			}
			redirect($redirect_uri);
		}
		redirect('users/logout');
	}
    #------------------------------------------------------------------------------------
	public function pdf(){

		$pdf_name = 'sales booking';
		$pdf_contents = '';
		if(!$this->uri->segment(4)){
			echo "<script>alert('".$this->lang->line('invalid-sales-bill')."');window.close();</script>";
		}
		$sales_id = $this->uri->segment(4);
		if($this->if_exists('dms_booking',array('id'=>$sales_id,'status'=>1)) === false){
			echo "<script>alert('".$this->lang->line('invalid-sales-bill')."');window.close();</script>";
		}

		#----------voucher type
		$vtype_id = $this->vtype;

		#----------voucher name
		$voucher_name = $this->vouchers->voucher_name($this->vtype);
		$this->load->library('my_pdf');
		$this->load->library('to_words');


		$this->load->model('sales/sales_vehicle_model','sales_vehicle');
		$this->load->library('my_pdf');
		$this->load->library('to_words');

		#----------sales data
	
        $sales_array = $this->sales_obj->get_sales(array('columns' => array('a.vtype_id','a.bill_no','a.bill_date','a.group_id','a.customer_type_id','a.customer_id','a.area_id','a.bill_discount_per','a.bill_discount_amt','a.bill_freight','a.other_expense','a.cess','a.narration','a.pricelist_id','a.payment_mode','a.cr_period','a.doctor','a.narration','a.paid_amount','a.balance_amount','a.delivery_date','a.created_by','a.created_on','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.taxable_amt','b.discount_per','b.hsn','b.discount_amt','b.godown_id','b.cgst','b.sgst','b.cgst_amt','b.sgst_amt','b.cess_amt'),'conditions' => array('a.id' => $sales_id,'a.status !=' => 0,'b.status !=' => 0,'b.item_status >' => 0)));
        $bill_date=$sales_array[0]['bill_date'];

        $group_id = $sales_array[0]['group_id'];
        $doctor = $sales_array[0]['doctor']; 
        
        $des_array = $this->sales_obj->get_description($group_id);
		if(empty($sales_array)){
			echo "<script>alert('".$this->lang->line('invalid-sales-bill')."');window.close();</script>";
		}else{
			#------------loading model
			$this->load->model('customers/customer_type_model','customer_type');
			
			#------------checking cst enabled or not
			$pdf_name = 'sales_bill_'.$sales_array[0]['bill_no'];

                        $deoctor = $sales_array[0]['doctor'];
                        $paid_amt = $sales_array[0]['paid_amount'];
		        $bal_amt = $sales_array[0]['balance_amount'];
                        $del_date = $sales_array[0]['delivery_date'];

			$voucher_type = $this->vouchers->voucher_name($sales_array[0]['vtype_id']);
			$customer_name = $this->stock->get_customer($sales_array[0]['customer_type_id'],$sales_array[0]['customer_id']);
			
			$pricelist = $this->customer_type->get_pricelist($sales_array[0]['pricelist_id']);
			$area_id = $this->dms->get_area($sales_array[0]['area_id']);
			$payment_mode = $this->stock->ledger_name($sales_array[0]['payment_mode']);
			$pdf_file = 'sales_bill_ar_pdf';

			

			if($sales_array[0]['customer_type_id'] == 2){
				$pdf_file = 'sales_bill_pdf';

			}else{
				$this->my_pdf->set_tin();
			}

			$this->my_pdf->set_header();

			$pdf_contents = $this->load->view('booking/'.$pdf_file,array('sales_array' => $sales_array,'presumptive_tax' => $presumptive_tax,'voucher_type' => $voucher_type,'bill_date'=>$bill_date,'customer_name' => $customer_name,'pricelist' => $pricelist,'area_id' => $area_id,'payment_mode' => $payment_mode,'paid_amount'=>$paid_amt,'bal_amount'=>$bal_amt,'del_date'=>$del_date,'doctor'=>$doctor,'des_array'=>$des_array),true);
		}
ob_clean();
		$this->my_pdf->output($pdf_name,$pdf_contents);
	}
	#-----------------------------------------------------------------------------

    public function print_bill(){
		
		if(!$this->uri->segment(4))
		{
			echo "<script>alert('".$this->lang->line('invalid-sales-bill')."');window.close();</script>";
		}
		$sales_id = $this->uri->segment(4);
		if($this->if_exists('dms_booking',array('id'=>$sales_id,'status'=>1)) === false)
		{
			echo "<script>alert('".$this->lang->line('invalid-sales-bill')."');window.close();</script>";
		}

		#----------voucher type
		$vtype_id = $this->vtype;

		#----------voucher name
		$voucher_name = $this->vouchers->voucher_name($this->vtype);
		$this->load->library('to_words');	

		#----------sales data
	
        $sales_array = $this->sales_obj->get_sales(array('columns' => array('a.vtype_id','a.bill_no','a.bill_date','a.group_id','a.customer_type_id','a.customer_id','a.area_id','a.bill_discount_per','a.bill_discount_amt','a.bill_freight','a.other_expense','a.cess','a.narration','a.pricelist_id','a.payment_mode','a.cr_period','a.doctor','a.narration','a.paid_amount','a.balance_amount','a.delivery_date','a.created_by','a.created_on','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.taxable_amt','b.discount_per','b.hsn','b.discount_amt','b.godown_id','b.cgst','b.sgst','b.cgst_amt','b.sgst_amt','b.cess_amt'),'conditions' => array('a.id' => $sales_id,'a.status !=' => 0,'b.status !=' => 0,'b.item_status >' => 0)));
                
        $bill_date=$sales_array[0]['bill_date'];
        $group_id = $sales_array[0]['group_id'];
        $doctor = $sales_array[0]['doctor']; 
        $des_array = $this->sales_obj->get_description($group_id);
		if(empty($sales_array))
		{
			echo "<script>alert('".$this->lang->line('invalid-sales-bill')."');window.close();</script>";
		}
		else
		{
			#------------loading model
			$this->load->model('customers/customer_type_model','customer_type');
			
			#------------checking cst enabled or not			

            $deoctor = $sales_array[0]['doctor'];
            $paid_amt = $sales_array[0]['paid_amount'];
		    $bal_amt = $sales_array[0]['balance_amount'];
            $del_date = $sales_array[0]['delivery_date'];

			$voucher_type = $this->vouchers->voucher_name($sales_array[0]['vtype_id']);
			$customer_name = $this->stock->get_customer($sales_array[0]['customer_type_id'],$sales_array[0]['customer_id']);
			
			$pricelist = $this->customer_type->get_pricelist($sales_array[0]['pricelist_id']);
			$area_id = $this->dms->get_area($sales_array[0]['area_id']);
			$payment_mode = $this->stock->ledger_name($sales_array[0]['payment_mode']);						
			$pdf_file = 'print_bill';
			
			$this->load->view('booking/print_bill',array('sales_array' => $sales_array,'voucher_type' => $voucher_type,'bill_date'=>$bill_date,'customer_name' => $customer_name,'pricelist' => $pricelist,'area_id' => $area_id,'payment_mode' => $payment_mode,'paid_amount'=>$paid_amt,'bal_amount'=>$bal_amt,'del_date'=>$del_date,'doctor'=>$doctor,'des_array'=>$des_array));
		}		
	}

    public function print_med_bill(){
		
		if(!$this->uri->segment(4))
		{
			echo "<script>alert('".$this->lang->line('invalid-sales-bill')."');window.close();</script>";
		}
		$sales_id = $this->uri->segment(4);
		if($this->if_exists('dms_booking',array('id'=>$sales_id,'status'=>1)) === false)
		{
			echo "<script>alert('".$this->lang->line('invalid-sales-bill')."');window.close();</script>";
		}

		#----------voucher type
		$vtype_id = $this->vtype;

		#----------voucher name
		$voucher_name = $this->vouchers->voucher_name($this->vtype);
		$this->load->library('to_words');	

		#----------sales data
	
        $sales_array = $this->sales_obj->get_sales(array('columns' => array('a.vtype_id','a.bill_no','a.bill_date','a.group_id','a.customer_type_id','a.customer_id','a.area_id','a.bill_discount_per','a.bill_discount_amt','a.bill_freight','a.other_expense','a.cess','a.narration','a.pricelist_id','a.payment_mode','a.cr_period','a.doctor','a.narration','a.paid_amount','a.balance_amount','a.delivery_date','a.created_by','a.created_on','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.discount_per','b.hsn','b.discount_amt','b.godown_id','b.cgst','b.sgst','b.cgst_amt','b.sgst_amt'),'conditions' => array('a.id' => $sales_id,'a.status !=' => 0,'b.status !=' => 0,'b.item_status >' => 0)));
                
        $bill_date=$sales_array[0]['bill_date'];
        $group_id = $sales_array[0]['group_id'];
        $doctor = $sales_array[0]['doctor']; 
        $des_array = $this->sales_obj->get_description($group_id);
        
		if(empty($sales_array))
		{
			echo "<script>alert('".$this->lang->line('invalid-sales-bill')."');window.close();</script>";
		}
		else
		{
			#------------loading model
			$this->load->model('customers/customer_type_model','customer_type');
			
			#------------checking cst enabled or not			

            $deoctor = $sales_array[0]['doctor'];
            $paid_amt = $sales_array[0]['paid_amount'];
		    $bal_amt = $sales_array[0]['balance_amount'];
            $del_date = $sales_array[0]['delivery_date'];

			$voucher_type = $this->vouchers->voucher_name($sales_array[0]['vtype_id']);
			$customer_name = $this->stock->get_customer($sales_array[0]['customer_type_id'],$sales_array[0]['customer_id']);
			
			$pricelist = $this->customer_type->get_pricelist($sales_array[0]['pricelist_id']);
			$area_id = $this->dms->get_area($sales_array[0]['area_id']);
			$payment_mode = $this->stock->ledger_name($sales_array[0]['payment_mode']);						
			$pdf_file = 'print_med_bill';			
			$this->load->view('booking/print_med_bill',array('sales_array' => $sales_array,'voucher_type' => $voucher_type,'bill_date'=>$bill_date,'customer_name' => $customer_name,'pricelist' => $pricelist,'area_id' => $area_id,'payment_mode' => $payment_mode,'paid_amount'=>$paid_amt,'bal_amount'=>$bal_amt,'del_date'=>$del_date,'doctor'=>$doctor,'des_array'=>$des_array));
		}		
	}

    public function barcode()
	{
        $this->load->library(array('stock','targets'));
        
        #----------loading models
		$this->load->model('designations/designation_master_model','desig');
		$this->load->model('customers/customer_type_model','customer_type');

		#----------voucher type
		$vtype_id = $this->vtype;

		#----------voucher type array
		$voucher_types = $this->vouchers->voucher_types($this->vtype);
		$bill_prefix = $this->stock->get_voucher_prefix($this->vtype);
		#----------voucher name
		$voucher_name = $this->vouchers->voucher_name($this->vtype);

		#------------cess %
		$cess = $this->stock->get_cess();
		
		#-----------sales date and next bill no
		$rules = "callback_bill_no_exists";
		$disabled = "";
		$result_array = $this->sales_obj->next_bill_no($this->vtype);
		$vtype_id = $result_array['vtype_id'];
		$voucher_no = $result_array['bill_no'];
		$voucher_date = $result_array['bill_date'];
		if($result_array['vstatus'])
		{
			#-----------redirection if sales order / delivery note / purchase request conversion is pending
			if($result_array['s_status'] == 2)
			{
				redirect("order_to_sales/so_sales/".$result_array['sid']);
			}
			elseif($result_array['s_status'] == 1)
			{
				redirect("request_to_sales/pr_sales/".$result_array['sid']);
			}

			$disabled = "readonly";
			$group_id = $result_array['group_id'];
			$rules = "callback_bill_no_exists[$vtype_id.$group_id]";

			$voucher_details = $this->dms->get_data(array('table' => 'dms_vouchers as a','join' => array('table' => 'dms_booking as b','on' => 'a.table_group_id = b.group_id'),'columns' => 'b.id','conditions' => array('a.table_name' => 'dms_booking','a.table_group_id' => $group_id)));
			if(!empty($voucher_details))
			{
				redirect("booking/update/id/".$voucher_details[0]['id']);
			}   

			#------------checking cst enabled or not
			
		}
		else
        {
		 	$group_id = $this->stock->get_group_id('dms_sales_items1');
		}

		#-------------adding data to sales temp
		if(isset($_POST['btn_add']))
		{
			#-----------validation
			$this->form_validation->set_rules('vtype_id','lang:voucher-types','required|xss_clean');
			$this->form_validation->set_rules('sales[bill_no]','lang:bill-no',"required|xss_clean|".$rules);
			$this->form_validation->set_rules('sales[bill_date]','lang:bill-date','required|xss_clean|valid_date');
			$this->form_validation->set_rules('sales[customer_id]','lang:customer-name','required|xss_clean');
            $this->form_validation->set_rules('sales[mobile]','lang:mobile','required|xss_clean');
		//	$this->form_validation->set_rules('item_id','lang:item-name','required|xss_clean');			
			$this->form_validation->set_rules('qty','lang:quantity','xss_clean|greater_than[0]|less_than[100000000]');		

			#-----------adding temporary data
			if($this->form_validation->run('btn_add') === true)
			{                               
                $item_array = $this->input->post(NULL,true);
                $sal_tem = $this->input->post('sales',true);
                $des_array = $this->input->post('des',true);
                                
				unset($item_array['sales']);
				unset($item_array['vtype_id']);
				unset($item_array['btn_add']);
                unset($item_array['des']);
                $itemID = $item_array['item_id'];
                if($item_array['qty']=='')
                {
                    $item_array['qty']='1';
                } 

                $qr_11 = $this->db->select(array('godown_id','unit_id'))->from('dms_stocks')->where('item_id',$itemID)->get()->row_array();                               
                $item_array['godown_id']=$qr_11['godown_id'];
                $item_array['hsn']='111';                                
                $item_array['unit_id']=$qr_11['unit_id'];
                $item_array['rate']=$this->stock->get_item_rate($itemID);
                $item_array['amount']=($item_array['qty'])*($item_array['rate']);
                $item_array['discount_per']='';
                $item_array['discount_amt']='';

				$item_array['group_id'] = $group_id;
				$item_array['status'] = -1;
				$item_array['item_status'] = 2;//sales only items

				#----------rate calculation
				$item_array['rate'] = 0;
				if($item_array['qty'] != 0)
				{
					$item_array['rate'] = $item_array['amount'] / $item_array['qty'];
				}
                if($item_array['qty'] != 0)
                {                              
                    $qty = $item_array['qty'];
                    $bill_no = $sal_tem['bill_no'];                          
				}	 		
                
                $sales_temp_item_result = $this->sales_obj->get_sales(array('columns' => array('b.id'),'conditions' => array('b.group_id' => $group_id,'item_id' => $item_array['item_id'],'godown_id' => $item_array['godown_id'],'unit_id' => $item_array['unit_id'],'a.status !=' => 0,'b.status !=' => 0,'b.item_status >' => 0),'numrows' => true));
				if($sales_temp_item_result == 0)
				{
					#----------GST calculation
   
                    $cgst = $this->stock->get_item_cgst($item_array['item_id']);
					$sgst = $this->stock->get_item_sgst($item_array['item_id']);
					$item_array['cgst'] = $cgst;
					$item_array['sgst'] = $sgst;
					$item_array['cgst_amt'] = (($item_array['amount']-$item_array['discount_amt']) * $cgst) / 100;
					$item_array['sgst_amt'] = (($item_array['amount']-$item_array['discount_amt']) * $sgst) / 100;
 
					$sales_temp_array = $this->input->post('sales',true);
					$sales_temp_array['vtype_id'] = $this->input->post('vtype_id',true);
					$sales_temp_array = array_filter($sales_temp_array);

					#----------start transaction
					$this->db->trans_start();
					#-----------bill date and next bill no
					if($result_array['vstatus'] == 0)//data not in dms_sales
					{
						$vtype_id = $sales_temp_array['vtype_id'];
						$voucher_no = $sales_temp_array['bill_no'];
						$voucher_date = date('Y-m-d',strtotime($sales_temp_array['bill_date']));
						$customer_type = 2;
						$customer_name = $sales_temp_array['customer_id'];
                        $cust_mob = $sales_temp_array['mobile'];
                        $doctor = $sales_temp_array['doctor'];
                        $customer_id = $this->sales_obj->save_customer(array('fname'=>$customer_name,'mobile_no'=>$cust_mob,'status'=>1));
						$data_sales_temp=array('vtype_id' =>$vtype_id,'branch_id' => $this->session->userdata('under_id'),'bill_no' => $voucher_no,'bill_date' => $voucher_date,'group_id' => $group_id,'customer_type_id' => $customer_type,'customer_id' => $customer_id,'doctor'=>$doctor,'status' =>-1);
						
						if(array_key_exists('pricelist_id',$sales_temp_array))
						{
							$data_sales_temp['pricelist_id'] = $sales_temp_array['pricelist_id'];
						}
						$this->sales_obj->insert("dms_booking",$data_sales_temp);
                        $ldv1=$des_array['ldv1']; $ldv2=$des_array['ldv2']; $ldv3=$des_array['ldv3']; $ldv4=$des_array['ldv4']; $lnv1=$des_array['lnv1']; $lnv2=$des_array['lnv2']; $lnv3=$des_array['lnv3']; $lnv4=$des_array['lnv4']; $ladd=$des_array['ladd']; $rdv1=$des_array['rdv1']; $rdv2=$des_array['rdv2']; $rdv3=$des_array['rdv3']; $rdv4=$des_array['rdv4'];
                        $rnv1=$des_array['rnv1']; $rnv2=$des_array['rnv2']; $rnv3=$des_array['rnv3']; $rnv4=$des_array['rnv4']; $radd=$des_array['radd'];

                        $this->db->query("insert into doctor_description(group_id,ldv1,ldv2,ldv3,ldv4,lnv1,lnv2,lnv3,lnv4,ladd,rdv1,rdv2,rdv3,rdv4,rnv1,rnv2,rnv3,rnv4,radd) values('$group_id','$ldv1','$ldv2','$ldv3','$ldv4','$lnv1','$lnv2','$lnv3','$lnv4','$ladd','$rdv1','$rdv2','$rdv3','$rdv4','$rnv1','$rnv2','$rnv3','$rnv4','$radd')");
					}

					#--------------adding sales items                                                                
                    $sales_items_id = $this->sales_obj->insert("dms_sales_items1",$item_array);
                                         
					if($sales_items_id)
					{
						#--------------adding temporary stock balance in dms_stocks
					/*	$stock_bal_temp = $this->stock->unit_conversion($item_array['item_id'],$item_array['unit_id'],$item_array['qty'],$item_array['rate'],$item_array['amount']);
						if($stock_bal_temp)
						{
							$this->sales_obj->insert('dms_stocks',array('company_id' => $this->session->userdata('company_id'),'branch_id'=>$this->session->userdata('under_id'),'godown_id' => $item_array['godown_id'],'item_id' => $item_array['item_id'],'qty' => $stock_bal_temp['qty'],'unit_id' => $stock_bal_temp['primary_unit'],'rate' => $stock_bal_temp['rate'],'amount' => $stock_bal_temp['amount'],'stock_date' => $voucher_date,'stock_status' => 6,'table_group_id' => $group_id,'table_id' => $sales_items_id,'status' => -1));
						}  */
						$this->message->set($this->lang->line('sales-add-success')); 
					}
					else
					{
						$this->message->set($this->lang->line('sales-add-error'),'e');
					}

					#----------transaction completed
					$this->db->trans_complete();
				}
				else
                {
					$this->message->set($this->lang->line('sales-add-error'),'e');
				}
				redirect('booking/barcode');
			}
		}

		#------------saving sales voucher
		if(isset($_POST['btn_save']))
		{
			#-----------validation
			$this->form_validation->set_rules('area_id','lang:area','required|xss_clean');
            $this->form_validation->set_rules('bill_advance','lang:advance','required|xss_clean');
			$this->form_validation->set_rules('payment_mode','lang:payment-mode','required|xss_clean');
			if($this->input->post('payment_mode',true) == 2)
            {
				$this->form_validation->set_rules('credit_period','lang:credit-period','required|xss_clean|is_natural');
			}
			elseif($this->input->post('payment_mode',true) > 2)
            {
				$this->form_validation->set_rules('ccd','lang:transaction-type','required|xss_clean');
				$this->form_validation->set_rules('cd_no','lang:cd-no','required|xss_clean|max_length[64]');
				$this->form_validation->set_rules('cheque_date','lang:cheque-date',"required|xss_clean|is_date|check_date[$voucher_date.>=]");
			}
			$this->form_validation->set_rules('remarks','lang:remarks','xss_clean');
			$this->form_validation->set_rules('freight','lang:freight','xss_clean|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('other_expense','lang:other-expense','xss_clean|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('bill_discount_per','lang:discount %','xss_clean|greater_or_equal[0]|less_or_equal[100]');
			$this->form_validation->set_rules('bill_discount_amt','lang:discount','xss_clean|greater_or_equal[0]|less_than[100000000]');

			#-----------saving data

			if($this->form_validation->run('btn_save') === true)
			{
				$payment_mode = $this->input->post('payment_mode',true);
				$narration = $this->input->post('remarks',true);
				$bill_discount_amt = $this->input->post('bill_discount_amt',true);
                $bill_advance = $this->input->post('bill_advance',true);
                $del_date =  date('Y-m-d',strtotime($this->input->post('d_date',true)));
				$freight = $this->input->post('freight',true);
				$other_expense = $this->input->post('other_expense',true);
				$sales_entry_array=array('area_id' => $this->input->post('area_id',true),'bill_discount_per' => $this->input->post('bill_discount_per',true),'bill_discount_amt' => $bill_discount_amt,'bill_freight' => $freight,'other_expense' => $other_expense,'cess' => $cess,'narration' => $narration,'payment_mode' => $payment_mode,'cr_period' => $this->input->post('credit_period',true),'delivery_date'=>$del_date,'status' => 1);

                $sales_entry_check = $this->sales_obj->get_sales(array('columns' => array('a.vtype_id','a.bill_no','a.bill_date','a.customer_type_id','a.customer_id'),'conditions' => array('a.group_id' => $group_id,'a.status !=' => 0,'b.item_status >' => 0)));

				if($sales_entry_check)
				{
					$bill_date = $sales_entry_check[0]['bill_date'];
					$vtype_id = $sales_entry_check[0]['vtype_id'];
					$bill_no = $sales_entry_check[0]['bill_no'];
                    $customer_id = $sales_entry_check[0]['customer_id'];                                    
                    $amount = $this->input->post('grand_total',true);
                    $vat = $this->input->post('vat_total',true);
                    $tot_amount = $amount+$vat;
                    $balance_amt = $tot_amount-$bill_discount_amt-$bill_advance;
                    $sales_entry_array['paid_amount']=$bill_advance;
                    $sales_entry_array['balance_amount']=$balance_amt;

                    if($bill_discount_amt)
                    {
                        if($bill_discount_amt != 0)
                        {
                            $sqlu1 = "update customer_total_point set point='0' where cid='$customer_id'";
                            $this->db->query($sqlu1);
                        }
                    }

                    $sql = "insert into customer_quantity (customer_id,bill_no,group_id,amount) values ('$customer_id','$bill_no','$group_id','$tot_amount')";
                    $this->db->query($sql);

					#----------start transaction
					$this->db->trans_start();
					if($this->sales_obj->update(array('table' => 'dms_booking','data' => $sales_entry_array,'conditions' => array('group_id' => $group_id))))
					{
					    $this->sales_obj->update(array('table' => 'dms_sales_items1','data' => array('status' => 1),'conditions' => array('group_id' => $group_id,'status !=' =>0,'item_status >' => 0)));
                        $sls_qr = $this->db->select(array('id'))->from('dms_booking')->where('group_id',$group_id)->get()->row_array();							
                        $sls_id = $sls_qr['id']; 					

						#--------------checking for user points and dr_ledger
						$user_points = 0;$user_type = "";
						if($sales_entry_check[0]['customer_type_id'] == 2)//customer
						{							
							$customer = $this->dms->get_data(array('table' => 'customer_master','columns' => 'ledger_id','conditions' => array('id' => $sales_entry_check[0]['customer_id'])));
						}
						else//branch or AR
						{
							$designation_id = $sales_entry_check[0]['customer_type_id'];
							//$user_id = $sales_entry_check[0]['customer_id'];
							if($designation_id == 3)
							{
								$customer = $this->dms->get_data(array('table' => 'retailer_master','columns' => 'ledger_id','conditions' => array('id' => $sales_entry_check[0]['customer_id'])));
							}
							else
							{
								$customer = $this->dms->get_data(array('table' => 'branch_master','columns' => 'ledger_id','conditions' => array('id' => $sales_entry_check[0]['customer_id'])));
							}
						}

                        $customer_id = $sales_entry_check[0]['customer_id'];
						$designation_id = $sales_entry_check[0]['customer_type_id'];
                        $bill_no = $sales_entry_check[0]['bill_no'];

						$amt= $this->dms->get_qty($customer_id,$bill_no);
                        $customer_points = $this->targets->get_customer_bill_points($amt);
                                                        
                        $c_point = $this->db->select(array('point'))->from('customer_total_point')->where('cid',$customer_id)->get()->row_array();
                        if($c_point)
                        {
                             $cur_point = $c_point['point'];
                             $new_point = $cur_point+$customer_points;
                             $sqlu = "update customer_total_point set point='$new_point' where cid='$customer_id'";
                             $this->db->query($sqlu);
                        }
                        else
                        {
                            $sql1 = "insert into customer_total_point(cid,point) values('$cust_id','$customer_points')";

                            $this->db->query($sql1);
                        }
                        $target_id2 = $this->targets->get_targets(array('columns' => 'a.id','conditions' => array('a.designation_id' => 0,'a.user_id' => 0,'a.status' => 1),'bill_date' => $bill_date));
						if($target_id2)
						{
							$this->sales_obj->insert('customer_points',array('designation_id' => 0,'user_id' => $customer_id,'targets_id' => $target_id2['id'],'group_id' => $group_id,'sms_point' => $customer_points,'actual_point' => $customer_points));
						}
						
						#-------------adding bill to dms_vouchers
						$voucher_status = 1;
						$voucher_amount = $bill_advance;  // $this->input->post('grand_total',true);
						$round_off_amount = $this->input->post('round_off_amount',true);
					//	$vat_amount = $this->input->post('vat_total',true);
						$cess_amount = $this->input->post('cess_total',true);
						if($payment_mode > 2)
						{
							$bill_date_time = strtotime($bill_date);
							$cheque_date = date('Y-m-d',strtotime($this->input->post('cheque_date',true)));
							$cheque_date_time = strtotime($cheque_date);
							if($this->input->post('ccd',true) == 1 && $cheque_date_time > $bill_date_time)
							{
								$voucher_status = 3;
							}
						}
						elseif($payment_mode == 2)
						{
							$payment_mode = $customer[0]['ledger_id'];//customer
						}
						$voucher_group_id = $this->stock->get_group_id('dms_vouchers');
						

						$voucher_array = array('company_id' => $this->session->userdata('company_id'),'branch_id' => $this->session->userdata('under_id'),'group_id' => $voucher_group_id,'vtype_id' => $vtype_id,'vno' => $bill_no,'vorder_no' => 6,'vdate' => $bill_date,'dr_ledger' => $payment_mode,'cr_ledger' => 4,'vamount' => $voucher_amount,'narration' => $narration,'table_name' => 'dms_booking','table_group_id' => $group_id,'status' => $voucher_status);
						$voucher_data = $this->dms->get_data(array('table' =>'dms_vouchers','columns' => 'id','conditions' => array('table_name' => 'dms_booking','table_group_id' => $group_id),'numrows' => true));
						if($voucher_data == 0)
						{
							$voucher_success = $this->sales_obj->insert('dms_vouchers',$voucher_array);
						/*	if($voucher_success)
							{
								#-----------VAT
								$voucher_array['cr_ledger'] = 12;
								$voucher_array['vorder_no'] = 2;
								$voucher_array['vamount'] = $vat_amount;
								$this->sales_obj->insert('dms_vouchers',$voucher_array);
								#-----------CESS
								$voucher_array['cr_ledger'] = 15;
								$voucher_array['vorder_no'] = 3;
								$voucher_array['vamount'] = $cess_amount;
								$this->sales_obj->insert('dms_vouchers',$voucher_array);
								#-----------Freight
								$voucher_array['dr_ledger'] = 13;
								$voucher_array['cr_ledger'] = $payment_mode;
								$voucher_array['vorder_no'] = 4;
								$voucher_array['vamount'] = $freight;
								$this->sales_obj->insert('dms_vouchers',$voucher_array);
								#-----------Other Expense
								$voucher_array['dr_ledger'] = 14;
								$voucher_array['vorder_no'] = 5;
								$voucher_array['vamount'] = $other_expense;
								$this->sales_obj->insert('dms_vouchers',$voucher_array);

								
							} */
if($payment_mode > 2)
{
	$this->sales_obj->insert('dms_voucher_banks',array('group_id' => $voucher_group_id,'cash_type' => $this->input->post('ccd',true),'cd_no' => $this->input->post('cd_no',true),'pdc' => $cheque_date,'vdate' => $bill_date));
								}
						}
							$sales_items_array = $this->sales_obj->get_sales_items(array('columns' => array('id','item_id','qty','unit_id','rate','godown_id'),'conditions' => array('group_id' => $group_id,'status' => 1,'item_status >' => 0)));

   						
						foreach($sales_items_array as $key => $value)
						{
							#-------------enabling temporarily added stocks
						//	$this->sales_obj->update_others(array('table' => 'dms_stocks','data' => array('status' => 1),'conditions' => array('stock_status' => 6,'table_id' => $value['id']))); 
                                              /*          if(!empty($customer_id))//cust_new
							{

								$customer_points += $this->targets->get_bill_points(0,1,$value['item_id'],$value['unit_id'],$value['qty'],$value['rate'],$bill_date);

							} */
						
						}








					/*	  if($customer_points > 0)//new_cust_28
						{
						
							$target_id2 = $this->targets->get_targets(array('columns' => 'a.id','conditions' => array('a.designation_id' => 0,'a.user_id' => 0,'a.status' => 1),'bill_date' => $bill_date));
							if($target_id2)
							{
								$this->sales_obj->insert('customer_points',array('designation_id' => 0,'user_id' => $customer_id,'targets_id' => $target_id2['id'],'group_id' => $group_id,'sms_point' => $customer_points,'actual_point' => $customer_points));
									 
							}
						}
                        if(!empty($customer_type))//new_cust
						{
							$customer_data = $this->dms->get_data(array('table' =>'customer_master','columns' => 'mobile','conditions' => array('id' => $customer_id)));
							if(!empty($customer_data)){
								$customer_type_mobile=$customer_data[0]['mobile'];
								$this->sales_obj->insert('dms_sms_customer',array('company_id' =>$this->companyID,'bill_ref_no' => $group_id,'user_type'=>$customer_type_id,'user_id'=>$customer_id,'status'=>3));
							}
						} */

                                                
                                    #----------------------- sms to customer ----------------------------------------------

                                                
								$this->load->model('sms/sms_model','sms');
								$this->load->library('stock');
								$this->load->library('targets');
								$offset =0;$links=NULL;
								$this->load->library('pagination');
			
								$sms_users = $this->sms->sms_user();
								$sms_user = $sms_users[0];
								//print_r($sms_user);
								$username = $sms_user['username'];
								$password = $sms_user['password'];
								$route = $sms_user['sms_type'];
								$msg_balance = $this->sms->sms_balance($username,$password,$route);		
														
								#---------for sms sending check balance msg ------------
								$sms_users = $this->sms->sms_user();
								$sms_user = $sms_users[0];
								//print_r($sms_user);
								$username = $sms_user['username'];
								$password = $sms_user['password'];
								$route = $sms_user['sms_type'];
								$msg_balance = $this->sms->sms_balance($username,$password,$route);
								
                                                                $this->load->model('customers/customer_master_model','customer_master');
                                                                $args = array('conditions'=>array('id'=>$customer_id));
                                                                $cust_data = $this->customer_master->get($args);
                                                                $cust_name = $cust_data[0]['fname'];
                                                                $cust_mob = $cust_data[0]['mobile_no'];
                                                                  			
																			
								$message="Dear ".$cust_name.", Your payment of Rs.".$bill_advance." for bill no. ".$bill_no." is success. Balance Amount is Rs.".$balance_amt." . Delivery date - ".date('d/m/Y',strtotime($del_date))." ";					
																	
								if($msg_balance > 0 )
								{
			
									$message = $message;
									$msg_send_status = $this->sms->send($cust_mob,$message);
												
									$this->db->insert('customer_sms',array('customer_id'=>$customer_id,'customer_name'=>$cust_name,'mobile'=>$cust_mob,'message'=>$message));
														
								}		





                                   #-------------------------------------------------------------------------------------------

						$this->message->set($this->lang->line('sales-save-success'));
						//redirect('booking/report');

                                                $lnk = 'booking/print_bill/id/'.$sls_id;
						redirect($lnk);
					}
					else{
						$this->message->set($this->lang->line('sales-save-error'),'e');
					}

					#----------transaction completed
					$this->db->trans_complete();
					
					
				}
				else
				{
					$this->message->set($this->lang->line('sales-save-error'),'e');
				}
				redirect('booking/barcode');
			}
		}

		#------------customer type
		$user_types = array();$custType = 2;
		if($this->branch_status){
			$customerTypes = $this->desig->listing(array('department_id'=>0,'utype_status >'=>1));
		}
		else{
			$customerTypes = $this->desig->listing(array('id'=>2));
		}

		#------------item details / unit details / godown details
		$units = array();$goDowns = array();
		$units[''] = "Select";
		$args['select'] = array('id','item_code','item_name');
		$items = $this->stock->get_stock_items($args);
		if(empty($items)){
			$this->message->set($this->lang->line('no-items-found'),'i');
		}
		if($this->input->post('item_id',true)){
			$itemID = $this->input->post('item_id',true);
			$goDowns = $this->stock->get_item_godowns(array('item_id'=>$itemID,'listing'=>1));
			$units = $this->stock->get_units($itemID);
		}

		#------------sales temp data
		$sales_temp_data = array();$cust_id="";$users = array();$user = "";$pricelists=array();$desig_id="";
		$price_list_id="";$stock_count="";$primary_unit['symbol']="";
		if($result_array['vstatus'])
		{
			#------------area details
			$this->load->model('areas/area_model','area');
			$areas = $this->area->listing();
		
                        $sales_temp_data = $this->sales_obj->get_sales(array('columns' => array('a.group_id','a.customer_type_id','a.customer_id','a.doctor','a.pricelist_id','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.discount_per','b.discount_amt','b.godown_id','b.cgst_amt','b.sgst_amt'),'conditions' => array('a.created_by' => $this->session->userdata('id'),'vtype_id' => $vtype_id,'bill_no' => $voucher_no,'a.status =' => -1,'b.status !=' => 0)));

$gr_id = $sales_temp_data[0]['group_id']; 

$des_array = $this->sales_obj->get_description($gr_id);
/* $des_array = $this->db->fetch($des_qr);*/


			#------------customer type
			$custType = $sales_temp_data[0]['customer_type_id'];

			#------------customer
			$cust_id = $sales_temp_data[0]['customer_id'];
                        $this->load->model('customers/customer_master_model','customer_master');
                        $args = array('conditions'=>array('id'=>$cust_id));
                        $cust_data = $this->customer_master->get($args);
                        $cust_name = $cust_data[0]['fname'];
                        $cust_mob = $cust_data[0]['mobile_no'];
			#------------user
			$user = $sales_temp_data[0]['user_id'];
                        $doctor = $sales_temp_data[0]['doctor'];

			#------------user designation
			$desig_id = $this->dms->get_desig($user);

			#------------user details
			$users = $this->dms->get_users(array('conditions' => array('designation_id' => $desig_id,'branch_id' => $this->session->userdata('under_id'))));

			#------------pricelist id
			$price_list_id = $sales_temp_data[0]['pricelist_id'];;
		}
		else
		{
			$sales_array = $this->input->post('sales',true);
			#------------customer type
			if($sales_array['customer_type'] != ""){
				$custType = $sales_array['customer_type'];
			}
			if($sales_array['customer_id'] != ""){
				$cust_id = $sales_array['customer_id'];
			}

			#------------user details
			if($sales_array['user_type'] != ""){
				$desig_id = $sales_array['user_type'];
				$users = $this->dms->get_users(array('conditions' => array('designation_id' => $desig_id,'branch_id' => $this->session->userdata('under_id'))));
				if($sales_array['user_id'] != ""){
					$user = $sales_array['user_id'];
				}
			}

			#------------pricelist
			if(isset($sales_array['pricelist_id']) && $sales_array['pricelist_id'] != ""){
				$price_list_id = $sales_array['pricelist_id'];
			}

			#------------stock count of this item
			if($this->input->post('item_id',true) && $this->input->post('godown_id',true) && $sales_array['bill_date'] != ""){
				$stock_count = $this->stock->get_stock_count($this->input->post('godown_id',true),$this->input->post('item_id',true),$sales_array['bill_date']);
				$primary_unit = $this->stock->get_primary_unit($this->input->post('item_id',true));
			}
		}

		#------------customer details
		if($this->branch_status)
		{
			if($custType == 1){

				$this->load->model('branches/branch_model','branches');
				$customers = $this->branches->listing(array('id !='=>$this->session->userdata('under_id')));
			}
			else if($custType ==2){
				$this->load->model('customers/customer_master_model','customer_master');
				$customers = $this->customer_master->listing();
				#array('conditions'=>array('branch_id'=>$this->session->userdata('under_id')))
			}
			else{
				$this->load->model('retailers/counter_model','retailer_master');
				$customers = $this->retailer_master->listing(array('company_id'=>$this->session->userdata('company_id')));
			}
		}
		else
		{
			$this->load->model('customers/customer_master_model','customer_master');
			$customers = $this->customer_master->listing();
			#array('conditions'=>array('branch_id'=>$this->session->userdata('under_id')))
		}

		#------------usertype details
		$user_types = $this->desig->listing(array('utype_status' => 1));

		#------------pricelist details
		$pricelists = $this->customer_type->listing();

		$areas[''] = 'Select';ksort($areas);
		$customers[''] = "Select";ksort($customers);
		$user_types[''] = "Select";ksort($user_types);
		$pricelists[''] = 'Select';ksort($pricelists);
		$items[''] = 'Select';ksort($items);
		$goDowns[''] = 'Select';ksort($goDowns);
		$users[''] = 'Select';ksort($users);

		#------------payment modes
		$payment_mode = $this->stock->payment_modes();

		#------------cheque / dd details
		$cd_status = 1;
		if($this->input->post('payment_mode',true) > 2){
			$cd_status = 0;
		}

		#------------template
		$this->template->title("New Sales Voucher");
		$this->template->main_heading($this->lang->line("$voucher_name")." ".$this->lang->line('booking'));
		$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("$voucher_name") => 'no_link',$this->lang->line('report') => 'booking/report'));
		$this->template->slice('dms/message');
		$this->template->slice('booking/barcode_add',array('voucher_types' => $voucher_types,'voucher_type' => $vtype_id,'voucher_name' => $voucher_name,'voucher_no' => $voucher_no,'voucher_date' => $voucher_date,'custType' => $custType,'customerTypes' => $customerTypes,'customers' => $customers,'user_types' => $user_types,'users' => $users,'user' => $user,'pricelists' => $pricelists,'price_list_id' => $price_list_id,'items' => $items,'units' => $units,'goDowns' => $goDowns,'sales_temp_status' =>$result_array['vstatus'],'sales_temp_data' => $sales_temp_data,'areas' => $areas,'cess' => $cess,'payment_mode' => $payment_mode,'disabled' => $disabled,'cust_name' => $cust_name,'cust_mob'=>$cust_mob,'doctor'=>$doctor,'desig_id' => $desig_id,'stock_count' => $stock_count,'primary_unit' => $primary_unit['symbol'],'cd_status' => $cd_status,'bill_prefix'=>$bill_prefix,'des_array'=>$des_array));
		$this->template->other_script('sales/sales_order');
		$this->template->render();
	}

	
}
?>