<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Cashbooks extends MY_Controller{

	public function __construct()
	{
		parent :: __construct();		
		$this->check_access_right();

		$this->load->library('Accounts');
	}
	
	public function index()
	{
		$fiscal_start_date = $this->dms->get_fiscal_year()['start_date'];
		$from_date = $to_date = date('Y-m-d'); //$fiscal_start_date;		
		$vouchers_array = array();$sub_group_id = $dc = "";$opening_bal = 0;
		
		if(isset($_POST['btn_search']))
		{
			#-------------validation
			$this->form_validation->set_rules('from_date','lang:from-date','required|xss_clean|valid_date');
			if($this->input->post('from_date',true))
			{
				$from_date = $this->input->post('from_date',true);
				$this->form_validation->set_rules('to_date','lang:to-date',"required|xss_clean|valid_date|check_date[$from_date.>=]");
			}
			if($this->form_validation->run() === true)
			{
				$from_date = date('Y-m-d',strtotime($this->input->post('from_date',true)));
				$to_date = date('Y-m-d',strtotime($this->input->post('to_date',true)));
				$this->session->set_userdata(array('from_date' => $from_date,'to_date' => $to_date));
			}
		}
		elseif($this->session->userdata('from_date') && $this->session->userdata('to_date'))
		{
			$from_date = $this->session->userdata('from_date');
			$to_date = $this->session->userdata('to_date');
			
			#----------validating dates
			if(!$this->form_validation->valid_date($from_date) || !$this->form_validation->valid_date($to_date)){
				redirect('users/logout');
			}
			else{
				if(!$this->form_validation->check_date($from_date,$to_date.".<=")){
					redirect('users/logout');
				}
			}
		}
		if(!empty($from_date) && !empty($to_date))
		{
			$next_date = date('Y-m-d',(strtotime($to_date)+86400));
			$account_groups = array(13,14,20);
			foreach($account_groups as $key => $value)	
			{		
				#----------account group name
				$group_name = $this->accounts->account_group_name($value);
				
				$dr_amount = $cr_amount = 0;				
				$opening_bal = $this->accounts->opening_bal($value,$to_date,1);
				$voucher_bal = $this->accounts->voucher_bal($value,$next_date,1);
				if($value != 20)
				{
					$voucher_amount = $opening_bal + ($voucher_bal['dr_amount'] - $voucher_bal['cr_amount']);
					if($voucher_amount > 0)
					{
						$dr_amount = $voucher_amount;
					}
					else
					{
						$cr_amount = -$voucher_amount;
					}
				}
				else
				{
					$voucher_amount = $opening_bal + ($voucher_bal['cr_amount'] - $voucher_bal['dr_amount']);
					if($voucher_amount > 0)
					{
						$cr_amount = $voucher_amount;
					}
					else
					{
						$dr_amount = -$voucher_amount;
					}
				}								
				if($dr_amount > 0 || $cr_amount > 0)
				{
					$vouchers_array[$value] = array('group_name' => $group_name,'dr_amount' => $dr_amount,'cr_amount' => $cr_amount);
				}								
			}
		}
		
		#-------------template
		$this->template->title('Cash / Bank Book');
		$this->template->main_heading('Cash / Bank Book');
		$this->template->breadcrumb(array($this->lang->line('account-reports') => 'no_link',$this->lang->line('cash-bank-book') => 'no_link'));
		$this->template->slice('account_reports/account_group_search',array('astatus' => 1,'from_date' => $from_date,'to_date' => $to_date));
		if(!empty($vouchers_array))
		{
			$this->session->set_userdata(array('from_date' => $from_date,'to_date' => $to_date));
			$access_rights = $this->have_access(433);
			$this->template->append('account_reports/cashbooks',array('voucher_array' => $vouchers_array,'access_rights' => $access_rights,'from_date' => $from_date,'to_date' => $to_date));
		}
		else{
			$this->message->set($this->lang->line('no-result-found'),'i');
		}
		$this->template->slice('dms/message');
		$this->template->render();
	}
}