<?php if(! defined('BASEPATH')) exit('No direct script access alloed');

	class Collection_report extends MY_Controller{
	    
	    public function __construct()
    	{
    		parent::__construct();
    
    		$this->check_access_right();
    		$this->companyID = $this->session->userdata('company_id');
            $this->branch_id = $this->session->userdata('under_id');
    		#---------------- Checking Financial year is enabled / closed-----------------#
    		$method_array = array('add','delete_temp','update_temp','update','delete','barcode');
    		fiscal_status($this->uri->segment(2),$method_array,"booking/report");
    		#---------------- Checking Financial year is enabled / closed-----------------#
    
    		$this->load->model('booking/Booking_model','book_obj');
    		$this->load->model('sales/Sales_model','sales_obj');
    		$this->load->model('vouchers/Voucher_model','vouchers');
            $this->load->model('users/User_point_model','user_point');
    		$this->load->library(array('Stock','Targets'));
            $this->load->model('products/Item_model','item');
    	}
    	
    	public function report()
    	{
    		#----------uri array
    		$uri_array  = $this->uri->uri_to_assoc(3);
    
    		#----------redirect
    		$redirect = ""; $collection_array = array();
    
    		#----------dates within financial year
    		$cur_date = date('Y-m-d');
    		$from_date = $cur_date;
    		$to_date = $cur_date;
    		$cur_fiscal_yr = $this->dms->get_fiscal_year();
    		if($from_date < $cur_fiscal_yr['start_date'] || $from_date > $cur_fiscal_yr['end_date'] || $to_date < $cur_fiscal_yr['start_date'] || $to_date > $cur_fiscal_yr['end_date'])
    		{
    			$from_date = $cur_fiscal_yr['end_date'];
    			$to_date = $cur_fiscal_yr['end_date'];
    		}
    
    		#----------validation
    		$this->form_validation->set_rules('from_date','From Date','required|xss_clean|valid_date');
    		$this->form_validation->set_rules('to_date','To Date','required|xss_clean|valid_date');
    		if($this->form_validation->run() === true)
    		{
    			$from_date = date('Y-m-d',strtotime($this->input->post('from_date',true)));
    			$to_date = date('Y-m-d',strtotime($this->input->post('to_date',true)));
    		}
    		
    		$fdate = strtotime($from_date);
    		$tdate = strtotime($to_date);
    		
    		for ($i = $fdate; $i <= $tdate; $i += (86400)) 
    		{ 
    		    $idate = date('Y-m-d', $i); 
    		    
    		    #---------------- Booking ----------------
    		    
    		    $book_amount = 0;
                $book_array = $this->db->query("select sum(paid_amount) as collection from dms_booking where bill_date='$idate' and branch_id='$this->branch_id' and status='1'")->row_array();
                if($book_array['collection']!='')
                {
                    $book_amount = $book_array['collection'];
                }
                $collection_array[$idate]['book'] = $book_amount;
                
                #---------------- Sales ----------------
                
                $sales_amount = 0;
                $sales_array = $this->db->query("select sum(vamount) as collection from dms_vouchers where vdate='$idate' and company_id='$this->companyID' and branch_id='$this->branch_id' and table_name='dms_sales' and status='1'")->row_array();
                if($sales_array['collection']!='')
                {
                    $sales_amount = $sales_array['collection'];
                }
                $collection_array[$idate]['sale'] = $sales_amount;
                
                #---------------- Sales Return----------------
                
                $sales_return_amount = 0;
                $sales_return_array = $this->db->query("select sum(vamount) as collection from dms_vouchers where vdate='$idate' and company_id='$this->companyID' and branch_id='$this->branch_id' and table_name='dms_sales_returns' and status='1'")->row_array();
                if($sales_return_array['collection']!='')
                {
                    $sales_return_amount = $sales_return_array['collection'];
                }
                $collection_array[$idate]['sale_return'] = $sales_return_amount;
                
            }  

    		#----------between condition
    		$between = "bill_date between '$from_date' and '$to_date'";
    
    		#----------total rows
    
    		if(empty($collection_array))
    		{
    			$this->message->set($this->lang->line('no-voucher'),'i');
    		}
    
    		#----------sales report datas
    		$sales_array=$this->sales_obj->get_bills(array('conditions' => $conditions,'between' => $between,'like' => $like_array,'order_by'=>'bill_no','order'=>'DESC','limit'=>$config['per_page'],'offset'=>$offset));
    
    		#----------template
    		$this->template->title("Collection Report");
    		$this->template->main_heading($this->lang->line("collection-report"));
    		$this->template->breadcrumb(array($this->lang->line("collection-report") => 'no_link'));
    		$this->template->slice('collection_report/search',array('from_date' => $from_date,'to_date' => $to_date));
    		$this->template->slice('dms/message');
    		if(!empty($collection_array))
    		{
    			$this->template->slice('collection_report/report',array('collection_array' => $collection_array));
    			$this->template->slice('dms/modals/delete_confirm');
    		} 
    		$this->template->render();
    	}
	}
