<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

	class Complaint extends MY_Controller{



		public function __construct(){
			parent :: __construct();
			$this->check_access_right();
			$this->load->model('complaint/Complaint_model','complaint');

			#---------------- Checking Financial year is enabled / closed-----------------#
			$method_array = array('add','update','delete','privilege');
			fiscal_status($this->uri->segment(2),$method_array,"engineers/report");
			#---------------- Checking Financial year is enabled / closed-----------------#




		}

		#------------------------------------------------

		#date : 7-01-2017
		#purpose : post complaints   #sps
		public function add(){


			$this->form_validation->set_rules('subject','lang:subject','required|trim|xss_clean');
			$this->form_validation->set_rules('complaint','lang:complaint','required|trim|xss_clean');
			//$b_id = $this->input->post('branch_id',true);

			if($this->form_validation->run() == true){

				$subject = $this->input->post('subject',true);
				$complaint = $this->input->post('complaint',true);

				$data = $this->input->post(NULL,TRUE);

				if($this->complaint->f_save('complaints',$data)){
					$this->message->set($this->lang->line('complaint-save'));
				}
				else{
					$this->message->set($this->lang->line('complaint-not-save'));

				}
				redirect('complaint/report');


			}
			#template
			$this->template->title($this->lang->line('post-complaints'));
			$this->template->main_heading($this->lang->line('post-complaints'));
			$this->template->breadcrumb(array($this->lang->line('post-complaints')=>'no_link',$this->lang->line('report')=>'complaint/report'));
			$this->template->slice('dms/message');


			$this->template->slice('complaints/add/new');
			//$this->template->other_script(array('user_add','users/user_name_check','masons/ar_branch_select'));
			$this->template->render();


		}
		#------------------------------------------------

		#date : 7-01-2017
		#purpose : post complaints   #sps
		public function report(){




				$uid = $this->session->userdata('id');
				if($uid == -1 || $uid == -2){
					$conditions = '';
				}
				else{
					$conditions['cmp.created_by'] = $uid;
				}

				$this->load->library('Pagination');
				$config['total_rows'] = $this->complaint->get_all($conditions,1);
				$config['per_page'] = $this->per_page();
				$config['base_url'] = base_url('complaint/report');
				$config['uri_segment'] = 3;
				# Pagination Config Customizations
				$config['full_tag_open'] = '<ul class="pagination">';
				$config['full_tag_close'] = '</ul>';
				$config['first_link'] = 'First';
				$config['last_link'] = 'Last';
				$config['next_link'] = '&raquo;';
				$config['prev_link'] = '&laquo;';
				$config['cur_tag_open'] = '<li class="active"><a href="#">';
				$config['cur_tag_close'] = '</a></li>';
				$config['num_tag_open'] = '<li>';
				$config['num_tag_close'] = '</li>';
				$this->pagination->initialize($config);
				$offset = ($this->uri->segment(3))?$this->uri->segment(3):0;


				$complaints = $this->complaint->get_all($conditions,0,$offset,$config['per_page']);
				$links = $this->pagination->create_links();

				if(empty($complaints)){
					$this->message->set($this->lang->line('no-results-found'),'i');
				}

				$this->template->title($this->lang->line('post-complaints'));
				$this->template->main_heading($this->lang->line('post-complaints'));
				$this->template->breadcrumb(array($this->lang->line('post-complaints')=>'complaint/add',$this->lang->line('report')=>'no_link'));
				$this->template->slice('dms/message');

				$this->template->slice('complaints/report',array('complaints'=>$complaints,'links'=>$links,'count'=>$offset,'uid'=>$uid));
				//$this->template->other_script(array('user_add','users/user_name_check','masons/ar_branch_select'));
				$this->template->slice('dms/modals/more_details');
				$this->template->other_script('complaints/more_details');
				$this->template->render();
		}

	}