<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

	class Customer_master extends MY_Controller{

	    var $companyID,$branchID,$createdBY;
	
		public function __construct(){

			parent ::__construct();
			$this->check_access_right();
			$this->load->model('customers/Customer_master_model','customer');
			$this->companyID = $this->session->userdata('company_id');
			$this->branchID = $this->session->userdata('under_id');
			$this->createdBY = $this->session->userdata('id');
		}

	   #----------------------------------------------------------------------

		public function add()
		{
            $this->load->model('accounts/Ledger_model','ledger');
			#validation checking
			if($this->form_validation->run() === TRUE)
			{
                $data = $this->input->post(NULL,TRUE);
				
				$data['branch_id'] = $this->branchID;
				$open_amount = $this->input->post('open_amount',TRUE);
				$dc_type =  $this->input->post('dc_type',TRUE);
				
				#definfing ledger saving ledger data
				$ledger['company_id'] = $this->companyID;
				$ledger['ledger_name'] = $data['fname'].'-'.$data['mobile_no'];
				$ledger['branch_id'] = $this->branchID;
				$ledger['sgroup_id'] = 15;
				$ledger['dc'] = $this->ledger->get_dc($ledger['sgroup_id']);

				$last_insert_id = $this->ledger->insert('dms_ledgers',$ledger);
				$open['ledger_id'] = $last_insert_id ;
				$data['ledger_id'] = $last_insert_id ;
				$dob=date('Y-m-d',strtotime($data['dob']));
                $data['dob'] = $dob ;
                if(empty($data['dob'])){ $data['dob'] = " ";}

				if(!empty($open_amount))
				{
					if($dc_type != $ledger['dc'])
					{
						$open['open_amount'] = -$open_amount;
					}
					else
					{
						$open['open_amount'] = $open_amount;
					}
					$open['company_id'] = $this->companyID;
					$open['branch_id'] = $this->branchID;
					$open['open_date'] = $this->dms->get_fiscal_year()['start_date'];
					$this->ledger->insert('dms_ledger_open_bals',$open);
				}		
				unset($data['open_amount']);unset($data['dc_type']);
				if($this->customer->f_save('customer_master',$data))
				{
					$this->message->set($this->lang->line('customer-save'));
				}
				else
				{
					$this->message->set($this->lang->line('customer-not-save'));
				}
				redirect('customer_master/report');
			}
			#get all areas
			$this->load->model('areas/Area_model','area');
			$areas = $this->area->listing();
			$areas[''] = 'Select';ksort($areas);

			#branches
			$this->load->model('branches/Branch_model','branch');
			$branches = $this->branch->listing(array('company_id'=>$this->companyID));
			$branches[''] = 'Select a branch';
			ksort($branches);

			$dc_array = array('dr' => 'Dr','cr' => 'Cr');

			#template
			$this->template->title($this->lang->line('customers'));
			$this->template->main_heading($this->lang->line('customers'));
			$this->template->breadcrumb(array($this->lang->line('customer')=>'no_link',$this->lang->line('report')=>'customer_master/report'));
			$this->template->slice('dms/message');
			$this->template->slice('customer/new/add',array('areas'=>$areas,'branches'=>$branches,'dc_array'=>$dc_array));
			$this->template->render();
		}
		
	    #----------------------------------------------------------------------

        public function report()
        {
			#pagination
   	 		$this->load->library('Pagination');
   	 		$like_array = array();$like_arr = array();
   	 		
   	 		$cond="";
   	 		$cond = array('branch_id'=>$this->branchID);
   	 		$name=""; $mobile=""; $address="";
   	 	/*	$config['total_rows'] = $this->customer->get_all(array('conditions'=>$cond,'numrows'=>TRUE));
   	 		if($config['total_rows']==0){
   	 			$this->message->set($this->lang->line('customer-not-found'),'i');
   	 		}*/
   	 		$config['base_url'] = base_url('customer_master/report');
   	 		$config['per_page'] = $this->per_page();
   	 		$config['uri_segment'] = 3;
			# Pagination Config Customizations
        $config['full_tag_open'] = '<ul class="pagination">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = 'First';
        $config['last_link'] = 'Last';
        $config['next_link'] = '&raquo;';
        $config['prev_link'] = '&laquo;';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
            #----------validation
		
		    $this->form_validation->set_rules('name','name','xss_clean|trim');
		    $this->form_validation->set_rules('mobile','mobile','xss_clean|trim');
		    $this->form_validation->set_rules('address','address','xss_clean|trim');
		    
			/*$config['base_url'] .= '/name/'.$name;
			$config['uri_segment'] += 6;
			$redirect .= '/name/'.$name;*/
    		if($this->form_validation->run() === true)
    		{
    		    $name = $this->input->post('name',true);
    		    $mobile = $this->input->post('mobile',true);//print_r("$name");print_r("$mobile");
    		     $address = $this->input->post('address',true);
    		    if(!empty($this->input->post('name',true)))
    			{
    				$name = $this->input->post('name',true);
    				$like_array['fname'] = $name;
    				$config['base_url'] .= '/name/'.$name;
    				$config['uri_segment'] += 2;
    				$redirect .= '/name/'.$name;
    			}
    			if(!empty($this->input->post('mobile',true)))
    			{
    				$mobile = $this->input->post('mobile',true);
    				$like_array['mobile_no'] = $mobile;
    				$config['base_url'] .= '/mobile/'.$mobile;
    				$config['uri_segment'] += 2;
    				$redirect .= '/mobile/'.$mobile;
    			}
    		if(!empty($this->input->post('address',true)))
    			{
    				$address = $this->input->post('address',true);
    				$like_array['address'] = $address;
    				$config['base_url'] .= '/address/'.$address;
    				$config['uri_segment'] += 2;
    				$redirect .= '/address/'.$address;
    			}
    		}
	        else 
	        {
	        if(isset($uri_array['name']))
		    {
		        $name = $uri_array['name'];
				$like_array['name'] = $name;
				$config['base_url'] .= '/name/'.$name;
				$config['uri_segment'] += 2;
				$redirect .= '/name/'.$name;
		    }
		    if(isset($uri_array['mobile']))
    		    {
    		        $mobile = $uri_array['mobile'];
    				$like_array['mobile_no'] = $mobile;
    				$config['base_url'] .= '/mobile/'.$mobile;
    				$config['uri_segment'] += 2;
    				$redirect .= '/mobile/'.$mobile;
    		    }
    		    if(isset($uri_array['address']))
    		    {
    		        $address = $uri_array['address'];
    				$like_array['address'] = $address;
    				$config['base_url'] .= '/address/'.$address;
    				$config['uri_segment'] += 2;
    				$redirect .= '/address/'.$address;
    		    }
	        }
		    
		    $config['total_rows'] = $this->customer->get_all(array('conditions'=>$cond,'numrows'=>TRUE));
   	 		if($config['total_rows']==0)
   	 		{
   	 			$this->message->set($this->lang->line('customer-not-found'),'i');
   	 		}
   	 		$this->pagination->initialize($config);
   	 		$links = $this->pagination->create_links();
   	 		$offset = $this->uri->segment($config['uri_segment'],0);
    
            $customers = $this->customer->get_all(array('conditions'=>$cond,'like' => $like_array,'order_by'=>'created_on','order'=>'DESC','limit'=>$config['per_page'],'offset'=>$offset));
            
			#template
			$this->template->title($this->lang->line('customers'));
			$this->template->main_heading($this->lang->line('customers'));
			$this->template->breadcrumb(array($this->lang->line('customer')=>'customer_master/add',$this->lang->line('report')=>'no_link'));
			
			$this->template->slice('dms/message');
			if(!empty($customers))
			{
		        $this->template->slice('customer/new/report',array('offset'=>$offset,'links'=>$links,'customers'=>$customers,'name'=>$name,'mobile'=>$mobile,'address'=>$address));
			}
			$this->template->slice('dms/modals/more_details');
			$this->template->other_script('customer/show_customer');
			$this->template->render();
        }
        
        public function customer_data()
        {
			$from_date = $to_date = $cur_date = date('Y-m-d');
   	 		$cond="";
   	 		$redirect ="";
   	 		
   	 		if(isset($_POST['filter']))
   	 		{
   	 		    if(!empty($this->input->post('branch_id',true)))
    			{
    			    $bid = $this->input->post('branch_id',true);
    			    $cond .= " and a.branch_id='$bid'";
    			    $redirect .= '/bid/'.$bid;
    			}
    			if(!empty($this->input->post('from_date',true)))
    			{
    			    $from_date = date('Y-m-d',strtotime($this->input->post('from_date',true)));
    			}  
    			if(!empty($this->input->post('to_date',true)))
    			{
    			    $to_date = date('Y-m-d',strtotime($this->input->post('to_date',true)));
    			}  
   	 		}
   	 		
   	 		$cond .= " and a.bill_date between '$from_date' and '$to_date'";
   	 		$redirect .= '/fdate/'.$from_date.'/tdate/'.$to_date;
   	 		
   	 		$customer_array = $this->db->query("select distinct a.customer_id,a.bill_no,a.bill_date,a.branch_id,b.branch_name,c.fname,c.lname,c.mobile_no,c.address from dms_sales as a join branch_master as b on a.branch_id=b.id join customer_master as c on a.customer_id=c.id where a.status=1 $cond order by a.id desc")->result_array();
   	 		$customer_count = count($customer_array);
   	 		
   	 		if($customer_count == 0)
   	 		{
   	 			$this->message->set($this->lang->line('customer-not-found'),'i');
   	 		}
   	 		 
            #branches
			$this->load->model('branches/Branch_model','branch');
			$branches = $this->branch->listing(array('company_id'=>$this->session->userdata('company_id')));
			$branches[''] = 'Select a branch';
			ksort($branches);
            
            #template
			$this->template->title($this->lang->line('customers'));
			$this->template->main_heading($this->lang->line('customers'));
			$this->template->breadcrumb(array($this->lang->line('customer')=>'customer_master/add',$this->lang->line('report')=>'no_link'));
			$this->template->slice('dms/message');
			if(!empty($customer_array))
			{
		        $this->template->slice('customer/new/customer_data',array('customers'=>$customer_array,'branches'=>$branches,'from_date'=>$from_date,'to_date'=>$to_date,'redirect'=>$redirect));
			}
			$this->template->slice('dms/modals/more_details');
			$this->template->other_script('customer/show_customer');
			$this->template->render();
        }
	   
	    #---------------------------------dob reprt----------------------------------------------------- 
	   
	    public function report_dob()
	    {
			#pagination
   	 		$this->load->library('Pagination');
   	 		$like_array = array();$like_arr = array();
   	 		
   	 		$cond="";
   	 		$cond = array('branch_id'=>$this->branchID);
   	 		$config['total_rows'] = $this->customer->get_all(array('conditions'=>$cond,'numrows'=>TRUE));
   	 		if($config['total_rows']==0)
   	 		{
   	 			$this->message->set($this->lang->line('customer-not-found'),'i');
   	 		}
   	 		$config['base_url'] = base_url('customer_master/report_dob');
   	 		$config['per_page'] = $this->per_page();
   	 		$config['uri_segment'] = 3;
			# Pagination Config Customizations
        $config['full_tag_open'] = '<ul class="pagination">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = 'First';
        $config['last_link'] = 'Last';
        $config['next_link'] = '&raquo;';
        $config['prev_link'] = '&laquo;';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
            #----------validation
		
		    $this->form_validation->set_rules('name','name','xss_clean|trim');
		    $this->form_validation->set_rules('mobile','mobile','xss_clean|trim');
		    
			$config['base_url'] .= '/name/'.$name;
			$config['uri_segment'] += 6;
			$redirect .= '/name/'.$name;
			
		    if($this->form_validation->run() === true)
		    {
    		    $name = $this->input->post('name',true);
    		    $mobile = $this->input->post('mobile',true);//print_r("$name");print_r("$mobile");
    		    $dob = $this->input->post('dob',true);
    		    $bdaymonth=$this->input->post('bdaymonth',true);
    		    $month = date('m', strtotime($bdaymonth));
		        if(!empty($this->input->post('name',true)))
			    {
    				$name = $this->input->post('name',true);
    				$like_array['fname'] = $name;
    				$config['base_url'] .= '/name/'.$name;
    				$config['uri_segment'] += 2;
    				$redirect .= '/name/'.$name;
    			}
    			if(!empty($this->input->post('mobile',true)))
    			{
    				$mobile = $this->input->post('mobile',true);
    				$like_array['mobile_no'] = $mobile;
    				$config['base_url'] .= '/mobile/'.$mobile;
    				$config['uri_segment'] += 2;
    				$redirect .= '/mobile/'.$mobile;
    			}
    			if(!empty($this->input->post('dob',true)))
    			{
    				$dobn = $this->input->post('dob',true);
    				$dob =date('Y-m-d',strtotime($dobn));
    				$like_array['dob'] = $dob;
    				$config['base_url'] .= '/dob/'.$dob;
    				$config['uri_segment'] += 2;
    				$redirect .= '/dob/'.$dob;
    			}
    			if(!empty($this->input->post('bdaymonth',true)))
    			{
    				$dobnm = $this->input->post('bdaymonth',true);
    				$month = date('m', strtotime($dobnm));
    				$like_array['dob'] = $month;
    				$config['base_url'] .= '/month/'.$month;
    				$config['uri_segment'] += 2;
    				$redirect .= '/month/'.$month;
    			}
		    }
	        else if(isset($uri_array['name']))
		    {
		        $name = $uri_array['name'];
				$like_array['name'] = $name;
				$config['base_url'] .= '/name/'.$name;
				$config['uri_segment'] += 2;
				$redirect .= '/name/'.$name;
		    }
		
   	 		$this->pagination->initialize($config);
   	 		$links = $this->pagination->create_links();
   	 		$offset = $this->uri->segment($config['uri_segment'],0);

            $customers = $this->customer->get_all(array('conditions'=>$cond,'like' => $like_array,'order_by'=>'created_on','order'=>'DESC','limit'=>$config['per_page'],'offset'=>$offset));
            
			#template
			$this->template->title($this->lang->line('customers'));
			$this->template->main_heading($this->lang->line('customers'));
			$this->template->breadcrumb(array($this->lang->line('customer')=>'customer_master/add',$this->lang->line('report')=>'no_link'));
			//$this->template->slice('customer/new/search_report',array('customers'=>$customers));
			$this->template->slice('dms/message');
			if(!empty($customers))
			{
		        $this->template->slice('customer/new/report_dob',array('offset'=>$offset,'links'=>$links,'customers'=>$customers));
			}
			
			$this->template->slice('dms/modals/more_details');
			$this->template->other_script('customer/show_customer');
			$this->template->render();
        }
	   
	    #-------------------------------------------------------------------------

		public function update($id)
		{
            if(!$this->uri->segment(3))
            {
				redirect('customer_master/report');
			}
			$customer_id = $this->uri->segment(3);
			if($this->if_exists('customer_master',array('id'=>$customer_id,'status'=>1)) === false)
			{
				redirect('customer_master/report');
			}

   	 		if(empty($customer_id)){ redirect('customer_master/report');}
   	 		#get customer details
   	 		$customer = $this->customer->get_all(array('conditions'=>array('cm.id'=>$customer_id)))[0];
   	 		$open_bal = array();
			if($customer['ledger_id'] !=0)
			{
				$open_bal = $this->customer->open_balance($customer['ledger_id']);
			}
			$this->load->model('accounts/Ledger_model','ledger');
			if(isset($_POST['btn_update']))
		{
   	 		/*if($this->form_validation->run('update') === TRUE)
   	 		{*/
                $data = $this->input->post(NULL,TRUE);
   	 			$open_amount = $this->input->post('open_amount',TRUE);
				$dc_type =  $this->input->post('dc_type',TRUE);
   	 			if($this->input->post('open_id',TRUE))
   	 			{
					if($open_amount != 0)
					{
						$ledger['ledger_name'] = $data['fname'].'-'.$data['mobile_no'];
						$ledger['sgroup_id'] = 15;
						$ledger['dc'] = $this->ledger->get_dc($ledger['sgroup_id']);
						$this->ledger->update(array('table'=>'dms_ledgers','data'=>$ledger,'conditions'=>array('id'=>$data['ledger_id'])));
						if($dc_type != $ledger['dc'])
						{
							$open['open_amount'] = -$open_amount;
						}
						else
						{
							$open['open_amount'] = $open_amount;
						}
						$this->ledger->update(array('table'=>'dms_ledger_open_bals','data'=>$open,'conditions'=>array('id'=>$data['open_id'])));
					}
					else
					{
						if($open_bal['vat'] == 1)
						{
							$ledger['ledger_name'] = $data['fname'].'-'.$data['mobile_no'];
							$ledger['sgroup_id'] = 15;
							$ledger['dc'] = $this->ledger->get_dc($ledger['sgroup_id']);
							$this->ledger->update(array('table'=>'dms_ledgers','data'=>$ledger,'conditions'=>array('id'=>$data['ledger_id'])));
							$open['open_amount'] = 0;
							$this->ledger->update(array('table'=>'dms_ledger_open_bals','data'=>$open,'conditions'=>array('id'=>$data['open_id'])));
						}
						else
						{
							$this->customer->my_update('dms_ledger_open_bals',array('status'=>0),array('id'=>$data['open_id']));
						}
					}
					unset($data['open_id']);
					unset($data['ledger_id']);
				}
				else
				{
				    
					$ledger['ledger_name'] = $data['fname'].'-'.$data['mobile_no'];
					$ledger['sgroup_id'] = 15;
					$ledger['dc'] = $this->ledger->get_dc($ledger['sgroup_id']);
					$this->customer->my_update('dms_ledgers',$ledger,array('id'=>$data['ledger_id']));
					if(!empty($open_amount))
					{
						if($dc_type != $ledger['dc'])
						{
							$open['open_amount'] = -$open_amount;
						}
						else
						{
							$open['open_amount'] = $open_amount;
						}
						$open['ledger_id'] = $data['ledger_id'];
						$open['company_id'] = $this->companyID;
						$open['branch_id'] = $this->branchID;
						$open['open_date'] = $this->dms->get_fiscal_year()['start_date'];
						$this->ledger->insert('dms_ledger_open_bals',$open);
					}
					unset($data['ledger_id']);
				}
				unset($data['open_amount']);unset($data['dc_type']);
				$customer_array = array();
				$customer_array['fname'] = $data['fname'];
				$customer_array['lname'] = $data['lname'];
				$customer_array['address'] = $data['address'];
				$customer_array['state'] = $data['state'];
				$customer_array['district'] = $data['district'];
				$customer_array['area_id'] = $data['area_id'];
				$customer_array['email_id'] = $data['email_id'];
				$customer_array['mobile_no'] = $data['mobile_no'];
				$customer_array['phone_no'] = $data['phone_no'];
				$customer_array['phone_no'] = $data['phone_no'];
   	 			//if($this->customer->update_a(array('table'=>'customer_master','data'=>$data,'conditions'=>array('id'=>$customer_id))))
   	 			if($this->customer->my_update('customer_master',$customer_array,array('id'=>$customer_id)))
   	 			{
					$this->message->set($this->lang->line('customer-update'));
				}
				else
				{
					$this->message->set($this->lang->line('customer-not-update'));
				}
				$call_ck_uri = $this->uri->uri_to_assoc(4);
				redirect($this->uri->assoc_to_uri($call_ck_uri));
   	 		//}
}
   	 		#get all areas
			$this->load->model('areas/Area_model','area');
			$areas = $this->area->listing();
			$areas[''] = 'Select';ksort($areas);
			$dc_array = array('dr' => 'Dr','cr' => 'Cr');
            
   	 		#template
   	 		$this->template->title($this->lang->line('customers'));
   	 		$this->template->main_heading($this->lang->line('customers'));
   	 		$this->template->breadcrumb(array($this->lang->line('customer')=>'customer_master/add',$this->lang->line('update')=>'no_link',$this->lang->line('report')=>'customer_master/report'));
   	 		$this->template->slice('customer/new/edit',array('areas'=>$areas,'customer'=>$customer,'open_bal'=>$open_bal,'dc_array'=>$dc_array));
   	 		$this->template->render();
		}

	    #-----------------------------------------------------------------------

		public function delete($id)
		{
			$customer_id = $id;
			if(empty($customer_id)){ redirect('customer_master/report');}

			if($this->if_exists('customer_master',array('id'=>$customer_id,'status'=>1)) === false)
			{
				redirect('customer_master/report');
			}

			$data['status'] = 0;
			$data['created_by'] = $this->session->userdata('id');
			$data['created_on'] = date('Y-m-d h:i:s');
			$customer = $this->customer->get_all(array('conditions'=>array('cm.id'=>$customer_id)))[0];
			$ledgerID = $customer['ledger_id'];

			$total_vouchers = $this->db->select('id')->from('dms_vouchers')->where(array('status !='=>0,'dr_ledger'=>$ledgerID))->or_where('cr_ledger',$ledgerID)->get()->num_rows();
			$total_sales = $this->db->select('id')->get_where('dms_sales',array('customer_type_id'=>2,'customer_id'=>$customer_id,'status !='=>0))->num_rows();
			$total_so = $this->db->select('id')->get_where('dms_sales_orders',array('customer_type_id'=>2,'customer_id'=>$customer_id,'status !='=>0))->num_rows();
			$total_so_temp = $this->db->select('id')->get_where('dms_sales_order_temp',array('customer_type_id'=>2,'customer_id'=>$customer_id))->num_rows();
			$total_sreturns = $this->db->select('id')->get_where('dms_sales_returns',array('customer_type_id'=>2,'customer_id'=>$customer_id,'status !='=>0))->num_rows();
			$total_dnotes = $this->db->select('id')->get_where('dms_delivery_notes',array('customer_type_id'=>2,'customer_id'=>$customer_id,'status !='=>0))->num_rows();
			$total_rej_ins = $this->db->select('id')->get_where('dms_rejection_ins',array('customer_type_id'=>2,'customer_id'=>$customer_id,'status !='=>0))->num_rows();
			$total_vreceipts = $this->db->select('id')->get_where('dms_voucher_against_bills',array('customer_type_id'=>2,'customer_id'=>$customer_id,'status !='=>0))->num_rows();

			if(empty($total_vouchers) && empty($total_sales) && empty($total_so) && empty($total_so_temp) && empty($total_sreturns) && empty($total_vreceipts) && empty($total_dnotes) && empty($total_rej_ins))
			{
				if($this->customer->delete_a(array('table'=>'customer_master','data'=>$data,'conditions'=>array('id'=>$customer_id))))
				{
					$this->customer->delete_a(array('table'=>'dms_ledgers','data'=>array('status'=>0),'conditions'=>array('id'=>$ledgerID)));
					$this->customer->delete_a(array('table'=>'dms_ledger_open_bals','data'=>array('status'=>0),'conditions'=>array('ledger_id'=>$ledgerID)));
					$this->message->set($this->lang->line('customer-deleted'),'s');
				}
				else
				{
					$this->message->set($this->lang->line('customer-not-deleted'),'e');
				}
			}
			else
			{
				$this->message->set($this->lang->line('can-not-delete-customer'),'i');
			}
			redirect('customer_master/report');
		}

	    #-----------------------------------------------------------------------
	   
		public function add_customer()
		{
			$uri_array = $this->uri->uri_to_assoc(3);
			if(!$this->uri->segment(3) || !$this->uri->segment(4))
			{
				redirect('users/logout');
			}
			$uri_string = $this->uri->assoc_to_uri($uri_array);
   	 		$this->template->title($this->lang->line('add-new-customer'));
   	 		$this->template->main_heading($this->lang->line('add-new-customer'));
   	 		$this->template->breadcrumb(array($this->lang->line('add-new-customer')=>'no_link',$this->lang->line('go-back')=>$uri_string));
			$status = 1;
			if($this->uri->segment(3) == 'purchase_requests')
			{
				$status = -1;
			}
			$this->load->model('areas/Area_model','area');
			$areas = $this->area->listing();
			$areas[''] = 'Select';ksort($areas);

			$this->form_validation->set_rules('fname','lang:first-name','xss_clean|required');
			$this->form_validation->set_rules('lname','lang:last-name','xss_clean');
			$this->form_validation->set_rules('email_id','lang:email','xss_clean');
			$this->form_validation->set_rules('address','lang:address','xss_clean');
			$this->form_validation->set_rules('mobile_no','lang:mobile','xss_clean|is_natural|exact_length[10]');

			if(!$this->input->post('new_area'))
			{
				$this->form_validation->set_rules('area_id','lang:area','xss_clean|required');
			}
			else
			{
				$this->form_validation->set_rules('new_area_name','lang:area','xss_clean|required|is_unique[area_master.area]');
			}
			$this->form_validation->set_rules('state','lang:state','xss_clean');
			$this->form_validation->set_rules('district','lang:district','xss_clean');
			$this->form_validation->set_rules('phone_no','lang:landline','xss_clean');

			if($this->form_validation->run() === true)
			{
			    $postedValues = $this->input->post();
                $this->db->select('id');
		        $this->db->from('customer_master');
                if(empty($postedValues['mobile_no']))
                { 
                    $postedValues['mobile_no']=""; 
                }
		        
		        $this->db->where(array('mobile_no'=>$postedValues['mobile_no'],'fname'=>$postedValues['fname'],'status!='=>0));
                $customer = $this->db->get()->row_array();
		        if(empty($customer))
		        {  
					$postedValues['branch_id'] = $this->branchID;
					$postedValues['status'] = $status;

					if(!$this->input->post('new_area'))
					{
						$area_id = $this->input->post('area_id');
						$postedValues['area_id'] = $area_id;
						unset($postedValues['new_area_name']);
					}
					else
					{
						$new_area_name = $this->input->post('new_area_name');
						unset($postedValues['new_area_name'],$postedValues['new_area']);
						$area_id = $this->customer->f_save('area_master',array('company_id'=>$this->companyID,'area'=>$new_area_name));
						$postedValues['area_id'] = $area_id;
					}

					$this->load->model('accounts/Ledger_model','ledger');
					$ledger['company_id'] = $this->companyID;
					$ledger['ledger_name'] = $postedValues['fname'].$postedValues['lname'].' '.$postedValues['mobile_no'];
					$ledger['branch_id'] = $this->branchID;
					$ledger['sgroup_id'] = 15;
					$ledger['status'] = $status;
					$ledger['dc'] = $this->ledger->get_dc($ledger['sgroup_id']);
					$ledgerID = $this->ledger->insert('dms_ledgers',$ledger);
					$postedValues['ledger_id'] = $ledgerID;
	
					if($this->customer->f_save('customer_master',$postedValues))
					{
						$this->message->set($this->lang->line('customer-save'));
					}
					else
					{
						$this->message->set($this->lang->line('customer-not-save'),'e');
					}
					redirect($uri_string);				
				}
				else
				{ 
			        $this->message->set($this->lang->line('already-exists'),'e');
		        }
            }
			
   	 		$this->template->slice('customer/new/add_customer',array('areas'=>$areas));
			$this->template->other_script('customer/show_customer');
   	 		$this->template->render();		   
	   }
	   
	   #-----------------------------------------------------------------------
	   
	   public function edit_customer()
	   {
			$customerID = $this->uri->segment(3);
			$uri_array = $this->uri->uri_to_assoc(4);
			$uri_string = $this->uri->assoc_to_uri($uri_array);		   
   	 		$this->template->title($this->lang->line('edit-customer'));
   	 		$this->template->main_heading($this->lang->line('edit-customer'));
   	 		$this->template->breadcrumb(array($this->lang->line('edit-customer')=>'no_link',$this->lang->line('go-back')=>$uri_string));
			
			$args = array();
			$args['select'] = array('id','branch_id','ledger_id','fname','lname','address','state','district','area_id','	mobile_no','phone_no','email_id','status');
			$args['conditions'] = array('id'=>$customerID);
			$customers = $this->customer->get($args);

			$this->form_validation->set_rules('fname','lang:first-name','xss_clean|required');
			$this->form_validation->set_rules('lname','lang:last-name','xss_clean');
			$this->form_validation->set_rules('email_id','lang:email','xss_clean');
			$this->form_validation->set_rules('address','lang:address','xss_clean');
			$this->form_validation->set_rules('mobile_no','lang:mobile','xss_clean|required|is_natural|exact_length[10]|is_edit_unique[customer_master.mobile_no.'.$customerID.']');
			$this->form_validation->set_rules('state','lang:state','xss_clean');
			$this->form_validation->set_rules('district','lang:district','xss_clean');
			$this->form_validation->set_rules('phone_no','lang:landline','xss_clean');
			
			if($this->form_validation->run() === true)
			{
				$postedValues = $this->input->post();
				$postedValues['branch_id'] = $this->branchID;
				if($customers[0]['status'] != 1)
				{
					if($this->customer->update_a(array('table'=>'customer_master','data'=>$postedValues,'conditions'=>array('id'=>$customerID))))
					{
						$this->message->set($this->lang->line('customer-update'));
					}
					else
					{
						$this->message->set($this->lang->line('customer-not-update'),'e');
					}
				}
				else
				{
					$this->message->set($this->lang->line('customer-not-update'),'e');
				}
				redirect($uri_string);
			}
			
   	 		$this->template->slice('customer/new/edit_customer',array('customer'=>$customers[0]));
   	 		$this->template->render();			   
	   }
	   
	   #------------------------------------------------------------------------
	}
?>