<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Daybooks extends MY_Controller{

	public function __construct()
	{
		parent :: __construct();		
		$this->check_access_right();

		$this->load->library('Accounts');
	}
	
	public function index()
	{
		$fiscal_start_date = $this->dms->get_fiscal_year()['start_date'];
	//	$from_date = $to_date = $fiscal_start_date;
	    $from_date = $to_date = date('Y-m-d');
		$vouchers_array = array();$vtype_id = $opening_bal = 0;$dc = "";
		
		if(isset($_POST['btn_search']))
		{
			#-------------validation
			$this->form_validation->set_rules('vtype_id','lang:voucher-types','required|xss_clean');
			$this->form_validation->set_rules('from_date','lang:from-date','required|xss_clean|valid_date');
			if($this->input->post('from_date',true))
			{
				$from_date = $this->input->post('from_date',true);
				$this->form_validation->set_rules('to_date','lang:to-date',"required|xss_clean|valid_date|check_date[$from_date.>=]");
			}
			if($this->form_validation->run() === true)
			{
				$vtype_id = $this->input->post('vtype_id',true);
				$from_date = date('Y-m-d',strtotime($this->input->post('from_date',true)));
				$to_date = date('Y-m-d',strtotime($this->input->post('to_date',true)));
				$this->session->set_userdata(array('from_date' => $from_date,'to_date' => $to_date));
			}
		}	
		else
		{
			if($this->uri->segment(4))
			{
				$vtype_id = xss_clean($this->uri->segment(4));				
			}
			if($this->session->userdata('from_date') && $this->session->userdata('to_date'))
			{
				$from_date = $this->session->userdata('from_date');
				$to_date = $this->session->userdata('to_date');				
				
				#----------validating dates
				if(!$this->form_validation->valid_date($from_date) || !$this->form_validation->valid_date($to_date)){
					redirect('users/logout');
				}
				else{
					if(!$this->form_validation->check_date($from_date,$to_date.".<=")){
						redirect('users/logout');
					}
				}
			}
		}	
		if(!empty($from_date) && !empty($to_date))
		{
			#-----------setting session variables
			$this->session->set_userdata(array('vtype_id' => $vtype_id,'from_date' => $from_date,'to_date' => $to_date));
			$data_array = array('table' => 'dms_vouchers','columns' => array('group_id','vtype_id','vno','vdate','dr_ledger','cr_ledger','vamount','table_name','table_group_id'),'conditions' => array('branch_id' => $this->session->userdata('under_id'),'vamount>'=>0,'status' => 1),'between' => "vdate between '$from_date' and '$to_date'",'order_by' => 'vdate','order' => 'asc');
			if($vtype_id > 0){
				$data_array['conditions']['vtype_id'] = $vtype_id;
			}
			$vouchers_array = $this->dms->get_data($data_array);
		}
		
		#-------------voucher type details		
		$vtype_array = $this->dms->get_data(array('table' => 'dms_voucher_types','columns' => array('id','vtype'),'or' => "(company_id=".$this->session->userdata('company_id')." or company_id=0)",'conditions' => array('status' => 1),'order_by' => 'vid','order' => 'asc'));
		$vtypes[0] = "All"; 
		foreach($vtype_array as $key => $value)
		{
			$vtypes[$value['id']] = $value['vtype'];
		}
		
		#-------------template
		$this->template->title('Day Book');
		$this->template->main_heading('Day Book');
		$this->template->breadcrumb(array($this->lang->line('account-reports') => 'no_link',$this->lang->line('day-book') => 'no_link'));
		$this->template->slice('account_reports/daybook_search',array('vtypes' => $vtypes,'vtype_id' => $vtype_id,'from_date' => $from_date,'to_date' => $to_date));	
		if(!empty($vouchers_array))
		{
			$this->template->append('account_reports/daybooks',array('voucher_array' => $vouchers_array,'vtype_id' => $vtype_id,'from_date' => $from_date,'to_date' => $to_date));
		}
		else{
			$this->message->set($this->lang->line('no-result-found'),'i');
		}
		$this->template->slice('dms/message');
		$this->template->render();
	}
}