<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
	
	class Departments extends MY_Controller{

		public function __construct(){

			parent :: __construct();
			$this->load->library('Form_validation');
			$this->check_access_right();
			$this->load->model('departments/Department_master_model','dept');
						
			#---------------- Checking Financial year is enabled / closed-----------------#
			$method_array = array('manage','update','delete');
			fiscal_status($this->uri->segment(2),$method_array,"departments/report");	
			#---------------- Checking Financial year is enabled / closed-----------------#
			
		}
		
		#--------------------------------------------------------
		
		public function manage(){

			$this->template->title($this->lang->line('departments'));
			$this->template->main_heading($this->lang->line('departments'));
			$this->template->script(array('dms_script'));

			#set validation rules
			$this->form_validation->set_rules('department_name','department name','trim|xss_clean|required|callback_does_exist');
			$this->form_validation->set_rules('description','description','trim');

			if($this->form_validation->run() === true){
				
				#get for which shop
				$this->load->library('Dms');
				$data = $this->input->post(NULL,true);	
				$data['company_id'] = $this->session->userdata('company_id');

				#save the dept data.
				if($this->dept->f_save('department_master',$data)){

					$this->message->set($this->lang->line('dept_save_msg'));
				}else{
					$this->message->set($this->lang->line('dept_save_err_msg'),'e');
				}
				redirect('departments/report');

			}

			$this->template->breadcrumb(array($this->lang->line('settings')=>'preferences/',$this->lang->line('departments')=>'no_link',$this->lang->line('report')=>'departments/report'));
			$this->template->slice('dms/message');
			$this->template->slice('preferences/departments/new');
			$this->template->render();
		}

		#--------------------------------------------------------	
		#use :  callback validation for department
		
		public function does_exist($department_name){
			$this->db->from('department_master');
			$this->db->where("(company_id='0' OR company_id='".$this->session->userdata('company_id')."')");
			$this->db->where(array('department_name'=>$department_name,'status'=>1));
			$row = $this->db->get()->result_array();			
			if(!empty($row)){
				$this->form_validation->set_message('does_exist',$this->lang->line('department-name-already-exists'));
				return FALSE;
			}else{
				return TRUE;
			}		
		}

		#--------------------------------------------------------

		#show all designations
		public function report(){

			$this->load->library('Pagination');
   	 		$config['total_rows'] = $this->dept->get_all(array('numrows'=>TRUE));
   	 		$config['base_url'] = base_url('departments/report');
   	 		$config['per_page'] = $this->per_page();
   	 		$config['uri_segment'] = 3;
			# Pagination Config Customizations
        $config['full_tag_open'] = '<ul class="pagination">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = 'First';
        $config['last_link'] = 'Last';
        $config['next_link'] = '&raquo;';
        $config['prev_link'] = '&laquo;';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';	
   	 		$this->pagination->initialize($config);
   	 		$links = $this->pagination->create_links();
   	 		$offset = $this->uri->segment($config['uri_segment'],0);

   	 		$rows = $this->dept->get_all(array('order_by'=>'created_on','order'=>'DESC','limit'=>$config['per_page'],'offset'=>$offset));

			$this->template->title($this->lang->line('departments'));
			$this->template->main_heading($this->lang->line('departments'));
			$this->template->slice('dms/message');
			$this->template->breadcrumb(array($this->lang->line('settings')=>'preferences/',$this->lang->line('departments')=>'departments/manage',$this->lang->line('report')=>'no_link'));
			$this->template->slice('preferences/departments/report',array('depts'=>$rows,'links'=>$links,'offset'=>$offset));
			$this->template->slice('dms/modals/delete_confirm');#delete_confirm
			$this->template->render();

		}

		#----------------------------------------------------------

		public function update($id){
			
			if(empty($id) && !$this->input->post()){
				redirect('users/home');
			}

			$id = $this->uri->segment(3);
			if($this->if_exists('department_master',array('id'=>$id,'status'=>1)) === false){
				redirect('departments/report');
			}	
			if($id == 1){
				$this->message->set($this->lang->line('def-data-not-changed'),'i');
				redirect('departments/report');
			}
			#get detals of id
			$dept = $this->db->get_where('department_master',array('id'=>$id))->row_array();
			#set validation
			$this->form_validation->set_rules('department_name','department name',"trim|xss_clean|required|callback_edit_does_exist[$id]");
			$this->form_validation->set_rules('description','description','trim');

			if($this->form_validation->run() === true){

				$data = $this->input->post(NULL,TRUE);
				if($this->db->update('department_master',$data,array('id'=>$id))){
					$this->message->set($this->lang->line('dept-updated'));
					redirect('departments/report');
				}
				else{
					$this->message->set($this->lang->line('dept-not-updated'));
					redirect('departments/report');
				}
				
			}

			$this->template->title($this->lang->line('department-edit'));
			$this->template->main_heading($this->lang->line('department-edit'));
			$this->template->breadcrumb(array($this->lang->line('settings')=>'preferences/',$this->lang->line('update')=>'no_link',$this->lang->line('report')=>'departments/report'));
			$this->template->slice('preferences/departments/update',array('dept'=>$dept));
			$this->template->render();

		}

		#----------------------------------------------------------

		public function delete($id){

			if(empty($id)){
				redirect('users/home');
			}
			if($this->if_exists('department_master',array('id'=>$id,'status'=>1)) === false){
				redirect('departments/report');
			}	
			if($id == 1){
				$this->message->set($this->lang->line('def-data-not-changed'),'i');
				redirect('departments/report');
			}

			$total_designations = $this->db->select('id')->get_where('designation_master',array('department_id'=>$id,'status'=>1))->num_rows();
			$total_users = $this->db->select('id')->get_where('users',array('department_id'=>$id,'status'=>1))->num_rows();
			
			if(empty($total_designations) && empty($total_users)){
				
				if($this->db->update('department_master',array('status'=>0),array('id'=>$id))){
					$this->message->set($this->lang->line('dept-deleted'));
				}else{
					$this->message->set($this->lang->line('dept-not-deleted'));
				}

			}else{
				$this->message->set($this->lang->line('can-not-delete-department'),'i');
			}
			redirect('departments/report');
		}
	   	#-----------------------------------------------------------
	   	public function edit_does_exist($dept_name,$dept_id){
			$this->db->from('department_master');
			$this->db->where("(company_id='0' OR company_id='".$this->session->userdata('company_id')."')");
			$this->db->where(array('id !='=>$dept_id,'department_name'=>$dept_name,'status'=>1));
			$row = $this->db->get()->result_array();
			if(!empty($row)){
				$this->form_validation->set_message('edit_does_exist',$this->lang->line('department-name-already-exists'));
				return FALSE;
			}else{
				return TRUE;
			}		
		}	
	#----------------------------------------------------------


	}

?>