<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');
	
	class Employees extends MY_Controller{

		public function __construct(){
			parent :: __construct();			
		}

	#--------------------------------------------------------------------

		#date : 24-7-2014
		#purpose : get targets assigned for the logged in User
		public function my_targets(){
			
			#update all till-time targets as SEEN
			$this->load->model('targets/Target_model','target');
			$this->target->i_have_seen_my_targets($this->session->userdata('id'));
			
			#pagination
			$this->load->library('Pagination');
			$config['per_page'] = $this->per_page();
			# Pagination Config Customizations
			$config['full_tag_open'] = '<ul class="pagination">';
			$config['full_tag_close'] = '</ul>';
			$config['first_link'] = 'First';
			$config['last_link'] = 'Last';
			$config['next_link'] = '&raquo;';
			$config['prev_link'] = '&laquo;';
			$config['cur_tag_open'] = '<li class="active"><a href="#">';
			$config['cur_tag_close'] = '</a></li>';
			$config['num_tag_open'] = '<li>';
			$config['num_tag_close'] = '</li>';
			$config['base_url'] = base_url('employees/my_targets/');
			//$config['uri_segment'] = 4;
			$config['total_rows'] = $this->target->get_all(array('t.user_id'=>$this->session->userdata('id'),'total'=>1));
			$this->pagination->initialize($config);
			$links = $this->pagination->create_links();
			$offset = (null !== $this->uri->segment(3))?$this->uri->segment(3):0;
			$offset = $this->uri->segment(3,0);
			
			$targets=$this->target->get_all(array('t.user_id'=>$this->session->userdata('id'),'limit'=>$config['per_page'],'offset'=>$offset));
			
			#target deadline
			$timeTarget = $this->get_target();

			if(!empty($targets))
			{
			$this->template->slice('employees/targets/report',array('targets'=>$targets,'ttarget'=>$timeTarget,'links'=>$links,'offset'=>$offset));
			} else { $this->message->set($this->lang->line('no-target'),'e'); }
			$this->template->title('My Targets');
			$this->template->main_heading($this->lang->line('targets'));
			$this->template->breadcrumb(array($this->lang->line('targets')=>'no_link'));
			$this->template->slice('dms/message');
			$this->template->render();
		}

	#--------------------------------------------------------------------
	
}