<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
	
class Fiscal extends MY_Controller{

	public function __construct(){
		parent :: __construct();
		#$this->check_access_right();
		$this->load->model('fiscals/Fiscal_model','fiscal');		
		$this->template->other_script('fiscal/fiscals');
	}

#-----------------------------------------------------
	
	public function manage()
	{		
		#----------template
		$this->template->main_heading($this->lang->line('fiscal year'));
		$this->template->breadcrumb(array($this->lang->line('settings') => 'preferences/',$this->lang->line('fiscal year')=>'no_link'));
		$this->template->slice('dms/message');

		#-----------fiscal years
		$fiscals = $this->fiscal->get(array('columns' => array('id','company_id','start_date','end_date','close_status'),'order_by'=>'start_date','order'=>'DESC'));
		if(!empty($fiscals))
		{
			#-----------next close year details
			$close_fiscal = $this->fiscal->get(array('columns' => 'id','cond' => array('close_status' => 1),'order_by' => 'fiscal_order','order' => 'asc','limit' => 1,'offset' => 0))[0];		
			$this->template->slice('preferences/fiscal_years/report',array('fiscals'=>$fiscals,'close_fiscal' => $close_fiscal['id']));
		}
		$this->template->render();
	}

#-----------------------------------------------------

	public function set_default(){
		
		$id = $this->uri->segment(3,0);
		if($this->fiscal_check($id))
		{
			#update default=1 for the selected one
			if($this->db->update('users',array('fiscal_yr_id'=>$id),array('id'=>$this->session->userdata('id')))){
				$this->session->set_userdata('fiscal_yr_id',$id);
				if($this->session->userdata('from_date') && $this->session->userdata('to_date'))
				{
					$this->session->unset_userdata(array('from_date' => '','to_date' => ''));
				}
				$this->message->set($this->lang->line('fiscal-year-updated'));
			}
			else{
				$this->message->set($this->lang->line('fiscal-year-not-updated'),'e');
			}
			if($this->uri->uri_to_assoc(4)){
				$redirect_uri = $this->uri->uri_to_assoc(4);
				redirect($this->uri->assoc_to_uri($redirect_uri));
			}
		}
		redirect('fiscal/manage');		
	}

#-----------------------------------------------------
	public function update()
	{
		$id = $this->uri->segment(3,0);

		#-----------closing year details
		$close_fiscal = $this->fiscal->get(array('columns' => array('id','start_date','end_date','fiscal_order'),'cond' => array('close_status' => 1),'order_by' => 'fiscal_order','order' => 'asc','limit' => 1,'offset' => 0))[0];
		
		if($close_fiscal['id'] == $id)
		{	
			#----------closing fiscal year details
			$fiscals = $this->fiscal->get(array('columns' => array('id','start_date','end_date'),'cond' => array('id'=>$id)))[0];
			
			#----------validation
			$this->form_validation->set_rules('end_date','lang:last date',"trim|required|is_date|check_date[$close_fiscal[start_date].>]");
	
			if($this->form_validation->run() == true)
			{
				$end_date = date('Y-m-d',strtotime($this->input->post('end_date',true)));
				
				#----------start transaction
				$this->db->trans_start();
				
				#------------updating closing fiscal year details	
				$this->fiscal->update('fiscal_year_master',array('end_date' => $end_date,'close_status' => 0),array('id'=>$id));
				
				#------------creating next fiscal year
				$start_date = date('Y-m-d',(strtotime($end_date)+86400));
				$fiscal_id = $this->fiscal->insert(array('company_id' => $this->session->userdata('company_id'),'start_date' => $start_date));
				$this->session->set_userdata('fiscal_yr_id',$fiscal_id);
				
				#------------updating fiscal year details of all users in that company
				$this->fiscal->update_others(array('table' => 'users','data' => array('fiscal_yr_id' => $fiscal_id),'conditions' => array('id' => $this->session->userdata('id'))));
				$this->fiscal->update_others(array('table' => 'users','data' => array('fiscal_yr_id' => $fiscal_id,'online_status' => 0),'conditions' => array('id !=' => $this->session->userdata('id'),'company_id' => $this->session->userdata('company_id'))));
				
				#----------end transaction
				$this->db->trans_complete();
					
				redirect("fiscal/close/");
			}
			$this->template->breadcrumb(array($this->lang->line('settings')=>'preferences/',$this->lang->line('fiscal year')=>'fiscal/manage',$this->lang->line('close')=>'no_link'));
			$this->template->main_heading($this->lang->line('close')." ".$this->lang->line('fiscal year'));
			$this->template->slice('dms/message');
			$this->template->slice('preferences/fiscal_years/update',array('fiscals'=>$fiscals));
			$this->template->render();
		}
		else
		{
			redirect('users/logout');
		}
	}

#-----------------------------------------------------
	public function close()
	{		
		#-----------closed & next fiscal year details
		$fiscal_details = $this->fiscal->get(array('columns' => array('id','start_date','end_date'),'order_by' => 'fiscal_order','order' => 'desc','limit' => 2,'offset' => 0));
		if(!empty($fiscal_details))
		{
			$close_fiscal = $fiscal_details[1];
			$next_start_date = $fiscal_details[0]['start_date'];
			
			#-----------checking branch_type (main branch / sub branch)			
			if($this->dms->branch_type())
			{
				$this->load->library('accounts');
				$total_income = $total_expense = 0;
				
				#------------income
				$income_array = $this->accounts->get_account_groups(array('columns' => 'id','or' => "(primary_group_id=10 or primary_group_id=13)"));
				if(!empty($income_array))
				{				
					foreach($income_array as $ikey => $ivalue)
					{
						$iopening_bal = $this->accounts->opening_bal($ivalue['id'],$close_fiscal['end_date'],3,$close_fiscal['start_date']);
						$ivoucher_array = $this->accounts->voucher_bal($ivalue['id'],$close_fiscal['end_date'],3,$close_fiscal['start_date']);					
						$ivoucher_bal = $ivoucher_array['cr_amount'] - $ivoucher_array['dr_amount'];
						$total_income += ($iopening_bal + $ivoucher_bal);
					}
				}
				
				#------------expense
				$expense_array = $this->accounts->get_account_groups(array('columns' => 'id','or' => "(primary_group_id=3 or primary_group_id=4 or primary_group_id=5 or primary_group_id=6)"));
				if(!empty($expense_array))
				{				
					foreach($expense_array as $ekey => $evalue)
					{
						$eopening_bal = $this->accounts->opening_bal($evalue['id'],$close_fiscal['end_date'],3,$close_fiscal['start_date']);
						$evoucher_array = $this->accounts->voucher_bal($evalue['id'],$close_fiscal['end_date'],3,$close_fiscal['start_date']);
						$evoucher_bal = $evoucher_array['dr_amount'] - $evoucher_array['cr_amount'];
						$total_expense += ($eopening_bal + $evoucher_bal);
					}
				}								
											
				#-----------closed stock
				$closed_voucher_stock_bal = $this->accounts->voucher_bal(16,$close_fiscal['end_date'],3,$close_fiscal['start_date']);//stock in hand voucher
				$closed_stock_bal = $this->accounts->stock_bal_amt($close_fiscal['end_date'],1,1);//stock in hand stock		
				$closed_stock = ($closed_voucher_stock_bal['dr_amount'] - $closed_voucher_stock_bal['cr_amount']) + $closed_stock_bal;				

				if($total_expense != 0 || $total_income != 0)
				{
					#-----------opening stock
					$total_expense += $this->accounts->stock_bal_amt($close_fiscal['start_date'],1);
					$total_income += $closed_stock;
				}
				
				#------------profit and loss
				$profit_loss = $this->accounts->opening_bal(7,$close_fiscal['start_date']);//Profit & Loss A/c
				$profit_loss += ($total_income - $total_expense);				
				
				#----------start transaction
				$this->db->trans_start();
					
				#-----------adding profit/loss of previous year as opening
				if(!empty($profit_loss))
				{
					$ledger_open_array = $this->dms->get_data(array('table' => 'dms_ledger_open_bals','columns' => array('id','open_amount'),'conditions' => array('branch_id' => $this->session->userdata('under_id'),'ledger_id' => 7,'open_date' => $next_start_date)));
					if(empty($ledger_open_array))
					{
						$this->fiscal->insert_others('dms_ledger_open_bals',array('company_id' => $this->session->userdata('company_id'),'branch_id' => $this->session->userdata('under_id'),'ledger_id' => 7,'open_amount' => $profit_loss,'open_date' => $next_start_date));
					}
					else
					{
						$profit_loss += $ledger_open_array[0]['open_amount'];
						$this->fiscal->update_others(array('table' => 'dms_ledger_open_bals','data' => array('open_amount' => $profit_loss),'conditions' => array('id' => $ledger_open_array[0]['id'])));
					}
				}
				
				#-----------adding closing stock of previous year as opening
				if(!empty($closed_stock))
				{					
					$this->fiscal->insert_others('dms_stock_open_bals',array('company_id' => $this->session->userdata('company_id'),'branch_id' => $this->session->userdata('under_id'),'open_amount' => $closed_stock,'open_date' => $next_start_date,'bal_type' => 1));
				}
				
				#------------assets
				$asset_array = $this->accounts->get_legders(array('columns' => 'a.id','or' => "(b.primary_group_id=1 or b.primary_group_id=2)"));				
				if(!empty($asset_array))
				{				
					foreach($asset_array as $akey => $avalue)
					{
						$aopening_bal = $this->accounts->opening_bal($avalue['id'],$close_fiscal['end_date'],2,$close_fiscal['start_date']);
						$avoucher_array = $this->accounts->voucher_bal($avalue['id'],$close_fiscal['end_date'],2,$close_fiscal['start_date']);						
						$avoucher_bal = $avoucher_array['dr_amount'] - $avoucher_array['cr_amount'];
						$total_asset = ($aopening_bal + $avoucher_bal);
						
						#-----------adding previous year bal. as opening for all asset ledgers
						if(!empty($total_asset))
						{
							$ledger_open_array = $this->dms->get_data(array('table' => 'dms_ledger_open_bals','columns' => array('id','open_amount'),'conditions' => array('branch_id' => $this->session->userdata('under_id'),'ledger_id' => $avalue['id'],'open_date' => $next_start_date)));
							if(empty($ledger_open_array))
							{
								$this->fiscal->insert_others('dms_ledger_open_bals',array('company_id' => $this->session->userdata('company_id'),'branch_id' => $this->session->userdata('under_id'),'ledger_id' => $avalue['id'],'open_amount' => $total_asset,'open_date' => $next_start_date));
							}
							else
							{
								$total_asset += $ledger_open_array[0]['open_amount'];
								$this->fiscal->update_others(array('table' => 'dms_ledger_open_bals','data' => array('open_amount' => $total_asset),'conditions' => array('id' => $ledger_open_array[0]['id'])));
							}	
						}
					}
				}
				
				#------------liability
				$liability_array = $this->accounts->get_legders(array('columns' => 'a.id','or' => "(b.primary_group_id=7 or b.primary_group_id=8 or b.primary_group_id=9 or b.primary_group_id=11 or b.primary_group_id=12)"));
				if(!empty($liability_array))
				{				
					foreach($liability_array as $lkey => $lvalue)
					{
						$lopening_bal = $this->accounts->opening_bal($lvalue['id'],$close_fiscal['end_date'],2,$close_fiscal['start_date']);
						$lvoucher_array = $this->accounts->voucher_bal($lvalue['id'],$close_fiscal['end_date'],2,$close_fiscal['start_date']);
						$lvoucher_bal = $lvoucher_array['cr_amount'] - $lvoucher_array['dr_amount'];
						$total_liability = ($lopening_bal + $lvoucher_bal);
						
						#-----------adding previous year bal. as opening for all liability ledgers
						if(!empty($total_liability))
						{
							$ledger_open_array = $this->dms->get_data(array('table' => 'dms_ledger_open_bals','columns' => array('id','open_amount'),'conditions' => array('branch_id' => $this->session->userdata('under_id'),'ledger_id' => $lvalue['id'],'open_date' => $next_start_date)));						
							if(empty($ledger_open_array))
							{
								$this->fiscal->insert_others('dms_ledger_open_bals',array('company_id' => $this->session->userdata('company_id'),'branch_id' => $this->session->userdata('under_id'),'ledger_id' => $lvalue['id'],'open_amount' => $total_liability,'open_date' => $next_start_date));
							}
							else
							{
								$total_liability += $ledger_open_array[0]['open_amount'];
								$this->fiscal->update_others(array('table' => 'dms_ledger_open_bals','data' => array('open_amount' => $total_liability),'conditions' => array('id' => $ledger_open_array[0]['id'])));
							}
						}
					}
				}
				
				#----------end transaction
				$this->db->trans_complete();
					
				$this->message->set($this->lang->line('close-fiscal-year'));
				redirect('fiscal/manage');
			}
			else
			{
				redirect('users/logout');
			}
		}		
	}
	
	#-----------------------------------------------------
	/*public function delete($id){

		if(empty($id)){
			redirect('users/logout');
		}
		$id = $this->uri->segment(3);
		if($this->fiscal_check($id))
		{
			if($this->fiscal->update('fiscal_year_master',array('status'=>0),array('id'=>$id))){		
				$this->message->set($this->lang->line('fiscal-year-deleted'));
			}
			else{
				$this->message->set($this->lang->line('fiscal-year-not-deleted'),'e');
			}
		}
		else
		{
			$this->message->set($this->lang->line('close-fiscal-year'),'e');
		}
		redirect('fiscal/manage');
	}*/
}
?>