<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');	
	class Fs extends MY_Controller{

		function __construct(){
			parent :: __construct();
			
			#---------------- Checking Financial year is enabled / closed-----------------#
			$method_array = array('assign_sites','edit_sv','delete_sv');
			fiscal_status($this->uri->segment(2),$method_array,"fs/site_visit_report");	
			#---------------- Checking Financial year is enabled / closed-----------------#
						
		}

	#------------------------------------------------------

		#date : 23-8-2014
		#purpose : info-block options for field staff site visits
		function index(){

			$this->template->title('site visits');
			$this->template->main_heading($this->lang->line('site-visits'));
			$this->template->breadcrumb(array($this->lang->line('fs')=>'no_link',$this->lang->line('site-visits')=>'no_link'));
			$this->template->slice('employees/sites/index');
			$this->template->render();
		}

	#------------------------------------------------------	
		
		#date : 23-8-2014
		#purpose : assign areas to field staffs
		function assign_sites(){

			$this->template->title('site visits');
			$this->template->main_heading($this->lang->line('site-visits'));
			$this->template->breadcrumb(array($this->lang->line('site-visits')=>'fs/',$this->lang->line('assign-sites')=>'no_link'));

			#list field staffs
			$fs = $this->user->listing(array('designation_id'=>5)); #assuming field staff is 5
			$fs[''] = 'Select a field employee'; ksort($fs);

			#list area/sites
			$this->load->model('areas/Area_model','site');
			$sites = $this->site->listing();
			$sites[''] = 'Select a site'; ksort($sites);

			$this->form_validation->set_rules('visit[fs_id]','lang:fs','required');

			if($this->input->post('save')){
				$this->form_validation->set_rules('visit[site_id]','lang:site','required|trim');
				$this->form_validation->set_rules('visit[date_of_visit]','lang:date','required|trim|is_date|xss_clean');
				$this->form_validation->set_rules('visit[assign_comment]','lang:comment','trim|xss_clean');
			}

			if($this->form_validation->run() == TRUE){
				
				#only if save btn pressed	
				if($this->input->post('save')){
					$this->load->model('users/Site_visit_model','site_visit');

					if($id = $this->site_visit->save($this->input->post('visit', TRUE))){

						#save notification message
						$this->message->save(array('message_to'=>$_POST['visit']['fs_id'],'message'=>'new-site-visit-added','table_name'=>'fs_site_visits','table_id'=>$id));

						$this->message->set($this->lang->line('set-site-visit'));
					}else{
						$this->message->set($this->lang->line('could-not-set-site-visit'),'e');
					}
				}
			}

			$this->template->slice('dms/message');
			$this->template->slice('employees/sites/assign',array('emps'=>$fs,'sites'=>$sites));
			$this->template->slice('dms/modals/more_details');
			$this->template->other_script('employees/site_visits');
			$this->template->render();

		}

	#--------------------------------------------------------
		#date : 25-8-2014
		#purpose : search site visit report
		function site_visit_report(){

			$this->template->title('field employee site visit report');
			$this->template->breadcrumb(array($this->lang->line('assign-sites')=>'fs/assign_sites',$this->lang->line('search')=>'no_link'));
			$this->template->main_heading($this->lang->line('visit-report'));

			$links = NULL; #dummy link
			$filter_data = array('from'=>'','to'=>'','fs_id'=>'','site_id'=>''); #dummy filter data

			#if submitted
			if($this->input->post('filter') || $this->uri->segment(3) != ''){

				
				$filter_data = ($this->input->post('filter'))?$this->input->post('search',TRUE):$this->uri->uri_to_assoc(3);
				$filter_data = array_filter($filter_data);
				#print_r($filter_data);

				if(empty($filter_data)){
					$this->message->set($this->lang->line('use-one-filter'),'e');
				}else{


				if($this->input->post('filter')){
					if(isset($filter_data['from']) && $filter_data['from'] != ''){
						$this->form_validation->set_rules('search[from]','lang:date','is_date');
					}

					if(isset($filter_data['to']) && $filter_data['to'] != ''){
						$this->form_validation->set_rules('search[to]','lang:date','is_date');
					}

					
				}	

				$this->form_validation->set_rules('search[fs_id]','lang:fs','xss_clean');
				$this->form_validation->set_rules('search[site_id]','lang:site','xss_clean');

				
				if($this->form_validation->run() == TRUE || $this->uri->segment(3)){

					$this->load->model('users/Site_visit_model','sv');

					$conditions = $filter_data;
					
					if(isset($filter_data['from']) && $conditions['from'] != ''){ $conditions['from'] = date('Y-m-d',strtotime($conditions['from'])); }
					if(isset($filter_data['to']) && $conditions['to'] != ''){ $conditions['to'] = date('Y-m-d',strtotime($conditions['to'])); }

					$this->load->library('Pagination');
					$config['per_page'] = $this->per_page();
					# Pagination Config Customizations
					$config['full_tag_open'] = '<ul class="pagination">';
					$config['full_tag_close'] = '</ul>';
					$config['first_link'] = 'First';
					$config['last_link'] = 'Last';
					$config['next_link'] = '&raquo;';
					$config['prev_link'] = '&laquo;';
					$config['cur_tag_open'] = '<li class="active"><a href="#">';
					$config['cur_tag_close'] = '</a></li>';
					$config['num_tag_open'] = '<li>';
					$config['num_tag_close'] = '</li>';
					$config['base_url'] = base_url('fs/site_visit_report').'/'.$this->uri->assoc_to_uri(array_filter($conditions));
					$config['uri_segment'] = count(array_filter($conditions)) * 2 + 3;
					$config['total_rows'] = $this->sv->filter_data(array('numrows'=>TRUE,'search'=>$filter_data));
					#echo $this->db->last_query();
					$this->pagination->initialize($config);
					$links = $this->pagination->create_links();

					$offset = $this->uri->segment($config['uri_segment'],0);
					$visits = $this->sv->filter_data(array('search'=>$conditions,'limit'=>$config['per_page'],'offset'=>$offset));
					#echo $this->db->last_query();

					if(empty($visits)){
						$this->message->set($this->lang->line('no-visit-data-found'),'e');
					}
				}

				}

			}

			#list field staffs
			$fs = $this->user->listing(array('designation_id'=>5)); #assuming field staff is 5
			$fs[''] = 'Select a field employee'; ksort($fs);

			#list sites
			$this->load->model('areas/Area_model','site');
			$sites = $this->site->listing();
			$sites[''] = 'Select site/area'; ksort($sites);

			#set dummy filter data again for the unset values
			if(!isset($filter_data['from'])){ $filter_data['from'] = ''; }
			if(!isset($filter_data['to'])){ $filter_data['to'] = ''; }
			if(!isset($filter_data['fs_id'])){ $filter_data['fs_id'] = ''; }
			if(!isset($filter_data['site_id'])){ $filter_data['site_id'] = ''; }

			if(!isset($visits)){ $visits = array(); }

			$this->template->slice('dms/message');
			$this->template->slice('employees/sites/site_visit_filter',array('employees'=>$fs,'links'=>$links,'data'=>$filter_data,'visits'=>$visits,'sites'=>$sites));
			$this->template->slice('dms/modals/more_details');
			$this->template->other_script('employees/site_visits');
			$this->template->render();
		}
	#--------------------------------------------------------

		#date : 26-8-2014
		#purpose : edit site visit(by admin)
		function edit_sv(){

			$id = $this->uri->segment(3);
			$this->load->model('users/Site_visit_model','sv');
			$site_visit = $this->sv->get_all(array('conditions'=>array('sv.id'=>$id)));
			#echo $this->db->last_query();die;

			if(empty($site_visit)){
				redirect('access/');
			}

			$this->form_validation->set_rules('visit[site_id]','lang:site','required');
			$this->form_validation->set_rules('visit[date_of_visit]','lang:date','required|is_date');
			$this->form_validation->set_rules('visit[assign_comment]','lang:comment','trim|xss_clean');

			if($this->form_validation->run() == TRUE){

				$visit = $this->input->post('visit',TRUE);
				if($this->sv->update(array('data'=>$visit,'conditions'=>array('id'=>$id)))){
					$this->message->set($this->lang->line('sv-data-updated'));
					$call_ck_uri = $this->uri->uri_to_assoc(4);
					redirect($this->uri->assoc_to_uri($call_ck_uri));
				}else{
					$this->message->set($this->lang->line('sv-data-not-updated'),'e');
				}
			}

			$this->template->title('Edit employee site visit');
			$this->template->main_heading($this->lang->line('site-visits'));
			$this->template->breadcrumb(array($this->lang->line('assign-sites')=>'fs/assign_sites',$this->lang->line('edit')=>'no_link'));

			#area listing
			$this->load->model('areas/Area_model','site');
			$sites = $this->site->listing();

			$this->template->slice('dms/message');
			$this->template->slice('employees/sites/edit_report',array('sites'=>$sites,'visit'=>$site_visit[0]));

			$this->template->render();
		}
	#--------------------------------------------------------	

		#date : 26-8-2014
		#purpose : delete a site visit record
		function delete_sv(){

			$id = $this->uri->segment(3);
			$this->load->model('users/Site_visit_model','sv');
			$site_visit = $this->sv->get_all(array('conditions'=>array('sv.id'=>$id)));
			#echo $this->db->last_query();die;

			if(empty($site_visit)){	redirect('access/'); }

			if($this->sv->update_a(array('table'=>'fs_site_visits','data'=>array('status'=>0),'conditions'=>array('id'=>$id)))){
				$this->message->set($this->lang->line('sv-data-deleted'));
			}else{
				$this->message->set($this->lang->line('sv-data-not-deleted'),'e');
			}
			
			$call_ck_uri = $this->uri->uri_to_assoc(4);
			redirect($this->uri->assoc_to_uri($call_ck_uri));
		}	

	#--------------------------------------------------------	

	}
?>