<?php if( ! defined('BASEPATH')) exit ();

class Gifts extends MY_Controller{

	#---------------------------------------------------------------

	public function __construct(){

		parent :: __construct();
	}

	#---------------------------------------------------------------

	public function pending(){

			$this->template->title($this->lang->line('pending-gifts'));
			$this->template->main_heading($this->lang->line('pending-gifts'));
			$this->template->breadcrumb(array($this->lang->line('pending-gifts')=>'no_link',$this->lang->line('approved-gifts') => 'gifts/approved',$this->lang->line('rejected-gifts')=>'gifts/rejected'));

			$user_types = $users = $user_points = array();
			$this->load->model('designations/Designation_master_model','designations');
			$this->load->model('users/User_point_model','user_points');
			$this->load->model('gift/Gift_model','gift');

			$conditions['us_ach.status'] = 1;
			$gift_array = $this->gift->get($conditions);
			if(empty($gift_array)){

				$this->message->set($this->lang->line('no-results-found'));

			}

			# view starts here--------------------------------
			$this->template->slice('dms/message');
			$this->template->slice('gift/pending_gift',array('gift_array'=>$gift_array));
			$this->template->render();


	}

	#---------------------------------------------------------------

	public function update(){

			/*if(!$this->uri->segment(3)){
			redirect('users/logout');
			}*/
			$this->createdBY = $this->session->userdata('id');
			$this->load->model('designations/Designation_master_model','designations');
			$this->load->model('gift/Gift_model','gift');
			$requestID = $this->uri->segment(3);
			if($this->if_exists('dms_user_achievements',array('id'=>$requestID,'status'=>1)) === false){
				redirect('gifts/pending');
			}
			$this->form_validation->set_rules('update_status','lang:gift','required|trim|xss_clean');
			if($this->form_validation->run() === true){

				$status = $this->input->post('update_status',true);
				$remark = $this->input->post('remark',true);
				$gift['status'] = $status;
				$gift['updated_remark'] = $remark;
				$gift['updated_by'] = $this->createdBY;
				$gift['updated_on'] = date('Y-m-d H:i:s');
				$result=$this->gift->update_gift('dms_user_achievements',$gift,$requestID);
				if($status == 3){

					$this->message->set($this->lang->line('gift-approved'));
					redirect('gifts/approved');
				}
				else if($status == 2){
					$this->message->set($this->lang->line('gift-rejected'));
					redirect('gifts/rejected');
				}
			}
			$conditions['us_ach.id'] =$requestID;
			$gift_array = $this->gift->get($conditions);
			$des = $gift_array[0]['designation_id'];
			$designations =  $this->designations->get_name($des);
			$gift_array[0]['designation'] =$designations;
			$gift_array[0]['requestID'] =$requestID;
			//$gift_array['designation'] =$designations[$des];

			 $statusArray = array();
			$statusArray[3] = $this->lang->line('approve');
			$statusArray[2] = $this->lang->line('reject');

			//print_r($statusArray);

			# view starts here--------------------------------

			$this->template->title($this->lang->line('pending-gifts'));
			$this->template->main_heading($this->lang->line('pending-gifts'));
			$this->template->breadcrumb(array($this->lang->line('pending-gifts')=>'gifts/pending',$this->lang->line('approved-gifts') => 'gifts/approved',$this->lang->line('rejected-gifts')=>'gifts/rejected'));

			$this->template->slice('dms/message');
			$this->template->slice('gift/update_gift',array('statusArray'=>$statusArray,'gift_array'=>$gift_array));
			$this->template->render();
	}


	#---------------------------------------------------------------

	public function approved(){



		$this->template->title($this->lang->line('approved-gifts'));
		$this->template->main_heading($this->lang->line('approved-gifts'));
		$this->template->breadcrumb(array($this->lang->line('pending-gifts')=>'gifts/pending',$this->lang->line('approved-gifts') => 'no_link',$this->lang->line('rejected-gifts')=>'gifts/rejected'));

		$user_types = $users = $user_points = array();
		$this->load->model('designations/Designation_master_model','designations');
		$this->load->model('users/User_point_model','user_points');
		$this->load->model('gift/Gift_model','gift');

		$conditions['us_ach.status'] = 3;
		$gift_array = $this->gift->get($conditions);
		if(empty($gift_array)){

			$this->message->set($this->lang->line('no-results-found'));

		}

		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('gift/approved_gift',array('gift_array'=>$gift_array));
		$this->template->render();

	}

	#---------------------------------------------------------------

	public function rejected(){


			$this->template->title($this->lang->line('rejected-gifts'));
			$this->template->main_heading($this->lang->line('rejected-gifts'));
			$this->template->breadcrumb(array($this->lang->line('pending-gifts')=>'gifts/pending',$this->lang->line('approved-gifts') => 'gifts/approved',$this->lang->line('rejected-gifts')=>'no_link'));

			$user_types = $users = $user_points = array();
			$this->load->model('designations/Designation_master_model','designations');
			$this->load->model('users/User_point_model','user_points');
			$this->load->model('gift/Gift_model','gift');

			$conditions['us_ach.status'] = 2;
			$gift_array = $this->gift->get($conditions);
			if(empty($gift_array)){

				$this->message->set($this->lang->line('no-results-found'));

			}

			# view starts here--------------------------------
			$this->template->slice('dms/message');
			$this->template->slice('gift/rejected_gift',array('gift_array'=>$gift_array));
			$this->template->render();

	}

	#---------------------------------------------------------------

}
?>
