<?php  if( ! defined('BASEPATH')) exit('No direct script access allowed'); 

	class Godown extends MY_Controller{


		public function __construct(){

			parent :: __construct();
			$this->check_access_right();
			$this->load->model('godown/Godown_model','godown');
			#---------------- Checking Financial year is enabled / closed-----------------#
			$method_array = array('add','update','delete');
			fiscal_status($this->uri->segment(2),$method_array,"godown/report");	
			#---------------- Checking Financial year is enabled / closed-----------------#	
		}
	 #--------------------------------------------------------------------------
		public  function add(){

			#validation
			$this->form_validation->set_rules('branch_id','lang:branch','required|trim|xss_clean');
			$b_id = $this->input->post('branch_id',true);
			$this->form_validation->set_rules('godown_code','lang:godown-code',"required|trim|xss_clean|callback_godown_exists[$b_id.1]");
			$this->form_validation->set_rules('godown_name','lang:godown-name',"required|trim|xss_clean|callback_godown_exists[$b_id.2]");
			$this->form_validation->set_rules('address','lang:godown-adress','trim|xss_clean');
			$this->form_validation->set_rules('description','lang:description','trim|xss_clean');

			if($this->form_validation->run() == TRUE){

				$data = $this->input->post(NULL,TRUE);
				if($this->godown->f_save('godown_master',$data)){
					$this->message->set($this->lang->line('godown-save'));
				}
				else{
					$this->message->set($this->lang->line('godown-not-save'));

				}
				redirect('godown/report');
			}

			#branches
			$this->load->model('branches/Branch_model','branch');
			$branches = $this->branch->listing(array('company_id'=>$this->session->userdata('company_id')));
			$branches[''] = 'Select a branch';
			ksort($branches);

			$this->template->title($this->lang->line('godown-settings'));
			$this->template->main_heading($this->lang->line('godown-settings'));
			$this->template->breadcrumb(array($this->lang->line('settings')=>'preferences/index',$this->lang->line('godown')=>'no_link',$this->lang->line('report')=>'godown/report'));
			$this->template->slice('godown/add',array('branches'=>$branches));
			$this->template->render();
		}
	 #--------------------------------------------------------------------------
		public function report()
		{
			$this->load->model('branches/Branch_model','branch');
			$this->form_validation->set_rules('branch_id','lang:branch','required|trim|xss_clean');
			#checking branch is main branch or branch
			$branch_type = $this->branch->branch_type($this->session->userdata('under_id'));

			if($this->form_validation->run() == true || $this->uri->segment(3) == 'branch'){

				$branch = ($this->input->post('branch_id'))?$this->input->post('branch_id',true):$this->uri->segment(4);
				if($branch==='all'){
					$conditions =array('bm.company_id'=>$this->session->userdata('company_id'));
				}else{
					$conditions['gm.branch_id'] = $branch;
					$conditions['bm.company_id'] = $this->session->userdata('company_id');
				}

			}
			else{
				if($branch_type == 1){
					$branch = 'all';
					$conditions = array('bm.company_id'=>$this->session->userdata('company_id'));
				}else{
					$branch = $this->session->userdata('under_id');
					$conditions['gm.branch_id'] = $branch;
					$conditions['bm.company_id'] = $this->session->userdata('company_id');
				}
				
			}

			$this->load->library('Pagination');
			$config['per_page'] = $this->per_page();
			# Pagination Config Customizations
			$config['full_tag_open'] = '<ul class="pagination">';
			$config['full_tag_close'] = '</ul>';
			$config['first_link'] = 'First';
			$config['last_link'] = 'Last';
			$config['next_link'] = '&raquo;';
			$config['prev_link'] = '&laquo;';
			$config['cur_tag_open'] = '<li class="active"><a href="#">';
			$config['cur_tag_close'] = '</a></li>';
			$config['num_tag_open'] = '<li>';
			$config['num_tag_close'] = '</li>';
			if($this->input->post('branch_id') ||  $this->uri->segment(3) == 'branch' ){
   	 			$config['total_rows'] = $this->godown->get_all(array('numrows'=>TRUE,'conditions'=>$conditions));
   	 		}
   	 		else{

   	 			$config['total_rows'] = $this->godown->get_all(array('numrows'=>TRUE,'conditions'=>$conditions));
   	 		}

   	 		if($config['total_rows'] == 0){ $this->message->set($this->lang->line('no-godown-found'),'i');}

   	 		if($this->uri->segment(3) == 'branch' || $this->input->post('branch_id')){
				$config['base_url'] = base_url('godown/report/branch/'.$branch);
				$config['uri_segment'] = 5;
				$offset = $this->uri->segment($config['uri_segment'],0);
			}else{
				$config['base_url'] = base_url('godown/report');
				$config['uri_segment'] = 3;
				$offset = $this->uri->segment($config['uri_segment'],0);
			}
   	 		$this->pagination->initialize($config);
   	 		$links = $this->pagination->create_links();
   	 		
   	 		if($this->input->post('branch_id') ||  $this->uri->segment(3) == 'branch' ){
   	 		$godowns = $this->godown->get_all(array('order_by'=>'branch_id','order'=>'asc','limit'=>$config['per_page'],'offset'=>$offset,'conditions'=>$conditions));
   	 		}
   	 		else{
   	 			$godowns = $this->godown->get_all(array('order_by'=>'branch_id','order'=>'asc','limit'=>$config['per_page'],'offset'=>$offset,'conditions'=>$conditions));
   	 		}
			
			#branches listing
			if($branch_type == 1){

				$branches = $this->branch->listing(array('company_id'=>$this->session->userdata('company_id')));
				$branches[''] = 'Select a branch';
				$branches['all'] = 'All';
				ksort($branches);
			}
			else{
				$branches = $this->branch->listing(array('company_id'=>$this->session->userdata('company_id'),'id'=>$this->session->userdata('under_id')));
				$branches[''] = 'Select a branch';
				ksort($branches);
			}
			$this->template->title($this->lang->line('godown-settings'));
			$this->template->main_heading($this->lang->line('godown-settings'));
			$this->template->breadcrumb(array($this->lang->line('settings')=>'preferences/index',$this->lang->line('godown')=>'godown/add',$this->lang->line('report')=>'no_link'));
			$this->template->slice('dms/message');
			$this->template->slice('godown/report',array('branches'=>$branches,'links'=>$links,'offset'=>$offset,'godowns'=>$godowns,'branch'=>$branch));
			$this->template->render();

		}
	 #--------------------------------------------------------------------------
		public function update($id)
		{
			$godown_id = $this->uri->segment(3);
   	 		if(empty($godown_id)){ redirect('godown/report');}
   	 		#get route id details 
   	 		$godown = $this->godown->get_all(array('conditions'=>array('gm.id'=>$godown_id)))[0];
   	 		if(empty($godown)){ redirect('godown/report');}
   	 		#validation
   	 		$this->form_validation->set_rules('branch_id','lang:branch','required|trim|xss_clean');
   	 		$b_id = $this->input->post('branch_id',true);
			$this->form_validation->set_rules('godown_code','lang:godown-code',"required|trim|xss_clean|callback_godown_exists[$b_id.1.$godown_id]");
			$this->form_validation->set_rules('godown_name','lang:godown-name',"required|trim|xss_clean|callback_godown_exists[$b_id.2.$godown_id]");
			$this->form_validation->set_rules('address','lang:godown-adress','trim|xss_clean');
			$this->form_validation->set_rules('description','lang:description','trim|xss_clean');

			if($this->form_validation->run() == TRUE){

				$data = $this->input->post(NULL,TRUE);
				if($this->godown->update_a(array('table'=>'godown_master','data'=>$data,'conditions'=>array('id'=>$godown_id)))){
					$this->message->set($this->lang->line('godown-update'));
				}
				else{
					$this->message->set($this->lang->line('godown-not-update'));

				}
				$call_ck_uri = $this->uri->uri_to_assoc(4);
				redirect($this->uri->assoc_to_uri($call_ck_uri));

			}


   	 		#branches
			$this->load->model('branches/Branch_model','branch');
			$branches = $this->branch->listing(array('company_id'=>$this->session->userdata('company_id')));
			$branches[''] = 'Select a branch';
			ksort($branches);

   	 		$this->template->title('Edit Godown Details');
   	 		$this->template->main_heading($this->lang->line('godown-settings'));
   	 		$this->template->breadcrumb(array($this->lang->line('settings')=>'preferences/index',$this->lang->line('godown')=>'godown/add',$this->lang->line('update')=>'no_link',$this->lang->line('report')=>'godown/report'));
   	 		$this->template->slice('godown/edit',array('godown'=>$godown,'branches'=>$branches));
   	 		$this->template->render();
		}
	 #--------------------------------------------------------------------------
		public function delete($id){
			$godown_id = $id;
			if(empty($godown_id)){ redirect('godown/report');}

			if($this->if_exists('godown_master',array('id'=>$godown_id,'status'=>1)) === false){
				redirect('godown/report');
			}	
			#checking opening stock in this godown id 
			if($this->godown->check_delete($godown_id) === false){
				$data['status'] = 0;
				$data['created_by'] = $this->session->userdata('id');
				$data['created_on'] = date('Y-m-d h:i:s');

				if($this->godown->delete_a(array('table'=>'godown_master','data'=>$data,'conditions'=>array('id'=>$godown_id)))){

					$this->message->set($this->lang->line('godown-deleted'),'s');
	 			}
	 			else{
	 				$this->message->set($this->lang->line('godown-not-deleted'),'e');
	 			}
			}
			else{
				$this->message->set($this->lang->line('can-not-delete-godown'),'e');
			}	
 			redirect('godown/report');
		}
	 #---------------------------------------------------------------------------

	public function godown_exists($godown_code,$values)
	{
		$godown_id = "";
		$exp = explode(".", $values);		
		$branch_id = $exp[0];
		$type = $exp[1];//1 => code, 2 => name
		if(isset($exp[2])){
			$godown_id = $exp[2];
		}
		if($this->godown->godown_exists($godown_code,$branch_id,$type,$godown_id)){
			return false;
		}
		return true;
	}
}
?>