<?php if( ! defined('BASEPATH')) exit('No direct script access allowed');

class Gst extends MY_Controller
{
	public function __construct()
	{
		parent :: __construct();
		
		#---------------- Checking Financial year is enabled / closed-----------------#
		$method_array = array('update');
		fiscal_status($this->uri->segment(2),$method_array,"gst/index");	
		#---------------- Checking Financial year is enabled / closed-----------------#
		
		$this->template->title('GST');
		$this->template->main_heading('GST Settings');	
		$this->load->model('accounts/Vat_model','vat');	
	}
	
	public function index()
	{
		$this->template->breadcrumb(array($this->lang->line('settings') => 'preferences/index',$this->lang->line('accounts') => 'accounts/index',$this->lang->line('gst') => 'no_link',$this->lang->line('set') => 'gst/update'));
		
		$data = $this->vat->get_gst();
		
		$this->template->slice('dms/message');
		$this->template->slice('preferences/vat/reports',array('gst_array' => $data));
		$this->template->render();
	}
	
	public function update()
	{
		$data = $this->vat->get_gst();
		foreach($data as $id => $value)
		{
			$this->form_validation->set_rules("cgst_$value[id]",'lang:vat-settings','xss_clean|numeric|less_or_equal[100]');
			$this->form_validation->set_rules("sgst_$value[id]",'lang:vat-settings','xss_clean|numeric|less_or_equal[100]');
		}
		if($this->form_validation->run() == true)
		{
			$gst_data = $this->input->post(NULL,true);
			$count = count($gst_data); 
			$i = 0;
			
			foreach($data as $id1 => $value1)
		    {
				$gst_id = $value1['id'];
				
				$item_cgst = $gst_data["cgst_$gst_id"];
				$item_sgst = $gst_data["sgst_$gst_id"];
                               
				$cgst = $this->vat->get_item_cgst($gst_id);
                $sgst = $this->vat->get_item_sgst($gst_id);
				
				if($cgst != $item_cgst || $sgst != $item_sgst )
				{
					if($this->vat->updates(array('item_grp_id' => $gst_id,'cgst' => $item_cgst,'sgst'=>$item_sgst)))
					{
						$this->message->set($this->lang->line('gst-edit-success'));
						$i++;
                    }
			    }
            }
			if($i == $count)
			{
				$this->message->set($this->lang->line('gst-edit-error'),'w');
			}
		//	redirect('gst/index');
		}
		$gst_array = $this->vat->get_gst();

		#----------template
		$this->template->breadcrumb(array($this->lang->line('settings') => 'preferences/index',$this->lang->line('accounts') => 'accounts/index',$this->lang->line('gst') => 'gst/index',$this->lang->line('set') => 'no_link'));
		$this->template->slice('dms/message');
		$this->template->slice('preferences/vat/reports',array('gst_array' => $gst_array,'gst_status' => 1));
		$this->template->render();		
	}
	
    public function other_add()
	{
		$this->template->breadcrumb(array($this->lang->line('settings') => 'preferences/index',$this->lang->line('accounts') => 'accounts/index',$this->lang->line('gst-other') => 'no_link',$this->lang->line('set') => 'gst/update_other'));
		
		$data = $this->vat->get_other_gst();
		
		$this->template->slice('dms/message');
		$this->template->slice('preferences/vat/other_reports',array('vat_array' => $data));
		$this->template->render();
	}
      
    public function update_other()
	{
		$data = $this->vat->get_other_gst();
		foreach($data as $id => $value)
		{
			$this->form_validation->set_rules("vat_percent$value[id]",'lang:vat-settings','xss_clean|numeric|less_or_equal[100]');
		}
		if($this->form_validation->run() == true)
		{
			$i = $count = count($vat_data);			
			$vat_data = $this->input->post(NULL,true);;
			foreach($vat_data as $vat_id => $vat_value)
			{
				$vat_id = substr($vat_id,11);                            				
				if($item_vat1 != $vat_value || $item_vat2 != $vat_value )
				{
								
						if($this->vat->updates_other(array('speciali' => $vat_id,'cgst' => $vat_value,'sgst'=>$vat_value)))
						{
							$this->message->set($this->lang->line('gst-edit-success'));
							$i--;
                                                }
                                        
			       }

                        }
                 
			if($i == $count)
			{
				$this->message->set($this->lang->line('gst-edit-error'),'w');
			}
			redirect('gst/index');
		}
		$vat_array = $this->vat->get_gst();

		#----------template
		$this->template->breadcrumb(array($this->lang->line('settings') => 'preferences/index',$this->lang->line('accounts') => 'accounts/index',$this->lang->line('gst') => 'gst/index',$this->lang->line('set') => 'no_link'));
		$this->template->slice('dms/message');
		$this->template->slice('preferences/vat/other_reports',array('vat_array' => $vat_array,'vat_status' => 1));
		$this->template->render();		
	}
 
    public function igst_add()
	{
		$this->template->breadcrumb(array($this->lang->line('settings') => 'preferences/index',$this->lang->line('accounts') => 'accounts/index',$this->lang->line('igst') => 'no_link',$this->lang->line('set') => 'gst/igst_update'));
		
		$data = $this->vat->get_igst();
		
		$this->template->slice('dms/message');
		$this->template->slice('preferences/vat/igst_reports',array('vat_array' => $data));
		$this->template->render();
	}
	
	public function igst_update()
	{
		$data = $this->vat->get_igst();
		foreach($data as $id => $value)
		{
			$this->form_validation->set_rules("vat_percent$value[id]",'lang:vat-settings','xss_clean|numeric|less_or_equal[100]');
		}
		if($this->form_validation->run() == true)
		{
			$i = $count = count($vat_data);			
			$vat_data = $this->input->post(NULL,true);
			foreach($vat_data as $vat_id => $vat_value)
			{
				$vat_id = substr($vat_id,11);  
                            																
				if($this->vat->update_igst(array('item_grp_id' => $vat_id,'igst' => $vat_value)))
				{
					$this->message->set($this->lang->line('gst-edit-success'));
					$i--;
                                }                                        			       
                        }
                   
			if($i == $count)
			{
				$this->message->set($this->lang->line('gst-edit-error'),'w');
			}
			redirect('gst/igst_add');
		}
		$vat_array = $this->vat->get_igst();

		#----------template
		$this->template->breadcrumb(array($this->lang->line('settings') => 'preferences/index',$this->lang->line('accounts') => 'accounts/index',$this->lang->line('gst') => 'gst/igst_add',$this->lang->line('set') => 'no_link'));
		$this->template->slice('dms/message');
		$this->template->slice('preferences/vat/igst_reports',array('vat_array' => $vat_array,'vat_status' => 1));
		$this->template->render();		
	}

}