<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

	class Item extends MY_Controller{

		public function __construct(){
			parent :: __construct();
			$this->check_access_right();
			
			#---------------- Checking Financial year is enabled / closed-----------------#
			$method_array = array('tint_add','tint_report','coat_add','coat_report','mat_add','mat_report','shape_add','shape_report','ftype_add','ftype_report','fsize_add','fsize_report','ctype_add','ctype_report');
			fiscal_status($this->uri->segment(2),$method_array,"products/report");	
			#---------------- Checking Financial year is enabled / closed-----------------#	
			
		}
     
                public function tint_add(){

			$this->template->title($this->lang->line('item'));
			$this->template->main_heading($this->lang->line('tint'));
			$this->template->breadcrumb(array($this->lang->line('settings')=>'item_settings/index',$this->lang->line('tint')=>'no_link',$this->lang->line('report')=>'item/tint_report'));
			$this->form_validation->set_rules('tint','lang:item','trim|xss_clean|required|is_unique[tint_master.tint]');
			
			if($this->form_validation->run() === true){
				
				$this->load->library('Dms');
				$data = $this->input->post(NULL,true);				
				
				if($this->db->insert('tint_master',$data)){
					$this->message->set($this->lang->line('tint-saved'));
				}else{
					$this->message->set($this->lang->line('tint-not-saved'),'e');
				}
				redirect('item/tint_report');
			}
			$this->template->slice('dms/message');
			$this->template->slice('item/tint/add');
			$this->template->render();
		}

                public function tint_report(){

			$this->template->title($this->lang->line('item'));
			$this->template->main_heading($this->lang->line('tint'));
			$this->template->breadcrumb(array($this->lang->line('settings')=>'item_settings/index',$this->lang->line('tint')=>'item/tint_add',$this->lang->line('report')=>'no_link'));
			
			$tint = $this->db->select(array('tint'))->from('tint_master')->get()->result_array();							                                                 
			if(empty($tint)){
				$this->message->set($this->lang->line('no-result-found'),'i');
			}
			$this->template->slice('dms/message');
			$this->template->slice('item/tint/report',array('tint'=>$tint));
			$this->template->render();
		}
               
                public function shape_add(){

			$this->template->title($this->lang->line('item'));
			$this->template->main_heading($this->lang->line('shape'));
			$this->template->breadcrumb(array($this->lang->line('settings')=>'item_settings/index',$this->lang->line('shape')=>'no_link',$this->lang->line('report')=>'item/shape_report'));
			$this->form_validation->set_rules('shape','lang:shape','trim|xss_clean|required|is_unique[fshape_master.shape]');
			
			if($this->form_validation->run() === true){
				
				$this->load->library('Dms');
				$data = $this->input->post(NULL,true);				
				
				if($this->db->insert('fshape_master',$data)){
					$this->message->set($this->lang->line('tint-saved'));
				}else{
					$this->message->set($this->lang->line('tint-not-saved'),'e');
				}
				redirect('item/shape_report');
			}
			$this->template->slice('dms/message');
			$this->template->slice('item/shape/add');
			$this->template->render();
		}

                public function shape_report(){

			$this->template->title($this->lang->line('item'));
			$this->template->main_heading($this->lang->line('tint'));
			$this->template->breadcrumb(array($this->lang->line('settings')=>'item_settings/index',$this->lang->line('tint')=>'item/tint_add',$this->lang->line('report')=>'no_link'));
			
			$shape = $this->db->select(array('shape'))->from('fshape_master')->get()->result_array();							                                                 
			if(empty($shape)){
				$this->message->set($this->lang->line('no-result-found'),'i');
			}
			$this->template->slice('dms/message');
			$this->template->slice('item/shape/report',array('shape'=>$shape));
			$this->template->render();
		}
}
?>