<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Ledgers extends MY_Controller{

	public function __construct()
	{
		parent :: __construct();
		$this->check_access_right();

		#---------------- Checking Financial year is enabled / closed-----------------#
		$method_array = array('add','update','delete');
		fiscal_status($this->uri->segment(2),$method_array,"ledgers/report");
		#---------------- Checking Financial year is enabled / closed-----------------#

		$this->load->model('accounts/Ledger_model','ledger');
	}

 	#-----------------------------------------------
	public function add()
	{
		#------------breadcrumb
		$breadcrumb = array($this->lang->line('ledgers')=>'no_link',$this->lang->line('report')=>'ledgers/report');

		#------------redirect
		$redirect = 'ledgers/report';
		if($this->uri->segment(3))
		{
			$uri_array = $this->uri->uri_to_assoc(3);
			if(isset($uri_array['vouchers']))
			{
				$redirect = $this->uri->assoc_to_uri($uri_array);
				$breadcrumb[$this->lang->line('go-back')] = $redirect;
			}
		}

		#------------validation
		$this->form_validation->set_rules('ledger_name','lang:ledger-name','required|xss_clean|max_length[128]|callback_ledger_exists');
		$this->form_validation->set_rules('sgroup_id','lang:under','required|xss_clean');
		$this->form_validation->set_rules('vat','lang:used-vat-return','required|xss_clean');
		$this->form_validation->set_rules('open_amount','lang:opening-balance','xss_clean|numeric|greater_or_equal[0]|less_than[10000000000000]');
		$this->form_validation->set_rules('dc_type','lang:dc','required|xss_clean');
		$this->form_validation->set_rules('description','lang:description','xss_clean');

		if($this->form_validation->run() === TRUE)
		{
			$data_ledger['company_id'] = $this->session->userdata('company_id');
			$data_ledger['branch_id'] = $this->session->userdata('under_id');
			$data_ledger['ledger_name'] = $this->input->post('ledger_name',TRUE);
			$data_ledger['sgroup_id'] = $this->input->post('sgroup_id',TRUE);
			$data_ledger['dc'] = $this->ledger->get_dc($data_ledger['sgroup_id']);
			$data_ledger['description'] = $this->input->post('description',TRUE);
			#---------save
			$last_insert_id = $this->ledger->insert('dms_ledgers',$data_ledger);
			if($last_insert_id)
			{
				if(!empty($this->input->post('open_amount',TRUE))){
					$open_amount = $this->input->post('open_amount',TRUE);
					if($this->input->post('dc_type',TRUE) != $data_ledger['dc']){
						$open_amount = -$open_amount;
					}
					$this->ledger->insert('dms_ledger_open_bals',array('company_id' => $data_ledger['company_id'],'branch_id' => $data_ledger['branch_id'],'ledger_id' => $last_insert_id,'open_amount' => $open_amount,'open_date' => $this->dms->get_fiscal_year()['start_date'],'vat' => $this->input->post('vat',TRUE)));
				}
				$this->message->set($this->lang->line('ledger-add-success'));
			}
			else{
				$this->message->set($this->lang->line('ledger-add-error'));
			}
			redirect($redirect);
		}
		#---------sub groups
		$sub_groups = $this->ledger->get_sub_groups(1);
		$dc_array = array('dr' => 'Dr','cr' => 'Cr');

		#---------template
		$this->template->title('Add New Ledger');
		$this->template->main_heading($this->lang->line('ledger-settings'));
		$this->template->breadcrumb($breadcrumb);
		$this->template->slice('dms/message');
		$this->template->slice('ledgers/add',array('sub_groups' => $sub_groups,'dc_array' => $dc_array));
		$this->template->other_script('ledgers/ledger');
		$this->template->render();
	}

	#-----------------------------------------------
	public function update()
	{
		#----------ledger primary key
		$uri_array = $this->uri->uri_to_assoc(3);
		if(isset($uri_array['id']))
		{
			$ledger_id = $uri_array['id'];
			unset($uri_array['id']);

			#------------ledger details
			$row = $this->ledger->get(array('columns' => array('a.sub_group','b.id','b.company_id','b.ledger_name','b.sgroup_id','b.dc','b.description'),'conditions' => array('b.id'=>$ledger_id,'b.sgroup_id !=' => 15,'b.sgroup_id !=' => 23)));
			if(empty($row)){redirect('ledgers/report');}
			else
			{
				$ledger = $row[0];
				$disabled = "disabled";$msg_status = 0;
				$dc = $ledger['dc'];

				#-------------accounts library
				$this->load->library('Accounts');

				#-------------validation
				if($ledger['company_id'] > 0)
				{
					$disabled = "";
					$this->form_validation->set_rules('ledger_name','lang:ledger-name',"required|xss_clean|max_length[128]|callback_ledger_exists[$ledger_id]");
					$this->form_validation->set_rules('sgroup_id','lang:under','required|xss_clean');
				}
				$this->form_validation->set_rules('vat','lang:used-vat-return','required|xss_clean');
				$this->form_validation->set_rules('open_amount','lang:opening-balance','xss_clean|greater_or_equal[0]|less_than[10000000000000]');
				$this->form_validation->set_rules('dc_type','lang:dc','required|xss_clean');
				$this->form_validation->set_rules('description','lang:description','xss_clean');

				#------------save
				if($this->form_validation->run() === true)
				{
					if($ledger['company_id'] > 0)
					{
						$data_ledger['ledger_name'] = $this->input->post('ledger_name',true);
						if($ledger['sgroup_id'] != $this->input->post('sgroup_id',true))
						{
						//	if(!$this->ledger->check_ledger($ledger_id)){
								$data_ledger['sgroup_id'] = $this->input->post('sgroup_id',true);
								$data_ledger['dc'] = $this->ledger->get_dc($data_ledger['sgroup_id']);
								$dc = $data_ledger['dc'];
						//	}
						//	else{
						//		$msg_status = 1;
						//	}
						}
						$data_ledger['description'] = $this->input->post('description',true);
						$this->ledger->update(array('table' => 'dms_ledgers','data' => $data_ledger,'conditions' => array('id' => $ledger_id)));
					}
					$fscal_start_date = $this->dms->get_fiscal_year()['start_date'];
					$company_id = $this->session->userdata('company_id');
					$branch_id = $this->session->userdata('under_id');
					$open_amount = $this->input->post('open_amount',true);
					$vat = $this->input->post('vat',true);
					if(!empty($open_amount) || $vat  == 1)
					{
						if($open_amount > 0 && ($this->input->post('dc_type',true) != $dc))
						{
							$open_amount = -$open_amount;
						}
						$lob_id = $this->ledger->if_exist_open_bal(array('conditions' => array('branch_id' => $branch_id,'ledger_id' => $ledger_id,'open_date' => $fscal_start_date)));
						if($lob_id)
						{
							$this->ledger->update(array('table' => 'dms_ledger_open_bals','data' => array('open_amount' => $open_amount,'vat' => $vat),'conditions' => array('id' => $lob_id)));
						}
						else
						{
							$this->ledger->insert('dms_ledger_open_bals',array('company_id' => $company_id,'branch_id' => $branch_id,'ledger_id' => $ledger_id,'open_amount' => $open_amount,'open_date' => $fscal_start_date,'vat' => $vat));
						}
					}
					else
					{
						$this->ledger->update(array('table' => 'dms_ledger_open_bals','data' => array('status' => 0),'conditions' => array('branch_id' => $branch_id,'ledger_id' => $ledger_id,'open_date' => $fscal_start_date)));
					}
					$this->message->set($this->lang->line('ledger-updated'));
					if($msg_status)
					{
						$this->message->set($this->lang->line('ledger-updated-sgroup-error'),'w');
					}
					redirect("ledgers/report/".$this->uri->assoc_to_uri($uri_array));
				}

				#------------sub group
				$sub_groups = $this->ledger->get_sub_groups();
				$dc_array = array('dr' => 'Dr','cr' => 'Cr');
				//$ledger_open_array = $this->accounts->cur_open_bal($ledger_id,1);
                $ledger_open_array = array();
				#------------template
				$this->template->title('Edit Ledger Details');
				$this->template->main_heading($this->lang->line('ledger-settings'));
				$this->template->breadcrumb(array($this->lang->line('ledgers')=>'ledgers/add',$this->lang->line('update')=>'no_link',$this->lang->line('report')=>'ledgers/report'));
				$this->template->slice('dms/message');
				$this->template->slice('ledgers/update',array('ledger_array' => $ledger,'ledger_open_array' => $ledger_open_array,'sub_groups' => $sub_groups,'dc_array' => $dc_array,'ledger_id' => $ledger_id,'disabled' => $disabled));
				$this->template->other_script('ledgers/ledger');
				$this->template->render();
			}
		}
		else
		{
			redirect('users/logout');
		}
	}

 	#-----------------------------------------------
	public function report()
	{
		$conditions = array();$sub_group = "";

		#----------uri array
		$uri_array  = $this->uri->uri_to_assoc(3);

		#----------redirect string
		$redirect = "";$config['uri_segment'] = 3;

		$config['base_url'] = base_url('ledgers/report');
		if($this->input->post('sub_group_id',true))
		{
			$sub_group = $this->input->post('sub_group_id',true);
			$conditions = array('b.sgroup_id'=>$sub_group);
			$config['base_url'] .= '/sg/'.$sub_group;
			$config['uri_segment'] = 5;
			$redirect .= '/sg/'.$sub_group;
		}
		elseif(isset($uri_array['sg']))
		{
			$sub_group = $uri_array['sg'];
			$conditions = array('b.sgroup_id'=>$sub_group);
			$config['base_url'] .= '/sg/'.$sub_group;
			$config['uri_segment'] = 5;
			$redirect .= '/sg/'.$sub_group;
		}

		#------------pagination
		$this->load->library(array('Pagination','Accounts'));
   	 	$config['total_rows'] = $this->ledger->get(array('columns' => array('b.id'),'conditions' => $conditions,'numrows' => true));
		if($config['total_rows'] == 0){
			$this->message->set($this->lang->line('no-ledger'),'i');
		}
		$config['per_page'] = $this->per_page();
		# Pagination Config Customizations
        $config['full_tag_open'] = '<ul class="pagination">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = 'First';
        $config['last_link'] = 'Last';
        $config['next_link'] = '&raquo;';
        $config['prev_link'] = '&laquo;';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
		$offset = $this->uri->segment($config['uri_segment'],0);
		$this->pagination->initialize($config);
		$links = $this->pagination->create_links();

		#------------ledgers
   	 	$ledgers = $this->ledger->get(array('conditions' => $conditions,'order_by' => 'b.ledger_name','order' => 'asc','limit' => $config['per_page'],'offset' => $offset));

		#------------sub groups
		$sub_groups = $this->ledger->get_sub_groups();

		#------------template
		$this->template->title('Ledger Reports');
		$this->template->main_heading($this->lang->line('ledger-settings'));
		$this->template->breadcrumb(array($this->lang->line('ledgers')=>'ledgers/add',$this->lang->line('report')=>'no_link'));
		$this->template->slice('ledgers/search',array('sub_groups'=>$sub_groups,'sub_group' =>$sub_group));
		$this->template->slice('dms/message');
		if(!empty($ledgers))
		{
			$this->template->slice('ledgers/report',array('ledgers'=>$ledgers,'links'=>$links,'count'=>$offset,'redirect' => $redirect));
			$this->template->slice('dms/modals/medium_modal');
			$this->template->other_script('ledgers/ledger');
			$this->template->slice('dms/modals/delete_confirm');
		}
		$this->template->render();
	}

 	#-----------------------------------------------
	public function delete(){

		#----------voucher primary key
		$uri_array = $this->uri->uri_to_assoc(3);
		if(isset($uri_array['id']))
		{
			$id = $uri_array['id'];
			unset($uri_array['id']);

			#------------ledger details
			$ledger = $this->ledger->get(array('columns' => array('b.id'),'conditions' => array('b.id'=>$id,'b.company_id' => $this->session->userdata('company_id'),'b.sgroup_id !=' => 15,'b.sgroup_id !=' => 23)));
			if(!empty($ledger))
			{
				if(!$this->ledger->check_ledger($id))
				{
					if(!$this->ledger->if_exist_open_bal(array('conditions' => array('ledger_id' => $id,'open_amount >' => 0)))){
						if($this->ledger->update(array('table' => 'dms_ledgers','data' => array('status' => 0),'conditions' => array('id'=>$id)))){
							$this->message->set($this->lang->line('ledger-deleted'),'s');
						}
						else{
							$this->message->set($this->lang->line('ledger-not-deleted'),'e');
						}
					}
					else{
						$this->message->set($this->lang->line('ledger-open-bal-delete-error'),'e');
					}
				}
				else
				{
					$this->message->set($this->lang->line('ledger-delete-voucher-error'),'e');
				}
			}
		}
		redirect('ledgers/report/'.$this->uri->assoc_to_uri($uri_array));
	}
 	#-----------------------------------------------

 	public function ledger_exists($ledger_name,$ledger_id = NULL)
 	{
 		if($this->ledger->check_exists($ledger_name,$ledger_id)){
 			return false;
 		}
 		return true;
 	}
}
?>