<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

	class Maps extends MY_Controller{

		function __construct(){
			parent :: __construct();
		}

		#-------------------------------------------
		public function sales(){
			$this->load->model('branches/Branch_model','branch');
			$this->load->model('graphs/Graph_model','graph');
			$this->load->model('areas/Area_model','area');
			$this->load->library('Stock');
			$branch_id = $this->session->userdata('under_id');
			$fiscal_years = $this->dms->get_fiscal_year();
			$from_date = $fiscal_years['start_date'];
			$to_date =  $fiscal_years['end_date'];


			$sel_from_date = $sel_to_date = NULL;
			$branch_type = $this->dms->get_main_branch($branch_id);
			if($branch_type == 1){
				$branches = $this->branch->listing(array('company_id'=>$this->session->userdata('company_id')));
				$branches[''] = 'Select a branch';
				ksort($branches);
			}else{
				$branches = $this->branch->listing(array('company_id'=>$this->session->userdata('company_id'),'id'=>$this->session->userdata('under_id')));
				ksort($branches);
			}
			$areas = $this->area->listing();
			$areas['all'] = 'All';
			ksort($areas);
			$products =  $this->stock->get_stock_items();
			$products['all'] = 'All Products';
			ksort($products);

			if($branch_type == 1){
				$branch_id = NULL;
			}else{
				$branch_id = $this->session->userdata('under_id');
			}

			$this->form_validation->set_rules('branch_id','lang:branch','trim|xss_clean');
			$this->form_validation->set_rules('area_id','lang:area','required|trim|xss_clean');
			$this->form_validation->set_rules('product_id','lang:product','required|trim|xss_clean');
			$this->form_validation->set_rules('from_date','lang:from','trim|xclean|valid_date');
			$this->form_validation->set_rules('to_date','lang:to','trim|xclean|valid_date');
			$area_id = $product_id = 'all';

			if($this->form_validation->run() == TRUE){

				$branch_id = $this->input->post('branch_id');
				$area_id = $this->input->post('area_id');
				$product_id = $this->input->post('product_id');
				$sel_from_date = $this->input->post('from_date');
				$sel_to_date = $this->input->post('to_date');
				if(!empty($sel_from_date) && !empty($sel_to_date) && $sel_from_date <= $sel_to_date){
					$from_date = date('Y-m-d',strtotime($sel_from_date));
					$to_date = date('Y-m-d',strtotime($sel_to_date));
				}
			}
			$area_array = $product_array = array();
			if($area_id == 'all')
			{
				$area_array = $this->area->get_all();
			}
			else
			{
				$area_array = $this->area->get_all(array('conditions'=>array('id'=>$area_id)));
			}

			if($product_id == 'all')
			{
				$product_array = $this->stock->get_stock_items();
			}
			else
			{
				$product_array = $this->stock->get_stock_items(array('conditions'=>array('id'=>$product_id)));
			}
			foreach ($area_array as $key => $area) 
			{
				if(!empty($branch_id))
				{
					if($product_id != 'all')
					{
					//	$sales = $this->graph->get_area_wise_sales(array('conditions'=>array('sls.branch_id'=>$branch_id,'sls.area_id'=>$area['id']),'item_id'=>$product_id,'from_date'=>$from_date,'to_date'=>$to_date));
						$sales1 = $this->graph->get_area_wise_sales_gst(array('conditions'=>array('sls.branch_id'=>$branch_id,'sls.area_id'=>$area['id']),'item_id'=>$product_id,'from_date'=>$from_date,'to_date'=>$to_date));
				
					}
					else
					{
					//	$sales = $this->graph->get_area_wise_sales(array('conditions'=>array('sls.branch_id'=>$branch_id,'sls.area_id'=>$area['id']),'from_date'=>$from_date,'to_date'=>$to_date));
						$sales1 = $this->graph->get_area_wise_sales_gst(array('conditions'=>array('sls.branch_id'=>$branch_id,'sls.area_id'=>$area['id']),'from_date'=>$from_date,'to_date'=>$to_date));
					}
				}
				else
				{
					if($product_id != 'all')
					{
					//	$sales = $this->graph->get_area_wise_sales(array('conditions'=>array('sls.area_id'=>$area['id']),'item_id'=>$product_id,'from_date'=>$from_date,'to_date'=>$to_date));
						$sales1 = $this->graph->get_area_wise_sales_gst(array('conditions'=>array('sls.area_id'=>$area['id']),'item_id'=>$product_id,'from_date'=>$from_date,'to_date'=>$to_date));
                                              
					}
					else
					{
					//	$sales = $this->graph->get_area_wise_sales(array('from_date'=>$from_date,'to_date'=>$to_date));
						$sales1 = $this->graph->get_area_wise_sales_gst(array('from_date'=>$from_date,'to_date'=>$to_date));
                     }
				}

				$sum = 0;$sum1=0; $sum2=0;
			/*	if(!empty($sales))
				{
					foreach ($sales as $key1 => $sale) 
					{
						$vamount = $sale['vamount'];
						$cst_per = $sale['cst'];
						$vat_amount = $sale['vat_amt'];
						$sum1 = round_this($sum1+$vamount+ ($vamount*$cst_per)/100+$vat_amount);
					} 
                                }
                                else
				{
					$area_array[$key]['sales'] = $sum1;
				}   */
                               if(!empty($sales1))
                               {
                    foreach ($sales1 as $key2 => $sale1) 
					{
						$vamount = $sale1['vamount'];
						$vat_amount = $sale1['vat_amt'];
						$sum2 = round_this($sum2+$vamount+$vat_amount);
					}  
                                }
                                else
				{
					$area_array[$key]['sales'] = $sum2;
				}            
                                        $sum = $sum1+$sum2;
					
					$area_array[$key]['sales'] = $sum;
				
				

			}

			$set_coidinate = true;
			foreach ($area_array as $key => $area){
				if(empty($area['cordinate_x']) || empty($area['cordinate_y'])){
					$set_coidinate = false;
					$this->message->set($this->lang->line('set-area-cordinate'),'e');
				}
			}
			if(!empty($area_array)){
				$constants = $this->db->select('currency_symbol')->get_where('constant_master',array('company_id'=>$this->session->userdata('company_id')))->row_array();
				$this->template->append('maps/area_wise_map',array('areas'=>$area_array,'area_id'=>$area_id,'currency'=>$constants['currency_symbol'],'set_coidinate'=>$set_coidinate));
			}

			$this->template->title('MAP bases sales report');
			$this->template->main_heading($this->lang->line('map'));
			$this->template->breadcrumb(array($this->lang->line('map')=>'no_link'));
			$this->template->slice('dms/message');
			$this->template->slice('maps/map_select',array('areas'=>$areas,'branches'=>$branches,'branch_id'=>$branch_id,'set_coidinate'=>$set_coidinate,'products'=>$products,'from_date'=>$sel_from_date,'to_date'=>$sel_to_date));
			$this->template->render();
		}
	}

?>