<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
	
	class Masons extends MY_Controller{

		#-------------------------------------------

		public function __construct(){
			parent :: __construct();
			$this->check_access_right();
			$this->load->model('users/Mason_model','mason');
			#---------------- Checking Financial year is enabled / closed-----------------#
			$method_array = array('add','edit','delete');
			fiscal_status($this->uri->segment(2),$method_array,"masons/report");	
			#---------------- Checking Financial year is enabled / closed-----------------#
			
		}

		#--------------------------------------------
		#purpose : add new mason data
		public function add(){
			
			#form validation
			if($this->form_validation->run() === TRUE){

				$file_upload_error = true;
				#upload the photo if one is selected.
				if($_FILES['photo']['name'] != ''){

					$ext = pathinfo($_FILES['photo']['name'], PATHINFO_EXTENSION);
					#file name initialization
					$max_id = $this->user->get_max_id();
					$f_part1 = $max_id+1;
					$f_part2 = $f_part1."user".date('YmdHis');
					$fileName = $f_part2.".".$ext;
					#file uploading 
					$config['upload_path'] =  FCPATH.'assets/images/photos/';
					$config['allowed_types'] = 'jpeg|jpg|png';
					$config['max_size']	= '600';
					$config['max_width']  = '2560';
					$config['max_height']  = '1600';
					$config['file_name'] = $fileName;
					$this->load->library('Upload');
					$this->upload->initialize($config);

					if($this->upload->do_upload('photo')){

						$file_upload_error = false;
						$config['image_library'] = 'gd2';
						$config['source_image']	= $config['upload_path'].$fileName;
						$config['create_thumb'] = TRUE;
						$config['maintain_ratio'] = false;
						$config['width']	= 150;
						$config['height']	= 120;
						$this->load->library('Image_lib', $config); 
						$this->image_lib->resize();
						#unlink original file & rename thumb
						unlink($config['upload_path'].$fileName);
						$thumb = $config['upload_path'].$f_part2.'_thumb'.'.'.$ext;
						$original = $config['upload_path'].$fileName;
						rename($thumb,$original);

					}else{
						$file_upload_error = true;
					}					
				}else{
					$fileName = $this->input->post('gender').'.jpg'; #dummy image in case no image uploaded
					$file_upload_error = false;
				}

				if($file_upload_error){
					$this->message->set($this->lang->line('invalid-photo'),'e');
				}else{

					$data = $this->input->post(NULL,true);
					$data['photo'] = $fileName;
					$data['dob'] = ($data['dob'] != '')?date('Y-m-d',strtotime($data['dob'])):'';
					$data['date_of_marriage'] = ($data['date_of_marriage'] != '')?date('Y-m-d',strtotime($data['date_of_marriage'])):'';
					$data['created_by'] = $this->session->userdata('id');
					$data['company_id'] = $this->session->userdata('company_id');
					$data['designation_id'] =5;
					#get financl year
					$data['fiscal_yr_id'] = $this->dms->get_default_fiscal_id();
					#password hashing
					if($data['password'] != ''){
						$data['password'] = password_hash($data['password'],PASSWORD_DEFAULT);
					}
			
					if($this->mason->f_save('users',$data)){
					 	$this->message->set($this->lang->line('mason-saved'));
					}else{
						$this->message->set($this->lang->line('mason-not-saved'));
					}
					redirect('masons/report');
				}
			}
			
			#branches listing
			$this->load->model('branches/Branch_model','branch');
			$branches = $this->branch->listing(array('company_id'=>$this->session->userdata('company_id')));
			$branches[''] = 'Select a branch';
			ksort($branches);

			#get all areas
			$this->load->model('areas/Area_model','area');
			$areas = $this->area->listing();
			$areas[''] = 'Select';ksort($areas);
			
			$this->template->title($this->lang->line('manage-masons'));
			$this->template->main_heading($this->lang->line('manage-masons'));
			$this->template->breadcrumb(array($this->lang->line('manage-masons')=>'no_link',$this->lang->line('report')=>'masons/report'));
			$this->template->slice('dms/message');
			$this->template->slice('masons/add/new',array('branches'=>$branches,'areas'=>$areas));
			$this->template->other_script(array('user_add','users/user_name_check','masons/ar_branch_select'));
			$this->template->render();
		}

		#---------------------------------------------
		public function report(){

			$this->load->model('users/Mason_model','mason');
			$this->load->library('Pagination');
			$config['total_rows'] = $this->mason->get_all('',1);
			$config['per_page'] = $this->per_page();
			# Pagination Config Customizations
			$config['full_tag_open'] = '<ul class="pagination">';
			$config['full_tag_close'] = '</ul>';
			$config['first_link'] = 'First';
			$config['last_link'] = 'Last';
			$config['next_link'] = '&raquo;';
			$config['prev_link'] = '&laquo;';
			$config['cur_tag_open'] = '<li class="active"><a href="#">';
			$config['cur_tag_close'] = '</a></li>';
			$config['num_tag_open'] = '<li>';
			$config['num_tag_close'] = '</li>';
			$config['base_url'] = base_url('masons/report');
			$config['uri_segment'] = 3;
			$this->pagination->initialize($config); 
			$offset = ($this->uri->segment(3))?$this->uri->segment(3):0;
			$masons = $this->mason->get_all('',0,$offset,$config['per_page']);
			$links = $this->pagination->create_links();

			if(empty($masons)){
				$this->message->set($this->lang->line('no-results-found'),'i');
			}
			
			#template
			$this->template->title($this->lang->line('manage-masons'));
			$this->template->main_heading($this->lang->line('manage-masons'));
			$this->template->breadcrumb(array($this->lang->line('manage-masons')=>'masons/add',$this->lang->line('report')=>'no_link'));
			$this->template->slice('dms/message');
			$this->template->slice('masons/report',array('masons'=>$masons,'links'=>$links,'count'=>$offset));
			$this->template->slice('dms/modals/more_details');
			$this->template->other_script('masons/mason_show');
			$this->template->render();
		}
		
		#---------------------------------------------
		public function edit($id = FALSE){
				
			if(!$id){ redirect('masons/report');}
			$id = $this->uri->segment(3);
			$this->load->model('users/Mason_model','mason');

			if($this->if_exists('users',array('id'=>$id,'status'=>1,'designation_id'=>5)) === false){
				redirect('masons/report');
			}
						
			$mason = $this->mason->get_all(array('users.id'=>$id))[0];

			if($this->form_validation->run('masons/edit') === TRUE){
				$data = $this->input->post(NULL,TRUE);
				$file_upload_error = TRUE; #dummy set

				if($_FILES['photo']['name'] != ''){
					$ext = pathinfo($_FILES['photo']['name'], PATHINFO_EXTENSION);
					#file name initialization
					$max_id = $this->user->get_max_id();
					$f_part1 = $max_id+1;
					$f_part2 = $f_part1."user".date('YmdHis');
					$fileName = $f_part2.".".$ext;
					#file uploading 
					$config['upload_path'] =  FCPATH.'assets/images/photos/';
					$config['allowed_types'] = 'jpeg|jpg|png';
					$config['max_size']	= '600';
					$config['max_width']  = '2560';
					$config['max_height']  = '1600';
					$config['file_name'] = $fileName;
					$this->load->library('Upload');
					$this->upload->initialize($config);

					if($this->upload->do_upload('photo')){

						$file_upload_error = TRUE;
						$config['image_library'] = 'gd2';
						$config['source_image']	= $config['upload_path'].$fileName;
						$config['create_thumb'] = TRUE;
						$config['maintain_ratio'] = FALSE;
						$config['width']	= 150;
						$config['height']	= 120;
						$this->load->library('Image_lib', $config); 
						$this->image_lib->resize();

						#unlink original file & rename thumb
						unlink($config['upload_path'].$fileName);
						$thumb = $config['upload_path'].$f_part2.'_thumb'.'.'.$ext;
						$original = $config['upload_path'].$fileName;
						rename($thumb,$original);

					}else{
						$file_upload_error = FALSE;
					}
				}

				if(!$file_upload_error){
					$this->message->set($this->lang->line('invalid-photo'),'e');
				}else{
					
					$data = $this->input->post(NULL,TRUE);
					if(!empty($fileName)){

						$data['photo'] = $fileName;
						 if((strtolower($mason['photo']) !='male.jpg') && (strtolower($mason['photo']) != 'female.jpg')){

							unlink(FCPATH.'assets/images/photos/'.$mason['photo']);
						 }
					}
					$data['dob'] = ($data['dob'] != '')?date('Y-m-d',strtotime($data['dob'])):'';
					$data['date_of_marriage'] = ($data['date_of_marriage'] != '')?date('Y-m-d',strtotime($data['date_of_marriage'])):'';
					
					if($data['password'] != ''){
						$data['password'] = password_hash($data['password'],PASSWORD_DEFAULT);
					}else{
						unset($data['password']);
					}
					if($this->mason->my_update('users',$data,array('id'=>$id))){
						$this->message->set($this->lang->line('mason-updated'));
					}else{
						$this->message->set($this->lang->line('mason-not-updated'));
					}
					redirect('masons/report');
				}
			}
			#branches listing
			$this->load->model('branches/Branch_model','branch');
			$branches = $this->branch->listing(array('company_id'=>$this->session->userdata('company_id')));
			$branches[''] = 'Select a branch';
			ksort($branches);

			#get all areas
			$this->load->model('areas/Area_model','area');
			$areas = $this->area->listing();
			$areas[''] = 'Select';
			ksort($areas);

			$this->template->title($this->lang->line('manage-masons'));
			$this->template->main_heading($this->lang->line('manage-masons'));
			$this->template->breadcrumb(array($this->lang->line('manage-masons')=>'masons/add',$this->lang->line('update')=>'no_link',$this->lang->line('report')=>'masons/report'));
			$this->template->slice('masons/edit/update',array('mason'=>$mason,'branches'=>$branches,'areas'=>$areas));
			$this->template->other_script(array('user_add','users/user_name_check','masons/ar_branch_select'));
			$this->template->render();
		}

		#---------------------------------------------

		public function delete($id){
			if(empty($id) || !$this->uri->segment(3)){
				redirect('masons/report');
			}

			$id = $this->uri->segment(3);
			if($this->if_exists('users',array('id'=>$id,'status'=>1,'designation_id'=>5)) === false){
				redirect('masons/report');
			}			
			$mason = $this->mason->get_all(array('users.id'=>$id))[0];
			
			$total_privileges = $this->db->select('id')->get_where('user_privileges',array('owner_id'=>$id))->num_rows();
			$total_sales = $this->db->select('id')->get_where('dms_sales',array('user_id'=>$id,'status'=>1))->num_rows();
			$total_so = $this->db->select('id')->get_where('dms_sales_orders',array('user_id'=>$id,'status'=>1))->num_rows();
			$total_so_temps = $this->db->select('id')->get_where('dms_sales_order_temp',array('user_id'=>$id))->num_rows();
			$total_targets = $this->db->select('id')->get_where('targets',array('designation_id'=>5,'user_id'=>$id,'status'=>1))->num_rows();
			if(empty($total_privileges) && empty($total_sales) && empty($total_so) && empty($total_so_temps) && empty($total_targets)){
						
				if((strtolower($mason['photo']) !='male.jpg') && (strtolower($mason['photo']) != 'female.jpg')){
					unlink(FCPATH.'assets/images/photos/'.$mason['photo']);
				}
				if($this->mason->my_update('users',array('status'=>0),array('id'=>$id))){
					$this->message->set($this->lang->line('mason-deleted'),'s');
				}else{
					$this->message->set($this->lang->line('mason-not-deleted'));
				}
				
			}else{
				$this->message->set($this->lang->line('can-not-delete-mason'),'i');
			}
			redirect('masons/report');
		}

		#---------------------------------------------

		public function stock_wise_report(){
			
			$this->load->model('stocks/Stock_model','stock');
			$masons_report = $this->stock->get_stock_requseted_data();
			#template
			$this->template->title('Masons Stock Wise Report');
			$this->template->main_heading('Masons Stock Requested Report');
			$this->template->render();

		}

		#---------------------------------------------

	}
?>