<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');
class Opening_stock extends MY_Controller
{
	#-------------------------------------------------
	var $companyID,$branchID,$fiscal_start_date,$fiscal_end_date;
	
	public function __construct(){
		parent :: __construct();
		$this->check_access_right();
		
		#---------------- Checking Financial year is enabled / closed-----------------#
		$method_array = array('add','edit','delete');
		fiscal_status($this->uri->segment(2),$method_array,"opening_stock/report");	
		#---------------- Checking Financial year is enabled / closed-----------------#	
		$this->branchID = $this->session->userdata('under_id');
		$this->companyID = $this->session->userdata('company_id');	
		$this->load->model('products/Opening_stock_model','opening_stock');
		$this->load->library(array('Stock'));
		
		$fiscals = $this->dms->get_fiscal_year();
		$this->fiscal_start_date = $fiscals['start_date'];
		$this->fiscal_end_date = $fiscals['end_date'];		
	}
	
	#-------------------------------------------------

	public function add(){

		$this->template->title($this->lang->line('opening-stock-set'));
		$this->template->main_heading($this->lang->line('opening-stock-set'));
		$this->template->breadcrumb(array($this->lang->line('products') => 'products/add',$this->lang->line('openings') => 'no_link',$this->lang->line('report') => 'opening_stock/report'));
		$unit_symbol = $unit_name = ''; $insertCount=0;
		$checkedArray = array();
		$args = array();
		$args['select'] = array('id','item_code','item_name');
		$items = $this->stock->get_stock_items($args);
		if(empty($items)){
			$this->message->set($this->lang->line('no-items-found'),'i');
		}		
		$items[''] = 'Select';
		ksort($items);
		$godowns = $this->stock->get_godowns(array('conditions'=>array('branch_id'=>$this->branchID)));
		if(empty($godowns)){
			$this->message->set($this->lang->line('no-godown-found'),'i');
		}
		
		#---------save opening stock-----------------------------------
		
		$this->form_validation->set_rules('item_id','lang:item-name','xss_clean|required');
		$this->form_validation->set_rules('check','lang:godown','xss_clean|required');
		
		if($this->input->post('item_id')){
			$itemID = $this->input->post('item_id');
			$itemPrimaryUnits = $this->stock->get_primary_unit($itemID);
			$primaryUnitID = $itemPrimaryUnits['id'];
			$unit_symbol = $itemPrimaryUnits['symbol'];
			$unit_name = $itemPrimaryUnits['formal_name'];			
		}
		
		if( $this->input->post('check')){
			$checkedArray = $this->input->post('check');
			foreach($checkedArray as $k=>$gID){
				$this->form_validation->set_rules('qty'.$gID,'lang:quantity','xss_clean|required|numeric');
				$this->form_validation->set_rules('rate'.$gID,'lang:rate','xss_clean|required|numeric');
			}
		}

		$fiscalStartDate = $this->fiscal_start_date;
		if($this->form_validation->run() === true){

			$itemID = $this->input->post('item_id');
			$checkedArray = $this->input->post('check');
			$opening_amount = 0;
			foreach($checkedArray as $key=>$goDownID){
				
				$qty = $this->input->post('qty'.$goDownID);
				$rate = $this->input->post('rate'.$goDownID);
				$args = array();
				$args['select'] = array('id');
				$args['conditions'] = array('company_id'=>$this->companyID,'godown_id'=>$goDownID,'item_id'=>$itemID,'stock_status'=>0);
				$checkExists = $this->opening_stock->get($args);

				if(empty($checkExists)){
					$opening_amount += ($qty*$rate);
					$saveArray = array('company_id'=>$this->companyID,'branch_id'=>$this->branchID,'godown_id'=>$goDownID,'item_id'=>$itemID,'qty'=>$qty,'unit_id'=>$primaryUnitID,'rate'=>$rate,'stock_date'=>$fiscalStartDate,'stock_status'=>0);
					

					if($this->opening_stock->save($saveArray)){
						$insertCount ++;
					}
				}else{
					$this->message->set($this->lang->line('opening-stock-exists'),'e');
				}
				
					$stock_count = $this->stock->get_stock_count($goDownID,$itemID);

					$this->opening_stock->update_stock_qty(array('qty'=>$stock_count),array('branch_id'=>$this->branchID,'item_id'=>$itemID));
			}
			if($opening_amount >0){
				$check_opening = $this->opening_stock->get_opening_balance(array('select'=>array('id','open_amount'),'conditions'=>array('company_id'=>$this->companyID,'branch_id'=>$this->branchID,'open_date'=>$fiscalStartDate)));
				if(empty($check_opening)){
					$this->opening_stock->save_opening_balance(array('company_id'=>$this->companyID,'branch_id'=>$this->branchID,'open_amount'=>$opening_amount,'open_date'=>$fiscalStartDate,'status'=>1));
				}else{
					$up_id = $check_opening[0]['id'];
					$prev_opening = $check_opening[0]['open_amount'];
					$new_opening = $prev_opening+$opening_amount;
					$this->opening_stock->update_opening_balance(array('open_amount'=>$new_opening),array('company_id'=>$this->companyID,'branch_id'=>$this->branchID,'open_date'=>$fiscalStartDate));
				}
			}
			if($insertCount >0){
				$this->message->set($this->lang->line('opening-stock-saved'));
				redirect('opening_stock/report');
			}
		}

		#---------save opening stock-----------------------------------		
		$this->template->slice('dms/message');
		$this->template->slice('products/openings/opening_stock',array('items'=>$items,'godowns'=>$godowns,'checkedItems'=>$checkedArray,'symbol'=>$unit_symbol,'unit_symbol'=>$unit_symbol,'unit_name'=>$unit_name));
		$this->template->other_script(array('products/opening_stock'));
		$this->template->render();
	}
	
	#==================================================================
	
	public function report(){
		
		$this->template->title = $this->lang->line('opening-stock-report');
		$this->template->main_heading($this->lang->line('opening-stock-report'));
		$this->template->breadcrumb(array($this->lang->line('products') => 'products/add',$this->lang->line('openings') => 'opening_stock/add',$this->lang->line('report') => 'no_link'));
		
		$this->load->model('products/Item_model','item');
		$this->load->library('Pagination');
		$items = $go_downs = array();
		#financial year start date
		$fiscalStartDate = $this->fiscal_start_date;
		$items = $this->stock->get_stock_items();
		$go_downs = $this->stock->get_godowns(array('listing'=>1,'conditions'=>array('branch_id'=>$this->branchID)));
		#for pagination
		$postItem = $postGodown = $selItem = $selGodown = NULL;
		$items[''] = 'Select';ksort($items);
		$go_downs[''] = 'Select';ksort($go_downs);
		$uriSegment = 3;
		$url_string = NULL;
		$this->form_validation->set_rules('item_id','lang:item-name','xss_clean');
		$this->form_validation->set_rules('go_down_id','lang:godown','xss_clean');
		if($this->form_validation->run() === true){
			$postItem = $this->input->post('item_id');
			$postGodown = $this->input->post('go_down_id');
		}else{
			if($this->uri->segment(3)){
				$uriArray = $this->uri->uri_to_assoc(3);
				if(array_key_exists('item',$uriArray)){
					$postItem = $uriArray['item'];
				}
				if(array_key_exists('godown',$uriArray)){
					$postGodown = $uriArray['godown'];
				}
			}
		}
		$conditions = array('ds.stock_status'=>0);
		if(!empty($postItem)){
			$conditions['ds.item_id'] = $postItem;
			$url_string .= '/item/'.$postItem;
			$selItem = $postItem;
			$uriSegment += 2;
		}
		if(!empty($postGodown)){
			$conditions['ds.godown_id'] = $postGodown;
			$url_string .= '/godown/'.$postGodown;
			$selGodown = $postGodown;
			$uriSegment += 2;
		}				
		
		$config['per_page'] = $this->per_page();
		# Pagination Config Customizations
        $config['full_tag_open'] = '<ul class="pagination">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = 'First';
        $config['last_link'] = 'Last';
        $config['next_link'] = '&raquo;';
        $config['prev_link'] = '&laquo;';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
		$args = array();
		$args['num_rows'] = 1;
		$args['conditions'] = $conditions;
		$config['total_rows'] = $this->opening_stock->getAll($args);
		$offset = ($this->uri->segment($uriSegment))?$this->uri->segment($uriSegment):0;
		$config['base_url'] = base_url('opening_stock/report'.$url_string);
		$config['uri_segment'] = $uriSegment;
		$this->pagination->initialize($config);
		$links = $this->pagination->create_links();		
		
		$args = array();
		$args['select'] = array('ds.item_id','ds.godown_id','ds.qty','ds.unit_id','ds.rate','ds.stock_date','ds.stock_status','gm.godown_code','gm.godown_name','im.item_code','im.item_name','im.model_no','um.symbol','um.formal_name');
		$args['conditions'] = $conditions;
		$args['limit'] = $config['per_page'];
		$args['offset'] = $offset;
		$openingStocks = $this->opening_stock->getAll($args);
		
		$StockOpenings = array();
		foreach($openingStocks as $key=>$openingStock){
			
			$itemID = $openingStock['item_id'];
			$goDownID = $openingStock['godown_id'];
			$actOpening = $this->stock->get_actual_opening($itemID,$goDownID);
			if(!empty($actOpening)){
			
					$rate = NULL;	
					$actOpDate = $actOpening['stock_date'];
					$editID = $actOpening['id'];		
					$args = array();
					$args['godown_id'] = $goDownID;
					$args['item_id'] = $itemID;
					$args['opening_date'] = $fiscalStartDate;
					//$openingQnty = $this->stock->get_opening_stock($args);	
					$openingQnty='';
					$purchase_rate = $this->stock->get_purchase_rate($itemID);
					if(!empty($purchase_rate)){
						$rate = $purchase_rate;
					}else{
						$rate = $this->stock->get_opening_rate($itemID);
					}
					$rate = ($rate);#round_this
					$StockOpenings[] = array('id'=>$editID,'item_id'=>$itemID,'item_code'=>$openingStock['item_code'],'item_name'=>$openingStock['item_name'],'godown_code'=>$openingStock['godown_code'],'godown_name'=>$openingStock['godown_name'],'opening_qnty'=>$openingQnty,'formal_name'=>$openingStock['formal_name'],'symbol'=>$openingStock['symbol'],'rate'=>$rate,'model_no'=>$openingStock['model_no']);
			}
		}

		if(empty($StockOpenings)){
			$this->message->set($this->lang->line('no-results-found'),'e');
		}

		$this->template->slice('dms/message');
		$this->template->slice('products/openings/opening_stock_report',array('items'=>$items,'go_downs'=>$go_downs,'stockOpenings'=>$StockOpenings,'opening_date'=>$fiscalStartDate,'count'=>$offset+1,'links'=>$links,'sel_item'=>$selItem,'sel_godown'=>$selGodown,'postItem'=>$postItem,'postGodown'=>$postGodown));
		$this->template->render();		
	}
	
	#-------------------------------------------------------------------------------
	
	public function edit(){
		
		if(!$this->uri->segment(3)){ 
			redirect('opening_stock/report');
		}
		$openingID = $this->uri->segment(3);
		if($this->if_exists('dms_stocks',array('id'=>$openingID)) === false){
			redirect('opening_stock/report');
		}
		$offset= NULL;
		if($this->uri->segment(4)){
			$offset = $this->uri->segment(4);
		}
		$fiscalStartDate = $this->fiscal_start_date;
		$this->template->title($this->lang->line('opening-stock-set'));
		$this->template->main_heading($this->lang->line('opening-stock-set'));
		$this->template->breadcrumb(array($this->lang->line('products') => 'products/add',$this->lang->line('openings') => 'no_link',$this->lang->line('report') => 'opening_stock/report'));
		$unit_symbol = ''; $unit_name = ''; $openingQnty = NULL;$sel_unit='';$units=array();
		$args = array();
		$args['select'] = array('ds.qty','ds.unit_id','ds.rate','ds.stock_date','ds.stock_status','ds.godown_id','ds.item_id','gm.godown_code','gm.godown_name','im.item_code','im.item_name','im.model_no','um.symbol','um.formal_name');
		$args['conditions'] = array('ds.id'=>$openingID);
		$openingStock = $this->opening_stock->getAll($args);

		$prev_qty=0;$prev_rate=0;$prev_opening=0;
		if(empty($openingStock)){
			redirect('opening_stock/report');
		}else{
			$args = array();
			$args['godown_id'] = $openingStock[0]['godown_id'];
			$args['item_id'] = $openingStock[0]['item_id'];
			$prev_qty = $openingStock[0]['qty'];
			$prev_rate = $openingStock[0]['rate'];
			$opening_date = $openingStock[0]['stock_date'];
			$prev_opening = $prev_qty*$prev_rate;
			$args['opening_date'] = $fiscalStartDate;
			//$openingQnty = $this->stock->get_opening_stock($args);			
		}
		
		$this->form_validation->set_rules('qty','lang:quantity','xss_clean|required|numeric');
		$this->form_validation->set_rules('rate','lang:rate','xss_clean|required|numeric');
		
		if($this->form_validation->run() === true){
			if($this->opening_stock->update($this->input->post(NULL,true),$openingID)){
				$opening_amount = $this->input->post('qty')*$this->input->post('rate');
				$check_opening = $this->opening_stock->get_opening_balance(array('select'=>array('id','open_amount'),'conditions'=>array('company_id'=>$this->companyID,'branch_id'=>$this->branchID,'open_date'=>$opening_date)));
				if(empty($check_opening)){
					if($opening_amount > 0){
						$this->opening_stock->save_opening_balance(array('company_id'=>$this->companyID,'branch_id'=>$this->branchID,'open_amount'=>$opening_amount,'open_date'=>$opening_date,'status'=>1));
					}
				}else{
					$up_id = $check_opening[0]['id'];
					$prev_opening_amount = $check_opening[0]['open_amount'];
					$new_opening = ($prev_opening_amount+$opening_amount)-$prev_opening;
					$this->opening_stock->update_opening_balance(array('open_amount'=>$new_opening),array('company_id'=>$this->companyID,'branch_id'=>$this->branchID,'open_date'=>$opening_date,'status'=>1));
				}
				$this->message->set($this->lang->line('opening-stock-saved'));
				redirect('opening_stock/report/'.$offset);
			}else{
				$this->message->set($this->lang->line('opening-stock-not-saved'));
			}
		}
		
		$this->template->slice('dms/message');
		$this->template->slice('products/openings/edit_opening_stock',array('openings'=>$openingStock[0],'current_opening'=>$openingQnty,'sel_unit'=>$sel_unit,'units'=>$units));
		$this->template->other_script(array('products/opening_stock'));
		$this->template->render();		
	}
	
	#------------------------------------------------------------------------------
	
	public function delete(){
		
		if(!$this->uri->segment(3)){ 
			redirect('opening_stock/report');
		}
		$openingID = $this->uri->segment(3);
		if($this->if_exists('dms_stocks',array('id'=>$openingID)) === false){
			redirect('opening_stock/report');
		}
		$offset= NULL;
		if($this->uri->segment(4)){
			$offset = $this->uri->segment(4);
		}
		$args = array();
		$args['select'] = array('ds.item_id','ds.qty','ds.rate','ds.stock_date');
		$args['conditions'] = array('ds.id'=>$openingID);
		$openingStock = $this->opening_stock->getAll($args);
		$prev_qty=0;$prev_rate=0;$prev_opening=0;
		if(empty($openingStock)){
			redirect('opening_stock/report');
		}else{
			$args = array();
			$itemID = $openingStock[0]['item_id'];
			$prev_qty=$openingStock[0]['qty'];
			$prev_rate=$openingStock[0]['rate'];
			$opening_date = $openingStock[0]['stock_date'];
			$prev_opening = $prev_qty*$prev_rate;
		}
		$total_stocks = $this->db->select('id')->get_where('dms_stocks',array('item_id'=>$itemID,'stock_status !='=>0,'status'=>1))->num_rows();
		$total_so = $this->db->select('id')->get_where('dms_sales_items',array('item_id'=>$itemID,'status'=>1))->num_rows();

		if(empty($total_stocks) && empty($total_so)){
			if($this->opening_stock->update(array('status'=>0),$openingID)){
				$this->message->set($this->lang->line('opening-stock-deleted'));
				$check_opening = $this->opening_stock->get_opening_balance(array('select'=>array('id','open_amount'),'conditions'=>array('company_id'=>$this->companyID,'branch_id'=>$this->branchID,'open_date'=>$opening_date)));
				if(!empty($check_opening)){
					$up_id = $check_opening[0]['id'];
					$prev_opening_amount = $check_opening[0]['open_amount'];
					$new_opening = ($prev_opening_amount-$prev_opening);
					$update_values = array('open_amount'=>$new_opening);
					if($new_opening == 0){
						$update_values['status'] = 0;
					}
					$this->opening_stock->update_opening_balance($update_values,array('company_id'=>$this->companyID,'branch_id'=>$this->branchID,'open_date'=>$opening_date));
				}			
			}else{
				$this->message->set($this->lang->line('opening-stock-not-deleted'));
			}
		}else{
			$this->message->set($this->lang->line('can-not-delete-opening'),'i');
		}
		$args = array();
		$perPage = $this->per_page();
		$args['select'] = array('ds.item_id');
		$args['conditions'] = array('ds.stock_status'=>0);
		$args['limit'] = $perPage;
		$args['offset'] = $offset;
		$openingStocks = $this->opening_stock->getAll($args);
		if(empty($openingStocks)){
			$offset = $offset-$perPage;
		}
		if(empty($offset)){$offset=NULL;}
		redirect('opening_stock/report/'.$offset);
	}
	
	#------------------------------------------------------------------------------
		
}
?>