<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
	
	class Payment_modes extends MY_Controller{

		public function __construct(){

			parent :: __construct();
			$this->check_access_right();
			
			#---------------- Checking Financial year is enabled / closed-----------------#
			$method_array = array('add');
			fiscal_status($this->uri->segment(2),$method_array,"payment_modes/report");	
			#---------------- Checking Financial year is enabled / closed-----------------#
			
		}	
	#--------------------------------------------------------	
		#date : 18-6-2014 and 19-6-2014 
		#use :  payment modes report
		
		public function report(){
		
			$this->load->model('payment_modes/Payment_modes_model','payment');
			$this->template->title('Payment Modes');
			$this->template->breadcrumb(array($this->lang->line('preferences')=>'preferences/',$this->lang->line('manage-payment-modes')=>'payment_modes/add',$this->lang->line('report')=>'no_link'));
			#getting DMS Library
			$this->load->library('Dms');
			
			$this->load->library('Pagination');
			$config['total_rows'] = $this->payment->get_all('',1);
			$config['per_page'] = $this->per_page();
			# Pagination Config Customizations
			$config['full_tag_open'] = '<ul class="pagination">';
			$config['full_tag_close'] = '</ul>';
			$config['first_link'] = 'First';
			$config['last_link'] = 'Last';
			$config['next_link'] = '&raquo;';
			$config['prev_link'] = '&laquo;';
			$config['cur_tag_open'] = '<li class="active"><a href="#">';
			$config['cur_tag_close'] = '</a></li>';
			$config['num_tag_open'] = '<li>';
			$config['num_tag_close'] = '</li>';
			$config['base_url'] = base_url('payment_modes/report');
			$config['uri_segment'] = 3;
			$this->pagination->initialize($config); 
			
			$offset = ($this->uri->segment(3))?$this->uri->segment(3):0;
			
			$modes = $this->payment->get_all('',0,$offset,$config['per_page']);
			
			if(empty($modes)){
				$this->message->set($this->lang->line('no-result-found'),'i');
				
			}
			//echo $this->db->last_query()."<hr/>";
			
			$links = $this->pagination->create_links();
			
			$this->template->slice('dms/message');
			$this->template->slice('preferences/payment_modes/report',array('modes'=>$modes,'links'=>$links,'count'=>$offset));
			$this->template->other_script('users/user_show');
			$this->template->render();
			
		}
		#--------------------------------------------------------	
		#date : 19-6-2014
		#use :  Add payment modes
		
		public function add(){
		
		$this->template->title('Payment Modes');
		
		//$this->template->script(array('dms_script'));

			#set validation rules
			$this->form_validation->set_rules('mode','payment mode','trim|xss_clean|required|callback_does_exist');
			$this->form_validation->set_rules('description','description','trim');

			if($this->form_validation->run() == true){
				
				#get for which shop
				$this->load->library('Dms');
				$data = $this->input->post(NULL,true);	
				$data['shop_id'] = $this->session->userdata('shop_id');
				$data['created_by'] = $this->session->userdata('id');
				
				#getting fiscal year
				$fiscal=$this->dms->get_default();
				$data['fiscal_yr_1'] = $fiscal['start_date'];
				$data['fiscal_yr_2'] = $fiscal['end_date'];
				

				#save the payment mode data.
				if($this->db->insert('payment_modes',$data)){
					$this->message->set($this->lang->line('payment_mode_save_msg'));
				}else{
					$this->message->set($this->lang->line('payment_mode_save_err_msg'),'e');
				}

			}
		
		
			$this->template->breadcrumb(array($this->lang->line('preferences')=>'preferences/',$this->lang->line('manage-payment-modes')=>'payment_modes/report',$this->lang->line('new')=>'no_link'));
			
			$this->template->slice('dms/message');
			$this->template->slice('preferences/payment_modes/new');
			$this->template->render();
		
		}
		
		
		#--------------------------------------------------------	
		#date : 19-6-2014
		#use :  callback validation for payment
		
		public function does_exist($mode){
		
			$row = $this->db->get_where('payment_modes',array('shop_id'=>$this->session->userdata('shop_id'),'mode'=>$mode,'status'=>1))->row_array();
			
			if(!empty($row)){
				$this->form_validation->set_message('does_exist',$this->lang->line('payment-mode-already-exists'));
				return FALSE;
			}else{
				return TRUE;
			}		
		}
		#--------------------------------------------------------	
		#date : 20-6-2014
		#use :  update payment mode
		public function update(){
		
		
		
		}
		
			
	}
