<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');



	class Preferences extends MY_Controller{

		public function __construct(){

			parent :: __construct();

			$this->check_access_right();

			

			#---------------- Checking Financial year is enabled / closed-----------------#

			$method_array = array('set');

			fiscal_status($this->uri->segment(2),$method_array,"preferences/index");	

			#---------------- Checking Financial year is enabled / closed-----------------#

			

			$this->load->model('accounts/Cess_model','cess');

			$this->load->model('preferences/Constant_master_model','constant_master');	

		}

		#---------------------------------------------

		

		public function index(){



			$this->template->title($this->lang->line('preferences'));

			$this->template->main_heading(APP_NAME.' '.$this->lang->line('settings'));

			$this->template->sub_heading($this->lang->line('settings'));

			$this->template->breadcrumb(array($this->lang->line('settings')=>'no_link'));

			$this->template->slice('dms/message');

			#get all general link assigned for this employee

			$this->db->select('mm.*');

			$this->db->from('menu_master mm');

			if($this->session->userdata('user_desig') != -1){

				$this->db->join('user_privileges up','up.menu_id=mm.id');

				$this->db->where('up.user_group','individual');

				$this->db->where('up.owner_id',$this->session->userdata('id'));

			}			

			$this->db->where_in('mm.menu_group',array('settings','settings-dashboard'));

			#$this->db->where('mm.menu_parent !=','0')

			$this->db->where('menu_status',1);

			$this->db->order_by('menu_order','ASC');

			$menus = $this->db->get()->result_array();

			$this->template->slice('preferences/general/link_list',array('menus'=>$menus));

			$this->template->render();

		}



	#----------------------------------------------	



		#application settings

		public function set(){



			$total_transactions = $this->constant_master->get_transactions();

			$this->form_validation->set_rules('date_format','lang:date-format','xss_clean');

			$this->form_validation->set_rules('decimal_place','lang:currency-decilam-places','required|xss_clean|is_natural|less_than[4]');

			$this->form_validation->set_rules('currency_symbol','lang:currency-symbol','required|xss_clean');

			$this->form_validation->set_rules('rows_per_page','lang:per-page','required|xss_clean|is_natural_no_zero');

			$this->form_validation->set_rules('stock_value_type','lang:stock-value-method','required|xss_clean');

			$this->form_validation->set_rules('cess_percent','lang:cess-percent','required|xss_clean|numeric');					

			$this->form_validation->set_rules('purchase_cst','lang:purchase-cst','xss_clean|numeric');

			$this->form_validation->set_rules('sales_cst','lang:sales-cst','xss_clean|numeric');

			$this->form_validation->set_rules('vat_in_ex','lang:vat-in-ex','required|xss_clean');

			if(empty($total_transactions)){

				$this->form_validation->set_rules('net_amount_round','lang:net-amount-round','required|xss_clean');

			}

			



			if($this->form_validation->run() == true)

			{				

				$cess_data = array();$cst_data = array();

				$data = $this->input->post(NULL,true);

				unset($data['cess_percent']);

				unset($data['stock_value_type']);

				unset($data['net_amount_round']);

				$stock_value_type = $this->input->post('stock_value_type');

				$cess_data['cess_percent'] = $this->input->post('cess_percent');

				$cess_data['company_id'] = $this->session->userdata('company_id');

				$cess_data['fiscal_yr_id'] = $this->session->userdata('fiscal_yr_id');

				$data['purchase_cst'] = $this->input->post('purchase_cst');

				$data['sales_cst'] = $this->input->post('sales_cst');

				

				if(empty($total_transactions)){

					$data['net_amount_round'] = $this->input->post('net_amount_round');

				}

				$data['created_by'] = $this->session->userdata('id');

				$data['created_on'] = date('Y-m-d H:i:s');



				if($this->constant_master->update($data,array('company_id' => $this->session->userdata('company_id')))){

					$this->cess->insert($cess_data);

					$this->constant_master->save_stock_value_type($stock_value_type);

					$this->message->set($this->lang->line('preferences-preserved'));

					$this->db->cache_delete_all();

				}else{

					$this->message->set($this->lang->line('preferences-not-preserved'));

				}	

			}



			$this->template->title('Preference settings');

			$this->template->main_heading($this->lang->line('preferences'));

			$this->template->breadcrumb(array($this->lang->line('settings')=>'preferences/',$this->lang->line('preferences')=>'no_link'));



			#date formats

			$formats = array('Y-m-d'=>date('Y-m-d'),'d-m-Y'=>date('d-m-Y'),'d/m/Y'=>date('d/m/Y'),'d-m-Y'=>date('d-m-Y'),'d:m:Y'=>date('d:m:Y'),'d/F/Y'=>date('d/F/Y'),'d-F-Y'=>date('d-F-Y'),'d-M-Y'=>date('d-M-Y'),'d/M/Y'=>date('d/M/Y'),'Y M d'=>date('Y M d'));



			#get constants from table

			$constants = $this->db->get_where('constant_master',array('company_id'=>$this->session->userdata('company_id')))->row_array();



			$stock_value_types = $this->constant_master->get_stock_value_type();

			$constants['stock_value_type'] = NULL;

			if(!empty($stock_value_types)){

				$constants['stock_value_type'] = $stock_value_types['value_type'];

			}



			$cess_percent = 0;

			$cess_result = $this->cess->get(array('columns' => array('cess_percent')));

			if($cess_result){

				$cess_percent = $cess_result['cess_percent'];

			}

			$constants['cess_percent'] = $cess_percent;

			$stock_value_array = array(0 => 'Avg. Cost',1 => 'Last Purchase Cost');

			$this->template->slice('dms/message');

			$this->template->slice('preferences/constants/settings',array('date_formats'=>$formats,'constants'=>$constants,'stock_value_array' => $stock_value_array,'stock_transactions'=>$total_transactions));

			#$this->js->select('.decimal')->apply_plugin('spinner({});')->endJS();

			$this->template->render();

		}



	#-------------------------------------------------	

	}

?>