<?php if( ! defined('BASEPATH')) exit('No direct script access alloed');

class Privileges extends MY_Controller{

	public function __construct(){

		parent ::__construct();
		$this->check_access_right();
		#---------------- Checking Financial year is enabled / closed-----------------#
		if($this->session->userdata('id') !=-1){
			$method_array = array('add','update','unblock','block');
			fiscal_status($this->uri->segment(2),$method_array,"privileges/report");	
		}	
		#---------------- Checking Financial year is enabled / closed-----------------#
		
	}

	#-------------------------------------------------------
	#date:26-07-2014
	#purpose:Add user menu privilege[this ajax scipt is assets/scripts/]
	public function add()
	{
		$this->load->model("designations/designation_master_model",'desig');
		$user_types = $this->desig->desig_listing(1);
		$user_types['-3'] = 'Select';
		ksort($user_types);
		
		#-----------template
		$this->template->title($this->lang->line('manage-privileges'));
		$this->template->main_heading($this->lang->line('manage-privileges'));
		$this->template->breadcrumb(array($this->lang->line('privileges') =>'no_link',$this->lang->line('update')=>'privileges/update'));
		$this->template->slice('privileges/new',array('user_types'=>$user_types));
		$this->template->other_script('privileges/user_privilege');
		$this->template->slice('dms/modals/message_modal');
		$this->template->render();
	}
	
	#--------------------------------------------------------
	#date:26-07-2014
	#purpose:update user menu privilege[this ajax scipt in dmscript.js]
	public function update()
	{
		$this->load->model("designations/designation_master_model",'desig');
		$user_types = $this->desig->desig_listing(1);
		$user_types['-3'] = 'Select';
		ksort($user_types);
		#template
		$this->template->title($this->lang->line('manage-privileges'));
		$this->template->main_heading($this->lang->line('manage-privileges'));
		$this->template->breadcrumb(array($this->lang->line('privileges')=>'no_link',$this->lang->line('new')=>'privileges/add'));
		$this->template->slice('privileges/update',array('user_types'=>$user_types));
		$this->template->other_script('privileges/update_user_privilege');
		$this->template->slice('dms/modals/message_modal');
		$this->template->render();
	}
#--------------------------------------------------------
	#date : 08-08-2014
	#purpose : Unblock All blocked users
	public function unblock()
	{
		#validation for user selection
		if($this->input->post('submit_one')){
			$this->form_validation->set_rules('user','lang:user-type','required');
		}
		
		#validation for unblock users	
		if(isset($_POST['submit_unblock'])){
			if(!isset($_POST['unblock'])){
				$this->message->set($this->lang->line('select-one-user'),'i');
			}else{
				$users=$_POST['unblock'];
				$result=$this->user->unblock($users);
				if($result){
					$this->message->set($this->lang->line('user-unblocked'));
				}else{
					$this->message->set($this->lang->line('user-not-unblocked'),'e');
				}
				redirect('privileges/block');
			}
		}
		if($this->form_validation->run() === true || $this->uri->segment(3) !=''){
			$user_type =($this->input->post('user'))?$this->input->post('user',true):$this->uri->segment(4);
			$this->load->library('Pagination');
			$config['total_rows'] = $this->user->get_users_details(array('designation_id'=>$user_type),1);
			if($config['total_rows'] == '0'){
					$this->message->set($this->lang->line('no-results-found'),'i');
			}
			if($this->uri->segment(3)=='unb' || $this->input->post('user')){

				$config['base_url'] = base_url('privileges/unblock/unb/'.$user_type);
				$config['per_page'] = $this->per_page();
				# Pagination Config Customizations
				$config['full_tag_open'] = '<ul class="pagination">';
				$config['full_tag_close'] = '</ul>';
				$config['first_link'] = 'First';
				$config['last_link'] = 'Last';
				$config['next_link'] = '&raquo;';
				$config['prev_link'] = '&laquo;';
				$config['cur_tag_open'] = '<li class="active"><a href="#">';
				$config['cur_tag_close'] = '</a></li>';
				$config['num_tag_open'] = '<li>';
				$config['num_tag_close'] = '</li>';
				$config['uri_segment'] = 5;
				$offset = ($this->uri->segment(5))?$this->uri->segment(5):0;		}else{
				$config['per_page'] = $this->per_page();
				$config['base_url'] = base_url('privileges/unblock');
				$config['uri_segment'] = 3;
				$offset = ($this->uri->segment(3))?$this->uri->segment(3):0;		
			}
			$this->pagination->initialize($config); 
			$users = $this->user->get_users_details(array('designation_id'=>$user_type),0,$offset,$config['per_page']);
			$links = $this->pagination->create_links();
			
		}else if(isset($_POST['submit_unblock'])){
			$user_type=$_POST['user_type'];
		}else{
			$user_type='';
		}
			
			
		$this->template->title($this->lang->line('unblock-users'));
		$this->template->main_heading($this->lang->line('unblock-users'));	
		$this->template->breadcrumb(array($this->lang->line('privileges')=>'no_link',$this->lang->line('block')=>'privileges/block'));
		
		//get user details with pagination
		#for select user type
		$this->load->model("designations/designation_master_model",'desig');
		$type = $this->desig->desig_listing(1);
		$type[''] = 'Select';
		ksort($type);

		$this->template->slice('dms/message');
		$this->template->slice('privileges/unblock/select_user',array('types'=>$type,'user_type'=>$user_type));
		if(!empty($users)){
		
			#view details of blocked Employees in branches for unbloking			
			if($user_type !=3){
				$this->template->slice('dms/message');
				$this->template->slice('privileges/unblock/show_branch_employee',array('employees'=>$users,'links'=>$links,'count'=>$offset,'user_type'=>$user_type));
			}
			#view details of blocked ARs for unbloking		
			if($user_type == 3){
				$this->template->slice('dms/message');
				$this->template->slice('privileges/unblock/show_ars',array('counters'=>$users,'links'=>$links,'count'=>$offset,'user_type'=>$user_type));
			}
		}
		$this->template->render();
	}
		
	#--------------------------------------------------------
	#date : 13-08-2014
	#purpose : Block users
	public function block(){
	
		#validation for user selection
		if($this->input->post('submit_one')){
			$this->form_validation->set_rules('user','lang:user-type','required');
		}
		
		#validation for unblock users	
		if(isset($_POST['submit_block'])){
			if(!isset($_POST['block'])){
				$this->message->set($this->lang->line('select-one-user'),'i');
			}else{
				$users=$_POST['block'];
				$result=$this->user->block($users);
				if($result){
					$this->message->set($this->lang->line('user-blocked'));
				}else{
					$this->message->set($this->lang->line('user-not-blocked'),'e');
				}
				redirect('privileges/unblock');
			}
		}
		
		if($this->form_validation->run() === true || $this->uri->segment(3) !=''){

			$user_type =($this->input->post('user'))?$this->input->post('user',true):$this->uri->segment(4);
			$this->load->library('Pagination');
			$config['total_rows'] = $this->user->get_unblock_users_details(array('designation_id'=>$user_type),1);
			if($config['total_rows'] == '0'){
				$this->message->set($this->lang->line('no-results-found'),'i');
			}
			if($this->uri->segment(3)=='blk' || $this->input->post('user')){
				$config['base_url'] = base_url('privileges/block/blk/'.$user_type);
				$config['per_page'] = $this->per_page();
				# Pagination Config Customizations
				$config['full_tag_open'] = '<ul class="pagination">';
				$config['full_tag_close'] = '</ul>';
				$config['first_link'] = 'First';
				$config['last_link'] = 'Last';
				$config['next_link'] = '&raquo;';
				$config['prev_link'] = '&laquo;';
				$config['cur_tag_open'] = '<li class="active"><a href="#">';
				$config['cur_tag_close'] = '</a></li>';
				$config['num_tag_open'] = '<li>';
				$config['num_tag_close'] = '</li>';
				$config['uri_segment'] = 5;
				$offset = ($this->uri->segment(5))?$this->uri->segment(5):0;		
			}else{
				$config['per_page'] = $this->per_page();
				# Pagination Config Customizations
				$config['full_tag_open'] = '<ul class="pagination">';
				$config['full_tag_close'] = '</ul>';
				$config['first_link'] = 'First';
				$config['last_link'] = 'Last';
				$config['next_link'] = '&raquo;';
				$config['prev_link'] = '&laquo;';
				$config['cur_tag_open'] = '<li class="active"><a href="#">';
				$config['cur_tag_close'] = '</a></li>';
				$config['num_tag_open'] = '<li>';
				$config['num_tag_close'] = '</li>';
				$config['base_url'] = base_url('privileges/block');
				$config['uri_segment'] = 3;
				$offset = ($this->uri->segment(3))?$this->uri->segment(3):0;		
			}
			$this->pagination->initialize($config); 
			$users = $this->user->get_unblock_users_details(array('designation_id'=>$user_type),0,$offset,$config['per_page']);
			$links = $this->pagination->create_links();

		}else if(isset($_POST['submit_block'])){
			$user_type=$_POST['user_type'];
		}else{
			 $user_type='';
		}

		$this->template->title('Block Users');
		$this->template->main_heading($this->lang->line('block-users'));
		$this->template->breadcrumb(array($this->lang->line('privileges')=>'no_link',$this->lang->line('unblock')=>'privileges/unblock'));	
			
		//get user details with pagination
		$this->load->model("designations/designation_master_model",'desig');
		$type = $this->desig->desig_listing(1);
		//echo $this->db->last_query();die;
		$type[''] = 'Select';
		ksort($type);
		//select users form
		$this->template->slice('dms/message');
		$this->template->slice('privileges/block/select_user',array('types'=>$type,'user_type'=>$user_type));
		
		if(!empty($users)){
		
			#view details of blocked Employees in branches for unbloking			
			if($user_type != 3){
				$this->template->slice('dms/message');
				$this->template->slice('privileges/block/show_branch_employee',array('employees'=>$users,'links'=>$links,'count'=>$offset,'user_type'=>$user_type));
			}
			#view details of blocked ARs for unbloking		
			if($user_type == 3){
				$this->template->slice('dms/message');
				$this->template->slice('privileges/block/show_ars',array('counters'=>$users,'links'=>$links,'count'=>$offset,'user_type'=>$user_type));
			}
		}
		$this->template->render();
	}
	
	#--------------------------------------------------------

	public function blocked_users(){

	}
}
?>