<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Purchase_orders extends MY_Controller{

	var $companyID;
	var $branchID;
	var $createdBY;
	var $fiscal_start_date;
	var $fiscal_end_date;

	#------------------------------------

	public function __construct(){

		parent::__construct();
		$this->check_access_right();

		#---------------- Checking Financial year is enabled / closed-----------------#
		$method_array = array('add','edit','delete','edit_item','remove_item');
		fiscal_status($this->uri->segment(2),$method_array,"purchase_orders/report");
		#---------------- Checking Financial year is enabled / closed-----------------#

		$this->companyID = $this->session->userdata('company_id');
		$this->branchID = $this->session->userdata('under_id');
		$this->createdBY = $this->session->userdata('id');

		$fiscals = $this->dms->get_fiscal_year();
		$this->fiscal_start_date = $fiscals['start_date'];
		$this->fiscal_end_date = $fiscals['end_date'];
	}

	#------------------------------------

	public function add(){

		$this->template->title($this->lang->line('purchase-order'));
		$this->template->main_heading($this->lang->line('purchase-order'));
		$this->template->breadcrumb(array($this->lang->line('purchase-order') => 'no_link',$this->lang->line('report') => 'purchase_orders/report'));
		$this->load->model('purchase/Purchase_order_temp_model','purchase_order_temp');

		$vendors = $units = $items =  $goDowns = array();
		$inputSelects = array('vendors','units','items','goDowns');
		$this->load->library('Stock');
		$cstEnabled = 0;
		$vendors = $this->stock->get_vendors();
		$items = $this->stock->get_stock_items();
		$po_details = array();
		$newBillNumber = $this->purchase_order_temp->get_purchase_order_number();

		#------------presumptive tax checking
		$presumtiveTax = $this->stock->get_tax_type();

		#--get temporary data
		$args = array();
	/*	$args['select'] = array('dpot.id','dpot.po_no','dpot.po_date','dpot.vendor_id','dpoti.id as dpoti_id','dpoti.item_id','dpoti.godown_id','dpoti.qty','dpoti.rate','dpoti.amount','dpoti.discount_per','dpoti.discount_amt','dpoti.unit_id','dpoti.vat_percent','dpoti.vat_amt','dpoti.cst','im.item_code','im.item_name','um.symbol');
		$args['conditions'] = array('dpot.branch_id'=>$this->branchID,'dpot.created_by'=>$this->createdBY);
		$args['join'] = array('dms_purchase_order_temp_items as dpoti'=>'dpot.id=dpoti.dpot_id','item_master as im'=>'dpoti.item_id=im.id','unit_master as um'=>'dpoti.unit_id=um.id'); 
		$tempOrder = $this->purchase_order_temp->get($args);
		if(empty($tempOrder))
		{       */
			$args['select'] = array('dpot.id','dpot.po_no','dpot.po_date','dpot.vendor_id','dpoti.id as dpoti_id','dpoti.item_id','dpoti.godown_id','dpoti.qty','dpoti.rate','dpoti.amount','dpoti.discount_per','dpoti.discount_amt','dpoti.unit_id','dpoti.vat','dpoti.vat_amt','im.item_code','im.item_name','im.model_no','um.symbol');
			$args['conditions'] = array('dpot.branch_id'=>$this->branchID,'dpot.created_by'=>$this->createdBY);
			$args['join'] = array('dms_purchase_order_temp_items as dpoti'=>'dpot.id=dpoti.dpot_id','item_master as im'=>'dpoti.item_id=im.id','unit_master as um'=>'dpoti.unit_id=um.id');
			$tempOrder = $this->purchase_order_temp->get($args);
	//	}
		if(!empty($tempOrder)){
			$purchaseOrderID = $tempOrder[0]['id'];
			$newBillNumber = $tempOrder[0]['po_no'];
			$po_details['po_date'] = $tempOrder[0]['po_date'];
			$po_details['vendor_id'] = $tempOrder[0]['vendor_id'];

			$args=array();
			$args['select'] = array('dpoti.id');
			$args['conditions'] = array('dpoti.dpot_id'=>$purchaseOrderID,'dpoti.cst >'=>0);
			$args['join'] = array('dms_purchase_order_temp_items as dpoti'=>'dpot.id=dpoti.dpot_id');
		//	$cstEnabled = $this->purchase_order_temp->get($args);
		//	$cstEnabled = count($cstEnabled);
		}

		if(isset($_POST['add_to_bill']))
		{
			if(empty($tempOrder))
			{
				$this->form_validation->set_rules('po_no','lang:po-no','xss_clean|required|is_natural|greater_than[0]|callback_bill_num_check');
				$this->form_validation->set_rules('po_date','lang:po-date','xss_clean|required|valid_date|is_date|check_date['.date('Y-m-d').'.<=]');
				$this->form_validation->set_rules('vendor_id','lang:vendor','xss_clean|required');
			}
			$this->form_validation->set_rules('item_id','lang:item-name','xss_clean|required');
			$this->form_validation->set_rules('godown_id','lang:godown','xss_clean|required');
		//	$this->form_validation->set_rules('cst','lang:cst','xss_clean|greater_or_equal[0]|less_or_equal[100]');
			$this->form_validation->set_rules('unit_id','lang:unit','xss_clean|required');
			$this->form_validation->set_rules('qty','lang:qty','xss_clean|required|greater_or_equal[0]');
			$this->form_validation->set_rules('rate','lang:rate','required|xss_clean|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('amount','lang:amount','xss_clean|required|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('discount_per','lang:discount %','xss_clean|greater_than[0]|less_or_equal[100]');
			$this->form_validation->set_rules('discount_amt','lang:discount','xss_clean|greater_or_equal[0]|less_than[100000000]');
			if($this->input->post('item_id'))
			{
				$itemID = $this->input->post('item_id');
				$units = $this->stock->get_units($itemID);
				$goDowns = $this->stock->get_item_godowns(array('item_id'=>$itemID,'listing'=>1));
			}

			if($this->form_validation->run('add_to_bill') === true)
			{
				$this->db->trans_start();
				$postedItems = $this->input->post(NULL,true);
		
				$b_date = date('Y-m-d',strtotime($postedItems['po_date']));
				$l_date = '2017-07-01';
				$poCST  = 0;
			 /*if($this->input->post('cst')){
					$poCST = $postedItems['cst'];
		    	}*/

				#----------VAT calculation
				
					$cgst = $sgst = $cgstAmt = $sgstAmt = 0;
					$cgst = $this->stock->get_item_cgst($postedItems['item_id']);
					$sgst = $this->stock->get_item_sgst($postedItems['item_id']);
					
					$cgstAmt = ((((float)$postedItems['amount']-(float)$postedItems['discount_amt']) * (float)$cgst) / 100);
					$sgstAmt = ((((float)$postedItems['amount']-(float)$postedItems['discount_amt']) * (float)$sgst) / 100);	
					
				
				$tempPOID = NULL;
				if(empty($tempOrder)){
					if($this->purchase_order_temp->save_order(array('branch_id'=>$this->branchID,'po_no'=>$newBillNumber,'po_date'=>date('Y-m-d',strtotime($postedItems['po_date'])),'vendor_id'=>$postedItems['vendor_id'],'created_by'=>$this->createdBY))){
						$tempPOID = $this->db->insert_id();
					}
				}else{
					$tempPOID = $tempOrder[0]['id'];
				}

				if(!empty($tempPOID))
				{
					$args = array();
					$args['select'] = array('dpot.id');
					$args['conditions'] = array('dpot.id'=>$tempPOID,'dpoti.item_id'=>$postedItems['item_id'],'dpoti.godown_id'=>$postedItems['godown_id'],'dpoti.unit_id'=>$postedItems['unit_id']);
					
						$args['join'] = array('dms_purchase_order_temp_items as dpoti'=>'dpot.id=dpoti.dpot_id');	
					
					$OrderItemCheck = $this->purchase_order_temp->get($args);

					$postedItems['rate'] = 0;
					if($postedItems['qty'] >0){
						$postedItems['rate'] = (float)$postedItems['amount']/(float)$postedItems['qty'];
					}
					if(empty($OrderItemCheck))
					{

						
						 	if($this->purchase_order_temp->save_order_items(array('dpot_id'=>$tempPOID,'item_id'=>$postedItems['item_id'],'godown_id'=>$postedItems['godown_id'],'qty'=>$postedItems['qty'],'unit_id'=>$postedItems['unit_id'],'rate'=>$postedItems['rate'],'amount'=>$postedItems['amount'],'discount_per'=>$postedItems['discount_per'],'discount_amt'=>$postedItems['discount_amt'],'cgst'=>$cgst,'sgst'=>$sgst,'cgst_amt'=>$cgstAmt,'sgst_amt'=>$sgstAmt)))
							{	
								$this->message->set($this->lang->line('item-added-to-bill'));
								$this->db->trans_complete();
								redirect('purchase_orders/add');	
							}
						
					}
					else
					{
						$this->message->set($this->lang->line('same-po-item-exists'),'e');
					}
				}
			}
		}

		if(isset($_POST['save_bill'])){
			$this->form_validation->set_rules('remarks','lang:remarks','xss_clean');
			if($this->form_validation->run('save_bill') === true){
				#check_po_number
				$this->load->model('purchase/Purchase_order_model','purchase_order');
				if($this->purchase_order->check_po_number($newBillNumber) === true){

					$this->db->trans_start();
					$cess = $this->stock->get_cess();
					$po_num = $tempOrder[0]['po_no'];
					$po_date = date('Y-m-d',strtotime($tempOrder[0]['po_date']));
					$l_date = '2017-07-01';
					$vendor_id = $tempOrder[0]['vendor_id'];
					$groupID = $this->stock->get_group_id('dms_purchase_orders');
					$remarks = $this->input->post('remarks');
					$discountPer = $this->input->post('bill_discount_per');
					$discountAmt = $this->input->post('bill_discount_amt');
					if($this->purchase_order->save_purchase_order(array('branch_id'=>$this->branchID,'po_no'=>$po_num,'po_date'=>$po_date,'group_id'=>$groupID,'vendor_id'=>$vendor_id,'remarks'=>$remarks,'po_status'=>0,'po_discount_per'=>$discountPer,'po_discount_amt'=>$discountAmt,'cess'=>$cess)))
					{
					
						if($po_date < $l_date)
						{
							foreach($tempOrder as $tkey=>$tempData)
							{
								if($this->purchase_order->save_purchase_order_item(array('group_id'=>$groupID,'item_id'=>$tempData['item_id'],'godown_id'=>$tempData['godown_id'],'qty'=>$tempData['qty'],'unit_id'=>$tempData['unit_id'],'rate'=>$tempData['rate'],'amount'=>$tempData['amount'],'discount_per'=>$tempData['discount_per'],'discount_amt'=>$tempData['discount_amt'],'vat_percent'=>$tempData['vat_percent'],'vat_amt'=>$tempData['vat_amt'],'cst'=>$poCST,'item_status'=>0)))
								{
									$this->purchase_order_temp->delete($tempData['dpoti_id']);
									$insertCount++;
								}
							}
							$this->message->set($this->lang->line('purchase-order-saved'));
						}
						else
						{	
							foreach($tempOrder as $tkey=>$tempData)
							{
								if($this->purchase_order->save_purchase_order_items(array('group_id'=>$groupID,'item_id'=>$tempData['item_id'],'godown_id'=>$tempData['godown_id'],'qty'=>$tempData['qty'],'unit_id'=>$tempData['unit_id'],'rate'=>$tempData['rate'],'amount'=>$tempData['amount'],'discount_per'=>$tempData['discount_per'],'discount_amt'=>$tempData['discount_amt'],'cgst'=>$tempData['cgst'],'sgst'=>$tempData['sgst'],'cgst_amt'=>$tempData['cgst_amt'],'sgst_amt'=>$tempData['sgst_amt'],'item_status'=>0)))
								{
									$this->purchase_order_temp->deletes($tempData['dpoti_id']);
									$insertCount++;
								}
							}
							$this->message->set($this->lang->line('purchase-order-saved'));
						}
					}
					else
					{
						$this->message->set($this->lang->line('purchase-order-not-saved'));
					}

				}else{
					$this->message->set($this->lang->line('same-po-bill-exists'));
				}
				$this->db->trans_complete();
				redirect('purchase_orders/add');
			}
		}

		foreach($inputSelects as $key=>$selectBox){
			$arrayName = $$selectBox;
			$arrayName[''] = 'Select';
			$$selectBox = $arrayName;
			ksort($$selectBox);
		}
		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('purchase/purchase_order/add_purchase_order',array('po_no'=>$newBillNumber,'items'=>$items,'goDowns'=>$goDowns,'units'=>$units,'vendors'=>$vendors,'po_details'=>$po_details,'purchase_order_items'=>$tempOrder,'cst_enabled'=>$cstEnabled,'presumtiveTax' => $presumtiveTax));
		$this->template->other_script(array('purchase/purchase_order'));
		$this->template->render();

	}

	#===============================================

	public function bill_num_check($str){
		if($this->purchase_order_temp->po_number_check($str) === true){
			return TRUE;
		}else{
			return FALSE;
		}
	}

	#===============================================

	public function remove_temp_item(){

		if(!$this->uri->segment(3)){
			redirect('users/logout');
		}
		$tempItemID = $this->uri->segment(3);
		if($this->if_exists('dms_purchase_order_temp_items',array('id'=>$tempItemID,'created_by'=>$this->createdBY)) === false){
			redirect('purchase_orders/add');
		}
		$this->load->model('purchase/Purchase_order_temp_model','purchase_order_temp');
		if($this->purchase_order_temp->deletes($tempItemID)){
			$this->message->set($this->lang->line('item-deleted-from-bill'));
		}
		redirect('purchase_orders/add');
	}

	#================================================

	public function report(){

		$this->template->title($this->lang->line('purchase-order-report'));
		$this->template->main_heading($this->lang->line('purchase-order-report'));
		$this->template->breadcrumb(array($this->lang->line('purchase-order') => 'purchase_orders/add',$this->lang->line('report') => 'no_link'));
		$this->load->model('purchase/Purchase_order_model','purchase_order');
		$this->load->library('Stock');
		$this->load->library('Pagination');

		$links = $from_date = $to_date = NULL;$offset=0;
		$l_date = '2017-07-01';
		$config['per_page'] = $this->per_page();
		# Pagination Config Customizations
        $config['full_tag_open'] = '<ul class="pagination">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = 'First';
        $config['last_link'] = 'Last';
        $config['next_link'] = '&raquo;';
        $config['prev_link'] = '&laquo;';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
		$config['uri_segment'] = 3;
		$offset = ($this->uri->segment(3))?$this->uri->segment(3):0;
		$config['base_url'] = base_url('purchase_orders/report');

		if(isset($_POST['get'])){
			$this->form_validation->set_rules('from_date','lang:from-date','xss_clean|required|is_date|valid_date');
			$this->form_validation->set_rules('to_date','lang:to-date','xss_clean|required|is_date|valid_date');
			if($this->form_validation->run() === true){
				$from_date = date('Y-m-d',strtotime($this->input->post('from_date')));
				$to_date = date('Y-m-d',strtotime($this->input->post('to_date')));
				$config['base_url'] = base_url('purchase_orders/report/'.$from_date.'/'.$to_date);
			}
		}else if($this->uri->segment(3) && $this->uri->segment(4)){

			$from_date = date('Y-m-d',strtotime($this->uri->segment(3)));
			$to_date = date('Y-m-d',strtotime($this->uri->segment(4)));
			$config['uri_segment'] = 5;
			$offset = ($this->uri->segment(5))?$this->uri->segment(5):0;
			$config['base_url'] = base_url('purchase_orders/report/'.$from_date.'/'.$to_date);

		}else{
			if((strtotime($this->fiscal_start_date) <= strtotime(date('Y-m-d'))) && (strtotime($this->fiscal_end_date) >= strtotime(date('Y-m-d')))){
				$from_date = date('Y-m-d');
				$to_date = date('Y-m-d');
			}else{
				$from_date = $this->fiscal_end_date;
				$to_date = $this->fiscal_end_date;
			}

		}
		$purchase_orders = array();$purchase_order_items= $poStatusArray = array();
		if(!empty($from_date) && !empty($to_date)){

			$args = array();
			$args['select'] = array('dpo.id');
			$args['from_date'] = $from_date;
			$args['to_date'] = $to_date;
			$args['num_rows'] = 1;
			$config['total_rows'] = $this->purchase_order->get($args);
			$this->pagination->initialize($config);
			$links = $this->pagination->create_links();

			$args = array();
			$args['select'] = array('dpo.id','dpo.po_no','dpo.po_date','dpo.group_id','dpo.po_status','dpo.po_discount_per','dpo.po_discount_amt','dpo.cess','imm.manufacturer_name as vendor_name','imm.phone');
			$args['join'] = array('item_manufacturer_master as imm'=>'dpo.vendor_id=imm.id');
			$args['from_date'] = $from_date;
			$args['to_date'] = $to_date;
			$args['limit'] = $config['per_page'];
			$args['offset'] = $offset;
			$purchase_orders = $this->purchase_order->get($args);
			if(empty($purchase_orders)){
				$this->message->set($this->lang->line('no-result-found'),'i');
			}
			foreach($purchase_orders as $pKey=>$purchase_order)
			{
				$po_date = $purchase_order['po_date'];	
				$args = array();
				if($po_date < $l_date)
				{
				/*	$args['select'] = array('dpo.id as dpo_id','dpi.id','dpi.group_id','dpi.item_id','dpi.qty','dpi.unit_id','dpi.rate','dpi.amount','dpi.discount_per','dpi.discount_amt','dpi.vat_amt','dpi.cst','dpi.godown_id','dpi.item_status');
					$args['join'] = array('dms_purchase_items as dpi'=>'dpo.group_id=dpi.group_id');
					$args['conditions'] = array('dpo.group_id'=>$purchase_order['group_id'],'dpi.item_status <='=>1,'dpi.status'=>1);
					*/
				}
				else
				{
					$args['select'] = array('dpo.id as dpo_id','dpi.id','dpi.group_id','dpi.item_id','dpi.qty','dpi.unit_id','dpi.rate','dpi.amount','dpi.discount_per','dpi.discount_amt','dpi.cgst_amt','dpi.sgst_amt','dpi.godown_id','dpi.item_status');
					$args['join'] = array('dms_purchase_items1 as dpi'=>'dpo.group_id=dpi.group_id');
					$args['conditions'] = array('dpo.group_id'=>$purchase_order['group_id'],'dpi.item_status <='=>1,'dpi.status'=>1);	
				}
				$purchase_order_items[$purchase_order['id']] = $this->purchase_order->get($args);
				if($this->purchase_order->get_po_status($purchase_order['id']) === true){
					$poStatusArray[$purchase_order['id']] = 1;
				}else{
					$poStatusArray[$purchase_order['id']] = 0;
				}
			}
		}
		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('date/between_date_search',array('from_date'=>$from_date,'to_date'=>$to_date));
		$this->template->slice('purchase/purchase_order/purchase_order_report',array('purchase_orders'=>$purchase_orders,'po_status_array'=>$poStatusArray,'purchase_order_items'=>$purchase_order_items,'links'=>$links,'count'=>$offset+1,'offset'=>$offset,'from_date'=>$from_date,'to_date'=>$to_date));
		$this->template->other_script(array('purchase/purchase_order'));
		$this->template->render();
	}

	#================================================

	public function edit(){

		if(!$this->uri->segment(3)){
			redirect('purchase_orders/report');
		}
		$purchaseOrderID = $this->uri->segment(3);
		if($this->if_exists('dms_purchase_orders',array('id'=>$purchaseOrderID,'status'=>1)) === false){
			redirect('purchase_orders/report');
		}
		$uriArray = $this->uri->uri_to_assoc(4);
		$urlString = $this->uri->assoc_to_uri($uriArray);
		$this->template->title($this->lang->line('edit-purchase-order'));
		$this->template->main_heading($this->lang->line('edit-purchase-order'));
		$this->template->breadcrumb(array($this->lang->line('purchase-order') => 'purchase_orders/add',$this->lang->line('report') => 'purchase_orders/report',$this->lang->line('edit') => 'no_link',$this->lang->line('go-back')=>array('purchase_orders/report/'.$urlString)));
		$this->load->model('purchase/Purchase_order_model','purchase_order');

		$vendors = $units = $goDowns = $items =  array();
		$inputSelects = array('vendors','units','goDowns','items');
		$this->load->library('Stock');
		$vendors = $this->stock->get_vendors();
		$items = $this->stock->get_stock_items();

		#------------presumptive tax checking
		$presumtiveTax = $this->stock->get_tax_type();

		$po_status = 1;
		$args = array();
		$args['select'] = array('dpo.id','dpo.branch_id','dpo.po_no','dpo.po_date','dpo.group_id','dpo.vendor_id','dpo.remarks','dpo.po_status','dpo.po_discount_per','dpo.po_discount_amt','dpo.cess','dpi.id as dpi_id','dpi.item_id','dpi.qty','dpi.unit_id','dpi.rate','dpi.amount','dpi.vat_percent','dpi.vat_amt','dpi.cst','dpi.discount_per','dpi.discount_amt','dpi.item_status','im.item_code','im.item_name','um.symbol');
		$args['join'] = array('dms_purchase_items as dpi'=>'dpo.group_id=dpi.group_id','item_master as im'=>'dpi.item_id=im.id','unit_master as um'=>'dpi.unit_id=um.id');
		$args['conditions'] = array('dpo.id'=>$purchaseOrderID,'dpi.item_status <='=>1,'dpi.status'=>1);
		$purchase_orders = $this->purchase_order->get($args);
		if(empty($purchase_orders))
		{
			$args['select'] = array('dpo.id','dpo.branch_id','dpo.po_no','dpo.po_date','dpo.group_id','dpo.vendor_id','dpo.remarks','dpo.po_status','dpo.po_discount_per','dpo.po_discount_amt','dpo.cess','dpi.id as dpi_id','dpi.item_id','dpi.qty','dpi.unit_id','dpi.rate','dpi.amount','dpi.cgst','dpi.sgst','dpi.cgst_amt','dpi.sgst_amt','dpi.discount_per','dpi.discount_amt','dpi.item_status','im.item_code','im.item_name','um.symbol');
			$args['join'] = array('dms_purchase_items1 as dpi'=>'dpo.group_id=dpi.group_id','item_master as im'=>'dpi.item_id=im.id','unit_master as um'=>'dpi.unit_id=um.id');
			$args['conditions'] = array('dpo.id'=>$purchaseOrderID,'dpi.item_status <='=>1,'dpi.status'=>1);
			$purchase_orders = $this->purchase_order->get($args);
		}
		if(!empty($purchase_orders)){
			$po_status = $purchase_orders[0]['po_status'];
			$purchase_order = $purchase_orders[0];
			$groupID = $purchase_order['group_id'];
			$cstEnabled = 0;
			$args=array();
			$args['select'] = array('dpi.id');
			$args['conditions'] = array('dpi.group_id'=>$groupID,'dpi.item_status <='=>1,'dpi.cst >'=>0);
			$args['join'] = array('dms_purchase_items as dpi'=>'dpo.group_id=dpi.group_id');
			$purchaseOrderCST = $this->purchase_order->get($args);
			$cstEnabled = count($purchaseOrderCST);
		}
		if(isset($_POST['add_to_bill'])){

			$this->form_validation->set_rules('item_id','lang:item-name','required|xss_clean|is_natural_no_zero');
			$this->form_validation->set_rules('godown_id','lang:godown','required|xss_clean');
			$this->form_validation->set_rules('cst','lang:cst','xss_clean|greater_or_equal[0]|less_or_equal[100]');
			$this->form_validation->set_rules('qty','lang:quantity','required|xss_clean|greater_than[0]|less_than[100000000]');
			$this->form_validation->set_rules('unit_id','lang:unit','required|xss_clean');
			$this->form_validation->set_rules('rate','lang:rate','required|xss_clean|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('amount','lang:amount','xss_clean|required|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('discount_per','lang:discount %','xss_clean|greater_or_equal[0]|less_or_equal[100]');
			$this->form_validation->set_rules('discount_amt','lang:discount','xss_clean|greater_or_equal[0]|less_than[100000000]');

			if($this->input->post('item_id')){
				$itemID = $this->input->post('item_id');
				$units = $this->stock->get_units($itemID);
			}

			if($this->form_validation->run('add_to_bill') === true){

				if($po_status == 0){
					$this->db->trans_start();
					$postedItems = $this->input->post(NULL,true);
					$group_id = $purchase_orders[0]['group_id'];
					$l_date = '2017-07-01';
					$po_date = $purchase_orders[0]['po_date'];

					#----------VAT calculation
					if($po_date < $l_date)
					{
						$cst = $vat_amt = $vat_percent = 0;
						if($this->input->post('cst',true))
						{
							$cst = $this->input->post('cst',true);
						}
						if(empty($presumptiveTax))
						{
							if(!$cst)
							{
								$vat_percent = $this->stock->get_item_vat($postedItems['item_id']);
								$vat_amt = ((((float)$postedItems['amount']-(float)$postedItems['discount_amt']) * (float)$vat_percent) / 100);#round_this
							}
						}
					}
					else
					{
						$cgst = $sgst = $csgtAmt = $sgstAmt = 0;
						$cgst = $this->stock->get_item_cgst($postedItems['item_id']);
						$sgst = $this->stock->get_item_sgst($postedItems['item_id']);
						$cgstAmt = ((((float)$postedItems['amount']-(float)$postedItems['discount_amt']) * (float)$cgst) / 100);
						$sgstAmt = ((((float)$postedItems['amount']-(float)$postedItems['discount_amt']) * (float)$sgst) / 100);
						$vat_amt = (float)$cgstAmt + (float)$sgstAmt;
					}
					$args = array();
					if($po_date < $l_date)
					{
						$args['select'] = array('dpi.id');
						$args['conditions'] = array('dpo.id'=>$purchaseOrderID,'dpi.item_id'=>$postedItems['item_id'],'staus'=>1);
						$args['join'] = array('dms_purchase_items as dpi'=>'dpo.group_id=dpi.group_id');
						$OrderItemCheck = $this->purchase_order->get($args);
					}
					else
					{	
						$args['select'] = array('dpi.id');
						$args['conditions'] = array('dpo.id'=>$purchaseOrderID,'dpi.item_id'=>$postedItems['item_id'],'staus'=>1);
						$args['join'] = array('dms_purchase_items1 as dpi'=>'dpo.group_id=dpi.group_id');
						$OrderItemCheck = $this->purchase_order->get($args);
					}
					$postedItems['rate'] =0;
					if($postedItems['qty'] > 0){
						$postedItems['rate'] = $postedItems['amount']/$postedItems['qty'];
					}
					if(empty($OrderItemCheck)){
						if($po_date < $l_date)
						{
							if($this->purchase_order->save_purchase_order_item(array('group_id'=>$group_id,'item_id'=>$postedItems['item_id'],'godown_id'=>$postedItems['godown_id'],'qty'=>$postedItems['qty'],'unit_id'=>$postedItems['unit_id'],'rate'=>$postedItems['rate'],'amount'=>$postedItems['amount'],'discount_per'=>$postedItems['discount_per'],'discount_amt'=>$postedItems['discount_amt'],'vat_percent'=>$vat_percent,'vat_amt'=>$vat_amt,'cst'=>$cst,'item_status'=>0)))
							{
								$this->message->set($this->lang->line('item-added-to-bill'));
								$this->db->trans_complete();
								redirect('purchase_orders/edit/'.$purchaseOrderID.'/'.$urlString);
							}
						}
						else
						{
							if($this->purchase_order->save_purchase_order_items(array('group_id'=>$group_id,'item_id'=>$postedItems['item_id'],'godown_id'=>$postedItems['godown_id'],'qty'=>$postedItems['qty'],'unit_id'=>$postedItems['unit_id'],'rate'=>$postedItems['rate'],'amount'=>$postedItems['amount'],'discount_per'=>$postedItems['discount_per'],'discount_amt'=>$postedItems['discount_amt'],'cgst'=>$cgst,'sgst'=>$sgst,'cgst_amt'=>$cgstAmt,'sgst_amt'=>$sgstAmt,'item_status'=>0)))
							{
								$this->message->set($this->lang->line('item-added-to-bill'));
								$this->db->trans_complete();
								redirect('purchase_orders/edit/'.$purchaseOrderID.'/'.$urlString);
							}	
							
						}
					}else{
						$this->message->set($this->lang->line('same-po-item-exists'),'e');
					}
				}else{
					$this->message->set($this->lang->line('edit-converted-purchase-order'),'e');
				}
			}
		}

		if(isset($_POST['save_bill'])){

			$this->form_validation->set_rules('po_no','lang:po-no','xss_clean|required|is_natural|greater_than[0]');
			$this->form_validation->set_rules('po_date','lang:po-date','xss_clean|required|valid_date|is_date');
			$this->form_validation->set_rules('vendor_id','lang:vendor','xss_clean|required');
			$this->form_validation->set_rules('remarks','lang:remarks','xss_clean');
			if($this->form_validation->run('save_bill') === true){
				#check_po_number
				if($po_status == 0){

					$this->load->model('purchase/Purchase_order_temp_model','purchase_order_temp');
					$billNumber = $this->input->post('po_no');
					$billDate = date('Y-m-d',strtotime($this->input->post('po_date')));
					$vendorID = $this->input->post('vendor_id');
					$remarks = $this->input->post('remarks');
					$discAmt = $this->input->post('bill_discount_amt');
					$discPer = $this->input->post('bill_discount_per');
					$args = array();
					$args['select'] = array('dpo.id');
					$args['conditions'] = array('dpo.id !='=>$purchaseOrderID,'dpo.po_no'=>$billNumber,'dpo.status'=>1);
					$checkPO = $this->purchase_order->get($args);

					$args = array();
					$args['select'] = array('id');
					$args['conditions'] = array('dpot.po_no'=>$billNumber);
					$checkPOtemp = $this->purchase_order_temp->get($args);

					$this->db->trans_start();
					if(empty($checkPO) && empty($checkPOtemp)){

						if($this->purchase_order->update_po(array('po_no'=>$billNumber,'po_date'=>$billDate,'vendor_id'=>$vendorID,'po_discount_per'=>$discPer,'po_discount_amt'=>$discAmt,'remarks'=>$remarks),array('id'=>$purchaseOrderID))){
							$this->message->set($this->lang->line('purchase-order-updated'));
						}
						$this->db->trans_complete();
						redirect('purchase_orders/edit/'.$purchaseOrderID.'/'.$urlString);
					}else{
						$this->message->set($this->lang->line('same-po-bill-exists'),'e');
					}
				}else{
					$this->message->set($this->lang->line('edit-converted-purchase-order'),'e');
				}
			}
		}

		foreach($inputSelects as $key=>$selectBox){
			$arrayName = $$selectBox;
			$arrayName[''] = 'Select';
			$$selectBox = $arrayName;
			ksort($$selectBox);
		}

		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('purchase/purchase_order/edit_purchase_order',array('purchase_orders'=>$purchase_orders,'items'=>$items,'units'=>$units,'vendors'=>$vendors,'goDowns'=>$goDowns,'cst_enabled'=>$cstEnabled,'presumtiveTax' => $presumtiveTax));
		$this->template->other_script(array('purchase/purchase_order'));
		$this->template->render();
	}

	#================================================

	public function remove_item(){

		if(!$this->uri->segment(3)){
			redirect('users/logout');
		}
		$poItemID = $this->uri->segment(3);
		if($this->if_exists('dms_purchase_items1',array('id'=>$poItemID,'status'=>1,'item_status <='=>1)) === false){
			redirect('purchase_orders/report');
		}
		$this->load->model('purchase/Purchase_order_model','purchase_order');
		$uriArray = $this->uri->uri_to_assoc(4);
		$urlString = $this->uri->assoc_to_uri($uriArray);
		$args = array();
		$args['select'] = array('dpo.id','dpi.item_status');
		$args['conditions'] = array('dpi.id'=>$poItemID);
		$args['join'] = array('dms_purchase_items1 dpi'=>'dpo.group_id=dpi.group_id');
		$purchase_order = $this->purchase_order->get($args);
		if(empty($purchase_order)){
			redirect('purchase_orders/report');
		}
		$purchaseOrderID = $purchase_order[0]['id'];
		$itemStatus = $purchase_order[0]['item_status'];
		if($itemStatus <= 0){
			if($this->purchase_order->delete_items($poItemID)){
				$this->message->set($this->lang->line('item-deleted-from-bill'));
			}
		}else{
			$this->message->set($this->lang->line('delete-converted-purchase-order'),'e');
		}
		redirect('purchase_orders/edit/'.$urlString);

	}

	#================================================

	public function edit_item(){

		if(!$this->uri->segment(3)){
			redirect('users/logout');
		}
		$poItemID = $this->uri->segment(3);
		if(($this->if_exists('dms_purchase_items',array('id'=>$poItemID,'status'=>1,'item_status <='=>1)) === false) && ($this->if_exists('dms_purchase_items1',array('id'=>$poItemID,'status'=>1,'item_status <='=>1)) === false) ){
			redirect('purchase_orders/report');
		}
		$uriArray = $this->uri->uri_to_assoc(4);
		$urlString = $this->uri->assoc_to_uri($uriArray);
		$this->load->model('purchase/Purchase_order_model','purchase_order');
		$this->load->library('Stock');

		$args = array();
		$args['select'] = array('dpo.id','dpo.po_status','dpo.group_id','dpo.po_date','dpi.item_id','dpi.godown_id','dpi.qty','dpi.unit_id','dpi.rate','dpi.amount','dpi.discount_per','dpi.discount_amt','dpi.vat_percent','dpi.vat_amt','dpi.cst','dpi.item_status');
		$args['conditions'] = array('dpi.id'=>$poItemID);
		$args['join'] = array('dms_purchase_items dpi'=>'dpo.group_id=dpi.group_id');
		$purchase_orders = $this->purchase_order->get($args);
		if(empty($purchase_orders))
		{
			$args['select'] = array('dpo.id','dpo.po_status','dpo.group_id','dpo.po_date','dpi.item_id','dpi.godown_id','dpi.qty','dpi.unit_id','dpi.rate','dpi.amount','dpi.discount_per','dpi.discount_amt','dpi.cgst','dpi.sgst','dpi.cgst_amt','dpi.sgst_amt','dpi.item_status');
			$args['conditions'] = array('dpi.id'=>$poItemID);
			$args['join'] = array('dms_purchase_items1 dpi'=>'dpo.group_id=dpi.group_id');
			$purchase_orders = $this->purchase_order->get($args);
		}
		$purchaseOrderID = $purchase_orders[0]['id'];
		$itemID = $purchase_orders[0]['item_id'];
		$po_status = $purchase_orders[0]['po_status'];
		$po_group_id = $purchase_orders[0]['group_id'];
		$po_date = $purchase_orders[0]['po_date'];
		$l_date = '2017-07-01';

		$this->form_validation->set_rules('godown_id','lang:godown','required|xss_clean');
		$this->form_validation->set_rules('cst','lang:cst','xss_clean|greater_or_equal[0]|less_or_equal[100]');
		$this->form_validation->set_rules('qty','lang:quantity','required|xss_clean|greater_than[0]|less_than[100000000]');
		$this->form_validation->set_rules('unit_id','lang:unit','required|xss_clean');
		$this->form_validation->set_rules('rate','lang:rate','required|xss_clean|greater_or_equal[0]|less_than[100000000]');
		$this->form_validation->set_rules('amount','lang:amount','xss_clean|required|greater_or_equal[0]|less_than[100000000]');
		$this->form_validation->set_rules('discount_per','lang:discount %','xss_clean|greater_or_equal[0]|less_or_equal[100]');
		$this->form_validation->set_rules('discount_amt','lang:discount','xss_clean|greater_or_equal[0]|less_than[100000000]');
		$this->form_validation->set_rules('vat_amt','lang:vat-amt','xss_clean|greater_or_equal[0]|less_than[100000000]');

		if($this->form_validation->run() === true){

			$postedValues = $this->input->post(NULL,true);
			$args = array();
			if($po_date < $l_date)
			{
				$args['select'] = array('dpi.id','dpo.po_status');
				$args['conditions'] = array('dpi.group_id'=>$po_group_id,'item_id'=>$itemID,'dpi.godown_id'=>$postedValues['godown_id'],'dpi.unit_id'=>$postedValues['unit_id'],'dpi.id !='=>$poItemID);
				$args['join'] = array('dms_purchase_items dpi'=>'dpo.group_id=dpi.group_id');
			}
			else
			{
				$args['select'] = array('dpi.id','dpo.po_status');
				$args['conditions'] = array('dpi.group_id'=>$po_group_id,'item_id'=>$itemID,'dpi.godown_id'=>$postedValues['godown_id'],'dpi.unit_id'=>$postedValues['unit_id'],'dpi.id !='=>$poItemID);
				$args['join'] = array('dms_purchase_items1 dpi'=>'dpo.group_id=dpi.group_id');	
			}
			$poItemCheck = $this->purchase_order->get($args);
			
			$postedValues['rate'] =0;
			if($postedValues['qty'] >0){
				$postedValues['rate'] = $postedValues['amount']/$postedValues['qty'];
			}
			if(empty($poItemCheck)){
				if($po_status == 0){
					if($po_date < $l_date)
					{
						if($this->purchase_order->update_po_item($postedValues,array('id'=>$poItemID))){
							$this->message->set($this->lang->line('purchase-order-updated'));
						}else{
							$this->message->set($this->lang->line('purchase-order-not-saved'));
						}
					}
					else
					{
						if($this->purchase_order->update_po_items($postedValues,array('id'=>$poItemID))){
							$this->message->set($this->lang->line('purchase-order-updated'));
						}else{
							$this->message->set($this->lang->line('purchase-order-not-saved'));
						}	
					}
				}else{
					$this->message->set($this->lang->line('delete-converted-purchase-order'),'e');
				}
				redirect('purchase_orders/edit/'.$urlString);
			}else{
				$this->message->set($this->lang->line('same-po-item-exists'));
			}
		}

		$this->template->title($this->lang->line('edit-purchase-order'));
		$this->template->main_heading($this->lang->line('edit-purchase-order'));
		$this->template->breadcrumb(array($this->lang->line('purchase-order') => 'purchase_orders/add',$this->lang->line('report') => 'purchase_orders/report',$this->lang->line('edit') => 'no_link',$this->lang->line('go-back')=>array('purchase_orders/edit/'.$urlString)));

		$vendors = $units = $items =  $goDowns = array();
		$inputSelects = array('vendors','units','items','goDowns');
		$vendors = $this->stock->get_vendors();
		$items = $this->stock->get_stock_items();
		$goDowns = $this->stock->get_item_godowns(array('item_id'=>$itemID,'listing'=>1));
		$units = $this->stock->get_units($itemID);

		foreach($inputSelects as $key=>$selectBox){
			$arrayName = $$selectBox;
			$arrayName[''] = 'Select';
			$$selectBox = $arrayName;
			ksort($$selectBox);
		}

		#----------rate
		$rate = $this->stock->get_purchase_rate($itemID);

		#----------primary unit
		$unit_id = $this->stock->get_primary_unit($itemID);

		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('purchase/purchase_order/edit_purchase_order_item',array('purchase_orders'=>$purchase_orders,'items'=>$items,'units'=>$units,'goDowns'=>$goDowns,'rate' => $rate,'unit' => $unit_id['symbol']));
		$this->template->other_script(array('purchase/purchase_order'));
		$this->template->render();
	}

	#================================================

	public function view(){

		if(!$this->uri->segment(3)){
			redirect('purchase_orders/report');
		}
		$purchaseOrderID = $this->uri->segment(3);
		if($this->if_exists('dms_purchase_orders',array('id'=>$purchaseOrderID,'status'=>1)) === false){
			redirect('purchase_orders/report');
		}

		$uriArray = $this->uri->uri_to_assoc(4);
		$urlString = $this->uri->assoc_to_uri($uriArray);
		$this->template->title($this->lang->line('view-purchase-order'));
		$this->template->main_heading($this->lang->line('view-purchase-order'));
		$this->template->breadcrumb(array($this->lang->line('purchase-order') => 'purchase_orders/add',$this->lang->line('report') => 'purchase_orders/report',$this->lang->line('view') => 'no_link',$this->lang->line('go-back')=>array('purchase_orders/report/'.$urlString)));
		$this->load->model('purchase/Purchase_order_model','purchase_order');
		$this->load->library('Stock');

		$args = array();
		$args['select'] = array('dpo.id','dpo.branch_id','dpo.po_no','dpo.po_date','dpo.group_id','dpo.vendor_id','dpo.remarks','dpo.po_status','dpo.po_discount_per','dpo.po_discount_amt','dpo.cess','dpo.created_by','dpo.created_on','dpi.id as dpi_id','dpi.item_id','dpi.qty','dpi.unit_id','dpi.rate','dpi.amount','dpi.vat_amt','dpi.cst','dpi.discount_per','dpi.discount_amt','dpi.item_status','im.item_code','im.item_name','um.symbol','imm.manufacturer_name as vendor_name');
		$args['join'] = array('dms_purchase_items as dpi'=>'dpo.group_id=dpi.group_id','item_master as im'=>'dpi.item_id=im.id','unit_master as um'=>'dpi.unit_id=um.id','item_manufacturer_master as imm'=>'dpo.vendor_id=imm.id');
		$args['conditions'] = array('dpo.id'=>$purchaseOrderID,'dpi.item_status <='=>1,'dpi.status'=>1);
		$purchase_orders = $this->purchase_order->get($args);
		
		if(empty($purchase_orders))
		{
			$args = array();
		$args['select'] = array('dpo.id','dpo.branch_id','dpo.po_no','dpo.po_date','dpo.group_id','dpo.vendor_id','dpo.remarks','dpo.po_status','dpo.po_discount_per','dpo.po_discount_amt','dpo.cess','dpo.created_by','dpo.created_on','dpi.id as dpi_id','dpi.item_id','dpi.qty','dpi.unit_id','dpi.rate','dpi.amount','dpi.cgst_amt','dpi.sgst_amt','dpi.discount_per','dpi.discount_amt','dpi.item_status','im.item_code','im.item_name','um.symbol','imm.manufacturer_name as vendor_name');
		$args['join'] = array('dms_purchase_items1 as dpi'=>'dpo.group_id=dpi.group_id','item_master as im'=>'dpi.item_id=im.id','unit_master as um'=>'dpi.unit_id=um.id','item_manufacturer_master as imm'=>'dpo.vendor_id=imm.id');
		$args['conditions'] = array('dpo.id'=>$purchaseOrderID,'dpi.item_status <='=>1,'dpi.status'=>1);
		$purchase_orders = $this->purchase_order->get($args);	
		}
		if(!empty($purchase_orders)){
			$purchase_order = $purchase_orders[0];
			$groupID = $purchase_order['group_id'];
			$cstEnabled = 0;
			$args=array();
			$args['select'] = array('dpi.id');
			$args['conditions'] = array('dpi.group_id'=>$groupID,'dpi.item_status <='=>1,'dpi.cst >'=>0);
			$args['join'] = array('dms_purchase_items as dpi'=>'dpo.group_id=dpi.group_id');
			$purchaseOrderCST = $this->purchase_order->get($args);
			$cstEnabled = count($purchaseOrderCST);
		}

		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('purchase/purchase_order/view_purchase_order',array('purchase_orders'=>$purchase_orders,'cst_enabled'=>$cstEnabled));
		$this->template->other_script(array('purchase/purchase_order'));
		$this->template->render();

	}

	#================================================

	public function delete(){

		if(!$this->uri->segment(3)){
			redirect('purchase_orders/report');
		}
		$purchaseOrderID = $this->uri->segment(3);
		if($this->if_exists('dms_purchase_orders',array('id'=>$purchaseOrderID,'status'=>1)) === false){
			redirect('purchase_orders/report');
		}
		$this->load->model('purchase/Purchase_order_model','purchase_order');
		$uriArray = $this->uri->uri_to_assoc(4);
		$urlString = $this->uri->assoc_to_uri($uriArray);

		$args = array();
		$args['select'] = array('dpo.id','dpo.group_id','dpo.po_status');
		$args['conditions'] = array('dpo.id'=>$purchaseOrderID);
		$purchase_orders = $this->purchase_order->get($args);
		if(!empty($purchase_orders)){
			$groupId = $purchase_orders[0]['group_id'];
			$po_status = $purchase_orders[0]['po_status'];
			if($po_status == 0){
				if($this->purchase_order->update_po(array('status'=>0),array('group_id'=>$groupId))){
					$this->purchase_order->update_po_item(array('status'=>0),array('group_id'=>$groupId));
					$this->message->set($this->lang->line('purchase-order-deleted'));
				}
			}else{
				$this->message->set($this->lang->line('delete-converted-purchase-order'),'i');
			}
		}
		redirect('purchase_orders/report/'.$urlString);
	}

	#================================================

	public function pdf(){

		if(!$this->uri->segment(3)){
			echo "<script>alert('".$this->lang->line('invalid-purchase-order')."');window.close();</script>";
		}
		$purchaseOrderID = $this->uri->segment(3);
		if($this->if_exists('dms_purchase_orders',array('id'=>$purchaseOrderID,'status'=>1)) === false){
			echo "<script>alert('".$this->lang->line('invalid-purchase-order')."');window.close();</script>";
		}
		$pdf_name = 'purchase_order';
		$this->load->model('purchase/Purchase_order_model','purchase_order');
		$this->load->library('Stock');
		$this->load->library('My_pdf');
		$this->load->library('To_words');
		$this->my_pdf->set_tin();
		$this->my_pdf->set_header();

		$args = array();
		$args['select'] = array('dpo.id','dpo.branch_id','dpo.po_no','dpo.po_date','dpo.group_id','dpo.vendor_id','dpo.remarks','dpo.po_status','dpo.po_discount_per','dpo.po_discount_amt','dpo.cess','dpi.id as dpi_id','dpi.item_id','dpi.qty','dpi.unit_id','dpi.rate','dpi.amount','dpi.vat_amt','dpi.cst','dpi.discount_per','dpi.discount_amt','dpi.item_status','im.item_code','im.item_name','um.symbol','imm.manufacturer_name as vendor_name','imm.phone as vendor_phone','imm.manufacturer_email as vendor_mail','imm.address as vendor_address','imm.tin_no as vendor_tin_no','imm.pincode as vendor_pin');
		$args['join'] = array('dms_purchase_items as dpi'=>'dpo.group_id=dpi.group_id','item_master as im'=>'dpi.item_id=im.id','unit_master as um'=>'dpi.unit_id=um.id','item_manufacturer_master as imm'=>'dpo.vendor_id=imm.id');
		$args['conditions'] = array('dpo.id'=>$purchaseOrderID,'dpi.item_status <='=>1,'dpi.status'=>1);
		$purchase_orders = $this->purchase_order->get($args);
		
		if(empty($purchase_orders))
		{
			$args['select'] = array('dpo.id','dpo.branch_id','dpo.po_no','dpo.po_date','dpo.group_id','dpo.vendor_id','dpo.remarks','dpo.po_status','dpo.po_discount_per','dpo.po_discount_amt','dpo.cess','dpi.id as dpi_id','dpi.item_id','dpi.qty','dpi.unit_id','dpi.rate','dpi.amount','dpi.cgst_amt','dpi.sgst_amt','dpi.discount_per','dpi.discount_amt','dpi.item_status','im.item_code','im.item_name','um.symbol','imm.manufacturer_name as vendor_name','imm.phone as vendor_phone','imm.manufacturer_email as vendor_mail','imm.address as vendor_address','imm.tin_no as vendor_tin_no','imm.pincode as vendor_pin');
		$args['join'] = array('dms_purchase_items1 as dpi'=>'dpo.group_id=dpi.group_id','item_master as im'=>'dpi.item_id=im.id','unit_master as um'=>'dpi.unit_id=um.id','item_manufacturer_master as imm'=>'dpo.vendor_id=imm.id');
		$args['conditions'] = array('dpo.id'=>$purchaseOrderID,'dpi.item_status <='=>1,'dpi.status'=>1);
		$purchase_orders = $this->purchase_order->get($args);
		}
		if(empty($purchase_orders)){
			echo "<script>alert('".$this->lang->line('invalid-purchase-order')."');window.close();</script>";
		}else{
			$purchase_order = $purchase_orders[0];
			$groupID = $purchase_order['group_id'];
			$cstEnabled = 0;
			$args=array();
			$args['select'] = array('dpi.id');
			$args['conditions'] = array('dpi.group_id'=>$groupID,'dpi.item_status <='=>1,'dpi.cst >'=>0);
			$args['join'] = array('dms_purchase_items as dpi'=>'dpo.group_id=dpi.group_id');
			$purchaseOrderCST = $this->purchase_order->get($args);
			$cstEnabled = count($purchaseOrderCST);
			$pdf_name .= '_no_'.$purchase_orders[0]['po_no'].'_'.date('d/m/Y',strtotime($purchase_orders[0]['po_date']));
		}
		$pdf_contents = $this->load->view('purchase/purchase_order/purchase_order_pdf',array('purchase_orders'=>$purchase_orders,'cst_enabled'=>$cstEnabled),true);
		$this->my_pdf->output($pdf_name,$pdf_contents);
	}

	#================================================

}
?>